/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.utils;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ColorRGB;
import ch.njol.skript.util.EnchantmentType;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import it.jakegblp.lusk.utils.Constants;
import it.jakegblp.lusk.utils.LuskUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

public class ItemUtils {
    public static final Function<ItemStack, ItemStack> UNENCHANT = Constants.HAS_REMOVE_ENCHANTMENTS_METHOD ? itemStack -> {
        itemStack.removeEnchantments();
        return itemStack;
    } : itemStack -> {
        for (Enchantment enchantment : itemStack.getEnchantments().keySet()) {
            itemStack.removeEnchantment(enchantment);
        }
        return itemStack;
    };

    @Nullable
    public static ItemMeta getItemMetaFromUnknown(@Nullable Object object) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            return itemStack.getItemMeta();
        }
        if (object instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            return itemType.getItemMeta();
        }
        if (object instanceof ItemMeta) {
            ItemMeta itemMeta = (ItemMeta)object;
            return itemMeta;
        }
        return null;
    }

    @Nullable
    public static ItemType getNullableItemType(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isEmpty()) {
            return null;
        }
        return new ItemType(itemStack);
    }

    @Nullable
    public static ItemStack getNullableItemStack(@Nullable ItemType itemType) {
        if (itemType == null) {
            return null;
        }
        return itemType.getRandom();
    }

    public static ItemType[] unenchant(ItemType ... itemTypes) {
        return (ItemType[])Arrays.stream(itemTypes).map(itemType -> {
            ItemStack itemStack = itemType.getRandom();
            if (itemStack != null) {
                ItemStack unenchantItemStack = UNENCHANT.apply(itemStack);
                return new ItemType(unenchantItemStack);
            }
            return null;
        }).toArray(ItemType[]::new);
    }

    public static Enchantment[] getSupportedEnchantments(@NotNull ItemStack itemStack) {
        return (Enchantment[])RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).stream().filter(enchantment -> enchantment.canEnchantItem(itemStack)).toArray(Enchantment[]::new);
    }

    @Nullable
    public static ItemStack getSingleItemTypeToItemStack(@Nullable Expression<ItemType> expression, @NotNull Event event) {
        if (expression == null) {
            return null;
        }
        return ItemUtils.getNullableItemStack((ItemType)expression.getSingle(event));
    }

    public static boolean hasChargedProjectiles(@NotNull ItemType itemType) {
        CrossbowMeta crossbowMeta;
        ItemMeta itemMeta = itemType.getItemMeta();
        return itemMeta instanceof CrossbowMeta && (crossbowMeta = (CrossbowMeta)itemMeta).hasChargedProjectiles();
    }

    @NullMarked
    public static void addChargedProjectiles(ItemType itemType, ItemType ... projectiles) {
        ItemType[] itemTypeArray = itemType.getItemMeta();
        if (itemTypeArray instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)itemTypeArray;
            for (ItemType projectile : projectiles) {
                ItemStack itemStack = projectile.getRandom();
                if (itemStack == null) continue;
                crossbowMeta.addChargedProjectile(itemStack);
            }
            itemType.setItemMeta((ItemMeta)crossbowMeta);
        }
    }

    @NullMarked
    public static void setChargedProjectiles(ItemType itemType, ItemType ... projectiles) {
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)itemMeta;
            crossbowMeta.setChargedProjectiles(projectiles == null ? null : Arrays.stream(projectiles).map(ItemType::getRandom).toList());
            itemType.setItemMeta((ItemMeta)crossbowMeta);
        }
    }

    @NullMarked
    public static void removeChargedProjectiles(ItemType itemType, ItemType ... projectiles) {
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)itemMeta;
            ArrayList itemStacks = new ArrayList(crossbowMeta.getChargedProjectiles());
            itemStacks.removeAll(Arrays.stream(projectiles).map(ItemType::getRandom).toList());
            crossbowMeta.setChargedProjectiles(itemStacks);
            itemType.setItemMeta((ItemMeta)crossbowMeta);
        }
    }

    @NotNull
    public static ItemType[] getChargedProjectiles(@NotNull ItemType itemType) {
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)itemMeta;
            return (ItemType[])crossbowMeta.getChargedProjectiles().stream().map(ItemType::new).toArray(ItemType[]::new);
        }
        return new ItemType[0];
    }

    @NullMarked
    public static void addStoredEnchantments(ItemType itemType, EnchantmentType ... enchantmentTypes) {
        EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemType.getItemMeta();
        for (EnchantmentType enchantmentType : enchantmentTypes) {
            if (enchantmentType.getType() == null) continue;
            enchantmentStorageMeta.addStoredEnchant(enchantmentType.getType(), enchantmentType.getLevel(), true);
        }
        itemType.setItemMeta((ItemMeta)enchantmentStorageMeta);
    }

    @NullMarked
    public static void removeStoredEnchantments(ItemType itemType, EnchantmentType ... enchantmentTypes) {
        EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemType.getItemMeta();
        if (!enchantmentStorageMeta.hasStoredEnchants()) {
            return;
        }
        for (EnchantmentType enchantmentType : enchantmentTypes) {
            if (enchantmentType.getType() == null) continue;
            enchantmentStorageMeta.removeStoredEnchant(enchantmentType.getType());
        }
        itemType.setItemMeta((ItemMeta)enchantmentStorageMeta);
    }

    @NotNull
    public static EnchantmentType[] getStoredEnchantments(@NotNull ItemType itemType) {
        EnchantmentStorageMeta enchantmentStorageMeta;
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta && (enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta).hasStoredEnchants()) {
            return (EnchantmentType[])enchantmentStorageMeta.getStoredEnchants().entrySet().stream().map(entry -> new EnchantmentType((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).toArray(EnchantmentType[]::new);
        }
        return new EnchantmentType[0];
    }

    @NullMarked
    public static void setStoredEnchantments(ItemType itemType, EnchantmentType ... enchantmentTypes) {
        EnchantmentStorageMeta enchantmentStorageMeta;
        EnchantmentType[] enchantmentTypeArray = itemType.getItemMeta();
        if (enchantmentTypeArray instanceof EnchantmentStorageMeta && (enchantmentStorageMeta = (EnchantmentStorageMeta)enchantmentTypeArray).hasStoredEnchants()) {
            if (enchantmentStorageMeta.hasStoredEnchants()) {
                enchantmentStorageMeta.getStoredEnchants().keySet().forEach(arg_0 -> ((EnchantmentStorageMeta)enchantmentStorageMeta).removeStoredEnchant(arg_0));
            }
            if (enchantmentTypes != null) {
                for (EnchantmentType enchantmentType : enchantmentTypes) {
                    if (enchantmentType.getType() == null) continue;
                    enchantmentStorageMeta.addStoredEnchant(enchantmentType.getType(), enchantmentType.getLevel(), true);
                }
            }
        }
    }

    public static boolean hasStoredEnchantments(@NotNull ItemType itemType) {
        EnchantmentStorageMeta enchantmentStorageMeta;
        ItemMeta itemMeta = itemType.getItemMeta();
        return itemMeta instanceof EnchantmentStorageMeta && (enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta).hasStoredEnchants();
    }

    public static EnchantmentType[] asEnchantmentTypes(Object[] objects) {
        return (EnchantmentType[])Arrays.stream(objects).map(object -> {
            if (object instanceof EnchantmentType) {
                EnchantmentType enchantmentType = (EnchantmentType)object;
                return enchantmentType;
            }
            if (object instanceof Enchantment) {
                Enchantment enchantment = (Enchantment)object;
                return new EnchantmentType(enchantment);
            }
            return null;
        }).filter(Objects::nonNull).toArray(EnchantmentType[]::new);
    }

    public static boolean hasSuspiciousStewPotionEffects(@NotNull ItemType itemType) {
        SuspiciousStewMeta meta;
        ItemMeta itemMeta = itemType.getItemMeta();
        return itemMeta instanceof SuspiciousStewMeta && (meta = (SuspiciousStewMeta)itemMeta).hasCustomEffects();
    }

    @NullMarked
    public static PotionEffect[] getSuspiciousStewPotionEffects(ItemType itemType) {
        SuspiciousStewMeta meta;
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof SuspiciousStewMeta && (meta = (SuspiciousStewMeta)itemMeta).hasCustomEffects()) {
            return meta.getCustomEffects().toArray(new PotionEffect[0]);
        }
        return new PotionEffect[0];
    }

    @NullMarked
    public static void setSuspiciousStewPotionEffects(ItemType itemType, PotionEffect ... effects) {
        PotionEffect[] potionEffectArray = itemType.getItemMeta();
        if (potionEffectArray instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta meta = (SuspiciousStewMeta)potionEffectArray;
            meta.clearCustomEffects();
            if (effects != null) {
                for (PotionEffect effect : effects) {
                    if (Constants.PAPER_1_20_4) {
                        meta.addCustomEffect(SuspiciousEffectEntry.create((PotionEffectType)effect.getType(), (int)effect.getDuration()), true);
                        continue;
                    }
                    meta.addCustomEffect(effect, true);
                }
            }
            itemType.setItemMeta((ItemMeta)meta);
        }
    }

    @NullMarked
    public static void addSuspiciousStewPotionEffects(ItemType itemType, PotionEffect ... effects) {
        PotionEffect[] potionEffectArray = itemType.getItemMeta();
        if (potionEffectArray instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta meta = (SuspiciousStewMeta)potionEffectArray;
            for (PotionEffect effect : effects) {
                if (Constants.PAPER_1_20_4) {
                    meta.addCustomEffect(SuspiciousEffectEntry.create((PotionEffectType)effect.getType(), (int)effect.getDuration()), false);
                    continue;
                }
                meta.addCustomEffect(effect, false);
            }
            itemType.setItemMeta((ItemMeta)meta);
        }
    }

    public static void removeSuspiciousStewPotionEffects(ItemType itemType, Object ... objects) {
        Object[] objectArray = itemType.getItemMeta();
        if (objectArray instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta meta = (SuspiciousStewMeta)objectArray;
            for (Object object : objects) {
                PotionEffectType type;
                if (object instanceof PotionEffect) {
                    PotionEffect potionEffect = (PotionEffect)object;
                    type = potionEffect.getType();
                } else {
                    PotionEffectType potionEffectType;
                    if (!(object instanceof PotionEffectType)) continue;
                    type = potionEffectType = (PotionEffectType)object;
                }
                meta.removeCustomEffect(type);
            }
            itemType.setItemMeta((ItemMeta)meta);
        }
    }

    public static void clearSuspiciousStewPotionEffects(ItemType itemType) {
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta meta = (SuspiciousStewMeta)itemMeta;
            meta.clearCustomEffects();
            itemType.setItemMeta((ItemMeta)meta);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isArmorDyed(@NotNull ItemType itemType) {
        ItemMeta itemMeta = itemType.getItemMeta();
        if (!(itemMeta instanceof LeatherArmorMeta)) return false;
        LeatherArmorMeta meta = (LeatherArmorMeta)itemMeta;
        if (Constants.PAPER_1_20_6) {
            if (!meta.isDyed()) return false;
            return true;
        } else if (!meta.getColor().equals((Object)Bukkit.getItemFactory().getDefaultLeatherColor())) return false;
        return true;
    }

    @Nullable
    public static Color getArmorColor(@NotNull ItemType itemType) {
        ColorRGB colorRGB;
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta meta = (LeatherArmorMeta)itemMeta;
            colorRGB = LuskUtils.getColorAsRGB(meta.getColor());
        } else {
            colorRGB = null;
        }
        return colorRGB;
    }

    public static void setArmorColor(@NotNull ItemType itemType, @NotNull Color color) {
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta meta = (LeatherArmorMeta)itemMeta;
            meta.setColor(color.asBukkitColor());
        }
    }
}

