/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import com.example.hords.HordsConfig;
import com.example.hords.HordsMod;
import com.example.hords.PlayerBroadcastSettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1550;
import net.minecraft.class_1551;
import net.minecraft.class_1560;
import net.minecraft.class_1571;
import net.minecraft.class_1577;
import net.minecraft.class_1588;
import net.minecraft.class_1589;
import net.minecraft.class_1590;
import net.minecraft.class_1606;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4836;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5419;
import net.minecraft.class_6880;
import net.minecraft.class_9254;
import net.minecraft.server.MinecraftServer;

public class HordsSpawner {
    private static final Random RANDOM = new Random();
    private static final Map<String, Map<UUID, BossInfo>> activeBosses = new ConcurrentHashMap<String, Map<UUID, BossInfo>>();
    private static final Map<String, Integer> activeHordesCount = new HashMap<String, Integer>();
    private static final Map<String, Long> worldCooldowns = new HashMap<String, Long>();

    public static int getSpawnChance() {
        return HordsMod.getConfig().spawnSettings.spawnChance;
    }

    public static void setSpawnChance(int chance) {
        HordsMod.getConfig().spawnSettings.spawnChance = Math.max(100, chance);
        HordsMod.saveConfig();
    }

    public static int getMinHordSize() {
        return HordsMod.getConfig().spawnSettings.minHordSize;
    }

    public static void setMinHordSize(int size) {
        HordsMod.getConfig().spawnSettings.minHordSize = Math.max(3, size);
        HordsMod.saveConfig();
    }

    public static int getMaxHordSize() {
        return HordsMod.getConfig().spawnSettings.maxHordSize;
    }

    public static void setMaxHordSize(int size) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.maxHordSize = Math.max(config.spawnSettings.minHordSize + 1, size);
        HordsMod.saveConfig();
    }

    public static int getMinPlayerDistance() {
        return HordsMod.getConfig().spawnSettings.minPlayerDistance;
    }

    public static void setMinPlayerDistance(int distance) {
        HordsMod.getConfig().spawnSettings.minPlayerDistance = Math.max(10, distance);
        HordsMod.saveConfig();
    }

    public static int getMaxPlayerDistance() {
        return HordsMod.getConfig().spawnSettings.maxPlayerDistance;
    }

    public static void setMaxPlayerDistance(int distance) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.maxPlayerDistance = Math.max(config.spawnSettings.minPlayerDistance + 5, distance);
        HordsMod.saveConfig();
    }

    public static boolean getRequireNightTime() {
        return HordsMod.getConfig().spawnSettings.requireNightTime;
    }

    public static void setRequireNightTime(boolean require) {
        HordsMod.getConfig().spawnSettings.requireNightTime = require;
        HordsMod.saveConfig();
    }

    public static int getMaxActiveHordes() {
        return HordsMod.getConfig().performance.maxActiveHordes;
    }

    public static void setMaxActiveHordes(int max) {
        HordsMod.getConfig().performance.maxActiveHordes = Math.max(1, Math.min(10, max));
        HordsMod.saveConfig();
    }

    public static long getDespawnTimeMinutes() {
        return HordsMod.getConfig().performance.despawnTimeMinutes;
    }

    public static void setDespawnTimeMinutes(long minutes) {
        HordsMod.getConfig().performance.despawnTimeMinutes = Math.max(1L, minutes);
        HordsMod.saveConfig();
    }

    public static int getActiveHordesCount(String worldName) {
        return activeHordesCount.getOrDefault(worldName, 0);
    }

    public static int getCooldownMinutes() {
        return HordsMod.getConfig().performance.cooldownMinutes;
    }

    public static void setCooldownMinutes(int minutes) {
        HordsMod.getConfig().performance.cooldownMinutes = Math.max(0, minutes);
        HordsMod.saveConfig();
    }

    public static boolean isBroadcastEnabled() {
        return HordsMod.getConfig().broadcast.enabled;
    }

    public static void setBroadcastEnabled(boolean enabled) {
        HordsMod.getConfig().broadcast.enabled = enabled;
        HordsMod.saveConfig();
    }

    public static int getBroadcastRadius() {
        return HordsMod.getConfig().broadcast.radius;
    }

    public static void setBroadcastRadius(int radius) {
        HordsMod.getConfig().broadcast.radius = Math.max(10, radius);
        HordsMod.saveConfig();
    }

    private static void registerBoss(String worldName, class_1309 boss, HordType type, int hordeSize, class_2338 spawnPos) {
        UUID bossId = boss.method_5667();
        BossInfo bossInfo = new BossInfo(type, bossId, hordeSize, spawnPos);
        Map worldBosses = activeBosses.computeIfAbsent(worldName, k -> new ConcurrentHashMap());
        worldBosses.put(bossId, bossInfo);
        int current = activeHordesCount.getOrDefault(worldName, 0);
        activeHordesCount.put(worldName, current + 1);
        System.out.println("[HORDS] Boss " + String.valueOf(bossId) + " (" + String.valueOf((Object)type) + ") spawned in " + worldName + " with " + hordeSize + " minions");
    }

    public static void onBossDeath(UUID bossId, String worldName, class_2338 deathLocation) {
        BossInfo bossInfo;
        Map<UUID, BossInfo> worldBosses = activeBosses.get(worldName);
        if (worldBosses != null && (bossInfo = worldBosses.remove(bossId)) != null) {
            int current = activeHordesCount.getOrDefault(worldName, 0);
            activeHordesCount.put(worldName, Math.max(0, current - 1));
            long ageSeconds = bossInfo.getAgeInSeconds();
            System.out.println("[HORDS] Boss defeated! Horde " + String.valueOf(bossId) + " (" + String.valueOf((Object)bossInfo.type) + ") in " + worldName + " lasted " + ageSeconds + " seconds");
        }
    }

    private static boolean isWorldOnCooldown(String worldName) {
        long cooldownMillis;
        long currentTime = System.currentTimeMillis();
        if (!worldCooldowns.containsKey(worldName)) {
            return false;
        }
        long lastSpawnTime = worldCooldowns.get(worldName);
        long timeDiff = currentTime - lastSpawnTime;
        return timeDiff < (cooldownMillis = (long)(HordsSpawner.getCooldownMinutes() * 60) * 1000L);
    }

    private static void setWorldCooldown(String worldName) {
        worldCooldowns.put(worldName, System.currentTimeMillis());
    }

    private static void cleanupOldBossesAndUpdateCount(String worldName, class_3218 world) {
        Map<UUID, BossInfo> worldBosses = activeBosses.get(worldName);
        if (worldBosses == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long despawnTime = HordsSpawner.getDespawnTimeMinutes() * 60000L;
        int removedCount = 0;
        Iterator<Map.Entry<UUID, BossInfo>> iterator = worldBosses.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, BossInfo> entry = iterator.next();
            BossInfo bossInfo = entry.getValue();
            UUID bossId = entry.getKey();
            boolean bossExists = false;
            for (class_1297 entity : world.method_27909()) {
                if (!entity.method_5667().equals(bossId) || !entity.method_5805()) continue;
                bossExists = true;
                break;
            }
            if (bossExists && currentTime - bossInfo.spawnTime <= despawnTime) continue;
            iterator.remove();
            ++removedCount;
            if (!bossExists) {
                System.out.println("[HORDS] Boss " + String.valueOf(bossId) + " died/despawned in " + worldName);
                continue;
            }
            System.out.println("[HORDS] Boss " + String.valueOf(bossId) + " timed out in " + worldName);
        }
        if (removedCount > 0) {
            int current = activeHordesCount.getOrDefault(worldName, 0);
            activeHordesCount.put(worldName, Math.max(0, current - removedCount));
        }
    }

    private static boolean canSpawnInWorld(String worldName, class_3218 world) {
        HordsSpawner.cleanupOldBossesAndUpdateCount(worldName, world);
        Map<UUID, BossInfo> worldBosses = activeBosses.get(worldName);
        int actualActiveBosses = worldBosses != null ? worldBosses.size() : 0;
        activeHordesCount.put(worldName, actualActiveBosses);
        return actualActiveBosses < HordsSpawner.getMaxActiveHordes();
    }

    private static void broadcastHordMessage(class_3218 world, class_2338 spawnPos, HordType hordType) {
        if (!HordsSpawner.isBroadcastEnabled()) {
            return;
        }
        class_5250 message = class_2561.method_43470((String)("A " + HordsSpawner.getHordTypeName(hordType) + " has appeared nearby!")).method_27695(new class_124[]{HordsSpawner.getHordTypeColor(hordType), class_124.field_1067});
        for (class_3222 player : world.method_18456()) {
            double maxDistance;
            double distance;
            if (!PlayerBroadcastSettings.shouldReceiveBroadcast(player.method_5667()) || !((distance = player.method_24515().method_10262((class_2382)spawnPos)) <= (maxDistance = (double)(HordsSpawner.getBroadcastRadius() * HordsSpawner.getBroadcastRadius())))) continue;
            player.method_7353((class_2561)message, false);
        }
    }

    private static class_124 getHordTypeColor(HordType type) {
        switch (type.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return class_124.field_1061;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return class_124.field_1079;
            }
            case 4: {
                return class_124.field_1064;
            }
            case 5: {
                return class_124.field_1062;
            }
        }
        return class_124.field_1061;
    }

    public static void onServerTick(MinecraftServer server) {
        class_3222 referencePlayer;
        boolean spawned;
        List players;
        class_3218 end;
        class_3222 referencePlayer2;
        boolean spawned2;
        List players2;
        class_3218 nether;
        class_3222 referencePlayer3;
        boolean spawned3;
        List players3;
        class_3218 overworld = server.method_30002();
        if (overworld.method_8407() != class_1267.field_5801 && !HordsSpawner.isWorldOnCooldown("overworld") && HordsSpawner.canSpawnInWorld("overworld", overworld) && !(players3 = overworld.method_18456()).isEmpty() && RANDOM.nextInt(HordsSpawner.getSpawnChance()) == 0 && (spawned3 = HordsSpawner.spawnOverworldHord(overworld, referencePlayer3 = (class_3222)players3.get(RANDOM.nextInt(players3.size()))))) {
            HordsSpawner.setWorldCooldown("overworld");
        }
        if ((nether = server.method_3847(class_1937.field_25180)) != null && nether.method_8407() != class_1267.field_5801 && !HordsSpawner.isWorldOnCooldown("nether") && HordsSpawner.canSpawnInWorld("nether", nether) && !(players2 = nether.method_18456()).isEmpty() && RANDOM.nextInt(HordsSpawner.getSpawnChance()) == 0 && (spawned2 = HordsSpawner.spawnNetherHord(nether, referencePlayer2 = (class_3222)players2.get(RANDOM.nextInt(players2.size()))))) {
            HordsSpawner.setWorldCooldown("nether");
        }
        if ((end = server.method_3847(class_1937.field_25181)) != null && end.method_8407() != class_1267.field_5801 && !HordsSpawner.isWorldOnCooldown("end") && HordsSpawner.canSpawnInWorld("end", end) && !(players = end.method_18456()).isEmpty() && RANDOM.nextInt(HordsSpawner.getSpawnChance()) == 0 && (spawned = HordsSpawner.spawnEndHord(end, referencePlayer = (class_3222)players.get(RANDOM.nextInt(players.size()))))) {
            HordsSpawner.setWorldCooldown("end");
        }
        if (server.method_3780() % 100 == 0) {
            HordsSpawner.cleanupOldBossesAndUpdateCount("overworld", overworld);
            if (nether != null) {
                HordsSpawner.cleanupOldBossesAndUpdateCount("nether", nether);
            }
            if (end != null) {
                HordsSpawner.cleanupOldBossesAndUpdateCount("end", end);
            }
        }
    }

    private static boolean spawnOverworldHord(class_3218 world, class_3222 referencePlayer) {
        HordType hordType;
        boolean isInOcean = HordsSpawner.isPlayerInOcean(world, referencePlayer.method_24515());
        if (!isInOcean && HordsSpawner.getRequireNightTime() && !HordsSpawner.isNightTime(world)) {
            return false;
        }
        if (isInOcean) {
            hordType = HordType.OCEAN_HORD;
        } else {
            HordType[] overworldTypes = new HordType[]{HordType.ZOMBIE_HORD, HordType.SKELETON_HORD, HordType.MIXED_HORD};
            hordType = overworldTypes[RANDOM.nextInt(overworldTypes.length)];
        }
        class_243 playerPos = referencePlayer.method_19538();
        class_2338 spawnPos = hordType == HordType.OCEAN_HORD ? HordsSpawner.findOceanSpawnPosition(world, playerPos) : HordsSpawner.findOverworldSpawnPosition(world, playerPos);
        if (spawnPos == null) {
            return false;
        }
        int hordSize = HordsSpawner.getMinHordSize() + RANDOM.nextInt(HordsSpawner.getMaxHordSize() - HordsSpawner.getMinHordSize() + 1);
        HordsSpawner.spawnSpecificHord(world, spawnPos, hordType, hordSize);
        HordsSpawner.broadcastHordMessage(world, spawnPos, hordType);
        return true;
    }

    private static boolean isNightTime(class_3218 world) {
        long timeOfDay = world.method_8532() % 24000L;
        return timeOfDay >= 13000L && timeOfDay <= 23000L;
    }

    private static boolean spawnNetherHord(class_3218 world, class_3222 referencePlayer) {
        HordType hordType;
        class_2338 playerPos = referencePlayer.method_24515();
        boolean isInBasaltDelta = HordsSpawner.isPlayerInBasaltDelta(world, playerPos);
        boolean isInNetherFortress = HordsSpawner.isPlayerInNetherFortress(world, playerPos);
        boolean isInSoulSandValley = HordsSpawner.isPlayerInSoulSandValley(world, playerPos);
        if (isInSoulSandValley) {
            HordType[] soulSandTypes = new HordType[]{HordType.SOULSAND_HORD, HordType.ZOMBIFIED_HORD, HordType.PIGLIN_HORD, HordType.NETHER_MIXED_HORD};
            hordType = soulSandTypes[RANDOM.nextInt(soulSandTypes.length)];
        } else if (isInNetherFortress) {
            HordType[] fortressTypes = new HordType[]{HordType.NETHERFORTRESS_HORD, HordType.ZOMBIFIED_HORD, HordType.PIGLIN_HORD, HordType.NETHER_MIXED_HORD};
            hordType = fortressTypes[RANDOM.nextInt(fortressTypes.length)];
        } else if (isInBasaltDelta) {
            HordType[] basaltTypes = new HordType[]{HordType.MAGMACUBE_HORD, HordType.ZOMBIFIED_HORD, HordType.PIGLIN_HORD, HordType.NETHER_MIXED_HORD};
            hordType = basaltTypes[RANDOM.nextInt(basaltTypes.length)];
        } else {
            HordType[] netherTypes = new HordType[]{HordType.ZOMBIFIED_HORD, HordType.PIGLIN_HORD, HordType.NETHER_MIXED_HORD};
            hordType = netherTypes[RANDOM.nextInt(netherTypes.length)];
        }
        class_243 playerPosVec = referencePlayer.method_19538();
        class_2338 spawnPos = HordsSpawner.findNetherSpawnPosition(world, playerPosVec);
        if (spawnPos == null) {
            return false;
        }
        int hordSize = HordsSpawner.getMinHordSize() + RANDOM.nextInt(HordsSpawner.getMaxHordSize() - HordsSpawner.getMinHordSize() + 1);
        HordsSpawner.spawnSpecificHord(world, spawnPos, hordType, hordSize);
        HordsSpawner.broadcastHordMessage(world, spawnPos, hordType);
        return true;
    }

    private static boolean spawnEndHord(class_3218 world, class_3222 referencePlayer) {
        class_243 playerPos = referencePlayer.method_19538();
        class_2338 spawnPos = HordsSpawner.findSpawnPosition(world, playerPos);
        if (spawnPos == null) {
            return false;
        }
        int hordSize = HordsSpawner.getMinHordSize() + RANDOM.nextInt(HordsSpawner.getMaxHordSize() - HordsSpawner.getMinHordSize() + 1);
        HordsSpawner.spawnSpecificHord(world, spawnPos, HordType.END_HORD, hordSize);
        HordsSpawner.broadcastHordMessage(world, spawnPos, HordType.END_HORD);
        return true;
    }

    public static void spawnSpecificHord(class_3218 world, class_2338 center, HordType type, int size) {
        switch (type.ordinal()) {
            case 0: {
                HordsSpawner.spawnZombieHordInternal(world, center, size);
                break;
            }
            case 1: {
                HordsSpawner.spawnSkeletonHordInternal(world, center, size);
                break;
            }
            case 2: {
                HordsSpawner.spawnMixedHordInternal(world, center, size);
                break;
            }
            case 3: {
                HordsSpawner.spawnZombifiedHordInternal(world, center, size);
                break;
            }
            case 4: {
                HordsSpawner.spawnEndHordInternal(world, center, size);
                break;
            }
            case 5: {
                HordsSpawner.spawnOceanHordInternal(world, center, size);
                break;
            }
            case 6: {
                HordsSpawner.spawnPiglinHordInternal(world, center, size);
                break;
            }
            case 7: {
                HordsSpawner.spawnMagmacubeHordInternal(world, center, size);
                break;
            }
            case 8: {
                HordsSpawner.spawnNetherFortressHordInternal(world, center, size);
                break;
            }
            case 9: {
                HordsSpawner.spawnNetherMixedHordInternal(world, center, size);
                break;
            }
            case 10: {
                HordsSpawner.spawnSoulSandHordInternal(world, center, size);
            }
        }
    }

    private static String getHordTypeName(HordType type) {
        switch (type.ordinal()) {
            case 0: {
                return "Zombie Hord";
            }
            case 1: {
                return "Skeleton Hord";
            }
            case 2: {
                return "Mixed Hord";
            }
            case 3: {
                return "Zombified Hord";
            }
            case 4: {
                return "End Hord";
            }
            case 5: {
                return "Ocean Hord";
            }
            case 6: {
                return "Piglin Hord";
            }
            case 7: {
                return "Magma Cube Hord";
            }
            case 8: {
                return "Nether Fortress Hord";
            }
            case 9: {
                return "Nether Mixed Hord";
            }
            case 10: {
                return "Soul Sand Hord";
            }
        }
        return "Unknown Hord";
    }

    private static class_1799 createPowerfulBow() {
        return new class_1799((class_1935)class_1802.field_8102);
    }

    private static void spawnZombieHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1642 boss = new class_1642(class_1299.field_6051, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        HordsSpawner.createBoss((class_1588)boss);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.ZOMBIE_HORD, size, center);
        List<class_1299> zombieTypes = Arrays.asList(class_1299.field_6051, class_1299.field_6051, class_1299.field_6051, class_1299.field_6054, class_1299.field_6071);
        for (int i = 0; i < size - 1; ++i) {
            class_1299 mobType = zombieTypes.get(RANDOM.nextInt(zombieTypes.size()));
            class_1588 mob = (class_1588)mobType.method_5883((class_1937)world, class_3730.field_16461);
            if (mob == null) continue;
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 5);
            mob.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f) {
                HordsSpawner.enhanceMob(mob);
            }
            world.method_8649((class_1297)mob);
        }
    }

    private static void spawnSkeletonHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1613 boss = new class_1613(class_1299.field_6137, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        HordsSpawner.createBoss((class_1588)boss);
        boss.method_5673(class_1304.field_6173, HordsSpawner.createPowerfulBow());
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 4, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.SKELETON_HORD, size, center);
        List<class_1299> skeletonTypes = Arrays.asList(class_1299.field_6137, class_1299.field_6137, class_1299.field_6137, class_1299.field_6098, class_1299.field_49148);
        for (int i = 0; i < size - 1; ++i) {
            class_1299 mobType = skeletonTypes.get(RANDOM.nextInt(skeletonTypes.size()));
            class_1588 mob = (class_1588)mobType.method_5883((class_1937)world, class_3730.field_16461);
            if (mob == null) continue;
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 5);
            mob.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            mob.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
            mob.method_5946(class_1304.field_6173, 0.085f);
            if (RANDOM.nextFloat() < 0.3f) {
                HordsSpawner.enhanceMob(mob);
            }
            world.method_8649((class_1297)mob);
        }
    }

    private static void spawnMixedHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1642 boss = new class_1642(class_1299.field_6051, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        HordsSpawner.createBoss((class_1588)boss);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.MIXED_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            int mobChoice = RANDOM.nextInt(5);
            if (mobChoice == 0) {
                class_1642 zombie = new class_1642(class_1299.field_6051, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                zombie.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)zombie);
                }
                world.method_8649((class_1297)zombie);
                continue;
            }
            if (mobChoice == 1) {
                class_1613 skeleton = new class_1613(class_1299.field_6137, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                skeleton.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                skeleton.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                skeleton.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)skeleton);
                }
                world.method_8649((class_1297)skeleton);
                continue;
            }
            if (mobChoice == 2) {
                class_1627 stray = new class_1627(class_1299.field_6098, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                stray.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                stray.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                stray.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)stray);
                }
                world.method_8649((class_1297)stray);
                continue;
            }
            if (mobChoice == 3) {
                class_9254 bogged = new class_9254(class_1299.field_49148, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                bogged.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                bogged.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                bogged.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)bogged);
                }
                world.method_8649((class_1297)bogged);
                continue;
            }
            class_1548 creeper = new class_1548(class_1299.field_6046, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
            creeper.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.4f) {
                HordsSpawner.enhanceMob((class_1588)creeper);
            }
            world.method_8649((class_1297)creeper);
        }
    }

    private static void spawnZombifiedHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1590 boss = new class_1590(class_1299.field_6050, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5673(class_1304.field_6173, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8371 : class_1802.field_8802)));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Hord Leader").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.ZOMBIFIED_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_1590 zombifiedPiglin = new class_1590(class_1299.field_6050, (class_1937)world);
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 6);
            zombifiedPiglin.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            zombifiedPiglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
            zombifiedPiglin.method_5946(class_1304.field_6173, 0.085f);
            if (RANDOM.nextFloat() < 0.3f) {
                HordsSpawner.enhanceMob((class_1588)zombifiedPiglin);
            }
            world.method_8649((class_1297)zombifiedPiglin);
        }
    }

    private static void spawnEndHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1560 boss = new class_1560(class_1299.field_6091, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(80.0);
            boss.method_6033(80.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5665((class_2561)class_2561.method_43470((String)"Void Lord").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.END_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            if (RANDOM.nextFloat() < 0.7f) {
                class_1560 enderman = new class_1560(class_1299.field_6091, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
                enderman.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)enderman);
                }
                world.method_8649((class_1297)enderman);
                continue;
            }
            class_1606 shulker = new class_1606(class_1299.field_6109, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
            spawnPos = new class_2338(spawnPos.method_10263(), spawnPos.method_10264() + 1, spawnPos.method_10260());
            shulker.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && shulker.method_5996(class_5134.field_23716) != null) {
                double currentHealth = shulker.method_5996(class_5134.field_23716).method_6201();
                shulker.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.3);
                shulker.method_6033(shulker.method_6063());
            }
            world.method_8649((class_1297)shulker);
        }
    }

    private static void spawnOceanHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1550 boss = new class_1550(class_1299.field_6086, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(160.0);
            boss.method_6033(160.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5665((class_2561)class_2561.method_43470((String)"Ocean Lord").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.OCEAN_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            int mobChoice = RANDOM.nextInt(3);
            if (mobChoice == 0 || mobChoice == 1) {
                class_1551 drowned = new class_1551(class_1299.field_6123, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
                drowned.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                drowned.method_5673(class_1304.field_6173, class_1799.field_8037);
                drowned.method_5946(class_1304.field_6173, 0.0f);
                if (RANDOM.nextFloat() < 0.3f) {
                    HordsSpawner.enhanceMob((class_1588)drowned);
                }
                world.method_8649((class_1297)drowned);
                continue;
            }
            class_1577 guardian = new class_1577(class_1299.field_6118, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
            guardian.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && guardian.method_5996(class_5134.field_23716) != null) {
                double currentHealth = guardian.method_5996(class_5134.field_23716).method_6201();
                guardian.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.2);
                guardian.method_6033(guardian.method_6063());
            }
            world.method_8649((class_1297)guardian);
        }
    }

    private static void spawnPiglinHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_5419 boss = new class_5419(class_1299.field_25751, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(100.0);
            boss.method_6033(100.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8825));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8862));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8678));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Piglin Warlord").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.PIGLIN_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_4836 piglin = new class_4836(class_1299.field_22281, (class_1937)world);
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 6);
            piglin.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextBoolean()) {
                piglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8399));
            } else {
                piglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
            }
            piglin.method_5946(class_1304.field_6173, 0.15f);
            if (RANDOM.nextFloat() < 0.4f) {
                HordsSpawner.enhanceMob((class_1588)piglin);
            }
            world.method_8649((class_1297)piglin);
        }
    }

    private static void spawnMagmacubeHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1589 boss = new class_1589(class_1299.field_6102, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        boss.method_7161(4, true);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(80.0);
            boss.method_6033(80.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        boss.method_5665((class_2561)class_2561.method_43470((String)"Molten King").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.MAGMACUBE_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_1589 magmaCube = new class_1589(class_1299.field_6102, (class_1937)world);
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
            magmaCube.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            int size_choice = RANDOM.nextInt(10);
            if (size_choice < 2) {
                magmaCube.method_7161(1, true);
            } else if (size_choice < 7) {
                magmaCube.method_7161(2, true);
            } else {
                magmaCube.method_7161(3, true);
            }
            if (RANDOM.nextFloat() < 0.4f) {
                if (magmaCube.method_5996(class_5134.field_23716) != null) {
                    double currentHealth = magmaCube.method_5996(class_5134.field_23716).method_6201();
                    magmaCube.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.4);
                    magmaCube.method_6033(magmaCube.method_6063());
                }
                magmaCube.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
            }
            world.method_8649((class_1297)magmaCube);
        }
    }

    private static void spawnNetherFortressHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1639 boss = new class_1639(class_1299.field_6076, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        boss.method_5673(class_1304.field_6173, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8371 : class_1802.field_8802)));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Fortress Commander").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.NETHERFORTRESS_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            if (RANDOM.nextFloat() < 0.6f) {
                class_1639 witherSkeleton = new class_1639(class_1299.field_6076, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 6);
                witherSkeleton.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                witherSkeleton.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8528));
                witherSkeleton.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)witherSkeleton);
                }
                world.method_8649((class_1297)witherSkeleton);
                continue;
            }
            class_1545 blaze = new class_1545(class_1299.field_6099, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
            blaze.method_5814((double)spawnPos.method_10263() + 0.5, (double)(spawnPos.method_10264() + 2), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && blaze.method_5996(class_5134.field_23716) != null) {
                double currentHealth = blaze.method_5996(class_5134.field_23716).method_6201();
                blaze.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.3);
                blaze.method_6033(blaze.method_6063());
            }
            world.method_8649((class_1297)blaze);
        }
    }

    private static void spawnNetherMixedHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1590 boss = new class_1590(class_1299.field_6050, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        boss.method_5673(class_1304.field_6173, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8371 : class_1802.field_8802)));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Nether Overlord").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.NETHER_MIXED_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            int mobChoice = RANDOM.nextInt(3);
            if (mobChoice == 0) {
                class_4836 piglin = new class_4836(class_1299.field_22281, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                piglin.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                if (RANDOM.nextBoolean()) {
                    piglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8399));
                } else {
                    piglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
                }
                piglin.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.3f) {
                    HordsSpawner.enhanceMob((class_1588)piglin);
                }
                world.method_8649((class_1297)piglin);
                continue;
            }
            if (mobChoice == 1) {
                class_1590 zombifiedPiglin = new class_1590(class_1299.field_6050, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                zombifiedPiglin.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                zombifiedPiglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
                zombifiedPiglin.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.3f) {
                    HordsSpawner.enhanceMob((class_1588)zombifiedPiglin);
                }
                world.method_8649((class_1297)zombifiedPiglin);
                continue;
            }
            class_1545 blaze = new class_1545(class_1299.field_6099, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
            blaze.method_5814((double)spawnPos.method_10263() + 0.5, (double)(spawnPos.method_10264() + 3), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && blaze.method_5996(class_5134.field_23716) != null) {
                double currentHealth = blaze.method_5996(class_5134.field_23716).method_6201();
                blaze.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.2);
                blaze.method_6033(blaze.method_6063());
            }
            world.method_8649((class_1297)blaze);
        }
    }

    private static void spawnSoulSandHordInternal(class_3218 world, class_2338 center, int size) {
        String worldName = HordsSpawner.getWorldName(world);
        class_1613 boss = new class_1613(class_1299.field_6137, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        boss.method_5673(class_1304.field_6173, HordsSpawner.createPowerfulBow());
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 4, false, false));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Soul Wraith").method_27695(new class_124[]{class_124.field_1058, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        HordsSpawner.registerBoss(worldName, (class_1309)boss, HordType.SOULSAND_HORD, size, center);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            if (RANDOM.nextFloat() < 0.8f) {
                class_1613 skeleton = new class_1613(class_1299.field_6137, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
                skeleton.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                skeleton.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)skeleton);
                }
                world.method_8649((class_1297)skeleton);
                continue;
            }
            class_1571 ghast = new class_1571(class_1299.field_6107, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 12);
            spawnPos = new class_2338(spawnPos.method_10263(), spawnPos.method_10264() + 8, spawnPos.method_10260());
            ghast.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && ghast.method_5996(class_5134.field_23716) != null) {
                double currentHealth = ghast.method_5996(class_5134.field_23716).method_6201();
                ghast.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.2);
                ghast.method_6033(ghast.method_6063());
            }
            world.method_8649((class_1297)ghast);
        }
    }

    private static void createBoss(class_1588 boss) {
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        if (boss instanceof class_1642) {
            class_1799 weapon = RANDOM.nextBoolean() ? new class_1799((class_1935)class_1802.field_8371) : new class_1799((class_1935)class_1802.field_8802);
            boss.method_5673(class_1304.field_6173, weapon);
        }
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Hord Leader").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        boss.method_5880(true);
    }

    private static void enhanceMob(class_1588 mob) {
        int enhancement = RANDOM.nextInt(3);
        switch (enhancement) {
            case 0: {
                if (mob.method_5996(class_5134.field_23716) == null) break;
                double currentHealth = mob.method_5996(class_5134.field_23716).method_6201();
                mob.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.5);
                mob.method_6033(mob.method_6063());
                break;
            }
            case 1: {
                mob.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 0, false, false));
                break;
            }
            case 2: {
                if (!RANDOM.nextBoolean()) break;
                mob.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8267));
            }
        }
    }

    private static boolean isPlayerInOcean(class_3218 world, class_2338 playerPos) {
        class_6880 biome = world.method_23753(playerPos);
        String biomeName = biome.method_55840();
        return biomeName.contains("ocean");
    }

    private static boolean isPlayerInSoulSandValley(class_3218 world, class_2338 playerPos) {
        class_6880 biome = world.method_23753(playerPos);
        String biomeName = biome.method_55840();
        return biomeName.contains("soul_sand_valley");
    }

    private static boolean isPlayerInNetherFortress(class_3218 world, class_2338 playerPos) {
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    class_2338 checkPos = playerPos.method_10069(x, y, z);
                    if (world.method_8320(checkPos).method_26204() != class_2246.field_10266) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPlayerInBasaltDelta(class_3218 world, class_2338 playerPos) {
        class_6880 biome = world.method_23753(playerPos);
        String biomeName = biome.method_55840();
        return biomeName.contains("basalt_deltas");
    }

    private static class_2338 findOverworldSpawnPosition(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 80; ++attempts) {
            class_2338 below;
            boolean hasGround;
            boolean hasMoreSpace;
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double distance = (double)HordsSpawner.getMinPlayerDistance() + RANDOM.nextDouble() * (double)(HordsSpawner.getMaxPlayerDistance() - HordsSpawner.getMinPlayerDistance());
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            int z = (int)(playerPos.field_1350 + Math.sin(angle) * distance);
            int surfaceY = world.method_8624(class_2902.class_2903.field_13203, x, z);
            class_2338 surfacePos = new class_2338(x, surfaceY, z);
            class_2338 above = surfacePos.method_10084();
            class_2338 above2 = surfacePos.method_10086(2);
            class_2680 currentState = world.method_8320(surfacePos);
            class_2680 aboveState = world.method_8320(above);
            class_2680 above2State = world.method_8320(above2);
            boolean canSpawnHere = currentState.method_26215();
            boolean hasSpace = aboveState.method_26215() || aboveState.method_45474();
            boolean bl = hasMoreSpace = above2State.method_26215() || above2State.method_45474();
            if (currentState.method_26204() == class_2246.field_10477) {
                canSpawnHere = true;
            }
            if (aboveState.method_26204() == class_2246.field_10477) {
                hasSpace = true;
            }
            if (above2State.method_26204() == class_2246.field_10477) {
                hasMoreSpace = true;
            }
            boolean bl2 = hasGround = world.method_8320(below = surfacePos.method_10074()).method_26212((class_1922)world, below) || !world.method_8320(below).method_26215();
            if (!canSpawnHere || !hasSpace || !hasMoreSpace || !hasGround) continue;
            return surfacePos;
        }
        return null;
    }

    private static class_2338 findOceanSpawnPosition(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 30; ++attempts) {
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double distance = (double)HordsSpawner.getMinPlayerDistance() + RANDOM.nextDouble() * (double)(HordsSpawner.getMaxPlayerDistance() - HordsSpawner.getMinPlayerDistance());
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            int z = (int)(playerPos.field_1350 + Math.sin(angle) * distance);
            for (int y = world.method_8615() - 15; y <= world.method_8615() + 5; ++y) {
                class_2338 pos = new class_2338(x, y, z);
                if (world.method_8320(pos).method_26204() != class_2246.field_10382 || world.method_8320(pos.method_10084()).method_26204() != class_2246.field_10382 || world.method_8320(pos.method_10086(2)).method_26204() != class_2246.field_10382) continue;
                return pos;
            }
        }
        return null;
    }

    private static class_2338 findSpawnPosition(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 20; ++attempts) {
            int z;
            int y;
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double distance = (double)HordsSpawner.getMinPlayerDistance() + RANDOM.nextDouble() * (double)(HordsSpawner.getMaxPlayerDistance() - HordsSpawner.getMinPlayerDistance());
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            class_2338 pos = new class_2338(x, y = world.method_8624(class_2902.class_2903.field_13203, x, z = (int)(playerPos.field_1350 + Math.sin(angle) * distance)), z);
            if (!world.method_8320(pos).method_26215() || !world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074())) continue;
            return pos;
        }
        return null;
    }

    private static class_2338 findNetherSpawnPosition(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 30; ++attempts) {
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double distance = (double)HordsSpawner.getMinPlayerDistance() + RANDOM.nextDouble() * (double)(HordsSpawner.getMaxPlayerDistance() - HordsSpawner.getMinPlayerDistance());
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            int z = (int)(playerPos.field_1350 + Math.sin(angle) * distance);
            for (int y = 10; y < 120; ++y) {
                class_2338 pos = new class_2338(x, y, z);
                class_2338 posAbove = pos.method_10084();
                class_2338 posAbove2 = pos.method_10086(2);
                if (!world.method_8320(pos).method_26212((class_1922)world, pos) || !world.method_8320(posAbove).method_26215() || !world.method_8320(posAbove2).method_26215() || !world.method_8320(posAbove2.method_10084()).method_26215() || HordsSpawner.isNearLava(world, posAbove) || y >= 115) continue;
                return posAbove;
            }
        }
        return null;
    }

    private static boolean isNearLava(class_3218 world, class_2338 pos) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 1; ++dy) {
                    class_2338 checkPos = pos.method_10069(dx, dy, dz);
                    if (world.method_8320(checkPos).method_26204() != class_2246.field_10164) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static class_2338 getRandomPositionAround(class_2338 center, int radius) {
        int x = center.method_10263() + RANDOM.nextInt(radius * 2 + 1) - radius;
        int z = center.method_10260() + RANDOM.nextInt(radius * 2 + 1) - radius;
        int y = center.method_10264() + RANDOM.nextInt(3) - 1;
        return new class_2338(x, y, z);
    }

    public static String getDetailedBossStatus(String worldName) {
        Map<UUID, BossInfo> worldBosses = activeBosses.get(worldName);
        if (worldBosses == null || worldBosses.isEmpty()) {
            return "No active hordes";
        }
        StringBuilder status = new StringBuilder();
        for (BossInfo info : worldBosses.values()) {
            long age = info.getAgeInSeconds();
            status.append(String.format("  %s: %d entities (%ds old)\n", HordsSpawner.getHordTypeName(info.type), info.hordeSize, age));
        }
        return status.toString();
    }

    public static String getWorldName(class_3218 world) {
        if (world.method_27983() == class_1937.field_25179) {
            return "overworld";
        }
        if (world.method_27983() == class_1937.field_25180) {
            return "nether";
        }
        if (world.method_27983() == class_1937.field_25181) {
            return "end";
        }
        return "unknown";
    }

    public static class BossInfo {
        public final long spawnTime = System.currentTimeMillis();
        public final HordType type;
        public final UUID bossId;
        public final int hordeSize;
        public final class_2338 spawnLocation;

        public BossInfo(HordType type, UUID bossId, int hordeSize, class_2338 spawnLocation) {
            this.type = type;
            this.bossId = bossId;
            this.hordeSize = hordeSize;
            this.spawnLocation = spawnLocation;
        }

        public long getAgeInSeconds() {
            return (System.currentTimeMillis() - this.spawnTime) / 1000L;
        }
    }

    public static enum HordType {
        ZOMBIE_HORD,
        SKELETON_HORD,
        MIXED_HORD,
        ZOMBIFIED_HORD,
        END_HORD,
        OCEAN_HORD,
        PIGLIN_HORD,
        MAGMACUBE_HORD,
        NETHERFORTRESS_HORD,
        NETHER_MIXED_HORD,
        SOULSAND_HORD;

    }
}

