/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1550;
import net.minecraft.class_1551;
import net.minecraft.class_1560;
import net.minecraft.class_1571;
import net.minecraft.class_1577;
import net.minecraft.class_1588;
import net.minecraft.class_1589;
import net.minecraft.class_1590;
import net.minecraft.class_1606;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_4836;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5419;
import net.minecraft.class_6880;
import net.minecraft.class_9254;
import net.minecraft.server.MinecraftServer;

public class HordsSpawner {
    private static final Random RANDOM = new Random();
    private static final int HORD_SPAWN_CHANCE = 1800;
    private static final int MIN_PLAYER_DISTANCE = 20;
    private static final int MAX_PLAYER_DISTANCE = 50;
    private static final int MIN_HORD_SIZE = 10;
    private static final int MAX_HORD_SIZE = 20;

    public static void onServerTick(MinecraftServer server) {
        class_3218 end;
        class_3218 nether;
        class_3218 overworld = server.method_30002();
        if (overworld.method_8407() != class_1267.field_5801) {
            for (Object player : overworld.method_18456()) {
                if (RANDOM.nextInt(1800) != 0) continue;
                HordsSpawner.spawnOverworldHord(overworld, (class_1657)player);
            }
        }
        if ((nether = server.method_3847(class_1937.field_25180)) != null && nether.method_8407() != class_1267.field_5801) {
            for (class_1657 player : nether.method_18456()) {
                if (RANDOM.nextInt(1800) != 0) continue;
                HordsSpawner.spawnNetherHord(nether, player);
            }
        }
        if ((end = server.method_3847(class_1937.field_25181)) != null && end.method_8407() != class_1267.field_5801) {
            for (class_1657 player : end.method_18456()) {
                if (RANDOM.nextInt(1800) != 0) continue;
                HordsSpawner.spawnEndHord(end, player);
            }
        }
    }

    private static void spawnOverworldHord(class_3218 world, class_1657 player) {
        HordType hordType;
        boolean isInOcean = HordsSpawner.isPlayerInOcean(world, player.method_24515());
        if (!isInOcean && !HordsSpawner.isNightTime(world)) {
            return;
        }
        if (isInOcean) {
            hordType = HordType.OCEAN_HORD;
        } else {
            HordType[] overworldTypes = new HordType[]{HordType.ZOMBIE_HORD, HordType.SKELETON_HORD, HordType.MIXED_HORD};
            hordType = overworldTypes[RANDOM.nextInt(overworldTypes.length)];
        }
        class_243 playerPos = player.method_19538();
        class_2338 spawnPos = hordType == HordType.OCEAN_HORD ? HordsSpawner.findOceanSpawnPosition(world, playerPos) : HordsSpawner.findSpawnPosition(world, playerPos);
        if (spawnPos == null) {
            return;
        }
        int hordSize = 10 + RANDOM.nextInt(10);
        HordsSpawner.spawnSpecificHord(world, spawnPos, hordType, hordSize);
        class_5250 message = class_2561.method_43470((String)("A " + HordsSpawner.getHordTypeName(hordType) + " has appeared nearby!")).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
        player.method_7353((class_2561)message, false);
    }

    private static boolean isNightTime(class_3218 world) {
        long timeOfDay = world.method_8532() % 24000L;
        return timeOfDay >= 13000L && timeOfDay <= 23000L;
    }

    private static void spawnNetherHord(class_3218 world, class_1657 player) {
        HordType hordType;
        class_2338 playerPos = player.method_24515();
        boolean isInBasaltDelta = HordsSpawner.isPlayerInBasaltDelta(world, playerPos);
        boolean isInNetherFortress = HordsSpawner.isPlayerInNetherFortress(world, playerPos);
        boolean isInSoulSandValley = HordsSpawner.isPlayerInSoulSandValley(world, playerPos);
        if (isInSoulSandValley) {
            HordType[] soulSandTypes = new HordType[]{HordType.SOULSAND_HORD, HordType.ZOMBIFIED_HORD, HordType.PIGLIN_HORD, HordType.NETHER_MIXED_HORD};
            hordType = soulSandTypes[RANDOM.nextInt(soulSandTypes.length)];
        } else if (isInNetherFortress) {
            HordType[] fortressTypes = new HordType[]{HordType.NETHERFORTRESS_HORD, HordType.ZOMBIFIED_HORD, HordType.PIGLIN_HORD, HordType.NETHER_MIXED_HORD};
            hordType = fortressTypes[RANDOM.nextInt(fortressTypes.length)];
        } else if (isInBasaltDelta) {
            HordType[] basaltTypes = new HordType[]{HordType.MAGMACUBE_HORD, HordType.ZOMBIFIED_HORD, HordType.PIGLIN_HORD, HordType.NETHER_MIXED_HORD};
            hordType = basaltTypes[RANDOM.nextInt(basaltTypes.length)];
        } else {
            HordType[] netherTypes = new HordType[]{HordType.ZOMBIFIED_HORD, HordType.PIGLIN_HORD, HordType.NETHER_MIXED_HORD};
            hordType = netherTypes[RANDOM.nextInt(netherTypes.length)];
        }
        class_243 playerPosVec = player.method_19538();
        class_2338 spawnPos = HordsSpawner.findNetherSpawnPosition(world, playerPosVec);
        if (spawnPos == null) {
            return;
        }
        int hordSize = 10 + RANDOM.nextInt(10);
        HordsSpawner.spawnSpecificHord(world, spawnPos, hordType, hordSize);
        class_5250 message = class_2561.method_43470((String)("A " + HordsSpawner.getHordTypeName(hordType) + " has appeared nearby!")).method_27695(new class_124[]{class_124.field_1079, class_124.field_1067});
        player.method_7353((class_2561)message, false);
    }

    private static void spawnEndHord(class_3218 world, class_1657 player) {
        class_243 playerPos = player.method_19538();
        class_2338 spawnPos = HordsSpawner.findSpawnPosition(world, playerPos);
        if (spawnPos == null) {
            return;
        }
        int hordSize = 10 + RANDOM.nextInt(10);
        HordsSpawner.spawnSpecificHord(world, spawnPos, HordType.END_HORD, hordSize);
        class_5250 message = class_2561.method_43470((String)("An " + HordsSpawner.getHordTypeName(HordType.END_HORD) + " has appeared nearby!")).method_27695(new class_124[]{class_124.field_1064, class_124.field_1067});
        player.method_7353((class_2561)message, false);
    }

    public static void spawnSpecificHord(class_3218 world, class_2338 center, HordType type, int size) {
        switch (type.ordinal()) {
            case 0: {
                HordsSpawner.spawnZombieHordInternal(world, center, size);
                break;
            }
            case 1: {
                HordsSpawner.spawnSkeletonHordInternal(world, center, size);
                break;
            }
            case 2: {
                HordsSpawner.spawnMixedHordInternal(world, center, size);
                break;
            }
            case 3: {
                HordsSpawner.spawnZombifiedHordInternal(world, center, size);
                break;
            }
            case 4: {
                HordsSpawner.spawnEndHordInternal(world, center, size);
                break;
            }
            case 5: {
                HordsSpawner.spawnOceanHordInternal(world, center, size);
                break;
            }
            case 6: {
                HordsSpawner.spawnPiglinHordInternal(world, center, size);
                break;
            }
            case 7: {
                HordsSpawner.spawnMagmacubeHordInternal(world, center, size);
                break;
            }
            case 8: {
                HordsSpawner.spawnNetherFortressHordInternal(world, center, size);
                break;
            }
            case 9: {
                HordsSpawner.spawnNetherMixedHordInternal(world, center, size);
                break;
            }
            case 10: {
                HordsSpawner.spawnSoulSandHordInternal(world, center, size);
            }
        }
    }

    private static class_1799 createPowerfulBow() {
        return new class_1799((class_1935)class_1802.field_8102);
    }

    private static void spawnZombieHordInternal(class_3218 world, class_2338 center, int size) {
        class_1642 boss = new class_1642((class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        HordsSpawner.createBoss((class_1588)boss);
        world.method_8649((class_1297)boss);
        List<class_1299> zombieTypes = Arrays.asList(class_1299.field_6051, class_1299.field_6051, class_1299.field_6051, class_1299.field_6054, class_1299.field_6071);
        for (int i = 0; i < size - 1; ++i) {
            class_1299 mobType = zombieTypes.get(RANDOM.nextInt(zombieTypes.size()));
            class_1588 mob = (class_1588)mobType.method_5883((class_1937)world);
            if (mob == null) continue;
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 5);
            mob.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f) {
                HordsSpawner.enhanceMob(mob);
            }
            world.method_8649((class_1297)mob);
        }
    }

    private static void spawnSkeletonHordInternal(class_3218 world, class_2338 center, int size) {
        class_1613 boss = new class_1613(class_1299.field_6137, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        HordsSpawner.createBoss((class_1588)boss);
        boss.method_5673(class_1304.field_6173, HordsSpawner.createPowerfulBow());
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 4, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        world.method_8649((class_1297)boss);
        List<class_1299> skeletonTypes = Arrays.asList(class_1299.field_6137, class_1299.field_6137, class_1299.field_6137, class_1299.field_6098, class_1299.field_49148);
        for (int i = 0; i < size - 1; ++i) {
            class_1299 mobType = skeletonTypes.get(RANDOM.nextInt(skeletonTypes.size()));
            class_1588 mob = (class_1588)mobType.method_5883((class_1937)world);
            if (mob == null) continue;
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 5);
            mob.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            mob.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
            mob.method_5946(class_1304.field_6173, 0.085f);
            if (RANDOM.nextFloat() < 0.3f) {
                HordsSpawner.enhanceMob(mob);
            }
            world.method_8649((class_1297)mob);
        }
    }

    private static void spawnMixedHordInternal(class_3218 world, class_2338 center, int size) {
        class_1642 boss = new class_1642((class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        HordsSpawner.createBoss((class_1588)boss);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            int mobChoice = RANDOM.nextInt(5);
            if (mobChoice == 0) {
                class_1642 zombie = new class_1642((class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                zombie.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)zombie);
                }
                world.method_8649((class_1297)zombie);
                continue;
            }
            if (mobChoice == 1) {
                class_1613 skeleton = new class_1613(class_1299.field_6137, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                skeleton.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                skeleton.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                skeleton.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)skeleton);
                }
                world.method_8649((class_1297)skeleton);
                continue;
            }
            if (mobChoice == 2) {
                class_1627 stray = new class_1627(class_1299.field_6098, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                stray.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                stray.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                stray.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)stray);
                }
                world.method_8649((class_1297)stray);
                continue;
            }
            if (mobChoice == 3) {
                class_9254 bogged = new class_9254(class_1299.field_49148, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                bogged.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                bogged.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                bogged.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)bogged);
                }
                world.method_8649((class_1297)bogged);
                continue;
            }
            class_1548 creeper = new class_1548(class_1299.field_6046, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
            creeper.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.4f) {
                HordsSpawner.enhanceMob((class_1588)creeper);
            }
            world.method_8649((class_1297)creeper);
        }
    }

    private static void spawnZombifiedHordInternal(class_3218 world, class_2338 center, int size) {
        class_1590 boss = new class_1590(class_1299.field_6050, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5673(class_1304.field_6173, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8371 : class_1802.field_8802)));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Hord Leader").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_1590 zombifiedPiglin = new class_1590(class_1299.field_6050, (class_1937)world);
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 6);
            zombifiedPiglin.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            zombifiedPiglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
            zombifiedPiglin.method_5946(class_1304.field_6173, 0.085f);
            if (RANDOM.nextFloat() < 0.3f) {
                HordsSpawner.enhanceMob((class_1588)zombifiedPiglin);
            }
            world.method_8649((class_1297)zombifiedPiglin);
        }
    }

    private static void spawnEndHordInternal(class_3218 world, class_2338 center, int size) {
        class_1560 boss = new class_1560(class_1299.field_6091, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(80.0);
            boss.method_6033(80.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5665((class_2561)class_2561.method_43470((String)"Void Lord").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            if (RANDOM.nextFloat() < 0.7f) {
                class_1560 enderman = new class_1560(class_1299.field_6091, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
                enderman.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)enderman);
                }
                world.method_8649((class_1297)enderman);
                continue;
            }
            class_1606 shulker = new class_1606(class_1299.field_6109, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
            spawnPos = new class_2338(spawnPos.method_10263(), spawnPos.method_10264() + 1, spawnPos.method_10260());
            shulker.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && shulker.method_5996(class_5134.field_23716) != null) {
                double currentHealth = shulker.method_5996(class_5134.field_23716).method_6201();
                shulker.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.3);
                shulker.method_6033(shulker.method_6063());
            }
            world.method_8649((class_1297)shulker);
        }
    }

    private static void spawnOceanHordInternal(class_3218 world, class_2338 center, int size) {
        class_1550 boss = new class_1550(class_1299.field_6086, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(160.0);
            boss.method_6033(160.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5665((class_2561)class_2561.method_43470((String)"Ocean Lord").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            int mobChoice = RANDOM.nextInt(3);
            if (mobChoice == 0 || mobChoice == 1) {
                class_1551 drowned = new class_1551(class_1299.field_6123, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
                drowned.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                drowned.method_5673(class_1304.field_6173, class_1799.field_8037);
                drowned.method_5946(class_1304.field_6173, 0.0f);
                if (RANDOM.nextFloat() < 0.3f) {
                    HordsSpawner.enhanceMob((class_1588)drowned);
                }
                world.method_8649((class_1297)drowned);
                continue;
            }
            class_1577 guardian = new class_1577(class_1299.field_6118, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
            guardian.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && guardian.method_5996(class_5134.field_23716) != null) {
                double currentHealth = guardian.method_5996(class_5134.field_23716).method_6201();
                guardian.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.2);
                guardian.method_6033(guardian.method_6063());
            }
            world.method_8649((class_1297)guardian);
        }
    }

    private static void spawnPiglinHordInternal(class_3218 world, class_2338 center, int size) {
        class_5419 boss = new class_5419(class_1299.field_25751, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(100.0);
            boss.method_6033(100.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8825));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8862));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8678));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Piglin Warlord").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_4836 piglin = new class_4836(class_1299.field_22281, (class_1937)world);
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 6);
            piglin.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextBoolean()) {
                piglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8399));
            } else {
                piglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
            }
            piglin.method_5946(class_1304.field_6173, 0.15f);
            world.method_8649((class_1297)piglin);
        }
    }

    private static void spawnMagmacubeHordInternal(class_3218 world, class_2338 center, int size) {
        class_1589 boss = new class_1589(class_1299.field_6102, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        boss.method_7161(4, true);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(80.0);
            boss.method_6033(80.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        boss.method_5665((class_2561)class_2561.method_43470((String)"Molten King").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_1589 magmaCube = new class_1589(class_1299.field_6102, (class_1937)world);
            class_2338 spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
            magmaCube.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            int size_choice = RANDOM.nextInt(10);
            if (size_choice < 2) {
                magmaCube.method_7161(1, true);
            } else if (size_choice < 7) {
                magmaCube.method_7161(2, true);
            } else {
                magmaCube.method_7161(3, true);
            }
            if (RANDOM.nextFloat() < 0.4f) {
                if (magmaCube.method_5996(class_5134.field_23716) != null) {
                    double currentHealth = magmaCube.method_5996(class_5134.field_23716).method_6201();
                    magmaCube.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.4);
                    magmaCube.method_6033(magmaCube.method_6063());
                }
                magmaCube.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
            }
            world.method_8649((class_1297)magmaCube);
        }
    }

    private static void spawnNetherFortressHordInternal(class_3218 world, class_2338 center, int size) {
        class_1639 boss = new class_1639(class_1299.field_6076, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        boss.method_5673(class_1304.field_6173, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8371 : class_1802.field_8802)));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Fortress Commander").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            if (RANDOM.nextFloat() < 0.6f) {
                class_1639 witherSkeleton = new class_1639(class_1299.field_6076, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 6);
                witherSkeleton.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                witherSkeleton.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8528));
                witherSkeleton.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)witherSkeleton);
                }
                world.method_8649((class_1297)witherSkeleton);
                continue;
            }
            class_1545 blaze = new class_1545(class_1299.field_6099, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
            blaze.method_5814((double)spawnPos.method_10263() + 0.5, (double)(spawnPos.method_10264() + 2), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f) {
                if (blaze.method_5996(class_5134.field_23716) != null) {
                    double currentHealth = blaze.method_5996(class_5134.field_23716).method_6201();
                    blaze.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.3);
                    blaze.method_6033(blaze.method_6063());
                }
                blaze.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
            }
            world.method_8649((class_1297)blaze);
        }
    }

    private static void spawnNetherMixedHordInternal(class_3218 world, class_2338 center, int size) {
        class_1590 boss = new class_1590(class_1299.field_6050, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        boss.method_5673(class_1304.field_6173, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8371 : class_1802.field_8802)));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Nether Overlord").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            int mobChoice = RANDOM.nextInt(3);
            if (mobChoice == 0) {
                class_4836 piglin = new class_4836(class_1299.field_22281, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                piglin.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                if (RANDOM.nextBoolean()) {
                    piglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8399));
                } else {
                    piglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
                }
                piglin.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.3f) {
                    HordsSpawner.enhanceMob((class_1588)piglin);
                }
                world.method_8649((class_1297)piglin);
                continue;
            }
            if (mobChoice == 1) {
                class_1590 zombifiedPiglin = new class_1590(class_1299.field_6050, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
                zombifiedPiglin.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                zombifiedPiglin.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
                zombifiedPiglin.method_5946(class_1304.field_6173, 0.085f);
                if (RANDOM.nextFloat() < 0.3f) {
                    HordsSpawner.enhanceMob((class_1588)zombifiedPiglin);
                }
                world.method_8649((class_1297)zombifiedPiglin);
                continue;
            }
            class_1545 blaze = new class_1545(class_1299.field_6099, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 7);
            blaze.method_5814((double)spawnPos.method_10263() + 0.5, (double)(spawnPos.method_10264() + 3), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && blaze.method_5996(class_5134.field_23716) != null) {
                double currentHealth = blaze.method_5996(class_5134.field_23716).method_6201();
                blaze.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.2);
                blaze.method_6033(blaze.method_6063());
            }
            world.method_8649((class_1297)blaze);
        }
    }

    private static void spawnSoulSandHordInternal(class_3218 world, class_2338 center, int size) {
        class_1613 boss = new class_1613(class_1299.field_6137, (class_1937)world);
        boss.method_5814((double)center.method_10263() + 0.5, (double)center.method_10264(), (double)center.method_10260() + 0.5);
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE, 0, false, false));
        boss.method_5673(class_1304.field_6173, HordsSpawner.createPowerfulBow());
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 4, false, false));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Soul Wraith").method_27695(new class_124[]{class_124.field_1058, class_124.field_1067}));
        boss.method_5880(true);
        world.method_8649((class_1297)boss);
        for (int i = 0; i < size - 1; ++i) {
            class_2338 spawnPos;
            if (RANDOM.nextFloat() < 0.8f) {
                class_1613 skeleton = new class_1613(class_1299.field_6137, (class_1937)world);
                spawnPos = HordsSpawner.getRandomPositionAround(center, 8);
                skeleton.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                skeleton.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                if (RANDOM.nextFloat() < 0.4f) {
                    HordsSpawner.enhanceMob((class_1588)skeleton);
                }
                world.method_8649((class_1297)skeleton);
                continue;
            }
            class_1571 ghast = new class_1571(class_1299.field_6107, (class_1937)world);
            spawnPos = HordsSpawner.getRandomPositionAround(center, 12);
            spawnPos = new class_2338(spawnPos.method_10263(), spawnPos.method_10264() + 8, spawnPos.method_10260());
            ghast.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (RANDOM.nextFloat() < 0.3f && ghast.method_5996(class_5134.field_23716) != null) {
                double currentHealth = ghast.method_5996(class_5134.field_23716).method_6201();
                ghast.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.2);
                ghast.method_6033(ghast.method_6063());
            }
            world.method_8649((class_1297)ghast);
        }
    }

    private static void createBoss(class_1588 boss) {
        if (boss.method_5996(class_5134.field_23716) != null) {
            boss.method_5996(class_5134.field_23716).method_6192(40.0);
            boss.method_6033(40.0f);
        }
        boss.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 2, false, false));
        boss.method_6092(new class_1293(class_1294.field_5907, Integer.MAX_VALUE, 1, false, false));
        boss.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 2, false, false));
        boss.method_5673(class_1304.field_6166, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8660 : class_1802.field_8285)));
        boss.method_5673(class_1304.field_6172, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8396 : class_1802.field_8348)));
        boss.method_5673(class_1304.field_6174, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8523 : class_1802.field_8058)));
        boss.method_5673(class_1304.field_6169, new class_1799((class_1935)(RANDOM.nextBoolean() ? class_1802.field_8743 : class_1802.field_8805)));
        if (boss instanceof class_1642) {
            class_1799 weapon = RANDOM.nextBoolean() ? new class_1799((class_1935)class_1802.field_8371) : new class_1799((class_1935)class_1802.field_8802);
            boss.method_5673(class_1304.field_6173, weapon);
        }
        for (class_1304 slot : class_1304.values()) {
            boss.method_5946(slot, 0.0f);
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)"Hord Leader").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        boss.method_5880(true);
    }

    private static void enhanceMob(class_1588 mob) {
        int enhancement = RANDOM.nextInt(3);
        switch (enhancement) {
            case 0: {
                if (mob.method_5996(class_5134.field_23716) == null) break;
                double currentHealth = mob.method_5996(class_5134.field_23716).method_6201();
                mob.method_5996(class_5134.field_23716).method_6192(currentHealth * 1.5);
                mob.method_6033(mob.method_6063());
                break;
            }
            case 1: {
                mob.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 0, false, false));
                break;
            }
            case 2: {
                if (!RANDOM.nextBoolean()) break;
                mob.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8267));
            }
        }
    }

    private static boolean isPlayerInOcean(class_3218 world, class_2338 playerPos) {
        class_6880 biome = world.method_23753(playerPos);
        String biomeName = biome.method_55840();
        return biomeName.contains("ocean");
    }

    private static boolean isPlayerInSoulSandValley(class_3218 world, class_2338 playerPos) {
        class_6880 biome = world.method_23753(playerPos);
        String biomeName = biome.method_55840();
        return biomeName.contains("soul_sand_valley");
    }

    private static boolean isPlayerInNetherFortress(class_3218 world, class_2338 playerPos) {
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    class_2338 checkPos = playerPos.method_10069(x, y, z);
                    if (world.method_8320(checkPos).method_26204() != class_2246.field_10266) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPlayerInBasaltDelta(class_3218 world, class_2338 playerPos) {
        class_6880 biome = world.method_23753(playerPos);
        String biomeName = biome.method_55840();
        return biomeName.contains("basalt_deltas");
    }

    private static class_2338 findOceanSpawnPosition(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 30; ++attempts) {
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double distance = 20.0 + RANDOM.nextDouble() * 30.0;
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            int z = (int)(playerPos.field_1350 + Math.sin(angle) * distance);
            for (int y = world.method_8615() - 15; y <= world.method_8615() + 5; ++y) {
                class_2338 pos = new class_2338(x, y, z);
                if (world.method_8320(pos).method_26204() != class_2246.field_10382 || world.method_8320(pos.method_10084()).method_26204() != class_2246.field_10382 || world.method_8320(pos.method_10086(2)).method_26204() != class_2246.field_10382) continue;
                return pos;
            }
        }
        return null;
    }

    private static class_2338 findSpawnPosition(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 20; ++attempts) {
            int z;
            int y;
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double distance = 20.0 + RANDOM.nextDouble() * 30.0;
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            class_2338 pos = new class_2338(x, y = world.method_8624(class_2902.class_2903.field_13203, x, z = (int)(playerPos.field_1350 + Math.sin(angle) * distance)), z);
            if (!world.method_8320(pos).method_26215() || !world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074())) continue;
            return pos;
        }
        return null;
    }

    private static class_2338 findNetherSpawnPosition(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 30; ++attempts) {
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double distance = 20.0 + RANDOM.nextDouble() * 30.0;
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            int z = (int)(playerPos.field_1350 + Math.sin(angle) * distance);
            for (int y = 10; y < 120; ++y) {
                class_2338 pos = new class_2338(x, y, z);
                class_2338 posAbove = pos.method_10084();
                class_2338 posAbove2 = pos.method_10086(2);
                if (!world.method_8320(pos).method_26212((class_1922)world, pos) || !world.method_8320(posAbove).method_26215() || !world.method_8320(posAbove2).method_26215() || !world.method_8320(posAbove2.method_10084()).method_26215() || HordsSpawner.isNearLava(world, posAbove) || y >= 115) continue;
                return posAbove;
            }
        }
        return null;
    }

    private static boolean isNearLava(class_3218 world, class_2338 pos) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 1; ++dy) {
                    class_2338 checkPos = pos.method_10069(dx, dy, dz);
                    if (world.method_8320(checkPos).method_26204() != class_2246.field_10164) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static class_2338 getRandomPositionAround(class_2338 center, int radius) {
        double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
        double distance = RANDOM.nextDouble() * (double)radius;
        int x = center.method_10263() + (int)(Math.cos(angle) * distance);
        int z = center.method_10260() + (int)(Math.sin(angle) * distance);
        return new class_2338(x, center.method_10264(), z);
    }

    private static String getHordTypeName(HordType type) {
        switch (type.ordinal()) {
            case 0: {
                return "Zombie Hord";
            }
            case 1: {
                return "Skeleton Hord";
            }
            case 2: {
                return "Mixed Hord";
            }
            case 3: {
                return "Zombified Hord";
            }
            case 4: {
                return "End Hord";
            }
            case 5: {
                return "Ocean Hord";
            }
            case 6: {
                return "Piglin Hord";
            }
            case 7: {
                return "Magmacube Hord";
            }
            case 8: {
                return "Nether Fortress Hord";
            }
            case 9: {
                return "Nether Mixed Hord";
            }
            case 10: {
                return "Soul Sand Hord";
            }
        }
        return "Unknown Hord";
    }

    public static enum HordType {
        ZOMBIE_HORD,
        SKELETON_HORD,
        MIXED_HORD,
        ZOMBIFIED_HORD,
        END_HORD,
        OCEAN_HORD,
        PIGLIN_HORD,
        MAGMACUBE_HORD,
        NETHERFORTRESS_HORD,
        NETHER_MIXED_HORD,
        SOULSAND_HORD;

    }
}

