/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import com.example.hords.HordsConfig;
import com.example.hords.HordsEchoLibConfigScreen;
import com.example.hords.HordsMod;
import com.example.hords.HordsSpawner;
import com.example.hords.PlayerBroadcastSettings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class HordsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hords").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"help").executes(HordsCommand::showHelp))).then(class_2170.method_9247((String)"status").executes(HordsCommand::showStatus))).then(class_2170.method_9247((String)"reload").executes(HordsCommand::reloadConfig))).then(class_2170.method_9247((String)"config").executes(HordsCommand::openConfigGui))).then(class_2170.method_9247((String)"notifications").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(HordsCommand::togglePersonalNotifications)))).then(class_2170.method_9247((String)"spawn").then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("zombie");
            builder.suggest("skeleton");
            builder.suggest("mixed");
            builder.suggest("zombified");
            builder.suggest("end");
            builder.suggest("ocean");
            builder.suggest("piglin");
            builder.suggest("magmacube");
            builder.suggest("netherfortress");
            builder.suggest("nethermixed");
            builder.suggest("soulsand");
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)3, (int)50)).executes(context -> HordsCommand.spawnHord((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"size"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"spawnchance").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)100, (int)36000)).executes(context -> HordsCommand.setSpawnChance((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"minhordsize").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)3, (int)50)).executes(context -> HordsCommand.setMinHordSize((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"maxhordsize").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)5, (int)100)).executes(context -> HordsCommand.setMaxHordSize((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"minplayerdistance").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)10, (int)100)).executes(context -> HordsCommand.setMinPlayerDistance((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"maxplayerdistance").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)20, (int)200)).executes(context -> HordsCommand.setMaxPlayerDistance((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"requirenighttime").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> HordsCommand.setRequireNightTime((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"maxactivehordes").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(context -> HordsCommand.setMaxActiveHordes((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"despawntime").then(class_2170.method_9244((String)"value", (ArgumentType)LongArgumentType.longArg((long)1L, (long)60L)).executes(context -> HordsCommand.setDespawnTime((CommandContext<class_2168>)context, LongArgumentType.getLong((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"cooldown").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)60)).executes(context -> HordsCommand.setCooldown((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"broadcast").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> HordsCommand.setBroadcast((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"broadcastradius").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)10, (int)500)).executes(context -> HordsCommand.setBroadcastRadius((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(class_2170.method_9247((String)"oceanrequirenight").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> HordsCommand.setOceanRequireNight((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value"))))))).then(class_2170.method_9247((String)"toggle").then(class_2170.method_9244((String)"hordetype", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("zombie");
            builder.suggest("skeleton");
            builder.suggest("mixed");
            builder.suggest("zombified");
            builder.suggest("end");
            builder.suggest("ocean");
            builder.suggest("piglin");
            builder.suggest("magmacube");
            builder.suggest("netherfortress");
            builder.suggest("nethermixed");
            builder.suggest("soulsand");
            return builder.buildFuture();
        }).executes(context -> HordsCommand.toggleHordeType((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"hordetype"))))));
    }

    private static int togglePersonalNotifications(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_9228() == null || !(source.method_9228() instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players!"));
            return 0;
        }
        class_3222 player = (class_3222)source.method_9228();
        boolean enabled = BoolArgumentType.getBool(context, (String)"enabled");
        PlayerBroadcastSettings.setBroadcastEnabled(player.method_5667(), enabled);
        if (enabled) {
            source.method_9226(() -> class_2561.method_43470((String)"Horde spawn notifications enabled for you!").method_27692(class_124.field_1060), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Horde spawn notifications disabled for you!").method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static int showHelp(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"=== Hords Commands ===").method_27692(class_124.field_1065), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords help - Show this help"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords status - Show current settings and active hordes"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords config - Open configuration GUI"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords reload - Reload config from file"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords notifications <true/false> - Toggle personal notifications"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords spawn <type> <size> - Manually spawn horde"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  Types: zombie, skeleton, mixed, zombified, end,"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"         ocean, piglin, magmacube, netherfortress,"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"         nethermixed, soulsand"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)""), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"=== Settings Commands ===").method_27692(class_124.field_1054), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set spawnchance <value> - Set spawn chance"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set minhordsize <value> - Set minimum horde size"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set maxhordsize <value> - Set maximum horde size"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set minplayerdistance <value> - Set min spawn distance"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set maxplayerdistance <value> - Set max spawn distance"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set requirenighttime <true/false> - Toggle night requirement"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set maxactivehordes <value> - Set max active hordes"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set despawntime <minutes> - Set auto-despawn time"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set cooldown <minutes> - Set spawn cooldown"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set broadcast <true/false> - Toggle spawn messages"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set broadcastradius <blocks> - Set message radius"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords toggle <hordetype> - Toggle specific horde type on/off"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"/hords set oceanrequirenight <true/false> - Toggle night requirement for ocean hordes"), false);
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        HordsMod.loadConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Config reloaded successfully!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int showStatus(CommandContext<class_2168> context) {
        HordsConfig config = HordsMod.getConfig();
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"=== Hords Status ===").method_27692(class_124.field_1065), false);
        if (source.method_9228() instanceof class_3222) {
            class_3222 player = (class_3222)source.method_9228();
            boolean personalNotifications = PlayerBroadcastSettings.isBroadcastEnabled(player.method_5667());
            source.method_9226(() -> class_2561.method_43470((String)("Personal Notifications: " + (personalNotifications ? "Enabled" : "Disabled"))).method_27692(personalNotifications ? class_124.field_1060 : class_124.field_1054), false);
            source.method_9226(() -> class_2561.method_43470((String)""), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"Spawn Settings:").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Spawn Chance: " + config.spawnSettings.spawnChance + " (1 in " + config.spawnSettings.spawnChance + " per tick)")), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Horde Size: " + config.spawnSettings.minHordSize + "-" + config.spawnSettings.maxHordSize + " mobs")), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Player Distance: " + config.spawnSettings.minPlayerDistance + "-" + config.spawnSettings.maxPlayerDistance + " blocks")), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Night Time Required: " + (config.spawnSettings.requireNightTime ? "Yes" : "No"))), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Ocean Hordes Night Required: " + (config.spawnSettings.oceanHordesRequireNight ? "Yes" : "No"))), false);
        source.method_9226(() -> class_2561.method_43470((String)"Performance:").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Max Active Hordes: " + config.performance.maxActiveHordes)), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Despawn Time: " + config.performance.despawnTimeMinutes + " minutes")), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Cooldown: " + config.performance.cooldownMinutes + " minutes")), false);
        source.method_9226(() -> class_2561.method_43470((String)"Broadcast:").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Enabled: " + (config.broadcast.enabled ? "Yes" : "No"))), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Radius: " + config.broadcast.radius + " blocks")), false);
        if (source.method_9225() != null) {
            String worldName = HordsSpawner.getWorldName(source.method_9225());
            int activeCount = HordsSpawner.getActiveHordesCount(worldName);
            source.method_9226(() -> class_2561.method_43470((String)("Active Hordes in " + worldName + ": " + activeCount + "/" + config.performance.maxActiveHordes)).method_27692(class_124.field_1060), false);
            String detailStatus = HordsSpawner.getDetailedBossStatus(worldName);
            if (!detailStatus.equals("No active hordes")) {
                source.method_9226(() -> class_2561.method_43470((String)detailStatus), false);
            }
        }
        return 1;
    }

    private static int openConfigGui(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_9228() == null || !(source.method_9228() instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players!"));
            return 0;
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            try {
                HordsCommand.openGuiOnClient();
                source.method_9226(() -> class_2561.method_43470((String)"Opening Hords configuration GUI...").method_27692(class_124.field_1060), false);
            }
            catch (Exception e) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Error opening config GUI: " + e.getMessage())));
            }
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"The config GUI is only available in singleplayer or via ModMenu. Use /hords set commands instead."));
        }
        return 1;
    }

    @Environment(value=EnvType.CLIENT)
    private static void openGuiOnClient() {
        class_310 client = class_310.method_1551();
        if (client != null) {
            client.execute(() -> client.method_1507(HordsEchoLibConfigScreen.create(client.field_1755)));
        }
    }

    private static int spawnHord(CommandContext<class_2168> context, String type, int size) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_9228() == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players!"));
            return 0;
        }
        class_3218 world = source.method_9225();
        class_2338 playerPos = source.method_9228().method_24515();
        class_2338 spawnPos = playerPos.method_10069(10, 0, 10);
        HordsSpawner.HordType hordType = HordsCommand.getHordTypeFromString(type);
        if (hordType == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid horde type! Use: zombie, skeleton, mixed, zombified, end, ocean, piglin, magmacube, netherfortress, nethermixed, soulsand"));
            return 0;
        }
        HordsSpawner.spawnSpecificHord(world, spawnPos, hordType, size);
        source.method_9226(() -> class_2561.method_43470((String)("Spawned " + HordsCommand.getHordTypeName(hordType) + "e with " + size + " mobs!")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static HordsSpawner.HordType getHordTypeFromString(String type) {
        switch (type.toLowerCase()) {
            case "zombie": {
                return HordsSpawner.HordType.ZOMBIE_HORD;
            }
            case "skeleton": {
                return HordsSpawner.HordType.SKELETON_HORD;
            }
            case "mixed": {
                return HordsSpawner.HordType.MIXED_HORD;
            }
            case "zombified": {
                return HordsSpawner.HordType.ZOMBIFIED_HORD;
            }
            case "end": {
                return HordsSpawner.HordType.END_HORD;
            }
            case "ocean": {
                return HordsSpawner.HordType.OCEAN_HORD;
            }
            case "piglin": {
                return HordsSpawner.HordType.PIGLIN_HORD;
            }
            case "magmacube": {
                return HordsSpawner.HordType.MAGMACUBE_HORD;
            }
            case "netherfortress": {
                return HordsSpawner.HordType.NETHERFORTRESS_HORD;
            }
            case "nethermixed": {
                return HordsSpawner.HordType.NETHER_MIXED_HORD;
            }
            case "soulsand": {
                return HordsSpawner.HordType.SOULSAND_HORD;
            }
        }
        return null;
    }

    private static String getHordTypeName(HordsSpawner.HordType type) {
        switch (type) {
            case ZOMBIE_HORD: {
                return "Zombie Hord";
            }
            case SKELETON_HORD: {
                return "Skeleton Hord";
            }
            case MIXED_HORD: {
                return "Mixed Hord";
            }
            case ZOMBIFIED_HORD: {
                return "Zombified Hord";
            }
            case END_HORD: {
                return "End Hord";
            }
            case OCEAN_HORD: {
                return "Ocean Hord";
            }
            case PIGLIN_HORD: {
                return "Piglin Hord";
            }
            case MAGMACUBE_HORD: {
                return "Magma Cube Hord";
            }
            case NETHERFORTRESS_HORD: {
                return "Nether Fortress Hord";
            }
            case NETHER_MIXED_HORD: {
                return "Nether Mixed Hord";
            }
            case SOULSAND_HORD: {
                return "Soul Sand Hord";
            }
        }
        return "Unknown Hord";
    }

    private static int toggleHordeType(CommandContext<class_2168> context, String hordeTypeStr) {
        HordsSpawner.HordType hordeType = HordsCommand.getHordTypeFromString(hordeTypeStr);
        if (hordeType == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid horde type! Available: zombie, skeleton, mixed, zombified, end, ocean, piglin, magmacube, netherfortress, nethermixed, soulsand"));
            return 0;
        }
        boolean currentState = HordsSpawner.isHordeTypeEnabled(hordeType);
        boolean newState = !currentState;
        HordsSpawner.setHordeTypeEnabled(hordeType, newState);
        String hordeTypeName = HordsCommand.getHordTypeName(hordeType);
        if (newState) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(hordeTypeName + "e ENABLED!")).method_27692(class_124.field_1060), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(hordeTypeName + "e DISABLED!")).method_27692(class_124.field_1061), true);
        }
        return 1;
    }

    private static int setSpawnChance(CommandContext<class_2168> context, int value) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.spawnChance = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Spawn chance set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setMinHordSize(CommandContext<class_2168> context, int value) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.minHordSize = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Min horde size set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setMaxHordSize(CommandContext<class_2168> context, int value) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.maxHordSize = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Max horde size set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setMinPlayerDistance(CommandContext<class_2168> context, int value) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.minPlayerDistance = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Min player distance set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setMaxPlayerDistance(CommandContext<class_2168> context, int value) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.maxPlayerDistance = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Max player distance set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setRequireNightTime(CommandContext<class_2168> context, boolean value) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.requireNightTime = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Require night time set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setMaxActiveHordes(CommandContext<class_2168> context, int value) {
        HordsConfig config = HordsMod.getConfig();
        config.performance.maxActiveHordes = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Max active hordes set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setDespawnTime(CommandContext<class_2168> context, long value) {
        HordsConfig config = HordsMod.getConfig();
        config.performance.despawnTimeMinutes = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Despawn time set to " + value + " minutes")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setCooldown(CommandContext<class_2168> context, int value) {
        HordsConfig config = HordsMod.getConfig();
        config.performance.cooldownMinutes = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Cooldown set to " + value + " minutes")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setBroadcast(CommandContext<class_2168> context, boolean value) {
        HordsConfig config = HordsMod.getConfig();
        config.broadcast.enabled = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Broadcast enabled set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setBroadcastRadius(CommandContext<class_2168> context, int value) {
        HordsConfig config = HordsMod.getConfig();
        config.broadcast.radius = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Broadcast radius set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setOceanRequireNight(CommandContext<class_2168> context, boolean value) {
        HordsConfig config = HordsMod.getConfig();
        config.spawnSettings.oceanHordesRequireNight = value;
        HordsMod.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Ocean hordes require night time set to " + value)).method_27692(class_124.field_1060), false);
        return 1;
    }
}

