/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;

public class PlayerBroadcastSettings {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path SETTINGS_FILE = FabricLoader.getInstance().getConfigDir().resolve("hords_player_settings.json");
    private static Map<String, Boolean> playerBroadcastSettings = new HashMap<String, Boolean>();

    public static void init() {
        PlayerBroadcastSettings.loadSettings();
    }

    public static void loadSettings() {
        block8: {
            try {
                if (!Files.exists(SETTINGS_FILE, new LinkOption[0])) break block8;
                try (FileReader reader = new FileReader(SETTINGS_FILE.toFile());){
                    PlayerSettingsData data = (PlayerSettingsData)GSON.fromJson((Reader)reader, PlayerSettingsData.class);
                    if (data != null && data.playerBroadcastSettings != null) {
                        playerBroadcastSettings = data.playerBroadcastSettings;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("[HORDS] Error loading player settings: " + e.getMessage());
                playerBroadcastSettings = new HashMap<String, Boolean>();
            }
        }
    }

    public static void saveSettings() {
        try {
            Files.createDirectories(SETTINGS_FILE.getParent(), new FileAttribute[0]);
            PlayerSettingsData data = new PlayerSettingsData();
            data.playerBroadcastSettings = playerBroadcastSettings;
            try (FileWriter writer = new FileWriter(SETTINGS_FILE.toFile());){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[HORDS] Failed to save player settings: " + e.getMessage());
        }
    }

    public static boolean shouldReceiveBroadcast(UUID playerId) {
        String playerKey = playerId.toString();
        return playerBroadcastSettings.getOrDefault(playerKey, true);
    }

    public static void setBroadcastEnabled(UUID playerId, boolean enabled) {
        String playerKey = playerId.toString();
        playerBroadcastSettings.put(playerKey, enabled);
        PlayerBroadcastSettings.saveSettings();
    }

    public static boolean isBroadcastEnabled(UUID playerId) {
        String playerKey = playerId.toString();
        return playerBroadcastSettings.getOrDefault(playerKey, true);
    }

    private static class PlayerSettingsData {
        public Map<String, Boolean> playerBroadcastSettings = new HashMap<String, Boolean>();

        private PlayerSettingsData() {
        }
    }
}

