/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_9334;

public class BossLootHandler {
    private static final Random RANDOM = new Random();

    public static void handleBossDeath(class_1309 boss, class_3218 world) {
        if (boss.method_5797() == null) {
            return;
        }
        String customName = boss.method_5797().getString();
        if (!BossLootHandler.isBossEntity(boss, customName)) {
            return;
        }
        class_243 deathPos = new class_243(boss.method_23317(), boss.method_23318(), boss.method_23321());
        BossLootHandler.spawnBossLoot(world, deathPos, customName);
    }

    private static boolean isBossEntity(class_1309 entity, String customName) {
        return customName.contains("Leader") || customName.contains("Lord") || customName.contains("King") || customName.contains("Warlord") || customName.contains("Commander") || customName.contains("Overlord") || customName.contains("Wraith");
    }

    private static void spawnBossLoot(class_3218 world, class_243 deathPos, String bossName) {
        BossLootHandler.dropLootItems(world, deathPos, bossName);
    }

    private static void dropLootItems(class_3218 world, class_243 pos, String bossName) {
        List<class_1799> lootItems = BossLootHandler.generateBossLoot();
        for (class_1799 item : lootItems) {
            if (item.method_7960()) continue;
            class_1542 itemEntity = new class_1542((class_1937)world, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, item);
            itemEntity.method_18800((RANDOM.nextDouble() - 0.5) * 0.2, RANDOM.nextDouble() * 0.2 + 0.1, (RANDOM.nextDouble() - 0.5) * 0.2);
            world.method_8649((class_1297)itemEntity);
        }
        BossLootHandler.spawnExperienceOrbs(world, new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
    }

    private static List<class_1799> generateBossLoot() {
        ArrayList<PossibleLoot> allPossibleLoot = new ArrayList<PossibleLoot>();
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8463, 1, 5, 0.5f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8477, 1, 5, 0.5f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8687, 2, 7, 0.5f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8620, 3, 12, 0.5f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8695, 2, 8, 0.5f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8634, 1, 4, 0.2f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8287, 1, 8, 0.25f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8071, 1, 7, 0.2f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8626, 1, 6, 0.33f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8448, 1, 1, 0.33f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8603, 1, 2, 0.165f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_22019, 1, 4, 0.1f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8070, 1, 3, 0.075f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8547, 1, 1, 0.05f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8815, 1, 3, 0.1f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8367, 1, 1, 0.0075f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_22020, 1, 1, 0.02f));
        allPossibleLoot.add(new PossibleLoot(class_1802.field_8288, 1, 1, 0.0375f));
        if (RANDOM.nextFloat() < 0.5f) {
            int potions = 1 + RANDOM.nextInt(3);
            for (int i = 0; i < potions; ++i) {
                class_1799 potion = BossLootHandler.createRandomPotion();
                allPossibleLoot.add(new PossibleLoot(potion, 1.0f));
            }
        }
        Collections.shuffle(allPossibleLoot);
        ArrayList<class_1799> finalLoot = new ArrayList<class_1799>();
        int itemCount = 0;
        for (PossibleLoot possibleItem : allPossibleLoot) {
            if (itemCount >= 5) break;
            if (!possibleItem.shouldDrop()) continue;
            finalLoot.add(possibleItem.createItemStack());
            ++itemCount;
        }
        return finalLoot;
    }

    private static class_1799 createRandomPotion() {
        class_1799 potion = new class_1799((class_1935)class_1802.field_8574);
        switch (RANDOM.nextInt(8)) {
            case 0: {
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8963));
                break;
            }
            case 1: {
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8980));
                break;
            }
            case 2: {
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8986));
                break;
            }
            case 3: {
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8978));
                break;
            }
            case 4: {
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_9005));
                break;
            }
            case 5: {
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8987));
                break;
            }
            case 6: {
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8968));
                break;
            }
            case 7: {
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8994));
            }
        }
        return potion;
    }

    private static void spawnExperienceOrbs(class_3218 world, class_2338 pos) {
        int orbValue;
        for (int totalXP = 50 + RANDOM.nextInt(101); totalXP > 0; totalXP -= orbValue) {
            orbValue = Math.min(totalXP, 20 + RANDOM.nextInt(31));
            class_1303 orb = new class_1303((class_1937)world, (double)pos.method_10263() + 0.5 + (RANDOM.nextDouble() - 0.5) * 2.0, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5 + (RANDOM.nextDouble() - 0.5) * 2.0, orbValue);
            world.method_8649((class_1297)orb);
        }
    }

    private static class PossibleLoot {
        private final class_1792 item;
        private final int minAmount;
        private final int maxAmount;
        private final float chance;
        private final class_1799 customStack;

        public PossibleLoot(class_1792 item, int minAmount, int maxAmount, float chance) {
            this.item = item;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
            this.chance = chance;
            this.customStack = null;
        }

        public PossibleLoot(class_1799 customStack, float chance) {
            this.item = null;
            this.minAmount = 1;
            this.maxAmount = 1;
            this.chance = chance;
            this.customStack = customStack;
        }

        public boolean shouldDrop() {
            return RANDOM.nextFloat() < this.chance;
        }

        public class_1799 createItemStack() {
            if (this.customStack != null) {
                return this.customStack.method_7972();
            }
            int amount = this.minAmount;
            if (this.maxAmount > this.minAmount) {
                amount += RANDOM.nextInt(this.maxAmount - this.minAmount + 1);
            }
            return new class_1799((class_1935)this.item, amount);
        }
    }
}

