/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import com.example.hords.HordsSpawner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class HordCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hord").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"spawn").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("zombie");
            builder.suggest("skeleton");
            builder.suggest("mixed");
            builder.suggest("zombified");
            builder.suggest("piglin");
            builder.suggest("magmacube");
            builder.suggest("fortress");
            builder.suggest("nethermixed");
            builder.suggest("soulsand");
            builder.suggest("ocean");
            builder.suggest("end");
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)5, (int)50)).executes(HordCommands::spawnHordWithSize))).executes(HordCommands::spawnHordDefault)))).then(class_2170.method_9247((String)"test").executes(HordCommands::testHord)));
    }

    private static int spawnHordWithSize(CommandContext<class_2168> context) {
        String type = StringArgumentType.getString(context, (String)"type");
        int size = IntegerArgumentType.getInteger(context, (String)"size");
        return HordCommands.executeSpawnHord(context, type, size);
    }

    private static int spawnHordDefault(CommandContext<class_2168> context) {
        String type = StringArgumentType.getString(context, (String)"type");
        return HordCommands.executeSpawnHord(context, type, 15);
    }

    private static int testHord(CommandContext<class_2168> context) {
        return HordCommands.executeSpawnHord(context, "mixed", 10);
    }

    private static int executeSpawnHord(CommandContext<class_2168> context, String type, int size) {
        class_2168 source = (class_2168)context.getSource();
        try {
            HordsSpawner.HordType hordType;
            class_3222 player = source.method_9207();
            class_2338 playerPos = player.method_24515();
            class_3218 world = (class_3218)player.method_37908();
            class_2338 spawnPos = HordCommands.findNearbySpawnPosition(world, playerPos);
            if (spawnPos == null) {
                source.method_9226(() -> class_2561.method_43470((String)"Keine geeignete Spawn-Position gefunden!").method_27692(class_124.field_1061), false);
                return 0;
            }
            switch (type.toLowerCase()) {
                case "zombie": {
                    hordType = HordsSpawner.HordType.ZOMBIE_HORD;
                    break;
                }
                case "skeleton": {
                    hordType = HordsSpawner.HordType.SKELETON_HORD;
                    break;
                }
                case "mixed": {
                    hordType = HordsSpawner.HordType.MIXED_HORD;
                    break;
                }
                case "zombified": {
                    hordType = HordsSpawner.HordType.ZOMBIFIED_HORD;
                    break;
                }
                case "piglin": {
                    hordType = HordsSpawner.HordType.PIGLIN_HORD;
                    break;
                }
                case "magmacube": {
                    hordType = HordsSpawner.HordType.MAGMACUBE_HORD;
                    break;
                }
                case "fortress": {
                    hordType = HordsSpawner.HordType.NETHERFORTRESS_HORD;
                    break;
                }
                case "nethermixed": {
                    hordType = HordsSpawner.HordType.NETHER_MIXED_HORD;
                    break;
                }
                case "soulsand": {
                    hordType = HordsSpawner.HordType.SOULSAND_HORD;
                    break;
                }
                case "ocean": {
                    hordType = HordsSpawner.HordType.OCEAN_HORD;
                    break;
                }
                case "end": {
                    hordType = HordsSpawner.HordType.END_HORD;
                    break;
                }
                default: {
                    source.method_9226(() -> class_2561.method_43470((String)"Unknown hord type! Use: zombie, skeleton, mixed, zombified, piglin, magmacube, fortress, nethermixed, soulsand, ocean, end").method_27692(class_124.field_1061), false);
                    return 0;
                }
            }
            HordsSpawner.spawnSpecificHord(world, spawnPos, hordType, size);
            source.method_9226(() -> class_2561.method_43470((String)("Hord spawned! Type: " + type + ", Size: " + size + ", Position: " + spawnPos.method_10263() + ", " + spawnPos.method_10264() + ", " + spawnPos.method_10260())).method_27692(class_124.field_1060), true);
            return 1;
        }
        catch (Exception e) {
            source.method_9226(() -> class_2561.method_43470((String)("Error spawning hord: " + e.getMessage())).method_27692(class_124.field_1061), false);
            return 0;
        }
    }

    private static class_2338 findNearbySpawnPosition(class_3218 world, class_2338 center) {
        if (world.method_27983() == class_1937.field_25180) {
            return HordCommands.findNetherSpawnPositionForCommands(world, center.method_46558());
        }
        for (int attempts = 0; attempts < 10; ++attempts) {
            int z;
            int y;
            double angle = Math.random() * 2.0 * Math.PI;
            int distance = 15 + (int)(Math.random() * 20.0);
            int x = center.method_10263() + (int)(Math.cos(angle) * (double)distance);
            class_2338 pos = new class_2338(x, y = world.method_8624(class_2902.class_2903.field_13203, x, z = center.method_10260() + (int)(Math.sin(angle) * (double)distance)), z);
            if (!world.method_8320(pos).method_26215() || !world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074())) continue;
            return pos;
        }
        return null;
    }

    private static class_2338 findNetherSpawnPositionForCommands(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 30; ++attempts) {
            double angle = Math.random() * 2.0 * Math.PI;
            double distance = 15.0 + Math.random() * 20.0;
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            int z = (int)(playerPos.field_1350 + Math.sin(angle) * distance);
            for (int y = 10; y < 120; ++y) {
                class_2338 pos = new class_2338(x, y, z);
                class_2338 posAbove = pos.method_10084();
                class_2338 posAbove2 = pos.method_10086(2);
                if (!world.method_8320(pos).method_26212((class_1922)world, pos) || !world.method_8320(posAbove).method_26215() || !world.method_8320(posAbove2).method_26215() || !world.method_8320(posAbove2.method_10084()).method_26215() || HordCommands.isNearLavaForCommands(world, posAbove) || y >= 115) continue;
                return posAbove;
            }
        }
        return null;
    }

    private static boolean isNearLavaForCommands(class_3218 world, class_2338 pos) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 1; ++dy) {
                    class_2338 checkPos = pos.method_10069(dx, dy, dz);
                    if (world.method_8320(checkPos).method_26204() != class_2246.field_10164) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

