/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import com.example.hords.HordsSpawner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class HordCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hord").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"spawn").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("zombie");
            builder.suggest("skeleton");
            builder.suggest("mixed");
            builder.suggest("zombified");
            builder.suggest("piglin");
            builder.suggest("magmacube");
            builder.suggest("fortress");
            builder.suggest("nethermixed");
            builder.suggest("soulsand");
            builder.suggest("ocean");
            builder.suggest("end");
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)3, (int)100)).executes(HordCommands::spawnHordWithSize))).executes(HordCommands::spawnHordDefault)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"chance").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)100, (int)36000)).executes(HordCommands::setSpawnChance))).executes(HordCommands::getSpawnChance))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"size").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"min").then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)3, (int)50)).executes(HordCommands::setMinHordSize))).executes(HordCommands::getMinHordSize))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"max").then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)5, (int)100)).executes(HordCommands::setMaxHordSize))).executes(HordCommands::getMaxHordSize)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"distance").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"min").then(class_2170.method_9244((String)"blocks", (ArgumentType)IntegerArgumentType.integer((int)10, (int)100)).executes(HordCommands::setMinPlayerDistance))).executes(HordCommands::getMinPlayerDistance))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"max").then(class_2170.method_9244((String)"blocks", (ArgumentType)IntegerArgumentType.integer((int)20, (int)200)).executes(HordCommands::setMaxPlayerDistance))).executes(HordCommands::getMaxPlayerDistance)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"nightonly").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(HordCommands::setRequireNightTime))).executes(HordCommands::getRequireNightTime)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"performance").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"maxhordes").then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(HordCommands::setMaxActiveHordes))).executes(HordCommands::getMaxActiveHordes))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"despawn").then(class_2170.method_9244((String)"minutes", (ArgumentType)LongArgumentType.longArg((long)1L, (long)60L)).executes(HordCommands::setDespawnTime))).executes(HordCommands::getDespawnTime)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cooldown").then(class_2170.method_9244((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)0, (int)60)).executes(HordCommands::setCooldown))).executes(HordCommands::getCooldown))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"broadcast").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(HordCommands::setBroadcast))).executes(HordCommands::toggleBroadcast))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"radius").then(class_2170.method_9244((String)"blocks", (ArgumentType)IntegerArgumentType.integer((int)10, (int)500)).executes(HordCommands::setBroadcastRadius))).executes(HordCommands::getBroadcastRadius))).executes(HordCommands::getBroadcastInfo))).executes(HordCommands::showConfigHelp))).then(class_2170.method_9247((String)"status").executes(HordCommands::getStatus))).then(class_2170.method_9247((String)"test").executes(HordCommands::testHord))).then(class_2170.method_9247((String)"help").executes(HordCommands::showHelp)));
    }

    private static int showConfigHelp(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"=== Hord Configuration ===").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Spawn Settings:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config spawn chance [ticks] - Spawn frequency").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config spawn size min/max [size] - Horde size range").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config spawn distance min/max [blocks] - Spawn distance").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config spawn nightonly [true/false] - Night only in Overworld").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Performance Settings:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config performance maxhordes [count] - Max hordes per world").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config performance despawn [minutes] - Auto-despawn timer").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Other Settings:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config cooldown [minutes] - Cooldown between hordes").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config broadcast toggle [true/false] - Enable/disable messages").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config broadcast radius [blocks] - Message broadcast range").method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int showHelp(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"=== Hord Commands ===").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Main Commands:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord spawn <type> [size] - Manually spawn a horde").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord config - Configure horde settings").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord status - Show all current settings").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /hord test - Spawn a test horde").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Available Horde Types:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  zombie, skeleton, mixed, zombified, piglin").method_27692(class_124.field_1080), false);
        source.method_9226(() -> class_2561.method_43470((String)"  magmacube, fortress, nethermixed, soulsand, ocean, end").method_27692(class_124.field_1080), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Use '/hord config' to see all configuration options.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int setSpawnChance(CommandContext<class_2168> context) {
        int ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        HordsSpawner.setSpawnChance(ticks);
        double seconds = (double)ticks / 20.0;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Spawn chance set to 1/" + ticks + " (" + String.format("%.1f", seconds) + " seconds average)")).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getSpawnChance(CommandContext<class_2168> context) {
        int ticks = HordsSpawner.getSpawnChance();
        double seconds = (double)ticks / 20.0;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current spawn chance: 1/" + ticks + " (" + String.format("%.1f", seconds) + " seconds average)")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int setMinHordSize(CommandContext<class_2168> context) {
        int size = IntegerArgumentType.getInteger(context, (String)"size");
        HordsSpawner.setMinHordSize(size);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Minimum horde size set to " + size)).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getMinHordSize(CommandContext<class_2168> context) {
        int size = HordsSpawner.getMinHordSize();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current minimum horde size: " + size)).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int setMaxHordSize(CommandContext<class_2168> context) {
        int size = IntegerArgumentType.getInteger(context, (String)"size");
        HordsSpawner.setMaxHordSize(size);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Maximum horde size set to " + size)).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getMaxHordSize(CommandContext<class_2168> context) {
        int size = HordsSpawner.getMaxHordSize();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current maximum horde size: " + size)).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int setMinPlayerDistance(CommandContext<class_2168> context) {
        int distance = IntegerArgumentType.getInteger(context, (String)"blocks");
        HordsSpawner.setMinPlayerDistance(distance);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Minimum player distance set to " + distance + " blocks")).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getMinPlayerDistance(CommandContext<class_2168> context) {
        int distance = HordsSpawner.getMinPlayerDistance();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current minimum player distance: " + distance + " blocks")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int setMaxPlayerDistance(CommandContext<class_2168> context) {
        int distance = IntegerArgumentType.getInteger(context, (String)"blocks");
        HordsSpawner.setMaxPlayerDistance(distance);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Maximum player distance set to " + distance + " blocks")).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getMaxPlayerDistance(CommandContext<class_2168> context) {
        int distance = HordsSpawner.getMaxPlayerDistance();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current maximum player distance: " + distance + " blocks")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int setRequireNightTime(CommandContext<class_2168> context) {
        boolean require = BoolArgumentType.getBool(context, (String)"enabled");
        HordsSpawner.setRequireNightTime(require);
        String status = require ? "enabled" : "disabled";
        class_124 color = require ? class_124.field_1060 : class_124.field_1061;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Night-only spawning in Overworld " + status)).method_27692(color), true);
        return 1;
    }

    private static int getRequireNightTime(CommandContext<class_2168> context) {
        boolean require = HordsSpawner.getRequireNightTime();
        String status = require ? "enabled" : "disabled";
        class_124 color = require ? class_124.field_1060 : class_124.field_1061;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Night-only spawning in Overworld: " + status)).method_27692(color), false);
        return 1;
    }

    private static int setMaxActiveHordes(CommandContext<class_2168> context) {
        int max = IntegerArgumentType.getInteger(context, (String)"count");
        HordsSpawner.setMaxActiveHordes(max);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Maximum active hordes per world set to " + max)).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getMaxActiveHordes(CommandContext<class_2168> context) {
        int max = HordsSpawner.getMaxActiveHordes();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current maximum active hordes per world: " + max)).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int setDespawnTime(CommandContext<class_2168> context) {
        long minutes = LongArgumentType.getLong(context, (String)"minutes");
        HordsSpawner.setDespawnTimeMinutes(minutes);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Horde despawn timer set to " + minutes + " minutes")).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getDespawnTime(CommandContext<class_2168> context) {
        long minutes = HordsSpawner.getDespawnTimeMinutes();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current horde despawn timer: " + minutes + " minutes")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int setCooldown(CommandContext<class_2168> context) {
        int minutes = IntegerArgumentType.getInteger(context, (String)"minutes");
        HordsSpawner.setCooldownMinutes(minutes);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Horde cooldown set to " + minutes + " minutes")).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getCooldown(CommandContext<class_2168> context) {
        int current = HordsSpawner.getCooldownMinutes();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current horde cooldown: " + current + " minutes")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int setBroadcast(CommandContext<class_2168> context) {
        boolean enabled = BoolArgumentType.getBool(context, (String)"enabled");
        HordsSpawner.setBroadcastEnabled(enabled);
        String status = enabled ? "enabled" : "disabled";
        class_124 color = enabled ? class_124.field_1060 : class_124.field_1061;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Horde broadcast messages " + status)).method_27692(color), true);
        return 1;
    }

    private static int toggleBroadcast(CommandContext<class_2168> context) {
        boolean currentState = HordsSpawner.isBroadcastEnabled();
        boolean newState = !currentState;
        HordsSpawner.setBroadcastEnabled(newState);
        String status = newState ? "enabled" : "disabled";
        class_124 color = newState ? class_124.field_1060 : class_124.field_1061;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Horde broadcast messages " + status)).method_27692(color), true);
        return 1;
    }

    private static int setBroadcastRadius(CommandContext<class_2168> context) {
        int radius = IntegerArgumentType.getInteger(context, (String)"blocks");
        HordsSpawner.setBroadcastRadius(radius);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Horde broadcast radius set to " + radius + " blocks")).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int getBroadcastRadius(CommandContext<class_2168> context) {
        int radius = HordsSpawner.getBroadcastRadius();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current horde broadcast radius: " + radius + " blocks")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int getBroadcastInfo(CommandContext<class_2168> context) {
        boolean enabled = HordsSpawner.isBroadcastEnabled();
        int radius = HordsSpawner.getBroadcastRadius();
        String status = enabled ? "enabled" : "disabled";
        class_124 statusColor = enabled ? class_124.field_1060 : class_124.field_1061;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Horde Broadcast Settings:").method_27692(class_124.field_1065), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("  Status: " + status)).method_27692(statusColor), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("  Radius: " + radius + " blocks")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int getStatus(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"=== Hord System Status ===").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Basic Settings:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Cooldown: " + HordsSpawner.getCooldownMinutes() + " minutes")).method_27692(class_124.field_1054), false);
        boolean broadcastEnabled = HordsSpawner.isBroadcastEnabled();
        String broadcastStatus = broadcastEnabled ? "enabled" : "disabled";
        class_124 broadcastColor = broadcastEnabled ? class_124.field_1060 : class_124.field_1061;
        source.method_9226(() -> class_2561.method_43470((String)("  Broadcast: " + broadcastStatus)).method_27692(broadcastColor), false);
        if (broadcastEnabled) {
            source.method_9226(() -> class_2561.method_43470((String)("  Broadcast radius: " + HordsSpawner.getBroadcastRadius() + " blocks")).method_27692(class_124.field_1054), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Spawn Settings:").method_27692(class_124.field_1075), false);
        int spawnChance = HordsSpawner.getSpawnChance();
        double avgSeconds = (double)spawnChance / 20.0;
        source.method_9226(() -> class_2561.method_43470((String)("  Spawn chance: 1/" + spawnChance + " (~" + String.format("%.1f", avgSeconds) + "s avg)")).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Horde size: " + HordsSpawner.getMinHordSize() + "-" + HordsSpawner.getMaxHordSize())).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Spawn distance: " + HordsSpawner.getMinPlayerDistance() + "-" + HordsSpawner.getMaxPlayerDistance() + " blocks")).method_27692(class_124.field_1054), false);
        boolean nightOnly = HordsSpawner.getRequireNightTime();
        String nightStatus = nightOnly ? "enabled" : "disabled";
        class_124 nightColor = nightOnly ? class_124.field_1060 : class_124.field_1061;
        source.method_9226(() -> class_2561.method_43470((String)("  Night-only (Overworld): " + nightStatus)).method_27692(nightColor), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Performance Settings:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Max hordes per world: " + HordsSpawner.getMaxActiveHordes())).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Despawn timer: " + HordsSpawner.getDespawnTimeMinutes() + " minutes")).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Active Hordes:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Overworld: " + HordsSpawner.getActiveHordesCount("overworld"))).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("  Nether: " + HordsSpawner.getActiveHordesCount("nether"))).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("  End: " + HordsSpawner.getActiveHordesCount("end"))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int spawnHordWithSize(CommandContext<class_2168> context) {
        String type = StringArgumentType.getString(context, (String)"type");
        int size = IntegerArgumentType.getInteger(context, (String)"size");
        return HordCommands.executeSpawnHord(context, type, size);
    }

    private static int spawnHordDefault(CommandContext<class_2168> context) {
        String type = StringArgumentType.getString(context, (String)"type");
        return HordCommands.executeSpawnHord(context, type, 15);
    }

    private static int testHord(CommandContext<class_2168> context) {
        return HordCommands.executeSpawnHord(context, "mixed", 10);
    }

    private static int executeSpawnHord(CommandContext<class_2168> context, String type, int size) {
        class_2168 source = (class_2168)context.getSource();
        try {
            HordsSpawner.HordType hordType;
            class_3222 player = source.method_9207();
            class_2338 playerPos = player.method_24515();
            class_3218 world = (class_3218)player.method_37908();
            class_2338 spawnPos = HordCommands.findNearbySpawnPosition(world, playerPos);
            if (spawnPos == null) {
                source.method_9226(() -> class_2561.method_43470((String)"No suitable spawn position found!").method_27692(class_124.field_1061), false);
                return 0;
            }
            switch (type.toLowerCase()) {
                case "zombie": {
                    hordType = HordsSpawner.HordType.ZOMBIE_HORD;
                    break;
                }
                case "skeleton": {
                    hordType = HordsSpawner.HordType.SKELETON_HORD;
                    break;
                }
                case "mixed": {
                    hordType = HordsSpawner.HordType.MIXED_HORD;
                    break;
                }
                case "zombified": {
                    hordType = HordsSpawner.HordType.ZOMBIFIED_HORD;
                    break;
                }
                case "piglin": {
                    hordType = HordsSpawner.HordType.PIGLIN_HORD;
                    break;
                }
                case "magmacube": {
                    hordType = HordsSpawner.HordType.MAGMACUBE_HORD;
                    break;
                }
                case "fortress": {
                    hordType = HordsSpawner.HordType.NETHERFORTRESS_HORD;
                    break;
                }
                case "nethermixed": {
                    hordType = HordsSpawner.HordType.NETHER_MIXED_HORD;
                    break;
                }
                case "soulsand": {
                    hordType = HordsSpawner.HordType.SOULSAND_HORD;
                    break;
                }
                case "ocean": {
                    hordType = HordsSpawner.HordType.OCEAN_HORD;
                    break;
                }
                case "end": {
                    hordType = HordsSpawner.HordType.END_HORD;
                    break;
                }
                default: {
                    source.method_9226(() -> class_2561.method_43470((String)"Unknown horde type! Use: zombie, skeleton, mixed, zombified, piglin, magmacube, fortress, nethermixed, soulsand, ocean, end").method_27692(class_124.field_1061), false);
                    return 0;
                }
            }
            HordsSpawner.spawnSpecificHord(world, spawnPos, hordType, size);
            source.method_9226(() -> class_2561.method_43470((String)("Horde spawned! Type: " + type + ", Size: " + size + ", Position: " + spawnPos.method_10263() + ", " + spawnPos.method_10264() + ", " + spawnPos.method_10260())).method_27692(class_124.field_1060), true);
            return 1;
        }
        catch (Exception e) {
            source.method_9226(() -> class_2561.method_43470((String)("Error spawning horde: " + e.getMessage())).method_27692(class_124.field_1061), false);
            return 0;
        }
    }

    private static class_2338 findNearbySpawnPosition(class_3218 world, class_2338 center) {
        if (world.method_27983() == class_1937.field_25180) {
            return HordCommands.findNetherSpawnPositionForCommands(world, center.method_46558());
        }
        for (int attempts = 0; attempts < 10; ++attempts) {
            int z;
            int y;
            double angle = Math.random() * 2.0 * Math.PI;
            int distance = 15 + (int)(Math.random() * 20.0);
            int x = center.method_10263() + (int)(Math.cos(angle) * (double)distance);
            class_2338 pos = new class_2338(x, y = world.method_8624(class_2902.class_2903.field_13203, x, z = center.method_10260() + (int)(Math.sin(angle) * (double)distance)), z);
            if (!world.method_8320(pos).method_26215() || !world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074())) continue;
            return pos;
        }
        return null;
    }

    private static class_2338 findNetherSpawnPositionForCommands(class_3218 world, class_243 playerPos) {
        for (int attempts = 0; attempts < 30; ++attempts) {
            double angle = Math.random() * 2.0 * Math.PI;
            double distance = 15.0 + Math.random() * 20.0;
            int x = (int)(playerPos.field_1352 + Math.cos(angle) * distance);
            int z = (int)(playerPos.field_1350 + Math.sin(angle) * distance);
            for (int y = 10; y < 120; ++y) {
                class_2338 pos = new class_2338(x, y, z);
                class_2338 posAbove = pos.method_10084();
                class_2338 posAbove2 = pos.method_10086(2);
                if (!world.method_8320(pos).method_26212((class_1922)world, pos) || !world.method_8320(posAbove).method_26215() || !world.method_8320(posAbove2).method_26215() || !world.method_8320(posAbove2.method_10084()).method_26215() || HordCommands.isNearLavaForCommands(world, posAbove) || y >= 115) continue;
                return posAbove;
            }
        }
        return null;
    }

    private static boolean isNearLavaForCommands(class_3218 world, class_2338 pos) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 1; ++dy) {
                    class_2338 checkPos = pos.method_10069(dx, dy, dz);
                    if (world.method_8320(checkPos).method_26204() != class_2246.field_10164) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

