/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.potion;

import com.almostreliable.morejs.features.potion.CustomBrewingFilter;
import com.almostreliable.morejs.features.potion.PotionBrewingFilter;
import com.almostreliable.morejs.mixin.PotionBrewingBuilderAccessor;
import com.almostreliable.morejs.util.Utils;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import org.apache.commons.lang3.StringUtils;

public class PotionBrewingRegisterEvent
implements KubeEvent {
    private final PotionBrewing.Builder potionBrewing;
    private final PotionBrewingBuilderAccessor potionBrewingAccessor;

    public PotionBrewingRegisterEvent(PotionBrewing.Builder potionBrewing) {
        this.potionBrewing = potionBrewing;
        this.potionBrewingAccessor = (PotionBrewingBuilderAccessor)potionBrewing;
    }

    private static ResourceLocation key(Potion potion) {
        return BuiltInRegistries.POTION.getKey((Object)potion);
    }

    protected void validate(Ingredient ingredient, Ingredient input, ItemStack output) {
        Preconditions.checkArgument((input.getItems().length > 0 ? 1 : 0) != 0, (Object)"Input must have at least one item");
        Preconditions.checkArgument((ingredient.getItems().length > 0 ? 1 : 0) != 0, (Object)"Ingredient must have at least one item");
        Preconditions.checkArgument((!output.isEmpty() ? 1 : 0) != 0, (Object)"Output must not be empty");
    }

    protected void validateSimple(Ingredient ingredient, Potion input, Potion output) {
        Preconditions.checkNotNull((Object)input, (Object)"Input potion must not be null");
        Preconditions.checkNotNull((Object)ingredient, (Object)"Ingredient must not be null");
        Preconditions.checkNotNull((Object)output, (Object)"Output potion must not be null");
        Preconditions.checkArgument((ingredient.getItems().length > 0 ? 1 : 0) != 0, (Object)"Ingredient must have at least one item");
    }

    public void addCustomBrewing(Ingredient ingredient, Ingredient input, ItemStack output) {
        this.validate(ingredient, input, output);
        this.potionBrewing.addRecipe(input, ingredient, output);
    }

    public void addPotionBrewing(Ingredient ingredient, Potion input, Potion output) {
        this.validateSimple(ingredient, input, output);
        Holder inputRef = BuiltInRegistries.POTION.wrapAsHolder((Object)input);
        Holder outputRef = BuiltInRegistries.POTION.wrapAsHolder((Object)output);
        this.potionBrewingAccessor.morejs$getPotionMixes().add((PotionBrewing.Mix<Potion>)new PotionBrewing.Mix(inputRef, ingredient, outputRef));
    }

    public void addPotionBrewing(Ingredient ingredient, Potion output) {
        this.addPotionBrewing(ingredient, (Potion)Potions.WATER.value(), output);
    }

    public void removePotionBrewing(PotionBrewingFilter filter) {
        this.potionBrewingAccessor.morejs$getPotionMixes().removeIf(mix -> {
            if (filter.test((PotionBrewing.Mix<Potion>)mix)) {
                ConsoleJS.STARTUP.info((Object)("Removed potion brewing recipe: " + String.valueOf(PotionBrewingRegisterEvent.key((Potion)mix.from().value())) + " + " + StringUtils.abbreviate((String)mix.ingredient().toString(), (int)64) + " -> " + String.valueOf(PotionBrewingRegisterEvent.key((Potion)mix.to().value()))));
                return true;
            }
            return false;
        });
    }

    public void removeContainer(Ingredient ingredient) {
        HashSet<Item> removed = new HashSet<Item>();
        ListIterator<Ingredient> containerIt = this.potionBrewingAccessor.morejs$getContainers().listIterator();
        while (containerIt.hasNext()) {
            Ingredient ac = containerIt.next();
            if (!Utils.matchesIngredient(ac, ingredient)) continue;
            containerIt.remove();
            for (ItemStack item : ac.getItems()) {
                removed.add(item.getItem());
            }
        }
        ListIterator<PotionBrewing.Mix<Item>> mixIt = this.potionBrewingAccessor.morejs$getContainerMixes().listIterator();
        while (mixIt.hasNext()) {
            PotionBrewing.Mix<Item> mix = mixIt.next();
            Item output = (Item)mix.to().value();
            if (!ingredient.test(output.getDefaultInstance())) continue;
            mixIt.remove();
            removed.add(output);
        }
        for (Item item : removed) {
            ConsoleJS.STARTUP.info((Object)("Removed potion container: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item))));
        }
    }

    public void validateContainer(Ingredient ingredient, Item input, Item output) {
        Preconditions.checkArgument((input != null && input != Items.AIR ? 1 : 0) != 0, (Object)"Input must not be null or air");
        Preconditions.checkNotNull((Object)ingredient, (Object)"Ingredient must not be null");
        Preconditions.checkArgument((ingredient.getItems().length > 0 ? 1 : 0) != 0, (Object)"Ingredient must have at least one item");
        Preconditions.checkArgument((output != null && output != Items.AIR ? 1 : 0) != 0, (Object)"Output must not be null or air");
    }

    public void addContainerRecipe(Ingredient ingredient, Item input, Item output) {
        this.validateContainer(ingredient, input, output);
        PotionBrewing.Mix mix = new PotionBrewing.Mix((Holder)input.builtInRegistryHolder(), ingredient, (Holder)output.builtInRegistryHolder());
        this.potionBrewingAccessor.morejs$getContainerMixes().add((PotionBrewing.Mix<Item>)mix);
    }

    public void removeCustomBrewing(CustomBrewingFilter filter) {
        ListIterator<IBrewingRecipe> it = this.potionBrewingAccessor.morejs$getRecipes().listIterator();
        while (it.hasNext()) {
            BrewingRecipe br;
            IBrewingRecipe recipe = it.next();
            if (!(recipe instanceof BrewingRecipe) || !filter.test(br = (BrewingRecipe)recipe)) continue;
            String s = String.format("Removing custom brewing recipe: [Input: %s][Ingredient: %s][Output: %s]", br.getInput(), br.getIngredient(), br.getOutput());
            ConsoleJS.STARTUP.info((Object)s);
            it.remove();
        }
    }

    public List<IBrewingRecipe> getCustomBrewingRecipes() {
        return this.potionBrewingAccessor.morejs$getRecipes();
    }
}

