/*
 * Decompiled with CFR 0.152.
 */
package trinitysoft.preset_dims;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresetDimsMod {
    public static final String MOD_ID = "preset_dims";
    public static final String LOCATION = "dimension_presets";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"preset_dims");

    public static void copyPresetDims(Path worldDimensionsDir, Path globalPresetsDir, Path originalLockLocation) {
        if (!Files.exists(globalPresetsDir, new LinkOption[0])) {
            LOGGER.info("Generating the preset_dims directory for the first time in this instance!");
            boolean sanity = globalPresetsDir.toFile().mkdir();
            if (!sanity) {
                LOGGER.error("Preset dims directory couldn't be generated despite no file existing at location!");
            }
        } else if (!Files.isDirectory(globalPresetsDir, new LinkOption[0])) {
            try {
                Files.delete(globalPresetsDir);
                LOGGER.warn("Non-directory file existed in place of preset_dims directory, generating one in its place.");
                boolean sanity = globalPresetsDir.toFile().mkdir();
                if (!sanity) {
                    LOGGER.error("Preset dims directory couldn't be generated despite removal of preexisting file!");
                }
            }
            catch (IOException e) {
                LOGGER.error(e.toString());
            }
        } else {
            Path localDimsLock = worldDimensionsDir.getParent().resolve("presetDimsLock.txt");
            if (!Files.exists(localDimsLock, new LinkOption[0])) {
                try (Stream<Path> copyStream = Files.walk(globalPresetsDir, new FileVisitOption[0]);){
                    copyStream.forEach(subSrc -> PresetDimsMod.copy(subSrc, worldDimensionsDir.resolve(globalPresetsDir.relativize((Path)subSrc))));
                }
                catch (IOException e) {
                    LOGGER.error(e.toString());
                }
                PresetDimsMod.copy(originalLockLocation, localDimsLock);
            } else {
                LOGGER.info("Preset dimension lock exists for this world, skipping copy process");
            }
        }
    }

    private static void copy(Path src, Path dest) {
        try {
            Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error(e.toString());
        }
    }
}

