#All of the code below is part of the Baked Neccessities datapack created by BeagleBlocks

#say LETS COOK!

#execute as @a at @s run function bn:pizzapie

#----------------------------------------------------------------------------------- Player Authentication ---------------------------------------------------------------------------------------------#

execute as @a[tag=!authentication] at @s run function bn:player/authenticate


#Recipe Enabling
#For BN 3.1.2 ONLY!
execute as @a[tag=recipe_bn] at @s run function bn:player/fix_recipe_3_1_2
#Enable Recipes
execute as @a[tag=!recipe_bn_update_2] at @s run function bn:player/recipe

#----------------------------------------------------------------------------------- Special Sweets ---------------------------------------------------------------------------------------------#

######## Wizarding Candies - Executable Food Item - TEMPLATE!!!

scoreboard players set @a[nbt={SelectedItem:{id:"minecraft:dried_kelp",components:{"minecraft:custom_data":{sickly_sweets:1b}}}}] sickly_delay 2


##### Run command for effect or any other command or function file if player eats custon item
##### (If the player has recently held the custom item and also just ate the base item)


#Sickly Sweets
execute as @a[scores={sickly_delay=1..,candy_eat=1}] at @s run scoreboard players set @s sickly_cure 120
execute as @a[scores={sickly_cure=1}] at @s run effect give @s minecraft:instant_health 1 3

##### Reset eat scoreboard - All Types
scoreboard players reset @a[scores={candy_eat=1..}] candy_eat

##### Constantly remove 1 from the delay - Candy Dependent
execute as @a[scores={sickly_delay=1..}] unless entity @s[nbt={SelectedItem:{id:"minecraft:dried_kelp",components:{"minecraft:custom_data":{sickly_sweets:1b}}}}] run scoreboard players remove @s sickly_delay 1
execute as @a[scores={sickly_cure=1..}] run scoreboard players remove @s sickly_cure 1

execute if entity @e[type=glow_item_frame,nbt={Item:{id:"minecraft:iron_ingot",count:1}}] run data merge entity @s[] {Item:{id:"minecraft:gold_ingot",count:1}}


#----------------------------------------------------------------------------------- Prep-tables ---------------------------------------------------------------------------------------------#

#Prep Table - Placement
execute as @e[type=minecraft:glow_item_frame,tag=oak_pt] at @s run function bn:prep_table/oak/place 
execute as @e[type=minecraft:glow_item_frame,tag=spruce_pt] at @s run function bn:prep_table/spruce/place
execute as @e[type=minecraft:glow_item_frame,tag=birch_pt] at @s run function bn:prep_table/birch/place
execute as @e[type=minecraft:glow_item_frame,tag=jungle_pt] at @s run function bn:prep_table/jungle/place
execute as @e[type=minecraft:glow_item_frame,tag=acadia_pt] at @s run function bn:prep_table/acadia/place
execute as @e[type=minecraft:glow_item_frame,tag=dark_oak_pt] at @s run function bn:prep_table/dark_oak/place
execute as @e[type=minecraft:glow_item_frame,tag=mangrove_pt] at @s run function bn:prep_table/mangrove/place
execute as @e[type=minecraft:glow_item_frame,tag=cherry_pt] at @s run function bn:prep_table/cherry/place
execute as @e[type=minecraft:glow_item_frame,tag=bamboo_pt] at @s run function bn:prep_table/bamboo/place
execute as @e[type=minecraft:glow_item_frame,tag=crimson_pt] at @s run function bn:prep_table/crimson/place
execute as @e[type=minecraft:glow_item_frame,tag=warped_pt] at @s run function bn:prep_table/warped/place
execute as @e[type=minecraft:glow_item_frame,tag=pale_oak_pt] at @s run function bn:prep_table/pale_oak/place 

#Prep Table - Removal
execute as @e[type=minecraft:armor_stand,tag=oak_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/oak/remove
execute as @e[type=minecraft:armor_stand,tag=spruce_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/spruce/remove
execute as @e[type=minecraft:armor_stand,tag=birch_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/birch/remove
execute as @e[type=minecraft:armor_stand,tag=jungle_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/jungle/remove
execute as @e[type=minecraft:armor_stand,tag=acadia_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/acadia/remove
execute as @e[type=minecraft:armor_stand,tag=dark_oak_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/dark_oak/remove
execute as @e[type=minecraft:armor_stand,tag=mangrove_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/mangrove/remove
execute as @e[type=minecraft:armor_stand,tag=cherry_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/cherry/remove
execute as @e[type=minecraft:armor_stand,tag=bamboo_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/bamboo/remove
execute as @e[type=minecraft:armor_stand,tag=crimson_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/crimson/remove
execute as @e[type=minecraft:armor_stand,tag=warped_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/warped/remove
execute as @e[type=minecraft:armor_stand,tag=pale_oak_pt,tag=prep] at @s unless block ~ ~ ~ minecraft:dropper run function bn:prep_table/pale_oak/remove

#Executes on all prep tables - regardless of material 
execute as @e[tag=prep] at @s run function bn:prep_table/crafting

#----------------------------------------------------------------------------------- Bushels/Bundles ---------------------------------------------------------------------------------------------#

#Bushel - Placement
execute as @e[type=minecraft:glow_item_frame,tag=berry_bushel] at @s run function bn:bushels/berry/place
execute as @e[type=minecraft:glow_item_frame,tag=bean_bushel] at @s run function bn:bushels/beans/place
execute as @e[type=minecraft:glow_item_frame,tag=chorus_bushel] at @s run function bn:bushels/chorus/place
execute as @e[type=minecraft:glow_item_frame,tag=glow_berry_bushel] at @s run function bn:bushels/glow_berry/place
execute as @e[type=minecraft:glow_item_frame,tag=honey_pack] at @s run function bn:bushels/honey_pack/place


#Bushel - Removal
execute as @e[type=minecraft:armor_stand,tag=berry_bushel] at @s unless block ~ ~ ~ minecraft:oak_planks run function bn:bushels/berry/remove
execute as @e[type=minecraft:armor_stand,tag=bean_bushel] at @s unless block ~ ~ ~ minecraft:oak_planks run function bn:bushels/beans/remove
execute as @e[type=minecraft:armor_stand,tag=chorus_bushel] at @s unless block ~ ~ ~ minecraft:oak_planks run function bn:bushels/chorus/remove
execute as @e[type=minecraft:armor_stand,tag=glow_berry_bushel] at @s unless block ~ ~ ~ minecraft:shroomlight run function bn:bushels/glow_berry/remove
execute as @e[type=minecraft:armor_stand,tag=honey_pack] at @s unless block ~ ~ ~ minecraft:flower_pot run function bn:bushels/honey_pack/remove


#----------------------------------------------------------------------------------- Sweet Boxes ---------------------------------------------------------------------------------------------#

#Sweet Box - Placement
execute as @e[type=minecraft:glow_item_frame,tag=brownie_sb] at @s run function bn:sweet_box/brownie/place
execute as @e[type=minecraft:glow_item_frame,tag=berry_cheese_cake_sb] at @s run function bn:sweet_box/berry_cheese_cake/place
execute as @e[type=minecraft:glow_item_frame,tag=carrot_cake_sb] at @s run function bn:sweet_box/carrot_cake/place
execute as @e[type=minecraft:glow_item_frame,tag=honeybun_sb] at @s run function bn:sweet_box/honeybun/place
execute as @e[type=minecraft:glow_item_frame,tag=berry_pie_sb] at @s run function bn:sweet_box/berry_pie/place
execute as @e[type=minecraft:glow_item_frame,tag=apple_pie_sb] at @s run function bn:sweet_box/apple_pie/place
execute as @e[type=minecraft:glow_item_frame,tag=pumpkin_pie_sb] at @s run function bn:sweet_box/pumpkin_pie/place
execute as @e[type=minecraft:glow_item_frame,tag=cupcake_sb] at @s run function bn:sweet_box/cupcake/place
execute as @e[type=minecraft:glow_item_frame,tag=muffin_sb] at @s run function bn:sweet_box/berry_muffin/place
execute as @e[type=minecraft:glow_item_frame,tag=cupcake_rv_sb] at @s run function bn:sweet_box/cupcake_rv/place
execute as @e[type=minecraft:glow_item_frame,tag=lumen_beans_sb] at @s run function bn:sweet_box/lumen_beans/place
execute as @e[type=minecraft:glow_item_frame,tag=sickly_sweets_sb] at @s run function bn:sweet_box/sickly_sweets/place
execute as @e[type=minecraft:glow_item_frame,tag=boomin_bon_sb] at @s run function bn:sweet_box/boomin_bon/place
execute as @e[type=minecraft:glow_item_frame,tag=whirlin_beez_sb] at @s run function bn:sweet_box/whirlin_beez/place
execute as @e[type=minecraft:glow_item_frame,tag=chocolate_hopper_sb] at @s run function bn:sweet_box/chocolate_hopper/place
execute as @e[type=minecraft:glow_item_frame,tag=blaze_donut_sb] at @s run function bn:sweet_box/blaze_donut/place
execute as @e[type=minecraft:glow_item_frame,tag=fox_fudge_sb] at @s run function bn:sweet_box/fox_fudge/place

#Sweet Box - Removal
execute as @e[type=minecraft:armor_stand,tag=brownie_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/brownie/remove
execute as @e[type=minecraft:armor_stand,tag=berry_cheese_cake_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/berry_cheese_cake/remove
execute as @e[type=minecraft:armor_stand,tag=carrot_cake_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/carrot_cake/remove
execute as @e[type=minecraft:armor_stand,tag=honeybun_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/honeybun/remove
execute as @e[type=minecraft:armor_stand,tag=berry_pie_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/berry_pie/remove
execute as @e[type=minecraft:armor_stand,tag=apple_pie_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/apple_pie/remove
execute as @e[type=minecraft:armor_stand,tag=pumpkin_pie_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/pumpkin_pie/remove
execute as @e[type=minecraft:armor_stand,tag=cupcake_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/cupcake/remove
execute as @e[type=minecraft:armor_stand,tag=muffin_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/berry_muffin/remove
execute as @e[type=minecraft:armor_stand,tag=cupcake_rv_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/cupcake_rv/remove
execute as @e[type=minecraft:armor_stand,tag=lumen_beans_sb] at @s unless block ~ ~ ~ minecraft:lantern run function bn:sweet_box/lumen_beans/remove
execute as @e[type=minecraft:armor_stand,tag=sickly_sweets_sb] at @s unless block ~ ~ ~ minecraft:oak_button run function bn:sweet_box/sickly_sweets/remove
execute as @e[type=minecraft:armor_stand,tag=boomin_bon_sb] at @s unless block ~ ~ ~ minecraft:oak_button run function bn:sweet_box/boomin_bon/remove
execute as @e[type=minecraft:armor_stand,tag=whirlin_beez_sb] at @s unless block ~ ~ ~ minecraft:oak_button run function bn:sweet_box/whirlin_beez/remove
execute as @e[type=minecraft:armor_stand,tag=chocolate_hopper_sb] at @s unless block ~ ~ ~ minecraft:oak_button run function bn:sweet_box/chocolate_hopper/remove
execute as @e[type=minecraft:armor_stand,tag=blaze_donut_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/blaze_donut/remove
execute as @e[type=minecraft:armor_stand,tag=fox_fudge_sb] at @s unless block ~ ~ ~ minecraft:oak_pressure_plate run function bn:sweet_box/fox_fudge/remove


#----------------------------------------------------------------------------------- Sweet Deals ---------------------------------------------------------------------------------------------#

#Offer Redeem - Needs to be above the Sweet Deal Offer                                  
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["brownie_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_brownie] run function bn:sweet_deal/brownie/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["apple_pie_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_apple_pie] run function bn:sweet_deal/apple_pie/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["berry_pie_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_berry_pie] run function bn:sweet_deal/berry_pie/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["pumpkin_pie_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_pumpkin_pie] run function bn:sweet_deal/pumpkin_pie/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["cupcake_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_cupcake] run function bn:sweet_deal/cupcake/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["muffin_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_muffin] run function bn:sweet_deal/berry_muffin/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["honeybun_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_honeybun] run function bn:sweet_deal/honeybun/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["carrot_cake_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_carrot_cake] run function bn:sweet_deal/carrot_cake/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["berry_cheese_cake_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_berry_cheese_cake] run function bn:sweet_deal/berry_cheese_cake/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["cupcake_rv_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_cupcake_rv] run function bn:sweet_deal/cupcake_rv/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["lumen_beans_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_lumen] run function bn:sweet_deal/lumen_beans/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["sickly_sweets_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_sickly] run function bn:sweet_deal/sickly_sweets/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["boomin_bon_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_bonbon] run function bn:sweet_deal/boomin_bon/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["whirlin_beez_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_beez] run function bn:sweet_deal/whirlin_beez/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["chocolate_hopper_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_hopper] run function bn:sweet_deal/chocolate_hopper/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["blaze_donut_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_blaze_donut] run function bn:sweet_deal/blaze_donut/complete
execute as @a[nbt={SelectedItem:{id: "minecraft:glow_item_frame",count:1,components:{"minecraft:entity_data":{id:"minecraft:glow_item_frame",Tags:["fox_fudge_sb"]}}}}] at @s if entity @e[distance=..4,tag=sd_fox_fudge] run function bn:sweet_deal/fox_fudge/complete

#Assigns Sweet Deal
execute as @e[type=minecraft:wandering_trader,tag=!santa,tag=!dealassigned] at @s run function bn:sweet_deal/deal_assignment

#Offers Sweet Deal to nearby players
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_apple_pie] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/apple_pie/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_berry_pie] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/berry_pie/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_pumpkin_pie] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/pumpkin_pie/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_berry_cheese_cake] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/berry_cheese_cake/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_brownie] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/brownie/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_carrot_cake] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/carrot_cake/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_honeybun] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/honeybun/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_cupcake] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/cupcake/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_cupcake_rv] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/cupcake_rv/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_muffin] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/berry_muffin/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_lumen] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/lumen_beans/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_sickly] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/sickly_sweets/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_beez] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/whirlin_beez/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_bonbon] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/boomin_bon/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_hopper] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/chocolate_hopper/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_blaze_donut] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/blaze_donut/sweet_deal
execute as @e[type=minecraft:wandering_trader,tag=dealassigned,tag=sd_fox_fudge] at @s if entity @p[distance=..4,tag=!toldsweetdeal] run function bn:sweet_deal/fox_fudge/sweet_deal

#Removes Tell Tag for Sweet Deal - (Stops Text Spam)
execute as @a[tag=toldsweetdeal] at @s unless entity @e[type=minecraft:wandering_trader,distance=..12] run tag @s remove toldsweetdeal

#----------------------------------------------------------------------------------- Treasure Boxes ---------------------------------------------------------------------------------------------#

######## Mailbox/package
scoreboard players set @a[nbt={SelectedItem:{id:"minecraft:squid_spawn_egg"}}] egg_delay 2

#New Command
execute as @e[type=minecraft:armor_stand,tag=tb_common] at @s run function bn:treasure_box/common_box/open

#New Command
execute as @e[type=minecraft:armor_stand,tag=tb_adventurous] at @s run function bn:treasure_box/adventure_box/open

#New Command
execute as @e[type=minecraft:armor_stand,tag=tb_legendary] at @s run function bn:treasure_box/legend_box/open

#Old Scoreboard Command
scoreboard players set @a[scores={treasure_box=1..}] treasure_box 0
#New Scoreboard Command
execute as @a[scores={egg_delay=1..}] unless entity @s[nbt={SelectedItem:{id:"minecraft:squid_spawn_egg"}}] run scoreboard players remove @s egg_delay 1

#----------------------------------------------------------------------------------- Registers ---------------------------------------------------------------------------------------------#

#Modified Facing "Non-Squared"
#execute as @a[y_rotation=145..180] at @s run say North!
#execute as @a[y_rotation=-180..-145] at @s run say North!
#execute as @a[y_rotation=-144..-46] at @s run say East!
#execute as @a[y_rotation=-45..45] at @s run say South!
#execute as @a[y_rotation=46..144] at @s run say West!

######## Holding Register - Will need to be reworked at some point - Needs to be more specific
scoreboard players set @a[nbt={SelectedItem:{id:"minecraft:glow_item_frame"}}] register_delay 2

#Register - Placement Command
execute as @e[type=minecraft:glow_item_frame,tag=register_oak] at @s run function bn:register/oak/place
execute as @e[type=minecraft:glow_item_frame,tag=register_acadia] at @s run function bn:register/acadia/place
execute as @e[type=minecraft:glow_item_frame,tag=register_bamboo] at @s run function bn:register/bamboo/place
execute as @e[type=minecraft:glow_item_frame,tag=register_birch] at @s run function bn:register/birch/place
execute as @e[type=minecraft:glow_item_frame,tag=register_cherry] at @s run function bn:register/cherry/place
execute as @e[type=minecraft:glow_item_frame,tag=register_crimson] at @s run function bn:register/crimson/place
execute as @e[type=minecraft:glow_item_frame,tag=register_dark_oak] at @s run function bn:register/dark_oak/place
execute as @e[type=minecraft:glow_item_frame,tag=register_jungle] at @s run function bn:register/jungle/place
execute as @e[type=minecraft:glow_item_frame,tag=register_mangrove] at @s run function bn:register/mangrove/place
execute as @e[type=minecraft:glow_item_frame,tag=register_spruce] at @s run function bn:register/spruce/place
execute as @e[type=minecraft:glow_item_frame,tag=register_warped] at @s run function bn:register/warped/place
execute as @e[type=minecraft:glow_item_frame,tag=register_pale_oak] at @s run function bn:register/pale_oak/place

#Register - Removal
execute as @e[type=minecraft:armor_stand,tag=register_oak,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/oak/remove
execute as @e[type=minecraft:armor_stand,tag=register_acadia,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/acadia/remove
execute as @e[type=minecraft:armor_stand,tag=register_bamboo,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/bamboo/remove
execute as @e[type=minecraft:armor_stand,tag=register_birch,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/birch/remove
execute as @e[type=minecraft:armor_stand,tag=register_cherry,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/cherry/remove
execute as @e[type=minecraft:armor_stand,tag=register_crimson,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/crimson/remove
execute as @e[type=minecraft:armor_stand,tag=register_dark_oak,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/dark_oak/remove
execute as @e[type=minecraft:armor_stand,tag=register_jungle,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/jungle/remove
execute as @e[type=minecraft:armor_stand,tag=register_mangrove,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/mangrove/remove
execute as @e[type=minecraft:armor_stand,tag=register_spruce,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/spruce/remove
execute as @e[type=minecraft:armor_stand,tag=register_warped,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/warped/remove
execute as @e[type=minecraft:armor_stand,tag=register_pale_oak,tag=register] at @s unless block ~ ~ ~ minecraft:hopper run function bn:register/pale_oak/remove

#Register - Villager Shopping - Intial Shop/adds scoreboard
execute as @e[type=minecraft:villager,tag=!shop] at @s if entity @e[type=minecraft:armor_stand,tag=register,distance=..10,tag=active] run function bn:register/customer
#If Shopping Tag is Set - repeat customer
execute as @e[type=minecraft:villager,tag=!shop,scores={shopping=..1}] at @s if entity @e[type=minecraft:armor_stand,tag=register,distance=..10,tag=active] run function bn:register/customer

#Register - No Longer Shopping
execute as @e[type=minecraft:villager,tag=shop] at @s unless entity @e[type=minecraft:armor_stand,tag=register,distance=..10,tag=active] run tag @s remove shop

#Register - Setting Active Register
execute as @e[type=minecraft:armor_stand,tag=register,tag=!active,limit=1,sort=nearest] at @s unless entity @e[type=minecraft:armor_stand,tag=register,distance=..50,tag=active] run function bn:register/active
execute as @e[type=minecraft:armor_stand,tag=register,tag=!mark_uuid] at @s run function bn:register/naming_uuid
execute as @a[tag=!bakery_side] at @s if entity @e[type=minecraft:armor_stand,tag=register,distance=..3,tag=active] at @s run function bn:register/sidebar
execute as @a[tag=bakery_side] at @s unless entity @e[type=minecraft:armor_stand,tag=register,distance=..3,tag=active] at @s run function bn:register/sidebar_remove

#Apply Bakery Stats
execute as @e[type=minecraft:armor_stand,tag=register,tag=!bakery_levels] at @s run function bn:register/bakery
#For BN 3.1.2 ONLY! - Applying Reward Score
execute as @e[type=minecraft:armor_stand,tag=register,tag=bakery_levels,tag=!reward_score] at @s run function bn:register/bakery_score_3.1.2

#Villager Shopping Cooldown
scoreboard players remove @e[type=minecraft:villager,scores={shopping=1..}] shopping 1

#Bakery Rewards
execute as @e[type=minecraft:armor_stand,tag=register,tag=active,tag=!novice,scores={reward_score=54..}] at @s run function bn:register/rewards/novice
execute as @e[type=minecraft:armor_stand,tag=register,tag=active,tag=!seasoned,scores={reward_score=162..}] at @s run function bn:register/rewards/seasoned
execute as @e[type=minecraft:armor_stand,tag=register,tag=active,tag=!elite,scores={reward_score=348..}] at @s run function bn:register/rewards/elite
execute as @e[type=minecraft:armor_stand,tag=register,tag=active,tag=elite,scores={reward_score=349..}] at @s run function bn:register/rewards/reset


#----------------------------------------------------------------------------------- Bakery Nametag ---------------------------------------------------------------------------------------------
##Gets CustomName 
execute as @e[type=minecraft:armor_stand,tag=bakery_name_tag,tag=!named] at @s run function bn:register/bakery_name
data modify entity @e[type=minecraft:armor_stand,tag=register,limit=1] CustomName set from entity @e[type=minecraft:armor_stand,tag=bakery_name_tag,tag=!named,sort=nearest,limit=1] CustomName
execute as @e[type=minecraft:armor_stand,tag=bakery_name_tag,tag=named] at @s run kill @s


#----------------------------------------------------------------------------------- Coffee Pot ---------------------------------------------------------------------------------------------#

#Coffee Pot
execute as @e[type=minecraft:glow_item_frame,tag=coffee_pot] at @s run function bn:coffee_pot/place
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place] at @s unless block ~ ~ ~ minecraft:polished_blackstone_button run function bn:coffee_pot/remove

#Detecting Blend
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,tag=!brewingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{coffee_roast:1b}}}}] run function bn:coffee_pot/brewing/coffee/coffee_brew
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,tag=!brewingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{tea_roast:1b}}}}] run function bn:coffee_pot/brewing/tea/tea_brew

#Brewing Countdown - Noises
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=180}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=140}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=140}] at @s run particle minecraft:white_smoke ~ ~ ~ 1 0.5 1 .1 10
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=100}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=80}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=80}] at @s run particle minecraft:white_smoke ~ ~ ~ 1 0.5 1 .1 10
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=60}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=40}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=20}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=20}] at @s run particle minecraft:white_smoke ~ ~ ~ 1 0.5 1 .1 10
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=10}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=5}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,scores={roast_delay=1}] at @s run playsound minecraft:block.note_block.bell ambient @a


#Collecting Drink
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,tag=brewingcoffee,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:polished_blackstone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:glass_bottle"}},distance=..3] run function bn:coffee_pot/brewing/coffee/coffee_brew_collect
execute as @e[type=minecraft:armor_stand,tag=coffee_pot_place,tag=brewingtea,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:polished_blackstone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:glass_bottle"}},distance=..3] run function bn:coffee_pot/brewing/tea/tea_brew_collect


#----------------------------------------------------------------------------------- Plates ---------------------------------------------------------------------------------------------#

#Plate Place Command
execute as @e[type=minecraft:armor_stand,tag=platter_marker_black,tag=!summoned] at @s run function bn:serving_platter/black/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_blue,tag=!summoned] at @s run function bn:serving_platter/blue/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_brown,tag=!summoned] at @s run function bn:serving_platter/brown/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_cyan,tag=!summoned] at @s run function bn:serving_platter/cyan/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_gray,tag=!summoned] at @s run function bn:serving_platter/gray/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_green,tag=!summoned] at @s run function bn:serving_platter/green/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_light_blue,tag=!summoned] at @s run function bn:serving_platter/light_blue/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_light_gray,tag=!summoned] at @s run function bn:serving_platter/light_gray/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_lime_green,tag=!summoned] at @s run function bn:serving_platter/lime_green/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_magenta,tag=!summoned] at @s run function bn:serving_platter/magenta/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_orange,tag=!summoned] at @s run function bn:serving_platter/orange/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_pink,tag=!summoned] at @s run function bn:serving_platter/pink/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_purple,tag=!summoned] at @s run function bn:serving_platter/purple/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_red,tag=!summoned] at @s run function bn:serving_platter/red/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_white,tag=!summoned] at @s run function bn:serving_platter/white/place
execute as @e[type=minecraft:armor_stand,tag=platter_marker_yellow,tag=!summoned] at @s run function bn:serving_platter/yellow/place


#Plate Remove Command
execute as @e[type=minecraft:armor_stand,tag=platter_marker_black,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/black/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_blue,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/blue/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_brown,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/brown/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_cyan,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/cyan/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_gray,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/gray/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_green,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/green/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_light_blue,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/light_blue/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_light_gray,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/light_gray/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_lime_green,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/lime_green/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_magenta,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/magenta/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_orange,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/orange/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_pink,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/pink/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_purple,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/purple/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_red,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/red/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_white,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/white/remove
execute as @e[type=minecraft:armor_stand,tag=platter_marker_yellow,tag=summoned] at @s unless entity @e[type=minecraft:glow_item_frame,tag=platter_frame,distance=..1] run function bn:serving_platter/yellow/remove

#Detects if a Platter has an item
execute as @e[type=glow_item_frame,tag=platter_frame] store success score @s hasItem run data get entity @s Item

#Vanilla Conversions - Place
execute as @e[type=glow_item_frame,tag=!vanilla_pumpkin,tag=platter_frame,nbt={Item:{id:"minecraft:pumpkin_pie",count:1}}] at @s run function bn:serving_platter/vanilla_conversion/pumpkin_pie

#Vanilla Conversions - Remove
execute as @e[type=glow_item_frame,tag=vanilla_pumpkin,tag=platter_frame,scores={hasItem=0}] at @s run function bn:serving_platter/vanilla_conversion/pumpkin_pie_remove




#----------------------------------------------------------------------------------- Bakers Oven ---------------------------------------------------------------------------------------------#

#Bakers Oven
execute as @e[type=minecraft:glow_item_frame,tag=bakers_oven] at @s run function bn:bakers_oven/place
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place] at @s unless block ~ ~ ~ minecraft:stone_button run function bn:bakers_oven/remove

#Detecting Batter
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_brownie:1b}}}}] run function bn:bakers_oven/baking/brownie/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_apple_pie:1b}}}}] run function bn:bakers_oven/baking/apple_pie/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_berry_pie:1b}}}}] run function bn:bakers_oven/baking/berry_pie/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_berry_cheesecake:1b}}}}] run function bn:bakers_oven/baking/berry_cheese_cake/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_berry_muffin:1b}}}}] run function bn:bakers_oven/baking/berry_muffin/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_blaze_donut:1b}}}}] run function bn:bakers_oven/baking/blaze_powder_donut/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_bon_bon:1b}}}}] run function bn:bakers_oven/baking/boomin_bon_bons/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_carrot_cake:1b}}}}] run function bn:bakers_oven/baking/carrot_cake/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_hopper:1b}}}}] run function bn:bakers_oven/baking/chocolate_hopper/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_cupcake:1b}}}}] run function bn:bakers_oven/baking/cupcake/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_fox_fudge:1b}}}}] run function bn:bakers_oven/baking/fox_fudge/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_honeybun:1b}}}}] run function bn:bakers_oven/baking/honeybun/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_lumen_bean:1b}}}}] run function bn:bakers_oven/baking/lumen_beans/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_velvet_cupcake:1b}}}}] run function bn:bakers_oven/baking/red_velvet_cupcake/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_sickly_sweets:1b}}}}] run function bn:bakers_oven/baking/sickly_sweets/bake
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=!bakingprocess] at @s if entity @e[distance=..1.2,type=item,nbt={Item:{id:"minecraft:iron_nugget",components:{"minecraft:custom_data":{batter_beez:1b}}}}] run function bn:bakers_oven/baking/whirlin_beez/bake

#Giving Bowl Back
execute as @e[type=armor_stand,tag=bakers_oven_place,tag=bakingprocess,scores={roast_delay=199}] at @s run loot give @p loot bn:entities/bowl

#Brewing Countdown - Noises
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=180}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=140}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=140}] at @s run particle minecraft:white_smoke ~ ~ ~ 1 0.5 1 .1 10
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=100}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=80}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=80}] at @s run particle minecraft:white_smoke ~ ~ ~ 1 0.5 1 .1 10
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=60}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=40}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=20}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=20}] at @s run particle minecraft:white_smoke ~ ~ ~ 1 0.5 1 .1 10
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=10}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=5}] at @s run playsound minecraft:block.fire.extinguish ambient @a ~ ~ ~ .05 2
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,scores={roast_delay=1}] at @s run playsound minecraft:block.note_block.bell ambient @a


scoreboard players remove @e[type=minecraft:armor_stand,scores={roast_delay=1..}] roast_delay 1

##Collecting Sweet Box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingbrownie,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/brownie/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingapplepie,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/apple_pie/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingberrypie,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/berry_pie/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingberrycheesecake,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/berry_cheese_cake/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingberrymuffin,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/berry_muffin/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingblazepowder,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/blaze_powder_donut/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingbonbon,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/boomin_bon_bons/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingcarrotcake,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/carrot_cake/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakinghopper,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/chocolate_hopper/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingcupcake,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/cupcake/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingfoxfudge,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/fox_fudge/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakinghoneybun,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/honeybun/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakinglumenbeans,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/lumen_beans/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingvelvetcupcake,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/red_velvet_cupcake/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingsicklysweets,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/sickly_sweets/bake_collect_box
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingbeez,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] if entity @a[nbt={SelectedItem:{id:"minecraft:paper"}},distance=..3] run function bn:bakers_oven/baking/whirlin_beez/bake_collect_box

##Collecting Sweets
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingbrownie,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/brownie/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingapplepie,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/apple_pie/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingberrypie,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/berry_pie/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingberrycheesecake,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/berry_cheese_cake/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingberrymuffin,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/berry_muffin/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingblazepowder,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/blaze_powder_donut/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingbonbon,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/boomin_bon_bons/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingcarrotcake,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/carrot_cake/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakinghopper,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/chocolate_hopper/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingcupcake,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/cupcake/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingfoxfudge,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/fox_fudge/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakinghoneybun,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/honeybun/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakinglumenbeans,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/lumen_beans/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingvelvetcupcake,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/red_velvet_cupcake/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingsicklysweets,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/sickly_sweets/bake_collect
execute as @e[type=minecraft:armor_stand,tag=bakers_oven_place,tag=bakingbeez,scores={roast_delay=..0}] at @s if block ~ ~ ~ minecraft:stone_button[powered=true] run function bn:bakers_oven/baking/whirlin_beez/bake_collect

#----------------------------------------------------------------------------------- Placeable Block Scoreboards ---------------------------------------------------------------------------------------------#
#### Constantly remove 1 from the delay - Register/Placeable blocks
execute as @a[scores={register_delay=1..}] unless entity @s[nbt={SelectedItem:{id:"minecraft:glow_item_frame"}}] run scoreboard players remove @s register_delay 1
##### Reset eat scoreboard - All Types
scoreboard players reset @a[scores={register_place=1..}] register_place
