/*
 * Decompiled with CFR 0.152.
 */
package me.tizo.drillPickaxe.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class BlockUtils {
    private static final int[][] DIRECTIONS = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
    private static final Set<Material> TRANSPARENT_MATERIALS = Set.of(Material.AIR, Material.CAVE_AIR, Material.WATER, Material.LAVA);

    public static Vector getBreakingFace(Player player) {
        Block adjacentBlock;
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(TRANSPARENT_MATERIALS, 10);
        if (lastTwoTargetBlocks.size() != 2 || !((Block)lastTwoTargetBlocks.get(1)).getType().isOccluding()) {
            return null;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        BlockFace face = targetBlock.getFace(adjacentBlock = (Block)lastTwoTargetBlocks.get(0));
        if (face == null) {
            return null;
        }
        return new Vector(face.getModX(), face.getModY(), face.getModZ());
    }

    public static List<Block> getAffectedBlocks(Block center, Vector face) {
        ArrayList<Block> blocks = new ArrayList<Block>(9);
        boolean xDominant = Math.abs(face.getX()) > Math.abs(face.getY()) && Math.abs(face.getX()) > Math.abs(face.getZ());
        boolean yDominant = Math.abs(face.getY()) > Math.abs(face.getZ());
        for (int[] offset : DIRECTIONS) {
            Block relative = xDominant ? center.getRelative(0, offset[0], offset[1]) : (yDominant ? center.getRelative(offset[0], 0, offset[1]) : center.getRelative(offset[0], offset[1], 0));
            blocks.add(relative);
        }
        blocks.add(center);
        return blocks;
    }
}

