/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.failedbreeding;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class BreedingConfig {
    private static final File CONFIG_FILE = new File("config/failed-breeding.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public double failChance = 0.1;
    public static BreedingConfig INSTANCE = new BreedingConfig();

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            BreedingConfig.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            INSTANCE = (BreedingConfig)GSON.fromJson((Reader)reader, BreedingConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        CONFIG_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

