/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.woodcutter.client.gui.screen;

import com.devnemo.nemos.woodcutter.client.gui.screen.ModMenuTypes;
import com.devnemo.nemos.woodcutter.interfaces.ModRecipeManagerGetter;
import com.devnemo.nemos.woodcutter.interfaces.WoodcutterRecipeGetter;
import com.devnemo.nemos.woodcutter.recipe.WoodcuttingRecipe;
import com.devnemo.nemos.woodcutter.recipe.display.WoodcuttingRecipeDisplay;
import com.devnemo.nemos.woodcutter.world.level.block.WoodcutterBlocks;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9696;
import org.jetbrains.annotations.NotNull;

public class WoodcutterMenu
extends class_1703 {
    private final class_3914 access;
    private final class_3915 selectedRecipeIndex = class_3915.method_17403();
    private final class_1937 level;
    private WoodcuttingRecipeDisplay.Grouping recipesForInput = WoodcuttingRecipeDisplay.Grouping.empty();
    private class_1799 inputStack = class_1799.field_8037;
    long lastTakeTime;
    final class_1735 inputSlot;
    final class_1735 resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final class_1263 input = new class_1277(1){

        public void method_5431() {
            super.method_5431();
            WoodcutterMenu.this.method_7609((class_1263)this);
            WoodcutterMenu.this.slotUpdateListener.run();
        }
    };
    final class_1731 resultContainer = new class_1731();

    public WoodcutterMenu(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public WoodcutterMenu(int syncId, class_1661 playerInventory, final class_3914 access) {
        super(ModMenuTypes.WOODCUTTER_SCREEN_HANDLER.get(), syncId);
        int i;
        this.access = access;
        this.level = playerInventory.field_7546.method_73183();
        this.inputSlot = this.method_7621(new class_1735(this.input, 0, 20, 33));
        this.resultSlot = this.method_7621(new class_1735((class_1263)this.resultContainer, 1, 143, 33){

            public boolean method_7680(@NotNull class_1799 stack) {
                return false;
            }

            public void method_7667(@NotNull class_1657 player, @NotNull class_1799 stack) {
                stack.method_7982(player, stack.method_7947());
                WoodcutterMenu.this.resultContainer.method_7664(player, this.getInputStacks());
                int recipeInputCount = WoodcutterMenu.this.recipesForInput.entries().get(WoodcutterMenu.this.selectedRecipeIndex.method_17407()).inputCount();
                class_1799 itemStack = WoodcutterMenu.this.inputSlot.method_7671(recipeInputCount);
                if (!itemStack.method_7960()) {
                    WoodcutterMenu.this.setupResultSlot(WoodcutterMenu.this.selectedRecipeIndex.method_17407());
                }
                access.method_17393((level, pos) -> {
                    long l = level.method_8510();
                    if (WoodcutterMenu.this.lastTakeTime != l) {
                        level.method_8396(null, pos, class_3417.field_17710, class_3419.field_15245, 1.0f, 1.0f);
                        WoodcutterMenu.this.lastTakeTime = l;
                    }
                });
                super.method_7667(player, stack);
            }

            private List<class_1799> getInputStacks() {
                return List.of(WoodcutterMenu.this.inputSlot.method_7677());
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
        this.method_17362(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.method_17407();
    }

    public WoodcuttingRecipeDisplay.Grouping getVisibleRecipes() {
        return this.recipesForInput;
    }

    public int getAvailableRecipeCount() {
        return this.recipesForInput.size();
    }

    public boolean canCraft() {
        return this.inputSlot.method_7681() && this.recipesForInput.hasRecipes();
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return WoodcutterMenu.method_17695((class_3914)this.access, (class_1657)player, (class_2248)WoodcutterBlocks.WOODCUTTER.get());
    }

    public boolean method_7604(@NotNull class_1657 player, int id) {
        if (this.selectedRecipeIndex.method_17407() == id || !this.isValidRecipeIndex(id)) {
            return false;
        }
        this.getRecipeHolder(id).ifPresent(recipeDisplay -> {
            Optional<class_8786<WoodcuttingRecipe>> optionalRecipeHolder = recipeDisplay.recipe();
            if (optionalRecipeHolder.isEmpty()) {
                return;
            }
            class_8786<WoodcuttingRecipe> recipeHolder = optionalRecipeHolder.get();
            WoodcuttingRecipe recipe = (WoodcuttingRecipe)recipeHolder.comp_1933();
            int inputCount = this.inputSlot.method_7677().method_7947();
            if (inputCount >= recipe.inputCount()) {
                this.selectedRecipeIndex.method_17404(id);
                this.resultContainer.method_7662(recipeHolder);
                this.resultSlot.method_7673(recipe.assemble(this.createRecipeInput(), (class_7225.class_7874)this.level.method_30349()));
            }
        });
        return true;
    }

    private Optional<WoodcuttingRecipeDisplay> getRecipeHolder(int id) {
        if (this.recipesForInput.hasRecipes() && this.isValidRecipeIndex(id)) {
            WoodcuttingRecipeDisplay.GroupEntry groupEntry = this.recipesForInput.entries().get(id);
            return Optional.of(groupEntry.recipe());
        }
        return Optional.empty();
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipesForInput.size();
    }

    public void method_7609(@NotNull class_1263 inventory) {
        class_1799 itemStack = this.inputSlot.method_7677();
        if (!itemStack.method_31574(this.inputStack.method_7909())) {
            this.inputStack = itemStack.method_7972();
            this.updateInput(itemStack);
        }
    }

    private void updateInput(class_1799 stack) {
        this.selectedRecipeIndex.method_17404(-1);
        this.resultSlot.method_7673(class_1799.field_8037);
        if (!stack.method_7960()) {
            class_1937 class_19372 = this.level;
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                this.recipesForInput = ((WoodcutterRecipeGetter)serverWorld.method_64577()).nemosWoodcutter$getWoodcutterRecipes().filter(stack);
            } else {
                class_19372 = this.level;
                if (class_19372 instanceof class_638) {
                    class_638 clientWorld = (class_638)class_19372;
                    this.recipesForInput = ((ModRecipeManagerGetter)clientWorld).nemosWoodcutter$getModRecipeManager().getWoodcutterRecipes().filter(stack);
                }
            }
        } else {
            this.recipesForInput = WoodcuttingRecipeDisplay.Grouping.empty();
        }
    }

    private void setupResultSlot(int selectedId) {
        Optional<Object> optionalRecipe;
        if (this.recipesForInput.hasRecipes() && this.isValidRecipeIndex(selectedId)) {
            WoodcuttingRecipeDisplay.GroupEntry groupEntry = this.recipesForInput.entries().get(selectedId);
            optionalRecipe = groupEntry.recipe().recipe();
        } else {
            optionalRecipe = Optional.empty();
        }
        optionalRecipe.ifPresentOrElse(recipeEntry -> {
            WoodcuttingRecipe woodcuttingRecipe = (WoodcuttingRecipe)recipeEntry.comp_1933();
            int inputCount = this.inputSlot.method_7677().method_7947();
            if (inputCount < woodcuttingRecipe.inputCount()) {
                this.resultSlot.method_7673(class_1799.field_8037);
                this.resultContainer.method_7662(null);
            } else {
                this.resultContainer.method_7662(recipeEntry);
                this.resultSlot.method_7673(woodcuttingRecipe.assemble(this.createRecipeInput(), (class_7225.class_7874)this.level.method_30349()));
            }
        }, () -> {
            this.resultSlot.method_7673(class_1799.field_8037);
            this.resultContainer.method_7662(null);
        });
        this.method_7623();
    }

    private class_9696 createRecipeInput() {
        return new class_9696(this.input.method_5438(0));
    }

    @NotNull
    public class_3917<?> method_17358() {
        return ModMenuTypes.WOODCUTTER_SCREEN_HANDLER.get();
    }

    public void registerUpdateListener(Runnable slotUpdateListener) {
        this.slotUpdateListener = slotUpdateListener;
    }

    public boolean method_7613(@NotNull class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.resultContainer && super.method_7613(stack, slot);
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = (class_1735)this.field_7761.get(slot);
        if (slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            class_1792 item = itemStack2.method_7909();
            itemStack = itemStack2.method_7972();
            if (slot == 1) {
                item.method_54465(itemStack2, player);
                if (!this.method_7616(itemStack2, 2, 38, true)) {
                    return class_1799.field_8037;
                }
                slot2.method_7670(itemStack2, itemStack);
            } else if (slot == 0 ? !this.method_7616(itemStack2, 2, 38, false) : (this.isWoodcuttingRecipe(itemStack2) ? !this.method_7616(itemStack2, 0, 1, false) : (slot >= 2 && slot < 29 ? !this.method_7616(itemStack2, 29, 38, false) : slot >= 29 && slot < 38 && !this.method_7616(itemStack2, 2, 29, false)))) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot2.method_53512(class_1799.field_8037);
            }
            slot2.method_7668();
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot2.method_7667(player, itemStack2);
            if (slot == 1) {
                player.method_7328(itemStack2, false);
            }
            this.method_7623();
        }
        return itemStack;
    }

    private boolean isWoodcuttingRecipe(class_1799 itemStack2) {
        boolean isClientSide = this.level.method_8608();
        return !isClientSide && ((WoodcutterRecipeGetter)this.level.method_8433()).nemosWoodcutter$getWoodcutterRecipes().contains(itemStack2) || isClientSide && ((ModRecipeManagerGetter)this.level).nemosWoodcutter$getModRecipeManager().getWoodcutterRecipes().contains(itemStack2);
    }

    public void method_7595(@NotNull class_1657 player) {
        super.method_7595(player);
        this.resultContainer.method_5441(1);
        this.access.method_17393((world, pos) -> this.method_7607(player, this.input));
    }
}

