/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.woodcutter.client.gui.screen;

import com.devnemo.nemos.woodcutter.client.gui.screen.WoodcutterMenu;
import com.devnemo.nemos.woodcutter.recipe.display.WoodcuttingRecipeDisplay;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;

public class WoodcutterScreen
extends class_465<WoodcutterMenu> {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"nemos_woodcutter", (String)"textures/gui/container/woodcutter.png");
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60655((String)"nemos_woodcutter", (String)"container/woodcutter/scroller");
    private static final class_2960 SCROLLER_DISABLED_SPRITE = class_2960.method_60655((String)"nemos_woodcutter", (String)"container/woodcutter/scroller_disabled");
    private static final class_2960 RECIPE_SELECTED_SPRITE = class_2960.method_60655((String)"nemos_woodcutter", (String)"container/woodcutter/recipe_selected");
    private static final class_2960 RECIPE_HIGHLIGHTED_SPRITE = class_2960.method_60655((String)"nemos_woodcutter", (String)"container/woodcutter/recipe_highlighted");
    private static final class_2960 RECIPE_DISABLED_SPRITE = class_2960.method_60655((String)"nemos_woodcutter", (String)"container/woodcutter/recipe_disabled");
    private static final class_2960 RECIPE_SPRITE = class_2960.method_60655((String)"nemos_woodcutter", (String)"container/woodcutter/recipe");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RELATIVE_RECIPE_X = 52;
    private static final int RELATIVE_RECIPE_Y = 14;
    private float scrollOffset;
    private boolean scrolling;
    private int firstVisibleRecipeIndex;
    private boolean areRecipesDisplayed;

    public WoodcutterScreen(WoodcutterMenu menu, class_1661 inventory, class_2561 title) {
        super((class_1703)menu, inventory, title);
        menu.registerUpdateListener(this::containerChanged);
        --this.field_25268;
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 guiGraphics, float delta, int mouseX, int mouseY) {
        int xPos = this.field_2776;
        int yPos = this.field_2800;
        guiGraphics.method_25290(class_10799.field_56883, BACKGROUND_TEXTURE, xPos, yPos, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        int yPosAfterScrolling = (int)(41.0f * this.scrollOffset);
        class_2960 scrollerTexture = this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.method_52706(class_10799.field_56883, scrollerTexture, xPos + 119, yPos + 15 + yPosAfterScrolling, 12, 15);
        int recipeXPos = this.field_2776 + 52;
        int recipeYPos = this.field_2800 + 14;
        int scrollOffset = this.firstVisibleRecipeIndex + 12;
        this.renderButtons(guiGraphics, mouseX, mouseY, recipeXPos, recipeYPos, scrollOffset);
        this.renderRecipes(guiGraphics, recipeXPos, recipeYPos, scrollOffset);
    }

    protected void method_2380(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        if (this.areRecipesDisplayed) {
            int firstRecipeX = this.field_2776 + 52;
            int firstRecipeY = this.field_2800 + 14;
            int scrollOffset = this.firstVisibleRecipeIndex + 12;
            WoodcuttingRecipeDisplay.Grouping visibleRecipes = ((WoodcutterMenu)this.field_2797).getVisibleRecipes();
            for (int recipeIndex = this.firstVisibleRecipeIndex; recipeIndex < scrollOffset && recipeIndex < visibleRecipes.size(); ++recipeIndex) {
                int visibleRecipeIndex = recipeIndex - this.firstVisibleRecipeIndex;
                int mouseDistanceToRecipeX = firstRecipeX + visibleRecipeIndex % 4 * 16;
                int mouseDistanceToRecipeY = firstRecipeY + visibleRecipeIndex / 4 * 18 + 2;
                if (mouseX < mouseDistanceToRecipeX || mouseX >= mouseDistanceToRecipeX + 16 || mouseY < mouseDistanceToRecipeY || mouseY >= mouseDistanceToRecipeY + 18) continue;
                class_10352 contextmap = class_10363.method_65008((class_1937)this.field_22787.field_1687);
                class_10302 slotDisplay = visibleRecipes.entries().get(recipeIndex).recipe().optionDisplay();
                guiGraphics.method_51446(this.field_22793, slotDisplay.method_64742(contextmap), mouseX, mouseY);
            }
        }
    }

    private void renderButtons(class_332 guiGraphics, int mouseX, int mouseY, int xPosForRecipe, int yPosForRecipe, int lastVisibleElementIndex) {
        for (int i = this.firstVisibleRecipeIndex; i < lastVisibleElementIndex && i < ((WoodcutterMenu)this.field_2797).getAvailableRecipeCount(); ++i) {
            int expectedInput;
            int yPosWithoutScrollOffset = i - this.firstVisibleRecipeIndex;
            int k = xPosForRecipe + yPosWithoutScrollOffset % 4 * 16;
            int l = yPosWithoutScrollOffset / 4;
            int m = yPosForRecipe + l * 18 + 2;
            int actualInput = ((WoodcutterMenu)this.field_2797).inputSlot.method_7677().method_7947();
            if (actualInput < (expectedInput = ((WoodcutterMenu)this.field_2797).getVisibleRecipes().entries().get(i).inputCount())) {
                guiGraphics.method_52706(class_10799.field_56883, RECIPE_DISABLED_SPRITE, k, m - 1, 16, 18);
                continue;
            }
            this.renderRecipeBackgroundForCraftableRecipe(guiGraphics, i, mouseX, mouseY, k, m);
        }
    }

    private void renderRecipeBackgroundForCraftableRecipe(class_332 guiGraphics, int i, int mouseX, int mouseY, int k, int m) {
        class_2960 texture = i == ((WoodcutterMenu)this.field_2797).getSelectedRecipeIndex() ? RECIPE_SELECTED_SPRITE : (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18 ? RECIPE_HIGHLIGHTED_SPRITE : RECIPE_SPRITE);
        guiGraphics.method_52706(class_10799.field_56883, texture, k, m - 1, 16, 18);
    }

    private void renderRecipes(class_332 guiGraphics, int x, int y, int startIndex) {
        WoodcuttingRecipeDisplay.Grouping availableRecipes = ((WoodcutterMenu)this.field_2797).getVisibleRecipes();
        class_10352 contextMap = class_10363.method_65008((class_1937)this.field_22787.field_1687);
        for (int i = this.firstVisibleRecipeIndex; i < startIndex && i < availableRecipes.size(); ++i) {
            int yPosWithoutScrollOffset = i - this.firstVisibleRecipeIndex;
            int k = x + yPosWithoutScrollOffset % 4 * 16;
            int l = yPosWithoutScrollOffset / 4;
            int m = y + l * 18 + 2;
            class_10302 slotDisplay = availableRecipes.entries().get(i).recipe().optionDisplay();
            guiGraphics.method_51427(slotDisplay.method_64742(contextMap), k, m);
        }
    }

    public boolean method_25402(@NotNull class_11909 mouseButtonEvent, boolean bl) {
        this.scrolling = false;
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        if (this.areRecipesDisplayed) {
            int firstRecipeX = this.field_2776 + 52;
            int firstRecipeY = this.field_2800 + 14;
            int maxVisibleRecipeCount = 12;
            int lastVisibleRecipeIndex = this.firstVisibleRecipeIndex + maxVisibleRecipeCount;
            for (int recipeIndex = this.firstVisibleRecipeIndex; recipeIndex < lastVisibleRecipeIndex; ++recipeIndex) {
                int visibleRecipeIndex = recipeIndex - this.firstVisibleRecipeIndex;
                double mouseDistanceToRecipeX = mouseX - (double)(firstRecipeX + visibleRecipeIndex % 4 * 16);
                double mouseDistanceToRecipeY = mouseY - (double)(firstRecipeY + visibleRecipeIndex / 4 * 18);
                if (!(mouseDistanceToRecipeX >= 0.0) || !(mouseDistanceToRecipeY >= 0.0) || !(mouseDistanceToRecipeX < 16.0) || !(mouseDistanceToRecipeY < 18.0) || !((WoodcutterMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, recipeIndex)) continue;
                this.handleRecipeSelect(recipeIndex);
                return true;
            }
            firstRecipeX = this.field_2776 + 119;
            firstRecipeY = this.field_2800 + 9;
            if (mouseX >= (double)firstRecipeX && mouseX < (double)(firstRecipeX + maxVisibleRecipeCount) && mouseY >= (double)firstRecipeY && mouseY < (double)(firstRecipeY + 54)) {
                this.scrolling = true;
            }
        }
        return super.method_25402(mouseButtonEvent, bl);
    }

    private void handleRecipeSelect(int recipeIndex) {
        boolean hasEnoughMaterials;
        int recipeInputCount = ((WoodcutterMenu)this.field_2797).getVisibleRecipes().entries().get(recipeIndex).inputCount();
        int inputCount = ((WoodcutterMenu)this.field_2797).inputSlot.method_7677().method_7947();
        boolean bl = hasEnoughMaterials = inputCount >= recipeInputCount;
        if (hasEnoughMaterials) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
            this.field_22787.field_1761.method_2900(((WoodcutterMenu)this.field_2797).field_7763, recipeIndex);
        } else {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)4.0f));
        }
    }

    public boolean method_25403(@NotNull class_11909 mouseButtonEvent, double dragX, double dragY) {
        double mouseY = mouseButtonEvent.comp_4799();
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.field_2800 + 14;
            int j = i + 54;
            this.scrollOffset = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffset = class_3532.method_15363((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.firstVisibleRecipeIndex = (int)((double)(this.scrollOffset * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(mouseButtonEvent, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)verticalAmount / (float)i;
            this.scrollOffset = class_3532.method_15363((float)(this.scrollOffset - f), (float)0.0f, (float)1.0f);
            this.firstVisibleRecipeIndex = (int)((double)(this.scrollOffset * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.areRecipesDisplayed && ((WoodcutterMenu)this.field_2797).getAvailableRecipeCount() > 12;
    }

    protected int getOffscreenRows() {
        return (((WoodcutterMenu)this.field_2797).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.areRecipesDisplayed = ((WoodcutterMenu)this.field_2797).canCraft();
        if (!this.areRecipesDisplayed) {
            this.scrollOffset = 0.0f;
            this.firstVisibleRecipeIndex = 0;
        }
    }
}

