/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.woodcutter.client.gui.screen;

import com.devnemo.nemos.woodcutter.client.gui.screen.WoodcutterMenu;
import com.devnemo.nemos.woodcutter.recipe.display.WoodcuttingRecipeDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WoodcutterScreen
extends AbstractContainerScreen<WoodcutterMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nemos_woodcutter", (String)"textures/gui/container/woodcutter.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nemos_woodcutter", (String)"container/woodcutter/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nemos_woodcutter", (String)"container/woodcutter/scroller_disabled");
    private static final ResourceLocation RECIPE_SELECTED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nemos_woodcutter", (String)"container/woodcutter/recipe_selected");
    private static final ResourceLocation RECIPE_HIGHLIGHTED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nemos_woodcutter", (String)"container/woodcutter/recipe_highlighted");
    private static final ResourceLocation RECIPE_DISABLED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nemos_woodcutter", (String)"container/woodcutter/recipe_disabled");
    private static final ResourceLocation RECIPE_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nemos_woodcutter", (String)"container/woodcutter/recipe");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RELATIVE_RECIPE_X = 52;
    private static final int RELATIVE_RECIPE_Y = 14;
    private float scrollOffset;
    private boolean scrolling;
    private int firstVisibleRecipeIndex;
    private boolean areRecipesDisplayed;

    public WoodcutterScreen(WoodcutterMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        menu.registerUpdateListener(this::containerChanged);
        --this.titleLabelY;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        int xPos = this.leftPos;
        int yPos = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, xPos, yPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int yPosAfterScrolling = (int)(41.0f * this.scrollOffset);
        ResourceLocation scrollerTexture = this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, scrollerTexture, xPos + 119, yPos + 15 + yPosAfterScrolling, 12, 15);
        int recipeXPos = this.leftPos + 52;
        int recipeYPos = this.topPos + 14;
        int scrollOffset = this.firstVisibleRecipeIndex + 12;
        this.renderButtons(guiGraphics, mouseX, mouseY, recipeXPos, recipeYPos, scrollOffset);
        this.renderRecipes(guiGraphics, recipeXPos, recipeYPos, scrollOffset);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.areRecipesDisplayed) {
            int firstRecipeX = this.leftPos + 52;
            int firstRecipeY = this.topPos + 14;
            int scrollOffset = this.firstVisibleRecipeIndex + 12;
            WoodcuttingRecipeDisplay.Grouping visibleRecipes = ((WoodcutterMenu)this.menu).getVisibleRecipes();
            for (int recipeIndex = this.firstVisibleRecipeIndex; recipeIndex < scrollOffset && recipeIndex < visibleRecipes.size(); ++recipeIndex) {
                int visibleRecipeIndex = recipeIndex - this.firstVisibleRecipeIndex;
                int mouseDistanceToRecipeX = firstRecipeX + visibleRecipeIndex % 4 * 16;
                int mouseDistanceToRecipeY = firstRecipeY + visibleRecipeIndex / 4 * 18 + 2;
                if (mouseX < mouseDistanceToRecipeX || mouseX >= mouseDistanceToRecipeX + 16 || mouseY < mouseDistanceToRecipeY || mouseY >= mouseDistanceToRecipeY + 18) continue;
                ContextMap contextmap = SlotDisplayContext.fromLevel((Level)this.minecraft.level);
                SlotDisplay slotDisplay = visibleRecipes.entries().get(recipeIndex).recipe().optionDisplay();
                guiGraphics.setTooltipForNextFrame(this.font, slotDisplay.resolveForFirstStack(contextmap), mouseX, mouseY);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int xPosForRecipe, int yPosForRecipe, int lastVisibleElementIndex) {
        for (int i = this.firstVisibleRecipeIndex; i < lastVisibleElementIndex && i < ((WoodcutterMenu)this.menu).getAvailableRecipeCount(); ++i) {
            int expectedInput;
            int yPosWithoutScrollOffset = i - this.firstVisibleRecipeIndex;
            int k = xPosForRecipe + yPosWithoutScrollOffset % 4 * 16;
            int l = yPosWithoutScrollOffset / 4;
            int m = yPosForRecipe + l * 18 + 2;
            int actualInput = ((WoodcutterMenu)this.menu).inputSlot.getItem().getCount();
            if (actualInput < (expectedInput = ((WoodcutterMenu)this.menu).getVisibleRecipes().entries().get(i).inputCount())) {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, RECIPE_DISABLED_SPRITE, k, m - 1, 16, 18);
                continue;
            }
            this.renderRecipeBackgroundForCraftableRecipe(guiGraphics, i, mouseX, mouseY, k, m);
        }
    }

    private void renderRecipeBackgroundForCraftableRecipe(GuiGraphics guiGraphics, int i, int mouseX, int mouseY, int k, int m) {
        ResourceLocation texture = i == ((WoodcutterMenu)this.menu).getSelectedRecipeIndex() ? RECIPE_SELECTED_SPRITE : (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18 ? RECIPE_HIGHLIGHTED_SPRITE : RECIPE_SPRITE);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, texture, k, m - 1, 16, 18);
    }

    private void renderRecipes(GuiGraphics guiGraphics, int x, int y, int startIndex) {
        WoodcuttingRecipeDisplay.Grouping availableRecipes = ((WoodcutterMenu)this.menu).getVisibleRecipes();
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)this.minecraft.level);
        for (int i = this.firstVisibleRecipeIndex; i < startIndex && i < availableRecipes.size(); ++i) {
            int yPosWithoutScrollOffset = i - this.firstVisibleRecipeIndex;
            int k = x + yPosWithoutScrollOffset % 4 * 16;
            int l = yPosWithoutScrollOffset / 4;
            int m = y + l * 18 + 2;
            SlotDisplay slotDisplay = availableRecipes.entries().get(i).recipe().optionDisplay();
            guiGraphics.renderItem(slotDisplay.resolveForFirstStack(contextMap), k, m);
        }
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent mouseButtonEvent, boolean bl) {
        this.scrolling = false;
        double mouseX = mouseButtonEvent.x();
        double mouseY = mouseButtonEvent.y();
        if (this.areRecipesDisplayed) {
            int firstRecipeX = this.leftPos + 52;
            int firstRecipeY = this.topPos + 14;
            int maxVisibleRecipeCount = 12;
            int lastVisibleRecipeIndex = this.firstVisibleRecipeIndex + maxVisibleRecipeCount;
            for (int recipeIndex = this.firstVisibleRecipeIndex; recipeIndex < lastVisibleRecipeIndex; ++recipeIndex) {
                int visibleRecipeIndex = recipeIndex - this.firstVisibleRecipeIndex;
                double mouseDistanceToRecipeX = mouseX - (double)(firstRecipeX + visibleRecipeIndex % 4 * 16);
                double mouseDistanceToRecipeY = mouseY - (double)(firstRecipeY + visibleRecipeIndex / 4 * 18);
                if (!(mouseDistanceToRecipeX >= 0.0) || !(mouseDistanceToRecipeY >= 0.0) || !(mouseDistanceToRecipeX < 16.0) || !(mouseDistanceToRecipeY < 18.0) || !((WoodcutterMenu)this.menu).clickMenuButton((Player)this.minecraft.player, recipeIndex)) continue;
                this.handleRecipeSelect(recipeIndex);
                return true;
            }
            firstRecipeX = this.leftPos + 119;
            firstRecipeY = this.topPos + 9;
            if (mouseX >= (double)firstRecipeX && mouseX < (double)(firstRecipeX + maxVisibleRecipeCount) && mouseY >= (double)firstRecipeY && mouseY < (double)(firstRecipeY + 54)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    private void handleRecipeSelect(int recipeIndex) {
        boolean hasEnoughMaterials;
        int recipeInputCount = ((WoodcutterMenu)this.menu).getVisibleRecipes().entries().get(recipeIndex).inputCount();
        int inputCount = ((WoodcutterMenu)this.menu).inputSlot.getItem().getCount();
        boolean bl = hasEnoughMaterials = inputCount >= recipeInputCount;
        if (hasEnoughMaterials) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
            this.minecraft.gameMode.handleInventoryButtonClick(((WoodcutterMenu)this.menu).containerId, recipeIndex);
        } else {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)4.0f));
        }
    }

    public boolean mouseDragged(@NotNull MouseButtonEvent mouseButtonEvent, double dragX, double dragY) {
        double mouseY = mouseButtonEvent.y();
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 14;
            int j = i + 54;
            this.scrollOffset = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffset = Mth.clamp((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.firstVisibleRecipeIndex = (int)((double)(this.scrollOffset * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(mouseButtonEvent, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)verticalAmount / (float)i;
            this.scrollOffset = Mth.clamp((float)(this.scrollOffset - f), (float)0.0f, (float)1.0f);
            this.firstVisibleRecipeIndex = (int)((double)(this.scrollOffset * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.areRecipesDisplayed && ((WoodcutterMenu)this.menu).getAvailableRecipeCount() > 12;
    }

    protected int getOffscreenRows() {
        return (((WoodcutterMenu)this.menu).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.areRecipesDisplayed = ((WoodcutterMenu)this.menu).canCraft();
        if (!this.areRecipesDisplayed) {
            this.scrollOffset = 0.0f;
            this.firstVisibleRecipeIndex = 0;
        }
    }
}

