/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.woodcutter.datagen;

import com.devnemo.nemos.woodcutter.recipe.WoodcuttingRecipeJsonBuilder;
import com.devnemo.nemos.woodcutter.world.level.block.WoodcutterBlocks;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class WoodcutterRecipeProvider
extends RecipeProvider {
    protected WoodcutterRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, List<String> modDependencies, TagKey<Item> inputTag, String criteria, Item result) {
        String inputName = inputTag.location().getPath();
        Ingredient ingredient = this.tag(inputTag);
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, (ItemLike)result).modDependencies(modDependencies).unlockedBy(criteria, this.has(inputTag));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, TagKey<Item> inputTag, String criteria, Item result) {
        String inputName = inputTag.location().getPath();
        Ingredient ingredient = this.tag(inputTag);
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, (ItemLike)result).unlockedBy(criteria, this.has(inputTag));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, TagKey<Item> inputTag, String criteria, int inputCount, Item result) {
        String inputName = inputTag.location().getPath();
        Ingredient ingredient = this.tag(inputTag);
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, inputCount, (ItemLike)result).unlockedBy(criteria, this.has(inputTag));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, List<String> modDependencies, TagKey<Item> inputTag, String criteria, Item result, int outputCount) {
        String inputName = inputTag.location().getPath();
        Ingredient ingredient = this.tag(inputTag);
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, (ItemLike)result, outputCount).modDependencies(modDependencies).unlockedBy(criteria, this.has(inputTag));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, TagKey<Item> inputTag, String criteria, Item result, int outputCount) {
        String inputName = inputTag.location().getPath();
        Ingredient ingredient = this.tag(inputTag);
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, (ItemLike)result, outputCount).unlockedBy(criteria, this.has(inputTag));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, List<String> modDependencies, ItemLike input, Item result) {
        Ingredient ingredient = Ingredient.of((ItemLike)input);
        String inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath();
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, (ItemLike)result).modDependencies(modDependencies).unlockedBy(WoodcutterRecipeProvider.getHasName((ItemLike)input), this.has(input));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, ItemLike input, Item result) {
        Ingredient ingredient = Ingredient.of((ItemLike)input);
        String inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath();
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, (ItemLike)result).unlockedBy(WoodcutterRecipeProvider.getHasName((ItemLike)input), this.has(input));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, List<String> modDependencies, ItemLike input, int inputCount, Item result) {
        Ingredient ingredient = Ingredient.of((ItemLike)input);
        String inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath();
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, inputCount, (ItemLike)result).modDependencies(modDependencies).unlockedBy(WoodcutterRecipeProvider.getHasName((ItemLike)input), this.has(input));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, ItemLike input, int inputCount, Item result) {
        Ingredient ingredient = Ingredient.of((ItemLike)input);
        String inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath();
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, inputCount, (ItemLike)result).unlockedBy(WoodcutterRecipeProvider.getHasName((ItemLike)input), this.has(input));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, List<String> modDependencies, ItemLike input, Item result, int outputCount) {
        Ingredient ingredient = Ingredient.of((ItemLike)input);
        String inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath();
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, (ItemLike)result, outputCount).modDependencies(modDependencies).unlockedBy(WoodcutterRecipeProvider.getHasName((ItemLike)input), this.has(input));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, ItemLike input, Item result, int outputCount) {
        Ingredient ingredient = Ingredient.of((ItemLike)input);
        String inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath();
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, (ItemLike)result, outputCount).unlockedBy(WoodcutterRecipeProvider.getHasName((ItemLike)input), this.has(input));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, List<String> modDependencies, ItemLike input, int inputCount, Item result, int outputCount) {
        Ingredient ingredient = Ingredient.of((ItemLike)input);
        String inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath();
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, inputCount, (ItemLike)result, outputCount).modDependencies(modDependencies).unlockedBy(WoodcutterRecipeProvider.getHasName((ItemLike)input), this.has(input));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected void createWoodcuttingRecipe(RecipeCategory recipeCategory, ItemLike input, int inputCount, Item result, int outputCount) {
        Ingredient ingredient = Ingredient.of((ItemLike)input);
        String inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath();
        RecipeBuilder recipeBuilder = WoodcuttingRecipeJsonBuilder.createWoodcutting(recipeCategory, ingredient, inputCount, (ItemLike)result, outputCount).unlockedBy(WoodcutterRecipeProvider.getHasName((ItemLike)input), this.has(input));
        this.saveWoodcutting(recipeBuilder, result, inputName);
    }

    protected static String convertBetween(ItemLike to, String from) {
        return WoodcutterRecipeProvider.getItemName((ItemLike)to) + "_from_" + from;
    }

    private void saveWoodcutting(RecipeBuilder recipeBuilder, Item result, String inputName) {
        recipeBuilder.save(this.output, WoodcutterRecipeProvider.convertBetween((ItemLike)result, inputName) + "_woodcutting");
    }

    protected void createWoodCutterRecipe() {
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)WoodcutterBlocks.WOODCUTTER.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('#'), ItemTags.LOGS).pattern(" I ").pattern("###").unlockedBy("has_logs", this.has(ItemTags.LOGS)).save(this.output);
    }
}

