/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.woodcutter.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleWithCountRecipe
implements Recipe<SingleRecipeInput> {
    private final String group;
    private final List<String> modDependencies;
    private final Ingredient ingredient;
    private final int inputCount;
    private final ItemStack result;
    @Nullable
    private PlacementInfo ingredientPlacement;

    public SingleWithCountRecipe(String group, List<String> modDependencies, Ingredient ingredient, int inputCount, ItemStack result) {
        this.group = group;
        this.modDependencies = modDependencies;
        this.ingredient = ingredient;
        this.inputCount = inputCount;
        this.result = result;
    }

    @NotNull
    public abstract RecipeSerializer<? extends SingleWithCountRecipe> getSerializer();

    @NotNull
    public abstract RecipeType<? extends SingleWithCountRecipe> getType();

    public boolean matches(SingleRecipeInput singleStackRecipeInput, @NotNull Level world) {
        return this.ingredient.test(singleStackRecipeInput.item());
    }

    @NotNull
    public String group() {
        return this.group;
    }

    public List<String> modDependencies() {
        return this.modDependencies;
    }

    public Ingredient ingredient() {
        return this.ingredient;
    }

    public int inputCount() {
        return this.inputCount;
    }

    protected ItemStack result() {
        return this.result;
    }

    @NotNull
    public PlacementInfo placementInfo() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = PlacementInfo.create((Ingredient)this.ingredient);
        }
        return this.ingredientPlacement;
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput singleRecipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider wrapperLookup) {
        return this.result.copy();
    }

    public static class Serializer<T extends SingleWithCountRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SingleWithCountRecipe::group), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("modDependencies", List.of()).forGetter(SingleWithCountRecipe::modDependencies), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(SingleWithCountRecipe::ingredient), (App)Codec.INT.fieldOf("inputCount").forGetter(SingleWithCountRecipe::inputCount), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(SingleWithCountRecipe::result)).apply((Applicative)instance, recipeFactory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> packetCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SingleWithCountRecipe::group, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), SingleWithCountRecipe::modDependencies, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SingleWithCountRecipe::ingredient, (StreamCodec)ByteBufCodecs.INT, SingleWithCountRecipe::inputCount, (StreamCodec)ItemStack.STREAM_CODEC, SingleWithCountRecipe::result, recipeFactory::create);

        public Serializer(RecipeFactory<T> recipeFactory) {
        }

        @NotNull
        public MapCodec<T> codec() {
            return this.codec;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.packetCodec;
        }
    }

    @FunctionalInterface
    public static interface RecipeFactory<T extends SingleWithCountRecipe> {
        public T create(String var1, List<String> var2, Ingredient var3, int var4, ItemStack var5);
    }
}

