/*
 * Decompiled with CFR 0.152.
 */
package tfcregistryapi.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.IdHolder;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import tfcregistryapi.TFCRegistryAPI;
import tfcregistryapi.util.Helpers;

public class MetalRegistryHelper {
    public static final RegistryMetal DEFAULT_METAL = Metal.WROUGHT_IRON;
    public static final IdHolder<Block> FALLBACK_BLOCK = (IdHolder)((Map)TFCBlocks.METALS.get(DEFAULT_METAL)).get(Metal.BlockType.BLOCK);
    public static final IdHolder<Item> FALLBACK_ITEM = (IdHolder)((Map)TFCItems.METAL_ITEMS.get(DEFAULT_METAL)).get(Metal.ItemType.INGOT);
    public static final Map<Class<? extends RegistryMetal>, MetalEntry> METAL_TYPES = new HashMap<Class<? extends RegistryMetal>, MetalEntry>();

    public static Block getFallbackBlock() {
        return (Block)FALLBACK_BLOCK.get();
    }

    public static Item getFallbackItem() {
        return (Item)FALLBACK_ITEM.get();
    }

    public static void discoverRegistryEnums() {
        ModList.get().getMods().forEach(mod -> {
            Path modFile = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath();
            try (JarFile jar = new JarFile(modFile.toFile());){
                jar.stream().filter(e -> e.getName().endsWith(".class")).forEach(entry -> {
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    try {
                        String lowerName = className.toLowerCase(Locale.ROOT);
                        if (lowerName.contains("mixin") || lowerName.contains("client")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (clazz.isEnum() && RegistryMetal.class.isAssignableFrom(clazz)) {
                            RegistryMetal[] constants = (RegistryMetal[])clazz.getEnumConstants();
                            METAL_TYPES.put(clazz, new MetalEntry(Arrays.asList(constants), mod.getModId()));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
        for (Map.Entry<Class<? extends RegistryMetal>, MetalEntry> entry : METAL_TYPES.entrySet()) {
            Class<? extends RegistryMetal> clazz = entry.getKey();
            List<RegistryMetal> metals = entry.getValue().getMetals();
            String modId = entry.getValue().getModId();
            String metalNames = metals.stream().map(StringRepresentable::getSerializedName).sorted().collect(Collectors.joining(", "));
            TFCRegistryAPI.LOGGER.debug("Found metal types in {} (mod={}): {}", new Object[]{clazz.getName(), modId, metalNames});
        }
    }

    public static void registerTypes(Class<? extends RegistryMetal> clazz, List<RegistryMetal> metals, String modId) {
        METAL_TYPES.put(clazz, new MetalEntry(metals, modId));
        String metalNames = metals.stream().map(StringRepresentable::getSerializedName).sorted().collect(Collectors.joining(", "));
        TFCRegistryAPI.LOGGER.debug("Custom metal types registered in {} (mod={}): {}", new Object[]{clazz.getName(), modId, metalNames});
    }

    public static Block getMetalBlock(RegistryMetal metal, TagKey<Block> tag) {
        return MetalRegistryHelper.getMetalBlock(metal, tag, null);
    }

    public static Block getMetalBlock(RegistryMetal metal, TagKey<Block> tag, String filter) {
        return MetalRegistryHelper.getMetalBlock(metal, tag, filter, false, false, MetalRegistryHelper.getFallbackBlock());
    }

    public static Block getMetalBlock(RegistryMetal metal, TagKey<Block> tag, String filter, boolean whitelist) {
        return MetalRegistryHelper.getMetalBlock(metal, tag, filter, whitelist, false, MetalRegistryHelper.getFallbackBlock());
    }

    public static Block getMetalBlock(RegistryMetal metal, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return MetalRegistryHelper.getMetalBlock(metal, tag, filter, whitelist, includeMinecraft, MetalRegistryHelper.getFallbackBlock());
    }

    public static Block getMetalBlock(RegistryMetal metal, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft, Block fallback) {
        String metalName = metal.getSerializedName();
        Block bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Block block : BuiltInRegistries.BLOCK) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), metalName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = block;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static Item getMetalItem(RegistryMetal metal, TagKey<Item> tag) {
        return MetalRegistryHelper.getMetalItem(metal, tag, null);
    }

    public static Item getMetalItem(RegistryMetal metal, TagKey<Item> tag, String filter) {
        return MetalRegistryHelper.getMetalItem(metal, tag, filter, false, false, MetalRegistryHelper.getFallbackItem());
    }

    public static Item getMetalItem(RegistryMetal metal, TagKey<Item> tag, String filter, boolean whitelist) {
        return MetalRegistryHelper.getMetalItem(metal, tag, filter, whitelist, false, MetalRegistryHelper.getFallbackItem());
    }

    public static Item getMetalItem(RegistryMetal metal, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return MetalRegistryHelper.getMetalItem(metal, tag, filter, whitelist, includeMinecraft, MetalRegistryHelper.getFallbackItem());
    }

    public static Item getMetalItem(RegistryMetal metal, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft, Item fallback) {
        String metalName = metal.getSerializedName();
        Item bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Item item : BuiltInRegistries.ITEM) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), metalName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = item;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static List<RegistryMetal> getAllMetalValues() {
        return METAL_TYPES.values().stream().flatMap(entry -> entry.getMetals().stream()).toList();
    }

    public static List<RegistryMetal> getMetalsByMod(String modId) {
        return METAL_TYPES.values().stream().filter(entry -> entry.getModId().equals(modId)).flatMap(entry -> entry.getMetals().stream()).toList();
    }

    public static String getModForMetal(RegistryMetal metal) {
        return METAL_TYPES.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(metal)).map(e -> ((MetalEntry)e.getValue()).getModId()).findFirst().orElse("unknown");
    }

    public static Map<Class<? extends RegistryMetal>, MetalEntry> getMetalEnumMap() {
        return Collections.unmodifiableMap(METAL_TYPES);
    }

    public static boolean matchesAnyMetal(String input) {
        return MetalRegistryHelper.getAllMetalValues().stream().anyMatch(metal -> metal.getSerializedName().equalsIgnoreCase(input));
    }

    public static RegistryMetal getMetalValue(String input) {
        return MetalRegistryHelper.getMetalValueOrDefault(input, null);
    }

    public static RegistryMetal getMetalValueOrDefault(String input) {
        return MetalRegistryHelper.getMetalValueOrDefault(input, DEFAULT_METAL);
    }

    public static RegistryMetal getMetalValueOrDefault(String input, RegistryMetal defaultValue) {
        return MetalRegistryHelper.getAllMetalValues().stream().filter(metal -> metal.getSerializedName().equalsIgnoreCase(input)).findFirst().orElse(defaultValue);
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return Helpers.resourceLocation(id.getNamespace(), "block/" + id.getPath());
    }

    public static class MetalEntry {
        private final List<RegistryMetal> metals;
        private final String modId;

        public MetalEntry(List<RegistryMetal> metals, String modId) {
            this.metals = metals;
            this.modId = modId;
        }

        public List<RegistryMetal> getMetals() {
            return this.metals;
        }

        public String getModId() {
            return this.modId;
        }
    }
}

