/*
 * Decompiled with CFR 0.152.
 */
package tfcregistryapi.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.registry.IdHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import tfcregistryapi.TFCRegistryAPI;
import tfcregistryapi.util.Helpers;
import tfcregistryapi.util.RockRegistryHelper;
import tfcregistryapi.util.registry.RegistryOre;

public class OreRegistryHelper {
    public static final RegistryOre DEFAULT_ORE = (RegistryOre)Ore.AMETHYST;
    public static final IdHolder<Block> FALLBACK_BLOCK = (IdHolder)((Map)TFCBlocks.ORES.get(RockRegistryHelper.DEFAULT_ROCK)).get(DEFAULT_ORE);
    public static final IdHolder<Item> FALLBACK_ITEM = (IdHolder)TFCItems.ORES.get(DEFAULT_ORE);
    public static final Map<Class<? extends RegistryOre>, OreEntry> ORE_TYPES = new HashMap<Class<? extends RegistryOre>, OreEntry>();

    public static Block getFallbackBlock() {
        return (Block)FALLBACK_BLOCK.get();
    }

    public static Item getFallbackItem() {
        return (Item)FALLBACK_ITEM.get();
    }

    public static void discoverRegistryEnums() {
        ModList.get().getMods().forEach(mod -> {
            Path modFile = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath();
            try (JarFile jar = new JarFile(modFile.toFile());){
                jar.stream().filter(e -> e.getName().endsWith(".class")).forEach(entry -> {
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    try {
                        String lowerName = className.toLowerCase(Locale.ROOT);
                        if (lowerName.contains("mixin") || lowerName.contains("client")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (clazz.isEnum() && RegistryOre.class.isAssignableFrom(clazz)) {
                            RegistryOre[] constants = (RegistryOre[])clazz.getEnumConstants();
                            ORE_TYPES.put(clazz, new OreEntry(Arrays.asList(constants), mod.getModId()));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
        for (Map.Entry<Class<? extends RegistryOre>, OreEntry> entry : ORE_TYPES.entrySet()) {
            Class<? extends RegistryOre> clazz = entry.getKey();
            List<RegistryOre> ores = entry.getValue().getOres();
            String modId = entry.getValue().getModId();
            String oreNames = ores.stream().map(RegistryOre::getSerializedName).sorted().collect(Collectors.joining(", "));
            TFCRegistryAPI.LOGGER.debug("Found ore types in {} (mod={}): {}", new Object[]{clazz.getName(), modId, oreNames});
        }
    }

    public static void registerTypes(Class<? extends RegistryOre> clazz, List<RegistryOre> ores, String modId) {
        ORE_TYPES.put(clazz, new OreEntry(ores, modId));
        String oreNames = ores.stream().map(RegistryOre::getSerializedName).sorted().collect(Collectors.joining(", "));
        TFCRegistryAPI.LOGGER.debug("Custom ore types registered in {} (mod={}): {}", new Object[]{clazz.getName(), modId, oreNames});
    }

    public static Block getOreBlock(RegistryOre ore, TagKey<Block> tag) {
        return OreRegistryHelper.getOreBlock(ore, tag, null);
    }

    public static Block getOreBlock(RegistryOre ore, TagKey<Block> tag, String filter) {
        return OreRegistryHelper.getOreBlock(ore, tag, filter, false, false, OreRegistryHelper.getFallbackBlock());
    }

    public static Block getOreBlock(RegistryOre ore, TagKey<Block> tag, String filter, boolean whitelist) {
        return OreRegistryHelper.getOreBlock(ore, tag, filter, whitelist, false, OreRegistryHelper.getFallbackBlock());
    }

    public static Block getOreBlock(RegistryOre ore, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return OreRegistryHelper.getOreBlock(ore, tag, filter, whitelist, includeMinecraft, OreRegistryHelper.getFallbackBlock());
    }

    public static Block getOreBlock(RegistryOre ore, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft, Block fallback) {
        String oreName = ore.getSerializedName();
        Block bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Block block : BuiltInRegistries.BLOCK) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), oreName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = block;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static Item getOreItem(RegistryOre ore, TagKey<Item> tag) {
        return OreRegistryHelper.getOreItem(ore, tag, null);
    }

    public static Item getOreItem(RegistryOre ore, TagKey<Item> tag, String filter) {
        return OreRegistryHelper.getOreItem(ore, tag, filter, false, false, OreRegistryHelper.getFallbackItem());
    }

    public static Item getOreItem(RegistryOre ore, TagKey<Item> tag, String filter, boolean whitelist) {
        return OreRegistryHelper.getOreItem(ore, tag, filter, whitelist, false, OreRegistryHelper.getFallbackItem());
    }

    public static Item getOreItem(RegistryOre ore, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return OreRegistryHelper.getOreItem(ore, tag, filter, whitelist, includeMinecraft, OreRegistryHelper.getFallbackItem());
    }

    public static Item getOreItem(RegistryOre ore, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft, Item fallback) {
        String oreName = ore.getSerializedName();
        Item bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Item item : BuiltInRegistries.ITEM) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), oreName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = item;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static List<RegistryOre> getAllOreValues() {
        return ORE_TYPES.values().stream().flatMap(entry -> entry.getOres().stream()).toList();
    }

    public static List<RegistryOre> getOresByMod(String modId) {
        return ORE_TYPES.values().stream().filter(entry -> entry.getModId().equals(modId)).flatMap(entry -> entry.getOres().stream()).toList();
    }

    public static String getModForOre(RegistryOre ore) {
        return ORE_TYPES.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(ore)).map(e -> ((OreEntry)e.getValue()).getModId()).findFirst().orElse("unknown");
    }

    public static Map<Class<? extends RegistryOre>, OreEntry> getOreEnumMap() {
        return Collections.unmodifiableMap(ORE_TYPES);
    }

    public static boolean matchesAnyOre(String input) {
        return OreRegistryHelper.getAllOreValues().stream().anyMatch(ore -> ore.getSerializedName().equalsIgnoreCase(input));
    }

    public static RegistryOre getOreValue(String input) {
        return OreRegistryHelper.getOreValueOrDefault(input, null);
    }

    public static RegistryOre getOreValueOrDefault(String input) {
        return OreRegistryHelper.getOreValueOrDefault(input, DEFAULT_ORE);
    }

    public static RegistryOre getOreValueOrDefault(String input, RegistryOre defaultValue) {
        return OreRegistryHelper.getAllOreValues().stream().filter(ore -> ore.getSerializedName().equalsIgnoreCase(input)).findFirst().orElse(defaultValue);
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return Helpers.resourceLocation(id.getNamespace(), "block/" + id.getPath());
    }

    public static class OreEntry {
        private final List<RegistryOre> ores;
        private final String modId;

        public OreEntry(List<RegistryOre> ores, String modId) {
            this.ores = ores;
            this.modId = modId;
        }

        public List<RegistryOre> getOres() {
            return this.ores;
        }

        public String getModId() {
            return this.modId;
        }
    }
}

