/*
 * Decompiled with CFR 0.152.
 */
package tfcregistryapi.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.registry.IdHolder;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import tfcregistryapi.TFCRegistryAPI;
import tfcregistryapi.util.Helpers;

public class RockRegistryHelper {
    public static final RegistryRock DEFAULT_ROCK = Rock.ANDESITE;
    public static final IdHolder<Block> FALLBACK_BLOCK = (IdHolder)((Map)TFCBlocks.ROCK_BLOCKS.get(DEFAULT_ROCK)).get(Rock.BlockType.COBBLE);
    public static final IdHolder<Item> FALLBACK_ITEM = (IdHolder)TFCItems.BRICKS.get(DEFAULT_ROCK);
    public static final Map<Class<? extends RegistryRock>, RockEntry> ROCK_TYPES = new HashMap<Class<? extends RegistryRock>, RockEntry>();

    public static Block getFallbackBlock() {
        return (Block)FALLBACK_BLOCK.get();
    }

    public static Item getFallbackItem() {
        return (Item)FALLBACK_ITEM.get();
    }

    public static void discoverRegistryEnums() {
        ModList.get().getMods().forEach(mod -> {
            Path modFile = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath();
            try (JarFile jar = new JarFile(modFile.toFile());){
                jar.stream().filter(e -> e.getName().endsWith(".class")).forEach(entry -> {
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    try {
                        String lowerName = className.toLowerCase(Locale.ROOT);
                        if (lowerName.contains("mixin") || lowerName.contains("client")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (clazz.isEnum() && RegistryRock.class.isAssignableFrom(clazz)) {
                            RegistryRock[] constants = (RegistryRock[])clazz.getEnumConstants();
                            ROCK_TYPES.put(clazz, new RockEntry(Arrays.asList(constants), mod.getModId()));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
        for (Map.Entry<Class<? extends RegistryRock>, RockEntry> entry : ROCK_TYPES.entrySet()) {
            Class<? extends RegistryRock> clazz = entry.getKey();
            List<RegistryRock> rocks = entry.getValue().getRocks();
            String modId = entry.getValue().getModId();
            String rockNames = rocks.stream().map(StringRepresentable::getSerializedName).sorted().collect(Collectors.joining(", "));
            TFCRegistryAPI.LOGGER.debug("Found rock types in {} (mod={}): {}", new Object[]{clazz.getName(), modId, rockNames});
        }
    }

    public static void registerTypes(Class<? extends RegistryRock> clazz, List<RegistryRock> rocks, String modId) {
        ROCK_TYPES.put(clazz, new RockEntry(rocks, modId));
        String rockNames = rocks.stream().map(StringRepresentable::getSerializedName).sorted().collect(Collectors.joining(", "));
        TFCRegistryAPI.LOGGER.debug("Custom rock types registered in {} (mod={}): {}", new Object[]{clazz.getName(), modId, rockNames});
    }

    public static Block getRockBlock(RegistryRock rock, TagKey<Block> tag) {
        return RockRegistryHelper.getRockBlock(rock, tag, null);
    }

    public static Block getRockBlock(RegistryRock rock, TagKey<Block> tag, String filter) {
        return RockRegistryHelper.getRockBlock(rock, tag, filter, false, false, RockRegistryHelper.getFallbackBlock());
    }

    public static Block getRockBlock(RegistryRock rock, TagKey<Block> tag, String filter, boolean whitelist) {
        return RockRegistryHelper.getRockBlock(rock, tag, filter, whitelist, false, RockRegistryHelper.getFallbackBlock());
    }

    public static Block getRockBlock(RegistryRock rock, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return RockRegistryHelper.getRockBlock(rock, tag, filter, whitelist, includeMinecraft, RockRegistryHelper.getFallbackBlock());
    }

    public static Block getRockBlock(RegistryRock rock, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft, Block fallback) {
        String rockName = rock.getSerializedName();
        Block bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Block block : BuiltInRegistries.BLOCK) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), rockName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = block;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static Item getRockItem(RegistryRock rock, TagKey<Item> tag) {
        return RockRegistryHelper.getRockItem(rock, tag, null);
    }

    public static Item getRockItem(RegistryRock rock, TagKey<Item> tag, String filter) {
        return RockRegistryHelper.getRockItem(rock, tag, filter, false, false, RockRegistryHelper.getFallbackItem());
    }

    public static Item getRockItem(RegistryRock rock, TagKey<Item> tag, String filter, boolean whitelist) {
        return RockRegistryHelper.getRockItem(rock, tag, filter, whitelist, false, RockRegistryHelper.getFallbackItem());
    }

    public static Item getRockItem(RegistryRock rock, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return RockRegistryHelper.getRockItem(rock, tag, filter, whitelist, includeMinecraft, RockRegistryHelper.getFallbackItem());
    }

    public static Item getRockItem(RegistryRock rock, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft, Item fallback) {
        String rockName = rock.getSerializedName();
        Item bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Item item : BuiltInRegistries.ITEM) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), rockName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = item;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static List<RegistryRock> getAllRockValues() {
        return ROCK_TYPES.values().stream().flatMap(entry -> entry.getRocks().stream()).toList();
    }

    public static List<RegistryRock> getRocksByMod(String modId) {
        return ROCK_TYPES.values().stream().filter(entry -> entry.getModId().equals(modId)).flatMap(entry -> entry.getRocks().stream()).toList();
    }

    public static String getModForRock(RegistryRock rock) {
        return ROCK_TYPES.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(rock)).map(e -> ((RockEntry)e.getValue()).getModId()).findFirst().orElse("unknown");
    }

    public static Map<Class<? extends RegistryRock>, RockEntry> getRockEnumMap() {
        return Collections.unmodifiableMap(ROCK_TYPES);
    }

    public static boolean matchesAnyRock(String input) {
        return RockRegistryHelper.getAllRockValues().stream().anyMatch(rock -> rock.getSerializedName().equalsIgnoreCase(input));
    }

    public static RegistryRock getRockValue(String input) {
        return RockRegistryHelper.getRockValueOrDefault(input, null);
    }

    public static RegistryRock getRockValueOrDefault(String input) {
        return RockRegistryHelper.getRockValueOrDefault(input, DEFAULT_ROCK);
    }

    public static RegistryRock getRockValueOrDefault(String input, RegistryRock defaultValue) {
        return RockRegistryHelper.getAllRockValues().stream().filter(rock -> rock.getSerializedName().equalsIgnoreCase(input)).findFirst().orElse(defaultValue);
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return Helpers.resourceLocation(id.getNamespace(), "block/" + id.getPath());
    }

    public static class RockEntry {
        private final List<RegistryRock> rocks;
        private final String modId;

        public RockEntry(List<RegistryRock> rocks, String modId) {
            this.rocks = rocks;
            this.modId = modId;
        }

        public List<RegistryRock> getRocks() {
            return this.rocks;
        }

        public String getModId() {
            return this.modId;
        }
    }
}

