/*
 * Decompiled with CFR 0.152.
 */
package tfcregistryapi.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.util.registry.IdHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import tfcregistryapi.TFCRegistryAPI;
import tfcregistryapi.util.Helpers;
import tfcregistryapi.util.registry.RegistrySand;

public class SandRegistryHelper {
    public static final RegistrySand DEFAULT_SAND = (RegistrySand)SandBlockType.YELLOW;
    public static final IdHolder<Block> FALLBACK_BLOCK = (IdHolder)TFCBlocks.SAND.get(DEFAULT_SAND);
    public static final Map<Class<? extends RegistrySand>, SandEntry> SAND_TYPES = new HashMap<Class<? extends RegistrySand>, SandEntry>();

    public static Block getFallbackBlock() {
        return (Block)FALLBACK_BLOCK.get();
    }

    public static Item getFallbackItem() {
        return ((Block)FALLBACK_BLOCK.get()).asItem();
    }

    public static void discoverRegistryEnums() {
        ModList.get().getMods().forEach(mod -> {
            Path modFile = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath();
            try (JarFile jar = new JarFile(modFile.toFile());){
                jar.stream().filter(e -> e.getName().endsWith(".class")).forEach(entry -> {
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    try {
                        String lowerName = className.toLowerCase(Locale.ROOT);
                        if (lowerName.contains("mixin") || lowerName.contains("client")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (clazz.isEnum() && RegistrySand.class.isAssignableFrom(clazz)) {
                            RegistrySand[] constants = (RegistrySand[])clazz.getEnumConstants();
                            SAND_TYPES.put(clazz, new SandEntry(Arrays.asList(constants), mod.getModId()));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
        for (Map.Entry<Class<? extends RegistrySand>, SandEntry> entry : SAND_TYPES.entrySet()) {
            Class<? extends RegistrySand> clazz = entry.getKey();
            List<RegistrySand> sands = entry.getValue().getSands();
            String modId = entry.getValue().getModId();
            String sandNames = sands.stream().map(RegistrySand::getSerializedName).sorted().collect(Collectors.joining(", "));
            TFCRegistryAPI.LOGGER.debug("Found sand types in {} (mod={}): {}", new Object[]{clazz.getName(), modId, sandNames});
        }
    }

    public static void registerTypes(Class<? extends RegistrySand> clazz, List<RegistrySand> sands, String modId) {
        SAND_TYPES.put(clazz, new SandEntry(sands, modId));
        String sandNames = sands.stream().map(RegistrySand::getSerializedName).sorted().collect(Collectors.joining(", "));
        TFCRegistryAPI.LOGGER.debug("Custom sand types registered in {} (mod={}): {}", new Object[]{clazz.getName(), modId, sandNames});
    }

    public static Block getSandBlock(RegistrySand sand, TagKey<Block> tag) {
        return SandRegistryHelper.getSandBlock(sand, tag, null);
    }

    public static Block getSandBlock(RegistrySand sand, TagKey<Block> tag, String filter) {
        return SandRegistryHelper.getSandBlock(sand, tag, filter, false, false, SandRegistryHelper.getFallbackBlock());
    }

    public static Block getSandBlock(RegistrySand sand, TagKey<Block> tag, String filter, boolean whitelist) {
        return SandRegistryHelper.getSandBlock(sand, tag, filter, whitelist, false, SandRegistryHelper.getFallbackBlock());
    }

    public static Block getSandBlock(RegistrySand sand, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return SandRegistryHelper.getSandBlock(sand, tag, filter, whitelist, includeMinecraft, SandRegistryHelper.getFallbackBlock());
    }

    public static Block getSandBlock(RegistrySand sand, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft, Block fallback) {
        String sandName = sand.getSerializedName();
        Block bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Block block : BuiltInRegistries.BLOCK) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), sandName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = block;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static Item getSandItem(RegistrySand sand, TagKey<Item> tag) {
        return SandRegistryHelper.getSandItem(sand, tag, null);
    }

    public static Item getSandItem(RegistrySand sand, TagKey<Item> tag, String filter) {
        return SandRegistryHelper.getSandItem(sand, tag, filter, false, false, SandRegistryHelper.getFallbackItem());
    }

    public static Item getSandItem(RegistrySand sand, TagKey<Item> tag, String filter, boolean whitelist) {
        return SandRegistryHelper.getSandItem(sand, tag, filter, whitelist, false, SandRegistryHelper.getFallbackItem());
    }

    public static Item getSandItem(RegistrySand sand, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return SandRegistryHelper.getSandItem(sand, tag, filter, whitelist, includeMinecraft, SandRegistryHelper.getFallbackItem());
    }

    public static Item getSandItem(RegistrySand sand, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft, Item fallback) {
        String sandName = sand.getSerializedName();
        Item bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Item item : BuiltInRegistries.ITEM) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), sandName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = item;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static List<RegistrySand> getAllSandValues() {
        return SAND_TYPES.values().stream().flatMap(entry -> entry.getSands().stream()).toList();
    }

    public static List<RegistrySand> getSandsByMod(String modId) {
        return SAND_TYPES.values().stream().filter(entry -> entry.getModId().equals(modId)).flatMap(entry -> entry.getSands().stream()).toList();
    }

    public static String getModForSand(RegistrySand sand) {
        return SAND_TYPES.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(sand)).map(e -> ((SandEntry)e.getValue()).getModId()).findFirst().orElse("unknown");
    }

    public static Map<Class<? extends RegistrySand>, SandEntry> getSandEnumMap() {
        return Collections.unmodifiableMap(SAND_TYPES);
    }

    public static boolean matchesAnySand(String input) {
        return SandRegistryHelper.getAllSandValues().stream().anyMatch(sand -> sand.getSerializedName().equalsIgnoreCase(input));
    }

    public static RegistrySand getSandValue(String input) {
        return SandRegistryHelper.getSandValueOrDefault(input, null);
    }

    public static RegistrySand getSandValueOrDefault(String input) {
        return SandRegistryHelper.getSandValueOrDefault(input, DEFAULT_SAND);
    }

    public static RegistrySand getSandValueOrDefault(String input, RegistrySand defaultValue) {
        return SandRegistryHelper.getAllSandValues().stream().filter(sand -> sand.getSerializedName().equalsIgnoreCase(input)).findFirst().orElse(defaultValue);
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return Helpers.resourceLocation(id.getNamespace(), "block/" + id.getPath());
    }

    public static class SandEntry {
        private final List<RegistrySand> sands;
        private final String modId;

        public SandEntry(List<RegistrySand> sands, String modId) {
            this.sands = sands;
            this.modId = modId;
        }

        public List<RegistrySand> getSands() {
            return this.sands;
        }

        public String getModId() {
            return this.modId;
        }
    }
}

