/*
 * Decompiled with CFR 0.152.
 */
package tfcregistryapi.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import tfcregistryapi.TFCRegistryAPI;
import tfcregistryapi.util.Helpers;
import tfcregistryapi.util.SoilVariantRegistryHelper;
import tfcregistryapi.util.registry.RegistrySoil;

public class SoilRegistryHelper {
    public static final RegistrySoil DEFAULT_SOIL = (RegistrySoil)SoilBlockType.DIRT;
    public static final Map<Class<? extends RegistrySoil>, SoilEntry> SOIL_TYPES = new HashMap<Class<? extends RegistrySoil>, SoilEntry>();

    public static void discoverRegistryEnums() {
        ModList.get().getMods().forEach(mod -> {
            Path modFile = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath();
            try (JarFile jar = new JarFile(modFile.toFile());){
                jar.stream().filter(e -> e.getName().endsWith(".class")).forEach(entry -> {
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    try {
                        String lowerName = className.toLowerCase(Locale.ROOT);
                        if (lowerName.contains("mixin") || lowerName.contains("client")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (clazz.isEnum() && RegistrySoil.class.isAssignableFrom(clazz)) {
                            RegistrySoil[] constants = (RegistrySoil[])clazz.getEnumConstants();
                            SOIL_TYPES.put(clazz, new SoilEntry(Arrays.asList(constants), mod.getModId()));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
        for (Map.Entry<Class<? extends RegistrySoil>, SoilEntry> entry : SOIL_TYPES.entrySet()) {
            Class<? extends RegistrySoil> clazz = entry.getKey();
            List<RegistrySoil> soils = entry.getValue().getSoils();
            String modId = entry.getValue().getModId();
            String soilNames = soils.stream().map(RegistrySoil::getSerializedName).sorted().collect(Collectors.joining(", "));
            TFCRegistryAPI.LOGGER.debug("Found soil types in {} (mod={}): {}", new Object[]{clazz.getName(), modId, soilNames});
        }
    }

    public static void registerTypes(Class<? extends RegistrySoil> clazz, List<RegistrySoil> soils, String modId) {
        SOIL_TYPES.put(clazz, new SoilEntry(soils, modId));
        String soilNames = soils.stream().map(RegistrySoil::getSerializedName).sorted().collect(Collectors.joining(", "));
        TFCRegistryAPI.LOGGER.debug("Custom soil types registered in {} (mod={}): {}", new Object[]{clazz.getName(), modId, soilNames});
    }

    public static Block getSoilBlock(RegistrySoil soil, TagKey<Block> tag) {
        return SoilRegistryHelper.getSoilBlock(soil, tag, null);
    }

    public static Block getSoilBlock(RegistrySoil soil, TagKey<Block> tag, String filter) {
        return SoilRegistryHelper.getSoilBlock(soil, tag, filter, false, false, SoilVariantRegistryHelper.getFallbackBlock());
    }

    public static Block getSoilBlock(RegistrySoil soil, TagKey<Block> tag, String filter, boolean whitelist) {
        return SoilRegistryHelper.getSoilBlock(soil, tag, filter, whitelist, false, SoilVariantRegistryHelper.getFallbackBlock());
    }

    public static Block getSoilBlock(RegistrySoil soil, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return SoilRegistryHelper.getSoilBlock(soil, tag, filter, whitelist, includeMinecraft, SoilVariantRegistryHelper.getFallbackBlock());
    }

    public static Block getSoilBlock(RegistrySoil soil, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft, Block fallback) {
        String soilName = soil.getSerializedName();
        Block bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Block block : BuiltInRegistries.BLOCK) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), soilName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = block;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static Item getSoilItem(RegistrySoil soil, TagKey<Item> tag) {
        return SoilRegistryHelper.getSoilItem(soil, tag, null);
    }

    public static Item getSoilItem(RegistrySoil soil, TagKey<Item> tag, String filter) {
        return SoilRegistryHelper.getSoilItem(soil, tag, filter, false, false, SoilVariantRegistryHelper.getFallbackItem());
    }

    public static Item getSoilItem(RegistrySoil soil, TagKey<Item> tag, String filter, boolean whitelist) {
        return SoilRegistryHelper.getSoilItem(soil, tag, filter, whitelist, false, SoilVariantRegistryHelper.getFallbackItem());
    }

    public static Item getSoilItem(RegistrySoil soil, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return SoilRegistryHelper.getSoilItem(soil, tag, filter, whitelist, includeMinecraft, SoilVariantRegistryHelper.getFallbackItem());
    }

    public static Item getSoilItem(RegistrySoil soil, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft, Item fallback) {
        String soilName = soil.getSerializedName();
        Item bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Item item : BuiltInRegistries.ITEM) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), soilName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = item;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static List<RegistrySoil> getAllSoilValues() {
        return SOIL_TYPES.values().stream().flatMap(entry -> entry.getSoils().stream()).toList();
    }

    public static List<RegistrySoil> getSoilsByMod(String modId) {
        return SOIL_TYPES.values().stream().filter(entry -> entry.getModId().equals(modId)).flatMap(entry -> entry.getSoils().stream()).toList();
    }

    public static String getModForSoil(RegistrySoil soil) {
        return SOIL_TYPES.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(soil)).map(e -> ((SoilEntry)e.getValue()).getModId()).findFirst().orElse("unknown");
    }

    public static Map<Class<? extends RegistrySoil>, SoilEntry> getSoilEnumMap() {
        return Collections.unmodifiableMap(SOIL_TYPES);
    }

    public static boolean matchesAnySoil(String input) {
        return SoilRegistryHelper.getAllSoilValues().stream().anyMatch(soil -> soil.getSerializedName().equalsIgnoreCase(input));
    }

    public static RegistrySoil getSoilValue(String input) {
        return SoilRegistryHelper.getSoilValueOrDefault(input, null);
    }

    public static RegistrySoil getSoilValueOrDefault(String input) {
        return SoilRegistryHelper.getSoilValueOrDefault(input, DEFAULT_SOIL);
    }

    public static RegistrySoil getSoilValueOrDefault(String input, RegistrySoil defaultValue) {
        return SoilRegistryHelper.getAllSoilValues().stream().filter(soil -> soil.getSerializedName().equalsIgnoreCase(input)).findFirst().orElse(defaultValue);
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return Helpers.resourceLocation(id.getNamespace(), "block/" + id.getPath());
    }

    public static class SoilEntry {
        private final List<RegistrySoil> soils;
        private final String modId;

        public SoilEntry(List<RegistrySoil> soils, String modId) {
            this.soils = soils;
            this.modId = modId;
        }

        public List<RegistrySoil> getSoils() {
            return this.soils;
        }

        public String getModId() {
            return this.modId;
        }
    }
}

