/*
 * Decompiled with CFR 0.152.
 */
package tfcregistryapi.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.registry.IdHolder;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import tfcregistryapi.TFCRegistryAPI;
import tfcregistryapi.util.Helpers;
import tfcregistryapi.util.SoilRegistryHelper;

public class SoilVariantRegistryHelper {
    public static final RegistrySoilVariant DEFAULT_SOIL_VARIANT = SoilBlockType.Variant.ENTISOL;
    public static final IdHolder<Block> FALLBACK_BLOCK = (IdHolder)((Map)TFCBlocks.SOIL.get(SoilRegistryHelper.DEFAULT_SOIL)).get(DEFAULT_SOIL_VARIANT);
    public static final IdHolder<Item> FALLBACK_ITEM = TFCItems.ENTISOL_MUD_BRICK;
    public static final Map<Class<? extends RegistrySoilVariant>, SoilVariantEntry> SOIL_VARIANT_TYPES = new HashMap<Class<? extends RegistrySoilVariant>, SoilVariantEntry>();

    public static Block getFallbackBlock() {
        return (Block)FALLBACK_BLOCK.get();
    }

    public static Item getFallbackItem() {
        return ((Block)FALLBACK_BLOCK.get()).asItem();
    }

    public static void discoverRegistryEnums() {
        ModList.get().getMods().forEach(mod -> {
            Path modFile = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath();
            try (JarFile jar = new JarFile(modFile.toFile());){
                jar.stream().filter(e -> e.getName().endsWith(".class")).forEach(entry -> {
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    try {
                        String lowerName = className.toLowerCase(Locale.ROOT);
                        if (lowerName.contains("mixin") || lowerName.contains("client")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (clazz.isEnum() && RegistrySoilVariant.class.isAssignableFrom(clazz)) {
                            RegistrySoilVariant[] constants = (RegistrySoilVariant[])clazz.getEnumConstants();
                            SOIL_VARIANT_TYPES.put(clazz, new SoilVariantEntry(Arrays.asList(constants), mod.getModId()));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
        for (Map.Entry<Class<? extends RegistrySoilVariant>, SoilVariantEntry> entry : SOIL_VARIANT_TYPES.entrySet()) {
            Class<? extends RegistrySoilVariant> clazz = entry.getKey();
            List<RegistrySoilVariant> soilVariants = entry.getValue().getSoilVariants();
            String modId = entry.getValue().getModId();
            String soilvariantNames = soilVariants.stream().map(type -> Helpers.getSerializedName(type.toString())).sorted().collect(Collectors.joining(", "));
            TFCRegistryAPI.LOGGER.debug("Found soil variant types in {} (mod={}): {}", new Object[]{clazz.getName(), modId, soilvariantNames});
        }
    }

    public static void registerTypes(Class<? extends RegistrySoilVariant> clazz, List<RegistrySoilVariant> soilVariants, String modId) {
        SOIL_VARIANT_TYPES.put(clazz, new SoilVariantEntry(soilVariants, modId));
        String soilvariantNames = soilVariants.stream().map(type -> Helpers.getSerializedName(type.toString())).sorted().collect(Collectors.joining(", "));
        TFCRegistryAPI.LOGGER.debug("Custom soil variant types registered in {} (mod={}): {}", new Object[]{clazz.getName(), modId, soilvariantNames});
    }

    public static Block getSoilVariantBlock(RegistrySoilVariant soilVariant, TagKey<Block> tag) {
        return SoilVariantRegistryHelper.getSoilVariantBlock(soilVariant, tag, null);
    }

    public static Block getSoilVariantBlock(RegistrySoilVariant soilVariant, TagKey<Block> tag, String filter) {
        return SoilVariantRegistryHelper.getSoilVariantBlock(soilVariant, tag, filter, false, false, SoilVariantRegistryHelper.getFallbackBlock());
    }

    public static Block getSoilVariantBlock(RegistrySoilVariant soilVariant, TagKey<Block> tag, String filter, boolean whitelist) {
        return SoilVariantRegistryHelper.getSoilVariantBlock(soilVariant, tag, filter, whitelist, false, SoilVariantRegistryHelper.getFallbackBlock());
    }

    public static Block getSoilVariantBlock(RegistrySoilVariant soilVariant, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return SoilVariantRegistryHelper.getSoilVariantBlock(soilVariant, tag, filter, whitelist, includeMinecraft, SoilVariantRegistryHelper.getFallbackBlock());
    }

    public static Block getSoilVariantBlock(RegistrySoilVariant soilVariant, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft, Block fallback) {
        String soilvariantName = Helpers.getSerializedName(soilVariant.toString());
        Block bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Block block : BuiltInRegistries.BLOCK) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), soilvariantName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = block;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static Item getSoilVariantItem(RegistrySoilVariant soilVariant, TagKey<Item> tag) {
        return SoilVariantRegistryHelper.getSoilVariantItem(soilVariant, tag, null);
    }

    public static Item getSoilVariantItem(RegistrySoilVariant soilVariant, TagKey<Item> tag, String filter) {
        return SoilVariantRegistryHelper.getSoilVariantItem(soilVariant, tag, filter, false, false, SoilVariantRegistryHelper.getFallbackItem());
    }

    public static Item getSoilVariantItem(RegistrySoilVariant soilVariant, TagKey<Item> tag, String filter, boolean whitelist) {
        return SoilVariantRegistryHelper.getSoilVariantItem(soilVariant, tag, filter, whitelist, false, SoilVariantRegistryHelper.getFallbackItem());
    }

    public static Item getSoilVariantItem(RegistrySoilVariant soilVariant, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return SoilVariantRegistryHelper.getSoilVariantItem(soilVariant, tag, filter, whitelist, includeMinecraft, SoilVariantRegistryHelper.getFallbackItem());
    }

    public static Item getSoilVariantItem(RegistrySoilVariant soilVariant, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft, Item fallback) {
        String soilvariantName = Helpers.getSerializedName(soilVariant.toString());
        Item bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Item item : BuiltInRegistries.ITEM) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), soilvariantName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = item;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static List<RegistrySoilVariant> getAllSoilVariantValues() {
        return SOIL_VARIANT_TYPES.values().stream().flatMap(entry -> entry.getSoilVariants().stream()).toList();
    }

    public static List<RegistrySoilVariant> getSoilVariantsByMod(String modId) {
        return SOIL_VARIANT_TYPES.values().stream().filter(entry -> entry.getModId().equals(modId)).flatMap(entry -> entry.getSoilVariants().stream()).toList();
    }

    public static String getModForSoilVariant(RegistrySoilVariant soilVariant) {
        return SOIL_VARIANT_TYPES.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(soilVariant)).map(e -> ((SoilVariantEntry)e.getValue()).getModId()).findFirst().orElse("unknown");
    }

    public static Map<Class<? extends RegistrySoilVariant>, SoilVariantEntry> getSoilVariantEnumMap() {
        return Collections.unmodifiableMap(SOIL_VARIANT_TYPES);
    }

    public static boolean matchesAnySoilVariant(String input) {
        return SoilVariantRegistryHelper.getAllSoilVariantValues().stream().anyMatch(soilVariant -> Helpers.getSerializedName(soilVariant.toString()).equalsIgnoreCase(input));
    }

    public static RegistrySoilVariant getSoilVariantValue(String input) {
        return SoilVariantRegistryHelper.getSoilVariantValueOrDefault(input, null);
    }

    public static RegistrySoilVariant getSoilVariantValueOrDefault(String input) {
        return SoilVariantRegistryHelper.getSoilVariantValueOrDefault(input, DEFAULT_SOIL_VARIANT);
    }

    public static RegistrySoilVariant getSoilVariantValueOrDefault(String input, RegistrySoilVariant defaultValue) {
        return SoilVariantRegistryHelper.getAllSoilVariantValues().stream().filter(soilVariant -> Helpers.getSerializedName(soilVariant.toString()).equalsIgnoreCase(input)).findFirst().orElse(defaultValue);
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return Helpers.resourceLocation(id.getNamespace(), "block/" + id.getPath());
    }

    public static class SoilVariantEntry {
        private final List<RegistrySoilVariant> soilVariants;
        private final String modId;

        public SoilVariantEntry(List<RegistrySoilVariant> soilVariants, String modId) {
            this.soilVariants = soilVariants;
            this.modId = modId;
        }

        public List<RegistrySoilVariant> getSoilVariants() {
            return this.soilVariants;
        }

        public String getModId() {
            return this.modId;
        }
    }
}

