/*
 * Decompiled with CFR 0.152.
 */
package tfcregistryapi.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.registry.IdHolder;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import tfcregistryapi.TFCRegistryAPI;
import tfcregistryapi.util.Helpers;

public class WoodRegistryHelper {
    public static final RegistryWood DEFAULT_WOOD = Wood.OAK;
    public static final IdHolder<Block> FALLBACK_BLOCK = (IdHolder)((Map)TFCBlocks.WOODS.get(DEFAULT_WOOD)).get(Wood.BlockType.LOG);
    public static final IdHolder<Item> FALLBACK_ITEM = (IdHolder)TFCItems.LUMBER.get(DEFAULT_WOOD);
    public static final Map<Class<? extends RegistryWood>, WoodEntry> WOOD_TYPES = new HashMap<Class<? extends RegistryWood>, WoodEntry>();

    public static Block getFallbackBlock() {
        return (Block)FALLBACK_BLOCK.get();
    }

    public static Item getFallbackItem() {
        return ((Block)FALLBACK_BLOCK.get()).asItem();
    }

    public static void discoverRegistryEnums() {
        ModList.get().getMods().forEach(mod -> {
            Path modFile = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath();
            try (JarFile jar = new JarFile(modFile.toFile());){
                jar.stream().filter(e -> e.getName().endsWith(".class")).forEach(entry -> {
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    try {
                        String lowerName = className.toLowerCase(Locale.ROOT);
                        if (lowerName.contains("mixin") || lowerName.contains("client")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (clazz.isEnum() && RegistryWood.class.isAssignableFrom(clazz)) {
                            RegistryWood[] constants = (RegistryWood[])clazz.getEnumConstants();
                            WOOD_TYPES.put(clazz, new WoodEntry(Arrays.asList(constants), mod.getModId()));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
        for (Map.Entry<Class<? extends RegistryWood>, WoodEntry> entry : WOOD_TYPES.entrySet()) {
            Class<? extends RegistryWood> clazz = entry.getKey();
            List<RegistryWood> woods = entry.getValue().getWoods();
            String modId = entry.getValue().getModId();
            String woodNames = woods.stream().map(StringRepresentable::getSerializedName).sorted().collect(Collectors.joining(", "));
            TFCRegistryAPI.LOGGER.debug("Found wood types in {} (mod={}): {}", new Object[]{clazz.getName(), modId, woodNames});
        }
    }

    public static void registerTypes(Class<? extends RegistryWood> clazz, List<RegistryWood> woods, String modId) {
        WOOD_TYPES.put(clazz, new WoodEntry(woods, modId));
        String woodNames = woods.stream().map(StringRepresentable::getSerializedName).sorted().collect(Collectors.joining(", "));
        TFCRegistryAPI.LOGGER.debug("Custom wood types registered in {} (mod={}): {}", new Object[]{clazz.getName(), modId, woodNames});
    }

    public static Block getWoodBlock(RegistryWood wood, TagKey<Block> tag) {
        return WoodRegistryHelper.getWoodBlock(wood, tag, null);
    }

    public static Block getWoodBlock(RegistryWood wood, TagKey<Block> tag, String filter) {
        return WoodRegistryHelper.getWoodBlock(wood, tag, filter, false, false, WoodRegistryHelper.getFallbackBlock());
    }

    public static Block getWoodBlock(RegistryWood wood, TagKey<Block> tag, String filter, boolean whitelist) {
        return WoodRegistryHelper.getWoodBlock(wood, tag, filter, whitelist, false, WoodRegistryHelper.getFallbackBlock());
    }

    public static Block getWoodBlock(RegistryWood wood, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return WoodRegistryHelper.getWoodBlock(wood, tag, filter, whitelist, includeMinecraft, WoodRegistryHelper.getFallbackBlock());
    }

    public static Block getWoodBlock(RegistryWood wood, TagKey<Block> tag, String filter, boolean whitelist, boolean includeMinecraft, Block fallback) {
        String woodName = wood.getSerializedName();
        Block bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Block block : BuiltInRegistries.BLOCK) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), woodName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = block;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static Item getWoodItem(RegistryWood wood, TagKey<Item> tag) {
        return WoodRegistryHelper.getWoodItem(wood, tag, null);
    }

    public static Item getWoodItem(RegistryWood wood, TagKey<Item> tag, String filter) {
        return WoodRegistryHelper.getWoodItem(wood, tag, filter, false, false, WoodRegistryHelper.getFallbackItem());
    }

    public static Item getWoodItem(RegistryWood wood, TagKey<Item> tag, String filter, boolean whitelist) {
        return WoodRegistryHelper.getWoodItem(wood, tag, filter, whitelist, false, WoodRegistryHelper.getFallbackItem());
    }

    public static Item getWoodItem(RegistryWood wood, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft) {
        return WoodRegistryHelper.getWoodItem(wood, tag, filter, whitelist, includeMinecraft, WoodRegistryHelper.getFallbackItem());
    }

    public static Item getWoodItem(RegistryWood wood, TagKey<Item> tag, String filter, boolean whitelist, boolean includeMinecraft, Item fallback) {
        String woodName = wood.getSerializedName();
        Item bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Item item : BuiltInRegistries.ITEM) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!includeMinecraft && "minecraft".equals(id.getNamespace()) || !Helpers.containsWholeWord(path = id.getPath(), woodName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = Helpers.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = item;
        }
        return bestMatch != null ? bestMatch : fallback;
    }

    public static List<RegistryWood> getAllWoodValues() {
        return WOOD_TYPES.values().stream().flatMap(entry -> entry.getWoods().stream()).toList();
    }

    public static List<RegistryWood> getWoodsByMod(String modId) {
        return WOOD_TYPES.values().stream().filter(entry -> entry.getModId().equals(modId)).flatMap(entry -> entry.getWoods().stream()).toList();
    }

    public static String getModForWood(RegistryWood wood) {
        return WOOD_TYPES.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(wood)).map(e -> ((WoodEntry)e.getValue()).getModId()).findFirst().orElse("unknown");
    }

    public static Map<Class<? extends RegistryWood>, WoodEntry> getWoodEnumMap() {
        return Collections.unmodifiableMap(WOOD_TYPES);
    }

    public static boolean matchesAnyWood(String input) {
        return WoodRegistryHelper.getAllWoodValues().stream().anyMatch(wood -> wood.getSerializedName().equalsIgnoreCase(input));
    }

    public static RegistryWood getWoodValue(String input) {
        return WoodRegistryHelper.getWoodValueOrDefault(input, null);
    }

    public static RegistryWood getWoodValueOrDefault(String input) {
        return WoodRegistryHelper.getWoodValueOrDefault(input, DEFAULT_WOOD);
    }

    public static RegistryWood getWoodValueOrDefault(String input, RegistryWood defaultValue) {
        return WoodRegistryHelper.getAllWoodValues().stream().filter(wood -> wood.getSerializedName().equalsIgnoreCase(input)).findFirst().orElse(defaultValue);
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return Helpers.resourceLocation(id.getNamespace(), "block/" + id.getPath());
    }

    public static class WoodEntry {
        private final List<RegistryWood> woods;
        private final String modId;

        public WoodEntry(List<RegistryWood> woods, String modId) {
            this.woods = woods;
            this.modId = modId;
        }

        public List<RegistryWood> getWoods() {
            return this.woods;
        }

        public String getModId() {
            return this.modId;
        }
    }
}

