/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ApiKeyManager {
    private static final Logger LOGGER = Logger.getLogger(ApiKeyManager.class.getName());
    private final List<ApiKey> apiKeys = new ArrayList<ApiKey>();
    private final OkHttpClient httpClient = new OkHttpClient();

    public ApiKeyManager(List<String> keys2) {
        for (String key : keys2) {
            if (key == null || key.isEmpty() || key.startsWith("YOUR_")) continue;
            this.apiKeys.add(new ApiKey(key));
        }
        LOGGER.info("Initialized " + this.apiKeys.size() + " API keys.");
    }

    public ApiKey getNextAvailableKey(String provider) {
        ApiKey.Type targetType = ApiKey.Type.fromString(provider);
        ArrayList<ApiKey> validKeys = new ArrayList<ApiKey>();
        for (ApiKey key : this.apiKeys) {
            if (key.getStatus() != ApiKey.Status.VALID || targetType != ApiKey.Type.ALL && key.getType() != targetType) continue;
            validKeys.add(key);
        }
        if (validKeys.isEmpty()) {
            return null;
        }
        validKeys.sort(Comparator.comparingLong(ApiKey::getResponseTime));
        ApiKey bestKey = (ApiKey)validKeys.get(0);
        bestKey.incrementUsageCount();
        return bestKey;
    }

    public void validateKeys(String defaultGeminiModel, String defaultClaudeModel, String defaultOpenAIModel) {
        for (int i = 0; i < this.apiKeys.size(); ++i) {
            ApiKey key = this.apiKeys.get(i);
            int keyIndex = i + 1;
            if (this.validateGeminiKey(key, defaultGeminiModel)) {
                key.setStatus(ApiKey.Status.VALID);
                key.setType(ApiKey.Type.GEMINI);
                LOGGER.info("API Key " + keyIndex + " is a valid Gemini key.");
                continue;
            }
            if (this.validateClaudeKey(key)) {
                key.setStatus(ApiKey.Status.VALID);
                key.setType(ApiKey.Type.CLAUDE);
                LOGGER.info("API Key " + keyIndex + " is a valid Claude key.");
                continue;
            }
            if (this.validateOpenAIKey(key)) {
                key.setStatus(ApiKey.Status.VALID);
                key.setType(ApiKey.Type.OPENAI);
                LOGGER.info("API Key " + keyIndex + " is a valid OpenAI key.");
                continue;
            }
            key.setStatus(ApiKey.Status.INVALID);
            key.setType(ApiKey.Type.UNKNOWN);
            LOGGER.warning("API Key " + keyIndex + " is invalid for all services.");
        }
    }

    private boolean validateGeminiKey(ApiKey apiKey, String model) {
        long startTime = System.currentTimeMillis();
        Request request = new Request.Builder().url("https://generativelanguage.googleapis.com/v1/models/" + model + "?key=" + apiKey.getKey()).get().build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            apiKey.setResponseTime(System.currentTimeMillis() - startTime);
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                apiKey.setResponseTime(Long.MAX_VALUE);
                return false;
            }
        }
    }

    private boolean validateClaudeKey(ApiKey apiKey) {
        long startTime = System.currentTimeMillis();
        Request request = new Request.Builder().url("https://api.anthropic.com/v1/messages").header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            apiKey.setResponseTime(System.currentTimeMillis() - startTime);
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                apiKey.setResponseTime(Long.MAX_VALUE);
                return false;
            }
        }
    }

    private boolean validateOpenAIKey(ApiKey apiKey) {
        long startTime = System.currentTimeMillis();
        Request request = new Request.Builder().url("https://api.openai.com/v1/engines").header("Authorization", "Bearer " + apiKey.getKey()).build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            apiKey.setResponseTime(System.currentTimeMillis() - startTime);
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                apiKey.setResponseTime(Long.MAX_VALUE);
                return false;
            }
        }
    }

    public List<ApiKey> getApiKeys() {
        return this.apiKeys;
    }

    public static class ApiKey {
        private final String key;
        private Status status;
        private Type type;
        private long responseTime;
        private int usageCount;

        public ApiKey(String key) {
            this.key = key;
            this.status = Status.VALID;
            this.type = Type.UNKNOWN;
            this.responseTime = -1L;
            this.usageCount = 0;
        }

        public String getKey() {
            return this.key;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public long getResponseTime() {
            return this.responseTime;
        }

        public void setResponseTime(long responseTime) {
            this.responseTime = responseTime;
        }

        public int getUsageCount() {
            return this.usageCount;
        }

        public void incrementUsageCount() {
            ++this.usageCount;
        }

        public static enum Status {
            VALID,
            INVALID,
            RATE_LIMITED;

        }

        public static enum Type {
            UNKNOWN,
            ALL,
            GEMINI,
            CLAUDE,
            OPENAI;


            public static Type fromString(String provider) {
                switch (provider.toLowerCase()) {
                    case "gemini": {
                        return GEMINI;
                    }
                    case "claude": {
                        return CLAUDE;
                    }
                    case "openai": {
                        return OPENAI;
                    }
                    case "all": {
                        return ALL;
                    }
                }
                return UNKNOWN;
            }
        }
    }
}

