/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.addons;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.addons.Addon;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class AddonManager {
    private final NSRAIPlugin plugin;
    private final List<Addon> addons = new ArrayList<Addon>();

    public AddonManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadAddons() {
        File addonsFolder = new File(this.plugin.getDataFolder(), "addons");
        if (!addonsFolder.exists()) {
            addonsFolder.mkdirs();
        }
        for (File file : addonsFolder.listFiles()) {
            this.loadAddonJar(file);
        }
        File pluginsDir = this.plugin.getDataFolder().getParentFile();
        if (pluginsDir.exists() && pluginsDir.isDirectory()) {
            for (File file : pluginsDir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".jar") || !this.isAddonJarWithoutPluginYml(file)) continue;
                this.loadAddonJar(file);
            }
        }
    }

    public void unloadAddons() {
        for (Addon addon : new ArrayList<Addon>(this.addons)) {
            try {
                addon.onDisable();
                this.addons.remove(addon);
                this.plugin.getLogger().info("Unloaded addon: " + addon.getName());
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to unload addon: " + addon.getName(), e);
            }
        }
    }

    public Addon getAddon(String name) {
        for (Addon addon : this.addons) {
            if (!addon.getName().equalsIgnoreCase(name)) continue;
            return addon;
        }
        return null;
    }

    public void addAddon(Addon addon) {
        if (!this.addons.contains(addon)) {
            this.addons.add(addon);
        }
    }

    public boolean isAddonEnabled(String name) {
        return this.getAddon(name) != null;
    }

    public List<Addon> getAddons() {
        return new ArrayList<Addon>(this.addons);
    }

    private boolean isAddonJarWithoutPluginYml(File jarFile) {
        boolean bl;
        JarFile jar = new JarFile(jarFile);
        try {
            boolean hasAddon = jar.getJarEntry("addon.yml") != null;
            boolean hasPlugin = jar.getJarEntry("plugin.yml") != null;
            bl = hasAddon && !hasPlugin;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Check jar failed: " + jarFile.getName() + " - " + e.getMessage());
                return false;
            }
        }
        jar.close();
        return bl;
    }

    private void loadAddonJar(File file) {
        if (!file.isFile() || !file.getName().endsWith(".jar")) {
            return;
        }
        try {
            URL jarUrl = file.toURI().toURL();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{jarUrl}, this.getClass().getClassLoader());
            JarFile jarFile = new JarFile(file);
            JarEntry entry = jarFile.getJarEntry("addon.yml");
            if (entry == null) {
                entry = jarFile.getJarEntry("plugin.yml");
            }
            if (entry == null) {
                this.plugin.getLogger().warning("Addon JAR " + file.getName() + " does not contain addon.yml or plugin.yml. Skipping.");
                jarFile.close();
                return;
            }
            File tempConfigFile = new File(this.plugin.getDataFolder(), "temp_addon_config_" + file.getName() + ".yml");
            try (InputStream is = jarFile.getInputStream(entry);
                 FileOutputStream fos = new FileOutputStream(tempConfigFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            YamlConfiguration addonConfig = YamlConfiguration.loadConfiguration((File)tempConfigFile);
            tempConfigFile.delete();
            String mainClass = addonConfig.getString("main");
            String addonName = addonConfig.getString("name", file.getName().replace(".jar", ""));
            String addonVersion = addonConfig.getString("version", "1.0");
            if (mainClass == null) {
                this.plugin.getLogger().warning("Addon " + addonName + " does not specify a 'main' class in its addon.yml/plugin.yml. Skipping.");
                jarFile.close();
                return;
            }
            Class<?> clazz = classLoader.loadClass(mainClass);
            if (Addon.class.isAssignableFrom(clazz)) {
                Addon addon = (Addon)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                addon.onEnable(this.plugin);
                this.addAddon(addon);
                this.plugin.getLogger().info("Loaded addon: " + addonName + " v" + addonVersion);
            } else {
                this.plugin.getLogger().warning("Class " + mainClass + " in " + file.getName() + " does not implement the Addon interface. Skipping.");
            }
            jarFile.close();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load addon from " + file.getName(), e);
        }
    }
}

