/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.command;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.addons.Addon;
import com.nsr.ai.plugin.util.ConfirmationEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final NSRAIPlugin plugin;

    public CommandManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args2.length == 0) {
            this.handleHelpCommand(player);
            return true;
        }
        String subCommand = args2[0].toLowerCase();
        String fullMessage = String.join((CharSequence)" ", args2);
        if (this.plugin.getAddonManager() != null) {
            for (Addon addon : this.plugin.getAddonManager().getAddons()) {
                String result = addon.onCommand(player, args2);
                if (result == null) continue;
                player.sendMessage(result);
                return true;
            }
        }
        switch (subCommand) {
            case "admin": {
                this.handleAdminCommand(player, args2);
                break;
            }
            case "cache": {
                this.handleCacheCommand(player, args2);
                break;
            }
            case "memory": {
                this.handleMemoryCommand(player, args2);
                break;
            }
            case "version": 
            case "v": {
                this.handleVersionCommand(player);
                break;
            }
            case "data": {
                if (args2.length > 1 && args2[1].equalsIgnoreCase("all")) {
                    this.handleDataAllCommand(player);
                    break;
                }
                this.handleDataCommand(player, args2);
                break;
            }
            case "add": {
                this.handleAddCommand(player, args2);
                break;
            }
            case "remove": {
                this.handleRemoveCommand(player, args2);
                break;
            }
            case "reload": {
                this.handleReloadCommand(player, args2);
                break;
            }
            case "shop": {
                this.handleShopCommand(player, args2);
                break;
            }
            case "confirm": {
                this.handleConfirmCommand(player, args2);
                break;
            }
            case "disable": {
                this.handleDisableCommand(player);
                break;
            }
            case "help": {
                this.handleHelpCommand(player);
                break;
            }
            default: {
                this.plugin.handleAIConversation(player, fullMessage, this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false), this.plugin.getDefaultApiProvider(), "AI_ONLY");
            }
        }
        return true;
    }

    private void handleVersionCommand(Player player) {
        if (!this.plugin.isVersionCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        String currentVersion = this.plugin.getDescription().getVersion();
        String message = String.valueOf(ChatColor.AQUA) + "NSR-AI Plugin Version: " + String.valueOf(ChatColor.WHITE) + currentVersion;
        if (this.plugin.getUpdateChecker() != null) {
            boolean outdated = this.plugin.getUpdateChecker().isOutdated();
            if (outdated) {
                message = message + String.valueOf(ChatColor.RED) + " (Outdated)";
                player.sendMessage(message);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Latest version available: " + this.plugin.getUpdateChecker().getLatestVersion());
                if (this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Download from:");
                    player.sendMessage(String.valueOf(ChatColor.RED) + "  Modrinth: https://modrinth.com/plugin/nsr-ai");
                    player.sendMessage(String.valueOf(ChatColor.RED) + "  SpigotMC: https://www.spigotmc.org/resources/nsr-ai.127717/");
                    player.sendMessage(String.valueOf(ChatColor.RED) + "  Polymart: https://polymart.org/product/8380/nsr-ai");
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "--- Features of Latest Version (" + this.plugin.getUpdateChecker().getLatestVersion() + ") ---");
            } else {
                message = message + String.valueOf(ChatColor.GREEN) + " (Latest)";
                player.sendMessage(message);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "--- Current Version Features ---");
            }
            if (this.plugin.getUpdateChecker().getLatestFeatures() != null && !this.plugin.getUpdateChecker().getLatestFeatures().isEmpty()) {
                for (String feature : this.plugin.getUpdateChecker().getLatestFeatures()) {
                    player.sendMessage(String.valueOf(ChatColor.GRAY) + "- " + feature);
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "-----------------------");
            }
        } else {
            player.sendMessage(message + String.valueOf(ChatColor.YELLOW) + " (Update checker not initialized)");
        }
    }

    private void handleAdminCommand(Player player, String[] args2) {
        if (!this.plugin.isAdminDisableCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai admin <activation_code>");
            return;
        }
        String activationCode = args2[1];
        if (activationCode.equals(this.plugin.getAdminActivationCode())) {
            boolean isAdmin = this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false);
            if (isAdmin) {
                this.plugin.getAdminModePlayers().remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Admin mode disabled.");
            } else {
                this.plugin.getAdminModePlayers().put(player.getUniqueId(), true);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Admin mode enabled.");
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid activation code.");
        }
    }

    private void handleDataCommand(Player player, String[] args2) {
        if (!this.plugin.isDataCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai data <query>");
            return;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args2, 1, args2.length));
        player.sendMessage(this.plugin.colorize(this.plugin.getUserPrefix().replace("%player_name%", "&e" + player.getName() + "&7") + this.plugin.getUserChatColor() + message));
        this.plugin.handleAIConversation(player, message, this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false), this.plugin.getDefaultApiProvider(), "KNOWLEDGE_SEARCH");
    }

    private void handleDataAllCommand(Player player) {
        if (!this.plugin.isDataCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (!this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage(this.plugin.getPermissionDeniedMessage());
            return;
        }
        Map<String, String> allKnowledge = this.plugin.getKnowledgeManager().getAllKnowledge(true);
        if (allKnowledge.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "The knowledge base is empty.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "--- All Knowledge Base Entries ---");
        for (Map.Entry<String, String> entry : allKnowledge.entrySet()) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Heading: " + String.valueOf(ChatColor.WHITE) + entry.getKey());
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Content: " + String.valueOf(ChatColor.WHITE) + entry.getValue());
            player.sendMessage("");
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "----------------------------------");
    }

    private void handleAddCommand(Player player, String[] args2) {
        if (!this.plugin.isAddConfirmCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (!this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage(this.plugin.getPermissionDeniedMessage());
            return;
        }
        String fullCommand = String.join((CharSequence)" ", args2);
        int firstCommaIndex = fullCommand.indexOf(44);
        if (firstCommaIndex == -1 || firstCommaIndex == fullCommand.length() - 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai add <keyword>, <message_content>");
            return;
        }
        String keyword = fullCommand.substring(fullCommand.indexOf("add ") + 4, firstCommaIndex).trim();
        String messageContent = fullCommand.substring(firstCommaIndex + 1).trim();
        if (keyword.isEmpty() || messageContent.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai add <keyword>, <message_content>");
            return;
        }
        if (this.plugin.isAddConfirmCommandEnabled()) {
            this.plugin.processAndAddKnowledgeEntry(player, keyword, messageContent);
        } else {
            String aiGeneratedHeading = this.plugin.generateAIHeading(messageContent, "", keyword);
            this.plugin.addKnowledgeEntry(keyword, aiGeneratedHeading, messageContent);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry added successfully!");
        }
    }

    private void handleRemoveCommand(Player player, String[] args2) {
        if (!this.plugin.isRemoveConfirmCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (!this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage(this.plugin.getPermissionDeniedMessage());
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai remove <keyword>");
            return;
        }
        String key = args2[1];
        if (this.plugin.isRemoveConfirmCommandEnabled()) {
            String code = this.plugin.getConfirmationManager().createConfirmation(player.getUniqueId(), "remove", key, null);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please confirm removing this knowledge entry by typing: /ai confirm " + code);
        } else {
            String removedEntry = this.plugin.removeKnowledgeEntry(key);
            if (removedEntry != null) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry removed successfully!");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Removed content: " + removedEntry);
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Knowledge entry not found.");
            }
        }
    }

    private void handleConfirmCommand(Player player, String[] args2) {
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai confirm <code>");
            return;
        }
        String code = args2[1];
        ConfirmationEntry entry = null;
        String entryCode = null;
        if (this.plugin.isSimpleKnowledgeYmlApprove() && code.equalsIgnoreCase("yes")) {
            for (Map.Entry<String, ConfirmationEntry> mapEntry : this.plugin.getConfirmationManager().getPendingConfirmations().entrySet()) {
                if (!mapEntry.getValue().getPlayerId().equals(player.getUniqueId()) || !mapEntry.getValue().getActionType().equals("add")) continue;
                entry = mapEntry.getValue();
                entryCode = mapEntry.getKey();
                break;
            }
        } else {
            entry = this.plugin.getConfirmationManager().getConfirmation(code);
            entryCode = code;
        }
        if (entry == null || !entry.getPlayerId().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid or expired confirmation code.");
            return;
        }
        if (entry.getActionType().equals("add")) {
            String[] parts = entry.getOriginalContent().split("/", 2);
            this.plugin.addKnowledgeEntry(parts[0], parts[1], entry.getAiResponse());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry added successfully!");
        } else if (entry.getActionType().equals("remove")) {
            String removedEntry = this.plugin.removeKnowledgeEntry(entry.getOriginalContent());
            if (removedEntry != null) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry removed successfully!");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Removed content: " + removedEntry);
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Knowledge entry not found.");
            }
        }
        if (entryCode != null) {
            this.plugin.getConfirmationManager().removeConfirmation(entryCode);
        }
    }

    private void handleDisableCommand(Player player) {
        if (!this.plugin.isAdminDisableCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (this.plugin.getAdminModePlayers().containsKey(player.getUniqueId())) {
            this.plugin.getAdminModePlayers().remove(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Admin mode disabled.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Admin mode is not enabled.");
        }
    }

    private void handleReloadCommand(Player player, String[] args2) {
        if (!this.plugin.isReloadCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (args2.length == 1) {
            this.plugin.reloadConfig();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI main configuration reloaded.");
        } else if (args2.length == 2) {
            String subCommand = args2[1].toLowerCase();
            if (subCommand.equals("f") || subCommand.equals("features")) {
                this.plugin.reloadFeaturesConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI features configuration reloaded.");
            } else if (subCommand.equals("nsr-ai")) {
                this.plugin.reloadNSR_AIPlugin();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI plugin (configs and knowledge base) reloaded.");
            } else if (subCommand.equals("k") || subCommand.equals("knowledge")) {
                this.plugin.reloadKnowledgeBase();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI knowledge base reloaded.");
            } else if (subCommand.equals("c") || subCommand.equals("config")) {
                this.plugin.reloadConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI main configuration reloaded.");
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai reload [f|features|nsr-ai|k|knowledge|c|config]");
        }
    }

    private void handleShopCommand(Player player, String[] args2) {
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai shop <item_name>");
            return;
        }
        String itemName = String.join((CharSequence)" ", Arrays.copyOfRange(args2, 1, args2.length));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Searching for shop price for: " + itemName + "...");
        String shopPrice = "Price for " + itemName + ": Not found in shop (placeholder)";
        player.sendMessage(String.valueOf(ChatColor.AQUA) + shopPrice);
    }

    private void handleCacheCommand(Player player, String[] args2) {
        if (args2.length < 2 || !args2[1].equalsIgnoreCase("clear") && !args2[1].equalsIgnoreCase("refresh")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai cache <clear|refresh>");
            return;
        }
        String action = args2[1].toLowerCase();
        if (action.equals("clear")) {
            if (!this.plugin.isCacheClearEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /ai cache clear command is currently disabled.");
                return;
            }
            this.plugin.getConversationManager().clearHistory(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your session has been cleared. A new session will begin with your next message.");
        } else if (action.equals("refresh")) {
            if (!this.plugin.isCacheRefreshEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /ai cache refresh command is currently disabled.");
                return;
            }
            this.plugin.reloadPlayerSession(player);
        }
    }

    private void handleMemoryCommand(Player player, String[] args2) {
        if (args2.length < 2 || !args2[1].equalsIgnoreCase("clear") && !args2[1].equalsIgnoreCase("refresh")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai memory <clear|refresh>");
            return;
        }
        String action = args2[1].toLowerCase();
        if (action.equals("clear")) {
            if (!this.plugin.isMemoryClearEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /ai memory clear command is currently disabled.");
                return;
            }
            this.plugin.summarizeAndClearSession(player);
        } else if (action.equals("refresh")) {
            if (!this.plugin.isMemoryRefreshEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /ai memory refresh command is currently disabled.");
                return;
            }
            this.plugin.summarizeAndRefreshSession(player);
        }
    }

    private void handleDefaultCommand(Player player, String[] args2) {
        this.handleHelpCommand(player);
    }

    private void handleHelpCommand(Player player) {
        boolean isAdmin = this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false);
        StringBuilder helpMessage = new StringBuilder();
        helpMessage.append(ChatColor.AQUA).append("--- NSR-AI Commands ---").append("\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai <message>").append(ChatColor.GRAY).append(" - Talk to the AI.\n");
        if (this.plugin.isDataCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai data <query>").append(ChatColor.GRAY).append(" - Query the knowledge base.\n");
            if (isAdmin) {
                helpMessage.append(ChatColor.YELLOW).append("/ai data all").append(ChatColor.GRAY).append(" - View all knowledge base entries.\n");
            }
        }
        if (isAdmin && this.plugin.isAdminDisableCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai admin <code>").append(ChatColor.GRAY).append(" - Toggle admin mode.\n");
        }
        if (isAdmin && this.plugin.isAdminDisableCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai disable").append(ChatColor.GRAY).append(" - Disable admin mode.\n");
        }
        if (this.plugin.isVersionCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai version (or /ai v)").append(ChatColor.GRAY).append(" - Display plugin version and update info.\n");
        }
        if (isAdmin) {
            if (this.plugin.isAddConfirmCommandEnabled()) {
                helpMessage.append(ChatColor.YELLOW).append("/ai add <keyword>, <message_content>").append(ChatColor.GRAY).append(" - Add knowledge to the AI (requires confirmation).\n");
            } else {
                helpMessage.append(ChatColor.YELLOW).append("/ai add <keyword>, <message_content>").append(ChatColor.GRAY).append(" - Add knowledge to the AI (no confirmation).\n");
            }
        }
        if (isAdmin) {
            if (this.plugin.isRemoveConfirmCommandEnabled()) {
                helpMessage.append(ChatColor.YELLOW).append("/ai remove <keyword>").append(ChatColor.GRAY).append(" - Remove knowledge from the AI (requires confirmation).\n");
            } else {
                helpMessage.append(ChatColor.YELLOW).append("/ai remove <keyword>").append(ChatColor.GRAY).append(" - Remove knowledge from the AI (no confirmation).\n");
            }
        }
        if (isAdmin && this.plugin.isReloadCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai reload [f|features|nsr-ai]").append(ChatColor.GRAY).append(" - Reload plugin configurations.\n");
        }
        helpMessage.append(ChatColor.YELLOW).append("/ai shop <item_name>").append(ChatColor.GRAY).append(" - Search for shop prices.\n");
        if (isAdmin && this.plugin.isCacheClearEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai cache clear").append(ChatColor.GRAY).append(" - Clear conversation cache.\n");
        }
        if (isAdmin && this.plugin.isCacheRefreshEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai cache refresh").append(ChatColor.GRAY).append(" - Refresh conversation cache from logs.\n");
        }
        if (isAdmin && this.plugin.isMemoryClearEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai memory clear").append(ChatColor.GRAY).append(" - Summarize and clear AI conversation memory.\n");
        }
        if (isAdmin && this.plugin.isMemoryRefreshEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai memory refresh").append(ChatColor.GRAY).append(" - Summarize and refresh AI conversation memory.\n");
        }
        boolean isAdvancedPlayerStatsAddonLoaded = false;
        if (this.plugin.getAddonManager() != null) {
            for (Addon addon : this.plugin.getAddonManager().getAddons()) {
                if (!addon.getName().equals("NSR-AI-Advanced-Player-Stats")) continue;
                isAdvancedPlayerStatsAddonLoaded = true;
                break;
            }
        }
        if (isAdvancedPlayerStatsAddonLoaded) {
            if (isAdmin) {
                helpMessage.append(ChatColor.YELLOW).append("/ai privacy <player> <feature> [on|off]").append(ChatColor.GRAY).append(" - Manage player privacy settings.\n");
            } else {
                helpMessage.append(ChatColor.YELLOW).append("/ai privacy <feature> [on|off]").append(ChatColor.GRAY).append(" - Manage your privacy settings.\n");
            }
        }
        helpMessage.append(ChatColor.AQUA).append("-------------------------").append("\n");
        player.sendMessage(helpMessage.toString());
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        if (args2.length == 1) {
            return Arrays.asList("admin", "cache", "memory", "version", "data", "add", "remove", "reload", "shop", "confirm", "disable", "help").stream().filter(s -> s.startsWith(args2[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args2.length == 2) {
            if (args2[0].equalsIgnoreCase("cache")) {
                return Arrays.asList("clear", "refresh").stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[0].equalsIgnoreCase("memory")) {
                return Arrays.asList("clear", "refresh").stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[0].equalsIgnoreCase("reload")) {
                return Arrays.asList("f", "features", "nsr-ai", "k", "knowledge", "c", "config").stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[0].equalsIgnoreCase("privacy")) {
                ArrayList<String> completions = new ArrayList<String>();
                if (args2.length == 2) {
                    completions.addAll(Arrays.asList("health", "hunger", "deaths", "kills", "kd", "blocks_mined", "blocks_placed", "distance_traveled", "playtime", "afk", "streak", "location", "stats"));
                } else if (args2.length == 3) {
                    completions.addAll(Arrays.asList("on", "off"));
                }
                return completions.stream().filter(s -> s.startsWith(args2[args2.length - 1].toLowerCase())).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }
}

