/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.config;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdater {
    private final NSRAIPlugin plugin;

    public ConfigUpdater(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    public void updateConfigs() {
        this.saveDefaultConfig("config.yml");
        this.saveDefaultConfig("features.yml");
        FileConfiguration currentConfig = this.loadConfig("config.yml");
        FileConfiguration currentFeatures = this.loadConfig("features.yml");
        FileConfiguration defaultConfig = this.loadDefaultConfig("config.yml");
        FileConfiguration defaultFeatures = this.loadDefaultConfig("features.yml");
        this.updateConfigFile(currentConfig, defaultConfig, "config.yml");
        this.updateConfigFile(currentFeatures, defaultFeatures, "features.yml");
        this.transferSettings(currentConfig, currentFeatures, defaultConfig, defaultFeatures);
    }

    private void updateConfigFile(FileConfiguration currentConfig, FileConfiguration defaultConfig, String fileName) {
        Set currentKeys = currentConfig.getKeys(true);
        Set defaultKeys = defaultConfig.getKeys(true);
        for (String key : defaultKeys) {
            if (currentConfig.contains(key)) continue;
            currentConfig.set(key, defaultConfig.get(key));
        }
        for (String key : new HashSet(currentKeys)) {
            if (defaultKeys.contains(key)) continue;
            currentConfig.set(key, null);
        }
        try {
            currentConfig.save(new File(this.plugin.getDataFolder(), fileName));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save " + fileName);
            e.printStackTrace();
        }
    }

    private void transferSettings(FileConfiguration currentConfig, FileConfiguration currentFeatures, FileConfiguration defaultConfig, FileConfiguration defaultFeatures) {
        for (String key : defaultFeatures.getKeys(true)) {
            if (!currentConfig.contains(key) || currentFeatures.contains(key)) continue;
            currentFeatures.set(key, currentConfig.get(key));
            currentConfig.set(key, null);
        }
        try {
            currentConfig.save(new File(this.plugin.getDataFolder(), "config.yml"));
            currentFeatures.save(new File(this.plugin.getDataFolder(), "features.yml"));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save configs after transferring settings.");
            e.printStackTrace();
        }
    }

    private FileConfiguration loadConfig(String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private FileConfiguration loadDefaultConfig(String fileName) {
        InputStream inputStream2 = this.plugin.getResource(fileName);
        if (inputStream2 != null) {
            return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream2));
        }
        return new YamlConfiguration();
    }

    private void saveDefaultConfig(String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            this.plugin.saveResource(fileName, false);
        }
    }
}

