/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.data.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class PlayerNotesDAO {
    private final NSRAIPlugin plugin;
    private final DatabaseManager dbManager;

    public PlayerNotesDAO(NSRAIPlugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
    }

    public void addNote(UUID uuid, String note, UUID authorUUID) {
        String sql = "INSERT INTO player_notes(uuid, note, ts, author_uuid) VALUES(?,?,?,?)";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, note);
            pstmt.setLong(3, System.currentTimeMillis());
            pstmt.setString(4, authorUUID.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error adding player note for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    public List<String> getNotes(UUID uuid) {
        ArrayList<String> notes = new ArrayList<String>();
        String sql = "SELECT note, ts, author_uuid FROM player_notes WHERE uuid = ? ORDER BY ts DESC";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String note = rs.getString("note");
                long ts = rs.getLong("ts");
                String authorUUID = rs.getString("author_uuid");
                notes.add("[" + String.valueOf(new Date(ts)) + " by " + this.plugin.getServer().getOfflinePlayer(UUID.fromString(authorUUID)).getName() + "]: " + note);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting player notes for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return notes;
    }
}

