/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class KnowledgeManager {
    private final NSRAIPlugin plugin;
    private File knowledgeFile;
    private FileConfiguration knowledgeConfig;
    private Map<String, String> knowledgeBase;
    private Map<String, String> adminKnowledgeBase;

    public KnowledgeManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.knowledgeBase = new HashMap<String, String>();
        this.adminKnowledgeBase = new HashMap<String, String>();
        this.loadKnowledgeBase();
    }

    public void loadKnowledgeBase() {
        String fileName = this.plugin.getConfig().getString("knowledge-file", "knowledge.yml");
        this.knowledgeFile = new File(this.plugin.getDataFolder(), fileName);
        if (!this.knowledgeFile.exists()) {
            try {
                this.knowledgeFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create knowledge file: " + e.getMessage());
            }
        }
        this.knowledgeConfig = YamlConfiguration.loadConfiguration((File)this.knowledgeFile);
        if (this.knowledgeConfig.isConfigurationSection("knowledge")) {
            for (String key : this.knowledgeConfig.getConfigurationSection("knowledge").getKeys(false)) {
                this.knowledgeBase.put(key.toLowerCase(), this.knowledgeConfig.getString("knowledge." + key));
            }
        }
        if (this.knowledgeConfig.isConfigurationSection("admin-knowledge")) {
            for (String key : this.knowledgeConfig.getConfigurationSection("admin-knowledge").getKeys(false)) {
                this.adminKnowledgeBase.put(key.toLowerCase(), this.knowledgeConfig.getString("admin-knowledge." + key));
            }
        }
    }

    public void saveKnowledgeBase() {
        this.knowledgeConfig.set("knowledge", this.knowledgeBase);
        this.knowledgeConfig.set("admin-knowledge", this.adminKnowledgeBase);
        try {
            this.knowledgeConfig.save(this.knowledgeFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save knowledge file: " + e.getMessage());
        }
    }

    public void addKnowledge(String question, String answer, boolean isAdminKnowledge) {
        if (isAdminKnowledge) {
            this.adminKnowledgeBase.put(question.toLowerCase(), answer);
        } else {
            this.knowledgeBase.put(question.toLowerCase(), answer);
        }
        this.saveKnowledgeBase();
    }

    public String removeKnowledge(String key) {
        String removedValue = this.knowledgeBase.remove(key.toLowerCase());
        if (removedValue == null) {
            removedValue = this.adminKnowledgeBase.remove(key.toLowerCase());
        }
        if (removedValue != null) {
            this.saveKnowledgeBase();
        }
        return removedValue;
    }

    public String getAnswer(String question, boolean isAdmin) {
        String adminAnswer;
        if (isAdmin && (adminAnswer = this.adminKnowledgeBase.get(question.toLowerCase())) != null) {
            return adminAnswer;
        }
        return this.knowledgeBase.get(question.toLowerCase());
    }

    private int calculateRelevance(String text, String query) {
        int score = 0;
        String[] queryWords = query.toLowerCase().split("\\s+");
        String lowerCaseText = text.toLowerCase();
        for (String word : queryWords) {
            if (!lowerCaseText.contains(word)) continue;
            ++score;
        }
        return score;
    }

    public Map<String, String> searchKnowledge(String query, boolean isAdmin) {
        HashMap<String, Integer> relevanceScores = new HashMap<String, Integer>();
        HashMap<String, String> combinedKnowledge = new HashMap<String, String>(this.knowledgeBase);
        if (isAdmin) {
            combinedKnowledge.putAll(this.adminKnowledgeBase);
        }
        for (Map.Entry entry2 : combinedKnowledge.entrySet()) {
            int contentScore;
            int headingScore = this.calculateRelevance((String)entry2.getKey(), query) * 2;
            int totalScore = headingScore + (contentScore = this.calculateRelevance((String)entry2.getValue(), query));
            if (totalScore <= 0) continue;
            relevanceScores.put((String)entry2.getKey(), totalScore);
        }
        HashMap<String, String> topResults = new HashMap<String, String>();
        relevanceScores.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(5L).forEach(entry -> {
            String key = (String)entry.getKey();
            if (combinedKnowledge.containsKey(key)) {
                topResults.put(key, (String)combinedKnowledge.get(key));
            }
        });
        return topResults;
    }

    public Map<String, String> getAllKnowledge(boolean isAdmin) {
        HashMap<String, String> allKnowledge = new HashMap<String, String>(this.knowledgeBase);
        if (isAdmin) {
            allKnowledge.putAll(this.adminKnowledgeBase);
        }
        return allKnowledge;
    }
}

