/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ShopManager {
    private final NSRAIPlugin plugin;
    private File shopPricesFile;
    private FileConfiguration shopPricesConfig;
    private Map<String, Double> prices;

    public ShopManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.prices = new HashMap<String, Double>();
        this.loadShopPrices();
    }

    private void loadShopPrices() {
        String fileName = this.plugin.getConfig().getString("shop-prices-file", "shop_prices.yml");
        this.shopPricesFile = new File(this.plugin.getDataFolder(), fileName);
        if (!this.shopPricesFile.exists()) {
            this.plugin.saveResource(fileName, false);
        }
        this.shopPricesConfig = YamlConfiguration.loadConfiguration((File)this.shopPricesFile);
        if (this.shopPricesConfig.isConfigurationSection("prices")) {
            for (String key : this.shopPricesConfig.getConfigurationSection("prices").getKeys(false)) {
                this.prices.put(key.toLowerCase(), this.shopPricesConfig.getDouble("prices." + key));
            }
        }
    }

    public Double getPrice(String item) {
        return this.prices.get(item.toLowerCase());
    }

    public String handleShopQuery(String query) {
        if (!this.plugin.getConfig().getBoolean("enable-shop-prices", false)) {
            return null;
        }
        Pattern pattern = Pattern.compile("cost of (\\d+) (.+)");
        Matcher matcher = pattern.matcher(query.toLowerCase());
        if (matcher.find()) {
            try {
                int quantity = Integer.parseInt(matcher.group(1));
                String item = matcher.group(2).trim();
                Double price = this.getPrice(item);
                if (price != null) {
                    double totalCost = (double)quantity * price;
                    return "The cost of " + quantity + " " + item + " is " + String.format("%.2f", totalCost) + ".";
                }
                return "I don't have price information for " + item + ".";
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

