/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import java.util.Collection;

public class StringUtil {
    public static String findBestMatch(String input, Collection<String> options) {
        if (input == null || options == null || options.isEmpty()) {
            return null;
        }
        String bestMatch = null;
        int minDistance = Integer.MAX_VALUE;
        for (String option : options) {
            int distance = StringUtil.levenshteinDistance(input.toLowerCase(), option.toLowerCase());
            if (distance >= minDistance) continue;
            minDistance = distance;
            bestMatch = option;
        }
        if (bestMatch == null || minDistance > bestMatch.length() / 2) {
            // empty if block
        }
        return bestMatch;
    }

    private static int levenshteinDistance(String a, String b) {
        int[] costs = new int[b.length() + 1];
        for (int j = 0; j < costs.length; ++j) {
            costs[j] = j;
        }
        for (int i = 1; i <= a.length(); ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (int j = 1; j <= b.length(); ++j) {
                int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[b.length()];
    }
}

