/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.api;

import com.nsr.ai.api.AIAddon;
import com.nsr.ai.api.AIMessage;
import com.nsr.ai.api.AIResponse;
import com.nsr.ai.api.AddonInfo;
import com.nsr.ai.api.CustomGUIProvider;
import com.nsr.ai.api.GUIBuilder;
import com.nsr.ai.api.GUIListener;
import com.nsr.ai.api.NPCListener;
import com.nsr.ai.api.PetDataSnapshot;
import com.nsr.ai.api.PetListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class NSRaiAPI {
    public static final int API_VERSION = 2;
    private static Object internalApiInstance;

    private NSRaiAPI() {
    }

    public static void setInternalApiInstance(Object instance) {
        internalApiInstance = instance;
    }

    private static <T> T callInternalMethod(String methodName, Class<?>[] paramTypes, Object ... args2) {
        if (internalApiInstance == null) {
            throw new IllegalStateException("NSR-AI core plugin not initialized or API not ready.");
        }
        try {
            Method method = internalApiInstance.getClass().getMethod(methodName, paramTypes);
            return (T)method.invoke(internalApiInstance, args2);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("NSR-AI core plugin does not support method: " + methodName + ". API mismatch?", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new IllegalStateException("Error calling internal NSR-AI API method: " + methodName, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access internal NSR-AI API method: " + methodName, e);
        }
    }

    public static CompletableFuture<Void> sendMessageToAI(Player player, AIMessage message) {
        return (CompletableFuture)NSRaiAPI.callInternalMethod("sendMessageToAI", new Class[]{Player.class, AIMessage.class}, player, message);
    }

    public static CompletableFuture<AIResponse> getAIResponse(AIMessage message) {
        return (CompletableFuture)NSRaiAPI.callInternalMethod("getAIResponse", new Class[]{AIMessage.class}, message);
    }

    public static Optional<PetDataSnapshot> getPetData(UUID owner) {
        try {
            return Optional.ofNullable((PetDataSnapshot)NSRaiAPI.callInternalMethod("getPetData", new Class[]{UUID.class}, owner));
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    public static void registerPetListener(PetListener listener) {
        NSRaiAPI.callInternalMethod("registerPetListener", new Class[]{PetListener.class}, listener);
    }

    public static void registerNPCListener(NPCListener listener) {
        NSRaiAPI.callInternalMethod("registerNPCListener", new Class[]{NPCListener.class}, listener);
    }

    public static void updateNPCSkin(String npcName, String texture, String signature) {
        NSRaiAPI.callInternalMethod("updateNPCSkin", new Class[]{String.class, String.class, String.class}, npcName, texture, signature);
    }

    public static void openCustomGUI(Player player, GUIBuilder guiBuilder) {
        try {
            NSRaiAPI.callInternalMethod("openCustomGUI", new Class[]{Player.class, GUIBuilder.class}, player, guiBuilder);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalStateException("GUI system not supported by this NSR-AI version.", e);
        }
    }

    public static void registerGUIListener(GUIListener listener) {
        try {
            NSRaiAPI.callInternalMethod("registerGUIListener", new Class[]{GUIListener.class}, listener);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalStateException("GUI system not supported by this NSR-AI version.", e);
        }
    }

    public static Optional<String> getSharedMemory(String key) {
        return (Optional)NSRaiAPI.callInternalMethod("getSharedMemory", new Class[]{String.class}, key);
    }

    public static void updateSharedMemory(String key, String value) {
        NSRaiAPI.callInternalMethod("updateSharedMemory", new Class[]{String.class, String.class}, key, value);
    }

    public static String getVersion() {
        return (String)NSRaiAPI.callInternalMethod("getVersion", new Class[0], new Object[0]);
    }

    public static int getApiVersion() {
        return 2;
    }

    public static List<AIAddon> getRegisteredAddons() {
        return (List)NSRaiAPI.callInternalMethod("getRegisteredAddons", new Class[0], new Object[0]);
    }

    public static List<AddonInfo> getLoadedAddons() {
        return (List)NSRaiAPI.callInternalMethod("getLoadedAddonInfo", new Class[0], new Object[0]);
    }

    public static List<AddonInfo> getFailedAddons() {
        return (List)NSRaiAPI.callInternalMethod("getFailedAddonInfo", new Class[0], new Object[0]);
    }

    public static Logger getLogger() {
        return (Logger)NSRaiAPI.callInternalMethod("getLogger", new Class[0], new Object[0]);
    }

    public static Plugin getPlugin() {
        return (Plugin)NSRaiAPI.callInternalMethod("getPlugin", new Class[0], new Object[0]);
    }

    public static NSRaiAPI getApi() {
        return new NSRaiAPI();
    }

    public static boolean toggleAdminMode(Player player, String activationCode) {
        return (Boolean)NSRaiAPI.callInternalMethod("toggleAdminMode", new Class[]{Player.class, String.class}, player, activationCode);
    }

    public static boolean isAdminModeEnabled(Player player) {
        return (Boolean)NSRaiAPI.callInternalMethod("isAdminModeEnabled", new Class[]{Player.class}, new Object[0]);
    }

    public static void registerCustomGUI(String guiId, CustomGUIProvider provider) {
        NSRaiAPI.callInternalMethod("registerCustomGUI", new Class[]{String.class, CustomGUIProvider.class}, guiId, provider);
    }

    public static void openCustomGUI(Player player, String guiId) {
        NSRaiAPI.callInternalMethod("openCustomGUI", new Class[]{Player.class, String.class}, player, guiId);
    }

    public static boolean isPlayerOnCooldown(Player player) {
        return (Boolean)NSRaiAPI.callInternalMethod("isPlayerOnCooldown", new Class[]{Player.class}, player);
    }

    public static long getPlayerCooldownRemaining(Player player) {
        return (Long)NSRaiAPI.callInternalMethod("getPlayerCooldownRemaining", new Class[]{Player.class}, player);
    }

    public static boolean isAiEnabled(Player player) {
        return (Boolean)NSRaiAPI.callInternalMethod("isAiEnabled", new Class[]{Player.class}, player);
    }

    public static void setAiEnabled(Player player, boolean enabled) {
        NSRaiAPI.callInternalMethod("setAiEnabled", new Class[]{Player.class, Boolean.TYPE}, player, enabled);
    }

    public static void addKnowledgeEntry(String keyword, String heading, String content) {
        NSRaiAPI.callInternalMethod("addKnowledgeEntry", new Class[]{String.class, String.class, String.class}, keyword, heading, content);
    }

    public static String removeKnowledgeEntry(String keyword) {
        return (String)NSRaiAPI.callInternalMethod("removeKnowledgeEntry", new Class[]{String.class}, keyword);
    }

    public static Map<String, String> getAllKnowledge() {
        return (Map)NSRaiAPI.callInternalMethod("getAllKnowledge", new Class[0], new Object[0]);
    }

    public static void clearConversationHistory(Player player) {
        NSRaiAPI.callInternalMethod("clearConversationHistory", new Class[]{Player.class}, player);
    }

    public static void summarizeConversation(Player player) {
        NSRaiAPI.callInternalMethod("summarizeConversation", new Class[]{Player.class}, player);
    }

    public static void refreshConversation(Player player) {
        NSRaiAPI.callInternalMethod("refreshConversation", new Class[]{Player.class}, player);
    }

    public static List<AIMessage> getConversationHistory(Player player) {
        return (List)NSRaiAPI.callInternalMethod("getConversationHistory", new Class[]{Player.class}, player);
    }

    public static void reloadMainConfig() {
        NSRaiAPI.callInternalMethod("reloadMainConfig", new Class[0], new Object[0]);
    }

    public static void reloadFeaturesConfig() {
        NSRaiAPI.callInternalMethod("reloadFeaturesConfig", new Class[0], new Object[0]);
    }

    public static void reloadKnowledgeBase() {
        NSRaiAPI.callInternalMethod("reloadKnowledgeBase", new Class[0], new Object[0]);
    }
}

