/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.managers.PlayerApiKeyManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bukkit.entity.Player;

public class ApiKeyManager {
    private static final Logger LOGGER = Logger.getLogger(ApiKeyManager.class.getName());
    private final Set<ApiKey> apiKeys = new HashSet<ApiKey>();
    private final Map<UUID, List<String>> playerApiKeys = new HashMap<UUID, List<String>>();
    private final OkHttpClient httpClient = new OkHttpClient();
    private final NSRAIPlugin plugin;

    public ApiKeyManager(NSRAIPlugin plugin, List<String> keys2) {
        this.plugin = plugin;
        for (String key : keys2) {
            if (key == null || key.isEmpty() || key.equalsIgnoreCase("your_key_here")) continue;
            this.apiKeys.add(new ApiKey(key));
        }
        if (this.apiKeys.isEmpty()) {
            LOGGER.warning("[NSR-AI] Coder Error: No API keys are set in config.yml. Please add your API keys to enable AI functionality. Suggestion: Add valid API keys to the 'api-keys' list in config.yml.");
        } else {
            LOGGER.info("Initialized " + this.apiKeys.size() + " API keys.");
        }
    }

    public ApiKey getNextAvailableKey(String provider) {
        ApiKey.Type targetType = ApiKey.Type.fromString(provider);
        for (ApiKey key : this.apiKeys) {
            if (key.getStatus() != ApiKey.KeyStatus.ACTIVE || key.getStatus() == ApiKey.KeyStatus.LIMIT_REACHED || targetType != ApiKey.Type.ALL && key.getType() != targetType) continue;
            key.incrementUsageCount();
            return key;
        }
        return null;
    }

    public ApiKey getNextAvailableKey(String provider, Player player) {
        PlayerApiKeyManager.ApiKey playerKey;
        if (this.plugin.getPlayerApiKeyManager().hasApiKeys(player.getUniqueId()) && (playerKey = this.plugin.getPlayerApiKeyManager().getMostRecentSessionKey(player.getUniqueId())) != null) {
            ApiKey apiKey = new ApiKey(playerKey.getApiKey());
            apiKey.setModel(playerKey.getModel());
            if (this.validatePlayerApiKey(apiKey)) {
                return apiKey;
            }
        }
        return this.getNextAvailableKey(provider);
    }

    public void validateKeys(String defaultGeminiModel, String defaultClaudeModel, String defaultOpenAIModel) {
        int keyCount = 0;
        for (ApiKey key : this.apiKeys) {
            ++keyCount;
            if (this.validateGeminiKey(key, defaultGeminiModel)) {
                key.setStatus(ApiKey.KeyStatus.ACTIVE);
                key.setType(ApiKey.Type.GEMINI);
                LOGGER.info("API Key " + keyCount + " is a valid Gemini key.");
                continue;
            }
            if (this.validateClaudeKey(key)) {
                key.setStatus(ApiKey.KeyStatus.ACTIVE);
                key.setType(ApiKey.Type.CLAUDE);
                LOGGER.info("API Key " + keyCount + " is a valid Claude key.");
                continue;
            }
            if (this.validateOpenAIKey(key)) {
                key.setStatus(ApiKey.KeyStatus.ACTIVE);
                key.setType(ApiKey.Type.OPENAI);
                LOGGER.info("API Key " + keyCount + " is a valid OpenAI key.");
                continue;
            }
            key.setStatus(ApiKey.KeyStatus.INACTIVE);
            key.setType(ApiKey.Type.UNKNOWN);
            LOGGER.warning("API Key " + keyCount + " is invalid for all services.");
        }
    }

    private boolean validatePlayerApiKey(ApiKey apiKey) {
        if (this.validateGeminiKey(apiKey, this.plugin.getConfig().getString("default-gemini-model", "gemini-1.5-flash"))) {
            apiKey.setType(ApiKey.Type.GEMINI);
            apiKey.setStatus(ApiKey.KeyStatus.ACTIVE);
            return true;
        }
        if (this.validateClaudeKey(apiKey)) {
            apiKey.setType(ApiKey.Type.CLAUDE);
            apiKey.setStatus(ApiKey.KeyStatus.ACTIVE);
            return true;
        }
        if (this.validateOpenAIKey(apiKey)) {
            apiKey.setType(ApiKey.Type.OPENAI);
            apiKey.setStatus(ApiKey.KeyStatus.ACTIVE);
            return true;
        }
        apiKey.setStatus(ApiKey.KeyStatus.INACTIVE);
        return false;
    }

    private boolean validateGeminiKey(ApiKey apiKey, String model) {
        long startTime = System.currentTimeMillis();
        Request request = new Request.Builder().url("https://generativelanguage.googleapis.com/v1/models/" + model + "?key=" + apiKey.getKey()).get().build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            apiKey.setResponseTime(System.currentTimeMillis() - startTime);
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                apiKey.setResponseTime(Long.MAX_VALUE);
                return false;
            }
        }
    }

    private boolean validateClaudeKey(ApiKey apiKey) {
        long startTime = System.currentTimeMillis();
        Request request = new Request.Builder().url("https://api.anthropic.com/v1/messages").header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            apiKey.setResponseTime(System.currentTimeMillis() - startTime);
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                apiKey.setResponseTime(Long.MAX_VALUE);
                return false;
            }
        }
    }

    private boolean validateOpenAIKey(ApiKey apiKey) {
        long startTime = System.currentTimeMillis();
        Request request = new Request.Builder().url("https://api.openai.com/v1/engines").header("Authorization", "Bearer " + apiKey.getKey()).build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            apiKey.setResponseTime(System.currentTimeMillis() - startTime);
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                apiKey.setResponseTime(Long.MAX_VALUE);
                return false;
            }
        }
    }

    public Set<ApiKey> getApiKeys() {
        return this.apiKeys;
    }

    public static class ApiKey {
        private final String key;
        private KeyStatus status;
        private Type type;
        private String model;
        private long responseTime;
        private int usageCount;
        private int errorCount;
        private int fallbackCount;

        public ApiKey(String key) {
            this.key = key;
            this.status = KeyStatus.ACTIVE;
            this.type = Type.UNKNOWN;
            this.responseTime = -1L;
            this.usageCount = 0;
        }

        public String getKey() {
            return this.key;
        }

        public String getKeyId() {
            return this.key;
        }

        public KeyStatus getStatus() {
            return this.status;
        }

        public void setStatus(KeyStatus status) {
            this.status = status;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public long getResponseTime() {
            return this.responseTime;
        }

        public void setResponseTime(long responseTime) {
            this.responseTime = responseTime;
        }

        public int getUsageCount() {
            return this.usageCount;
        }

        public void incrementUsageCount() {
            ++this.usageCount;
        }

        public void incrementErrorCount() {
            ++this.errorCount;
        }

        public void incrementFallbackCount() {
            ++this.fallbackCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApiKey apiKey = (ApiKey)o;
            return this.key.equals(apiKey.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public static enum KeyStatus {
            ACTIVE,
            INACTIVE,
            USING,
            OVERLOADED,
            INVALID,
            LIMIT_REACHED;

        }

        public static enum Type {
            UNKNOWN,
            ALL,
            GEMINI,
            CLAUDE,
            OPENAI;


            public static Type fromString(String provider) {
                switch (provider.toLowerCase()) {
                    case "gemini": {
                        return GEMINI;
                    }
                    case "claude": {
                        return CLAUDE;
                    }
                    case "openai": {
                        return OPENAI;
                    }
                    case "all": {
                        return ALL;
                    }
                }
                return UNKNOWN;
            }
        }
    }
}

