/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nsr.ai.api.NSRaiAPI;
import com.nsr.ai.plugin.ApiKeyManager;
import com.nsr.ai.plugin.ConversationManager;
import com.nsr.ai.plugin.PlayerListener;
import com.nsr.ai.plugin.addons.AddonManager;
import com.nsr.ai.plugin.command.CommandManager;
import com.nsr.ai.plugin.config.ConfigUpdater;
import com.nsr.ai.plugin.managers.ApiKeyStorage;
import com.nsr.ai.plugin.managers.BugFixManager;
import com.nsr.ai.plugin.managers.KnowledgeManager;
import com.nsr.ai.plugin.managers.OverloadedKeyManager;
import com.nsr.ai.plugin.managers.PlayerApiKeyManager;
import com.nsr.ai.plugin.managers.PlayerSecurityManager;
import com.nsr.ai.plugin.managers.PrivacyManager;
import com.nsr.ai.plugin.pet.Pet;
import com.nsr.ai.plugin.pet.PetListener;
import com.nsr.ai.plugin.pet.PetManager;
import com.nsr.ai.plugin.pet.ReservedNicknameManager;
import com.nsr.ai.plugin.util.ChatLogger;
import com.nsr.ai.plugin.util.ConfigEncryptor;
import com.nsr.ai.plugin.util.ConfirmationManager;
import com.nsr.ai.plugin.util.SecurityUtil;
import com.nsr.ai.plugin.util.UpdateChecker;
import com.nsr.ai.security.SecurityManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NSRAIPlugin
extends JavaPlugin
implements Listener {
    private static NSRAIPlugin instance;
    private FileConfiguration featuresConfig;
    private SecurityManager securityManager;
    private ApiKeyStorage apiKeyStorage;
    private SecurityUtil securityUtil;
    private PlayerSecurityManager playerSecurityManager;
    private ConfirmationManager confirmationManager;
    private String adminActivationCode;
    private String defaultGeminiModel;
    private String defaultClaudeModel;
    private String defaultOpenAIModel;
    private String defaultApiProvider;
    private List<String> apiKeys;
    private ApiKeyManager apiKeyManager;
    private PlayerApiKeyManager playerApiKeyManager;
    private PrivacyManager privacyManager;
    private String aiChatColor;
    private String userChatColor;
    private String aiPrefix;
    private String userPrefix;
    private String adminAiPrefix;
    private String aiNotConfiguredMessage;
    private String apiErrorMessage;
    private String permissionDeniedMessage;
    private String noValidKeysMessage;
    private String allKeysRateLimitedMessage;
    private List<String> globalKeyFailMessage;
    private String systemPrompt;
    private boolean codeBlockerEnabled;
    private String codeBlockerMessage;
    private String knowledgeBaseColor;
    private boolean simpleKnowledgeYmlApprove;
    private boolean dataCommandEnabled;
    private boolean adminDisableCommandEnabled;
    private boolean versionCommandEnabled;
    private boolean addConfirmCommandEnabled;
    private boolean removeConfirmCommandEnabled;
    private boolean reloadCommandEnabled;
    private boolean memoryClearEnabled;
    private boolean memoryRefreshEnabled;
    private boolean cacheClearEnabled;
    private boolean cacheRefreshEnabled;
    private ConversationManager conversationManager;
    private AddonManager addonManager;
    private BugFixManager bugFixManager;
    private ChatLogger chatLogger;
    private CommandManager commandManager;
    private ConfigEncryptor configEncryptor;
    private UpdateChecker updateChecker;
    private KnowledgeManager knowledgeManager;
    private PetManager petManager;
    private ReservedNicknameManager reservedNicknameManager;
    private final Map<UUID, Boolean> adminModePlayers = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> aiChatCooldown = new HashMap<UUID, Long>();
    private long aiChatCooldownDuration;
    private boolean aiChatCooldownEnabled;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).build();
    private final Gson gson = new Gson();
    private boolean hasCriticalError = false;
    private OverloadedKeyManager overloadedKeyManager;
    private long globalKeyCooldownDuration;
    private long playerKeyCooldownDuration;
    private String guiColorScheme;
    private String adminGuiColorScheme;
    private boolean petsEnabled;
    private boolean memoryEnabled;
    private boolean chatsEnabled;
    private boolean knowledgeEnabled;
    public final Map<UUID, Boolean> aiStatus = new HashMap<UUID, Boolean>();

    public String getKnowledgeBaseColor() {
        return this.knowledgeBaseColor;
    }

    public boolean isSimpleKnowledgeYmlApprove() {
        return this.simpleKnowledgeYmlApprove;
    }

    public boolean isDataCommandEnabled() {
        return this.dataCommandEnabled;
    }

    public boolean isAdminDisableCommandEnabled() {
        return this.adminDisableCommandEnabled;
    }

    public boolean isVersionCommandEnabled() {
        return this.versionCommandEnabled;
    }

    public boolean isAddConfirmCommandEnabled() {
        return this.addConfirmCommandEnabled;
    }

    public boolean isRemoveConfirmCommandEnabled() {
        return this.removeConfirmCommandEnabled;
    }

    public boolean isReloadCommandEnabled() {
        return this.reloadCommandEnabled;
    }

    public void reloadFeaturesConfig() {
        File featuresFile = new File(this.getDataFolder(), "features.yml");
        if (!featuresFile.exists()) {
            this.saveResource("features.yml", false);
        }
        this.featuresConfig = YamlConfiguration.loadConfiguration((File)featuresFile);
        this.loadConfig();
        this.getLogger().info("features.yml reloaded.");
    }

    public void reloadNSR_AIPlugin() {
        this.getLogger().info("Attempting to reload NSR-AI plugin...");
        this.reloadPlugin();
        this.getLogger().info("NSR-AI plugin (configs and knowledge base) reloaded.");
    }

    public void reloadKnowledgeBase() {
        this.knowledgeManager.loadKnowledgeBase();
        this.getLogger().info("Knowledge base reloaded.");
    }

    private void reloadPlugin() {
        this.reloadConfig();
        File featuresFile = new File(this.getDataFolder(), "features.yml");
        if (!featuresFile.exists()) {
            this.saveResource("features.yml", false);
        }
        this.featuresConfig = YamlConfiguration.loadConfiguration((File)featuresFile);
        this.loadConfig();
        this.apiKeyManager = new ApiKeyManager(this, this.apiKeys);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            this.apiKeyManager.validateKeys(this.defaultGeminiModel, this.defaultClaudeModel, this.defaultOpenAIModel);
            if (this.apiKeyManager.getApiKeys().stream().noneMatch(key -> key.getStatus() == ApiKeyManager.ApiKey.KeyStatus.ACTIVE)) {
                this.setCriticalError(true);
                this.getLogger().severe("[NSR-AI] No active API keys found after validation. AI functionality will be limited.");
            }
        });
        this.overloadedKeyManager = new OverloadedKeyManager(this, this.globalKeyCooldownDuration, this.playerKeyCooldownDuration);
        this.conversationManager = new ConversationManager(this.featuresConfig.getInt("conversation-history-length", 10));
        this.knowledgeManager.loadKnowledgeBase();
        this.addonManager.reloadAddons();
        this.getLogger().info("NSR-AI plugin configuration and managers reloaded successfully.");
    }

    public boolean isMemoryClearEnabled() {
        return this.memoryClearEnabled;
    }

    public boolean isMemoryRefreshEnabled() {
        return this.memoryRefreshEnabled;
    }

    public boolean isCacheClearEnabled() {
        return this.cacheClearEnabled;
    }

    public boolean isCacheRefreshEnabled() {
        return this.cacheRefreshEnabled;
    }

    public void setCriticalError(boolean status) {
        this.hasCriticalError = status;
    }

    public void onEnable() {
        instance = this;
        NSRaiAPI.setInternalApiInstance((Object)this);
        ConfigUpdater configUpdater = new ConfigUpdater(this);
        configUpdater.updateConfigs();
        File featuresFile = new File(this.getDataFolder(), "features.yml");
        if (!featuresFile.exists()) {
            this.saveResource("features.yml", false);
        }
        this.featuresConfig = YamlConfiguration.loadConfiguration((File)featuresFile);
        this.securityUtil = new SecurityUtil(this);
        this.configEncryptor = new ConfigEncryptor(this);
        this.playerSecurityManager = new PlayerSecurityManager(this);
        this.apiKeyStorage = new ApiKeyStorage(this);
        this.loadConfig();
        this.addonManager = new AddonManager(this);
        this.securityManager = new SecurityManager(this, this.addonManager);
        if (!this.securityManager.initialize()) {
            this.getLogger().severe("[NSR-AI] Security system failed to initialize. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.updateChecker = new UpdateChecker(this, "https://nsr-ai-security.1987sakshamsingh.workers.dev/version");
        this.confirmationManager = new ConfirmationManager(this);
        this.chatLogger = new ChatLogger(this);
        this.knowledgeManager = new KnowledgeManager(this);
        this.petManager = new PetManager(this);
        this.reservedNicknameManager = new ReservedNicknameManager(this);
        this.playerApiKeyManager = new PlayerApiKeyManager(this);
        this.privacyManager = new PrivacyManager(this);
        this.overloadedKeyManager = new OverloadedKeyManager(this, this.globalKeyCooldownDuration, this.playerKeyCooldownDuration);
        this.apiKeyManager = new ApiKeyManager(this, this.apiKeys);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            this.apiKeyManager.validateKeys(this.defaultGeminiModel, this.defaultClaudeModel, this.defaultOpenAIModel);
            if (this.apiKeyManager.getApiKeys().stream().noneMatch(key -> key.getStatus() == ApiKeyManager.ApiKey.KeyStatus.ACTIVE)) {
                this.setCriticalError(true);
                this.getLogger().severe("[NSR-AI] No active API keys found after validation. AI functionality will be limited.");
            }
        });
        this.conversationManager = new ConversationManager(this.featuresConfig.getInt("conversation-history-length", 10));
        this.addonManager.loadAddons();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.securityManager.checkAndPerformUpdate(), 1200L, 1200L);
        this.bugFixManager = new BugFixManager(this);
        this.bugFixManager.initialize();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PetListener(this, this.petManager), (Plugin)this);
        this.commandManager = new CommandManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.commandManager, (Plugin)this);
        this.getCommand("ai").setExecutor((CommandExecutor)this.commandManager);
        this.getCommand("ai").setTabCompleter((TabCompleter)this.commandManager);
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||====================================================||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||                                                    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||   _   _   _____    _____                 _____    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  | \\ | | / ____|  |  __ \\      /\\      |_   _|   ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  |  \\| | | (___   | |__) |    /  \\        | |     ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  | . ` |  \\___ \\  |  _  /    / /\\ \\       | |      ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  | |\\  |  ____) | | | \\ \\   / ____ \\     _| |_     ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  |_| \\_| |_____/  |_|  \\_\\ /_/    \\_\\   |_____|    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||                                                    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||                    Version: " + String.valueOf(ChatColor.WHITE) + this.getDescription().getVersion() + "                     " + String.valueOf(ChatColor.AQUA) + "||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||               " + String.valueOf(ChatColor.GREEN) + "Thanks for downloading!" + String.valueOf(ChatColor.AQUA) + "              ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||               " + String.valueOf(ChatColor.AQUA) + "Developed by: " + String.valueOf(ChatColor.GOLD) + "BlackForge" + String.valueOf(ChatColor.AQUA) + "             ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||                                                    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||====================================================||");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            this.updateChecker.checkForUpdates();
            if (this.updateChecker.isOutdated()) {
                this.getLogger().info(String.valueOf(ChatColor.RED) + "-----------------------------------------------------------------");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| Your NSR-AI plugin is outdated!                              ||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| Latest version: " + String.valueOf(ChatColor.YELLOW) + this.updateChecker.getLatestVersion() + String.valueOf(ChatColor.RED) + " (You are using: " + String.valueOf(ChatColor.GRAY) + this.updateChecker.getCurrentVersion() + String.valueOf(ChatColor.RED) + ")                    ||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| Please download the latest version from:                     ||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| " + String.valueOf(ChatColor.GREEN) + "Modrinth: " + String.valueOf(ChatColor.BLUE) + "https://modrinth.com/plugin/nsr-ai                " + String.valueOf(ChatColor.RED) + "||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| " + String.valueOf(ChatColor.GOLD) + "SpigotMC: " + String.valueOf(ChatColor.BLUE) + "https://www.spigotmc.org/resources/nsr-ai.127717/ " + String.valueOf(ChatColor.RED) + "||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| " + String.valueOf(ChatColor.AQUA) + "Polymart: " + String.valueOf(ChatColor.BLUE) + "https://polymart.org/product/8380/nsr-ai          " + String.valueOf(ChatColor.RED) + "||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "-----------------------------------------------------------------");
            } else {
                this.getLogger().info(String.valueOf(ChatColor.GREEN) + "NSR-AI plugin is up to date!");
            }
        });
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.petManager.loadPetsForPlayer(player);
        }
        this.petManager.loadAllPets();
    }

    public static NSRAIPlugin getInstance() {
        return instance;
    }

    public void onDisable() {
        if (this.addonManager != null) {
            this.addonManager.unloadAddons();
        }
        if (this.hasCriticalError) {
            String statusMessage = String.valueOf(ChatColor.AQUA) + "\"NSR-AI\" has been " + String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED (Errors Found)!";
            this.getLogger().warning(String.valueOf(ChatColor.RED) + " _   _  _____ _____               _____  ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "| \\ | |/ ____|  __ \\        /\\   |_   _| ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "|  \\| | (___ | |__) |_____ /  \\    | |   ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "| . ` |\\___ \\|  _  /______/ /\\ \\   | |   ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "| |\\  |____) | | \\ \\     / ____ \\ _| |_  ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "|_| \\_|_____/|_|  \\_\\   /_/    \\_\\_____| ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "                                         ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "                                         ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||====================================================||");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||                                                    ||");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||   " + statusMessage + String.valueOf(ChatColor.RED) + "                        ||");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||                                                    ||");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||====================================================||");
        } else {
            String statusMessage = String.valueOf(ChatColor.AQUA) + "\"NSR-AI\" has been " + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "DISABLED.";
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + " _   _  _____ _____               _____  ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "| \\ | |/ ____|  __ \\        /\\   |_   _| ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "|  \\| | (___ | |__) |_____ /  \\    | |   ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "| . ` |\\___ \\|  _  /______/ /\\ \\   | |   ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "| |\\  |____) | | \\ \\     / ____ \\ _| |_  ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "|_| \\_|_____/|_|  \\_\\   /_/    \\_\\_____| ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "                                         ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "                                         ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||====================================================||");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||                                                    ||");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||   " + statusMessage + String.valueOf(ChatColor.GREEN) + "                      ||");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||                                                    ||");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||====================================================||");
        }
    }

    public void loadConfig() {
        FileConfiguration config = this.getConfig();
        File configFile = new File(this.getDataFolder(), "config.yml");
        boolean changesMade = false;
        String currentAdminCode = config.getString("admin-activation-code");
        if (currentAdminCode == null || currentAdminCode.isEmpty()) {
            String newCode = new SecureRandom().ints(5L, 0, 10).mapToObj(String::valueOf).collect(Collectors.joining());
            config.set("admin-activation-code", (Object)newCode);
            changesMade = true;
        }
        if (this.configEncryptor.encryptIfNecessary(config, "admin-activation-code")) {
            changesMade = true;
        }
        this.adminActivationCode = this.configEncryptor.getDecryptedString(config, "admin-activation-code");
        if (this.configEncryptor.encryptStringListIfNecessary(config, "api-keys")) {
            changesMade = true;
        }
        if (changesMade) {
            this.saveConfig();
        }
        this.apiKeys = this.configEncryptor.getDecryptedStringList(config, "api-keys");
        this.defaultGeminiModel = config.getString("default-gemini-model", "gemini-2.0-flash");
        this.defaultClaudeModel = config.getString("default-claude-model", "claude-3-opus-20240229");
        this.defaultOpenAIModel = config.getString("default-openai-model", "gpt-4");
        this.defaultApiProvider = config.getString("default-api-provider", "all");
        this.aiChatColor = "&b";
        this.userChatColor = "&7";
        this.aiPrefix = this.colorize("&b[AI]");
        this.userPrefix = this.colorize("&7[You]");
        this.adminAiPrefix = this.colorize("&c[AI]");
        this.aiNotConfiguredMessage = this.colorize("&cThe AI chat is not configured correctly. Please contact the server owner.");
        this.apiErrorMessage = this.colorize("&cAPI Error: Could not get a response from the AI. Please try again later.");
        this.permissionDeniedMessage = this.colorize("&cI don't have permission to fulfill that request for you.");
        this.noValidKeysMessage = this.colorize("&cThere are no valid API keys available. Please contact the server owner.");
        this.allKeysRateLimitedMessage = this.colorize("&cAll API keys are currently rate-limited. Please try again later.");
        this.systemPrompt = "You are a helpful AI.";
        this.codeBlockerEnabled = true;
        this.codeBlockerMessage = this.colorize("&cThis is a game built for fun and answering, not for coding.");
        this.knowledgeBaseColor = "&a";
        this.simpleKnowledgeYmlApprove = false;
        this.dataCommandEnabled = true;
        this.adminDisableCommandEnabled = true;
        this.versionCommandEnabled = true;
        this.addConfirmCommandEnabled = true;
        this.removeConfirmCommandEnabled = true;
        this.reloadCommandEnabled = true;
        this.memoryClearEnabled = true;
        this.memoryRefreshEnabled = true;
        this.cacheClearEnabled = true;
        this.cacheRefreshEnabled = true;
        this.aiChatCooldownEnabled = false;
        this.aiChatCooldownDuration = 5000L;
        this.globalKeyCooldownDuration = config.getLong("global-key-cooldown-duration", 300000L);
        this.playerKeyCooldownDuration = config.getLong("player-key-cooldown-duration", 60000L);
        if (this.featuresConfig != null) {
            this.aiChatCooldownEnabled = this.featuresConfig.getBoolean("chat-cooldown.enabled", this.aiChatCooldownEnabled);
            this.aiChatCooldownDuration = this.featuresConfig.getLong("chat-cooldown.duration", this.aiChatCooldownDuration);
            this.aiChatColor = this.featuresConfig.getString("chat-colors.ai", this.aiChatColor);
            this.userChatColor = this.featuresConfig.getString("chat-colors.user", this.userChatColor);
            this.aiPrefix = this.colorize(this.featuresConfig.getString("chat-prefixes.ai", this.aiPrefix));
            this.userPrefix = this.colorize(this.featuresConfig.getString("chat-prefixes.user", this.userPrefix));
            this.adminAiPrefix = this.colorize(this.featuresConfig.getString("chat-prefixes.admin-ai", this.adminAiPrefix));
            this.aiNotConfiguredMessage = this.colorize(this.featuresConfig.getString("messages.ai-not-configured", this.aiNotConfiguredMessage));
            this.apiErrorMessage = this.colorize(this.featuresConfig.getString("messages.api-error", this.apiErrorMessage));
            this.permissionDeniedMessage = this.colorize(this.featuresConfig.getString("messages.permission-denied", this.permissionDeniedMessage));
            this.noValidKeysMessage = this.colorize(this.featuresConfig.getString("messages.no-valid-keys", this.noValidKeysMessage));
            this.allKeysRateLimitedMessage = this.colorize(this.featuresConfig.getString("messages.all-keys-rate-limited", this.allKeysRateLimitedMessage));
            this.globalKeyFailMessage = this.featuresConfig.getStringList("messages.global-key-fail").stream().map(this::colorize).collect(Collectors.toList());
            this.systemPrompt = this.featuresConfig.getString("system-prompt", this.systemPrompt);
            this.codeBlockerEnabled = this.featuresConfig.getBoolean("code-blocker.enabled", this.codeBlockerEnabled);
            this.codeBlockerMessage = this.colorize(this.featuresConfig.getString("code-blocker.message", this.codeBlockerMessage));
            this.knowledgeBaseColor = this.featuresConfig.getString("chat-colors.knowledge-base", this.knowledgeBaseColor);
            this.simpleKnowledgeYmlApprove = this.featuresConfig.getBoolean("simple-knowledge-yml-approve", this.simpleKnowledgeYmlApprove);
            this.dataCommandEnabled = this.featuresConfig.getBoolean("command-toggles.data", this.dataCommandEnabled);
            this.adminDisableCommandEnabled = this.featuresConfig.getBoolean("command-toggles.admin-disable", this.adminDisableCommandEnabled);
            this.versionCommandEnabled = this.featuresConfig.getBoolean("command-toggles.version", this.versionCommandEnabled);
            this.addConfirmCommandEnabled = this.featuresConfig.getBoolean("command-toggles.add-confirm", this.addConfirmCommandEnabled);
            this.removeConfirmCommandEnabled = this.featuresConfig.getBoolean("command-toggles.remove-confirm", this.removeConfirmCommandEnabled);
            this.reloadCommandEnabled = this.featuresConfig.getBoolean("command-toggles.reload", this.reloadCommandEnabled);
            this.memoryClearEnabled = this.featuresConfig.getBoolean("command-toggles.memory-clear", this.memoryClearEnabled);
            this.memoryRefreshEnabled = this.featuresConfig.getBoolean("command-toggles.memory-refresh", this.memoryRefreshEnabled);
            this.cacheClearEnabled = this.featuresConfig.getBoolean("command-toggles.cache-clear", this.cacheClearEnabled);
            this.guiColorScheme = this.featuresConfig.getString("gui-color-scheme", "&1");
            this.petsEnabled = this.featuresConfig.getBoolean("global-toggles.pets", true);
            this.memoryEnabled = this.featuresConfig.getBoolean("global-toggles.memory", true);
            this.chatsEnabled = this.featuresConfig.getBoolean("global-toggles.chats", true);
            this.knowledgeEnabled = this.featuresConfig.getBoolean("global-toggles.knowledge", true);
            this.adminGuiColorScheme = this.featuresConfig.getString("admin-gui-color-scheme", "&c");
            this.cacheRefreshEnabled = this.featuresConfig.getBoolean("command-toggles.cache-refresh", this.cacheRefreshEnabled);
        }
    }

    public void handleAIConversation(Player player, String message, boolean isAdmin, String provider, String mode) {
        long timeLeft;
        if (this.aiChatCooldownEnabled && this.aiChatCooldown.containsKey(player.getUniqueId()) && (timeLeft = this.aiChatCooldown.get(player.getUniqueId()) + this.aiChatCooldownDuration - System.currentTimeMillis()) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + String.format("%.1f", (double)timeLeft / 1000.0) + " seconds before using the AI chat again.");
            return;
        }
        this.chatLogger.log(player, message, isAdmin, false);
        String finalMessage = message;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String response = null;
            boolean success = false;
            boolean playerHasKeys = this.playerApiKeyManager.hasApiKeys(player.getUniqueId());
            boolean fallbackEnabled = this.playerApiKeyManager.isFallbackEnabled(player.getUniqueId());
            if (playerHasKeys) {
                ArrayList<PlayerApiKeyManager.ApiKey> playerKeys = new ArrayList<PlayerApiKeyManager.ApiKey>(this.playerApiKeyManager.getAllKeys(player));
                PlayerApiKeyManager.ApiKey usingKey = playerKeys.stream().filter(k -> k.getStatus() == PlayerApiKeyManager.ApiKey.KeyStatus.USING).findFirst().orElse(null);
                if (usingKey != null) {
                    try {
                        ApiKeyManager.ApiKey tempKey = new ApiKeyManager.ApiKey(usingKey.getApiKey());
                        tempKey.setType(ApiKeyManager.ApiKey.Type.fromString(usingKey.getProvider().name()));
                        tempKey.setModel(usingKey.getModel());
                        response = this.callAppropriateApi(player, finalMessage, tempKey);
                        usingKey.incrementUsageCount();
                        success = true;
                    }
                    catch (IOException e) {
                        usingKey.incrementFallbackCount();
                        this.handlePlayerApiError(player, usingKey, e);
                        success = false;
                    }
                }
                if (!success) {
                    for (PlayerApiKeyManager.ApiKey pKey : playerKeys) {
                        if (pKey.getStatus() != PlayerApiKeyManager.ApiKey.KeyStatus.ACTIVE) continue;
                        try {
                            pKey.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.USING);
                            ApiKeyManager.ApiKey tempKey = new ApiKeyManager.ApiKey(pKey.getApiKey());
                            tempKey.setType(ApiKeyManager.ApiKey.Type.fromString(pKey.getProvider().name()));
                            tempKey.setModel(pKey.getModel());
                            response = this.callAppropriateApi(player, finalMessage, tempKey);
                            pKey.incrementUsageCount();
                            success = true;
                            break;
                        }
                        catch (IOException e) {
                            pKey.incrementFallbackCount();
                            this.handlePlayerApiError(player, pKey, e);
                        }
                    }
                }
            }
            if (!(success || playerHasKeys && !fallbackEnabled)) {
                ArrayList<ApiKeyManager.ApiKey> globalKeys = new ArrayList<ApiKeyManager.ApiKey>(this.apiKeyManager.getApiKeys());
                for (ApiKeyManager.ApiKey gKey : globalKeys) {
                    if (gKey.getStatus() == ApiKeyManager.ApiKey.KeyStatus.INACTIVE || this.overloadedKeyManager.isOverloaded(gKey)) continue;
                    try {
                        response = this.callAppropriateApi(player, finalMessage, gKey);
                        success = true;
                        break;
                    }
                    catch (IOException e) {
                        gKey.incrementFallbackCount();
                        this.logGlobalApiError(gKey, e);
                    }
                }
            }
            if (success) {
                String finalResponse = this.filterCodeSnippets(response, isAdmin);
                this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("user", finalMessage));
                this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("assistant", finalResponse));
                this.chatLogger.log(player, finalResponse, isAdmin, true);
                String rawAiMessage = this.aiPrefix + this.aiChatColor + finalResponse;
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.colorize(rawAiMessage)));
                if (this.aiChatCooldownEnabled) {
                    this.aiChatCooldown.put(player.getUniqueId(), System.currentTimeMillis());
                }
            } else if (!playerHasKeys || fallbackEnabled) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    for (String line : this.globalKeyFailMessage) {
                        player.sendMessage(line);
                    }
                });
            }
        });
    }

    public void handleGlobalAIConversation(Player player, String message, boolean isAdmin) {
        this.chatLogger.log(player, message, isAdmin, false);
        String finalMessage = message;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String response = null;
            boolean success = false;
            ArrayList<ApiKeyManager.ApiKey> globalKeys = new ArrayList<ApiKeyManager.ApiKey>(this.apiKeyManager.getApiKeys());
            for (ApiKeyManager.ApiKey gKey : globalKeys) {
                if (gKey.getStatus() == ApiKeyManager.ApiKey.KeyStatus.INACTIVE || this.overloadedKeyManager.isOverloaded(gKey)) continue;
                try {
                    response = this.callAppropriateApi(player, finalMessage, gKey);
                    success = true;
                    break;
                }
                catch (IOException e) {
                    gKey.incrementFallbackCount();
                    this.logGlobalApiError(gKey, e);
                }
            }
            if (success) {
                String finalResponse = this.filterCodeSnippets(response, isAdmin);
                this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("user", finalMessage));
                this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("assistant", finalResponse));
                this.chatLogger.log(player, finalResponse, isAdmin, true);
                String rawAiMessage = this.aiPrefix + this.aiChatColor + finalResponse;
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.colorize(rawAiMessage)));
            } else {
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    for (String line : this.globalKeyFailMessage) {
                        player.sendMessage(line);
                    }
                });
            }
        });
    }

    private void handlePlayerApiError(Player player, PlayerApiKeyManager.ApiKey key, IOException e) {
        String[] messageToSend;
        String errorMessage = e.getMessage();
        String code = this.extractErrorCode(errorMessage);
        if (e instanceof SocketTimeoutException || errorMessage.toLowerCase().contains("timeout")) {
            key.incrementFallbackCount();
            messageToSend = new String[]{String.valueOf(ChatColor.YELLOW) + "Error: Timeout. " + String.valueOf(ChatColor.GRAY) + "Suggestion: The request timed out. Trying next key..."};
        } else if (errorMessage.contains("401")) {
            key.incrementErrorCount();
            key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.INVALID);
            messageToSend = new String[]{String.valueOf(ChatColor.RED) + "Error " + code + ": Invalid API Key. " + String.valueOf(ChatColor.GRAY) + "Suggestion: Check your key is correct and active."};
        } else if (errorMessage.contains("models/") && errorMessage.contains("is not found")) {
            key.incrementErrorCount();
            key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.INACTIVE);
            messageToSend = new String[]{String.valueOf(ChatColor.RED) + "Error " + code + ": Model Not Found. " + String.valueOf(ChatColor.GRAY) + "Suggestion: Change to a valid model for the " + key.getProvider().name() + " provider."};
        } else if (errorMessage.contains("429")) {
            key.incrementErrorCount();
            this.overloadedKeyManager.setOverloaded(key);
            key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.OVERLOADED);
            messageToSend = new String[]{String.valueOf(ChatColor.RED) + "Error " + code + ": Rate Limit Exceeded. " + String.valueOf(ChatColor.GRAY) + "Suggestion: Please wait a moment before trying again. This key is temporarily disabled."};
        } else if (errorMessage.contains("insufficient_quota")) {
            key.incrementErrorCount();
            key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.LIMIT_REACHED);
            messageToSend = new String[]{String.valueOf(ChatColor.RED) + "Error " + code + ": Quota/Billing Issue. " + String.valueOf(ChatColor.GRAY) + "Suggestion: Check your API provider dashboard for billing status and limits. This key is temporarily disabled."};
        } else if (errorMessage.contains("API key expired")) {
            key.incrementErrorCount();
            key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.INACTIVE);
            messageToSend = new String[]{String.valueOf(ChatColor.RED) + "Error " + code + ": API Key Expired. " + String.valueOf(ChatColor.GRAY) + "Suggestion: Your API key has expired. Please renew it."};
        } else {
            key.incrementErrorCount();
            key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.INVALID);
            messageToSend = new String[]{String.valueOf(ChatColor.RED) + "Error " + code + ": Unknown API Error. " + String.valueOf(ChatColor.GRAY) + "Suggestion: Please validate your key and model permissions."};
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            for (String line : messageToSend) {
                player.sendMessage(line);
            }
        });
    }

    private void logGlobalApiError(ApiKeyManager.ApiKey key, IOException e) {
        Object suggestion;
        String errorName;
        String errorMessage = e.getMessage();
        String code = this.extractErrorCode(errorMessage);
        if (e instanceof SocketTimeoutException || errorMessage.toLowerCase().contains("timeout")) {
            key.incrementFallbackCount();
            errorName = "Request Timed Out";
            suggestion = "The service may be overloaded or unreachable. Check network connectivity.";
        } else if (errorMessage.contains("401")) {
            key.setStatus(ApiKeyManager.ApiKey.KeyStatus.INVALID);
            errorName = "Invalid API Key";
            suggestion = "Please check the key in your config.yml.";
        } else if (errorMessage.contains("429")) {
            this.overloadedKeyManager.setOverloaded(key);
            key.setStatus(ApiKeyManager.ApiKey.KeyStatus.OVERLOADED);
            errorName = "Rate Limit Exceeded";
            suggestion = "Please wait a moment before trying again. This key is temporarily disabled.";
        } else if (errorMessage.contains("insufficient_quota")) {
            key.setStatus(ApiKeyManager.ApiKey.KeyStatus.LIMIT_REACHED);
            errorName = "Quota/Billing Issue";
            suggestion = "Check your API provider dashboard for billing status and rate limits. This key is temporarily disabled.";
        } else if (errorMessage.contains("models/") && errorMessage.contains("is not found")) {
            key.setStatus(ApiKeyManager.ApiKey.KeyStatus.INACTIVE);
            errorName = "Model Not Found";
            suggestion = "Change to a valid model for the " + key.getType().name() + " provider.";
        } else if (errorMessage.contains("API key expired")) {
            key.setStatus(ApiKeyManager.ApiKey.KeyStatus.INACTIVE);
            errorName = "API Key Expired";
            suggestion = "Your API key has expired. Please renew it.";
        } else {
            key.setStatus(ApiKeyManager.ApiKey.KeyStatus.INVALID);
            errorName = "Unknown Error";
            suggestion = "Check the full error body for details.";
        }
        String typeName = key.getType() != null ? key.getType().name() : "UNKNOWN";
        this.getLogger().warning(String.format("[NSR-AI] Global %s Key Failure. Error %s: %s. Suggestion: %s", typeName, code, errorName, suggestion));
    }

    private String extractErrorCode(String errorMessage) {
        if (errorMessage == null) {
            return "N/A";
        }
        Pattern pattern = Pattern.compile("API Error: (\\d{3})");
        Matcher matcher = pattern.matcher(errorMessage);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "N/A";
    }

    private String callAppropriateApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String model = apiKey.getModel();
        if (model == null || model.isEmpty()) {
            model = this.getDefaultModelForProvider(apiKey.getType());
        }
        switch (apiKey.getType()) {
            case CLAUDE: {
                return this.callClaudeApi(player, prompt, apiKey, model);
            }
            case OPENAI: {
                return this.callOpenAIApi(player, prompt, apiKey, model);
            }
        }
        return this.callGeminiApi(player, prompt, apiKey, model);
    }

    private String getDefaultModelForProvider(ApiKeyManager.ApiKey.Type type) {
        switch (type) {
            case GEMINI: {
                return this.defaultGeminiModel;
            }
            case CLAUDE: {
                return this.defaultClaudeModel;
            }
            case OPENAI: {
                return this.defaultOpenAIModel;
            }
        }
        return this.defaultGeminiModel;
    }

    private String filterCodeSnippets(String response, boolean isAdmin) {
        if (isAdmin) {
            return response;
        }
        if (response == null) {
            return "";
        }
        if (response.matches(".*```[\\w\\W]*?```.*")) {
            return this.codeBlockerMessage;
        }
        return response;
    }

    private String callGeminiApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey, String model) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://generativelanguage.googleapis.com/v1/models/" + model + ":generateContent?key=" + apiKey.getKey();
        JsonArray contents = new JsonArray();
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        StringBuilder systemInstructions = new StringBuilder();
        ArrayList<ConversationManager.Message> filteredHistory = new ArrayList<ConversationManager.Message>();
        for (ConversationManager.Message message : history) {
            if (message.getRole().equals("system")) {
                systemInstructions.append(message.getContent()).append("\n");
                continue;
            }
            filteredHistory.add(message);
        }
        Object finalPrompt = prompt;
        if (systemInstructions.length() > 0) {
            finalPrompt = systemInstructions.toString().trim() + "\n" + (String)prompt;
        }
        for (ConversationManager.Message message : filteredHistory) {
            JsonObject message2 = new JsonObject();
            message2.addProperty("role", message.getRole().equals("assistant") ? "model" : message.getRole());
            JsonObject part = new JsonObject();
            part.addProperty("text", message.getContent());
            message2.add("parts", this.gson.toJsonTree(new JsonObject[]{part}));
            contents.add(message2);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("role", "user");
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.addProperty("text", (String)finalPrompt);
        jsonObject.add("parts", this.gson.toJsonTree(new JsonObject[]{jsonObject2}));
        contents.add(jsonObject);
        JsonObject requestBody = new JsonObject();
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        int retries = 0;
        if (retries < 3) {
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
                return string;
            }
        }
        throw new IOException("Gemini API call failed after 3 retries.");
    }

    private String callClaudeApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey, String model) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://api.anthropic.com/v1/messages";
        JsonArray messages = new JsonArray();
        if (this.systemPrompt != null && !this.systemPrompt.isEmpty()) {
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("role", "system");
            systemMessage.addProperty("content", this.systemPrompt);
            messages.add(systemMessage);
        }
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        for (ConversationManager.Message msg : history) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            message.addProperty("content", msg.getContent());
            messages.add(message);
        }
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", (String)prompt);
        messages.add(userMessage);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("model", model);
        requestBody.addProperty("max_tokens", 1024);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        int retries = 0;
        if (retries < 3) {
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
                return string;
            }
        }
        throw new IOException("Claude API call failed after 3 retries.");
    }

    private String callOpenAIApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey, String model) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://api.openai.com/v1/chat/completions";
        JsonArray messages = new JsonArray();
        if (this.systemPrompt != null && !this.systemPrompt.isEmpty()) {
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("role", "system");
            systemMessage.addProperty("content", this.systemPrompt);
            messages.add(systemMessage);
        }
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        for (ConversationManager.Message msg : history) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            message.addProperty("content", msg.getContent());
            messages.add(message);
        }
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", (String)prompt);
        messages.add(userMessage);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("model", model);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        int retries = 0;
        if (retries < 3) {
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
                return string;
            }
        }
        throw new IOException("OpenAI API call failed after 3 retries.");
    }

    public String generateAIHeading(String originalContent, String aiResponse, String keyword) {
        String prompt = "Generate a descriptive and concise heading (single phrase or short sentence) for the following knowledge base entry. The heading should accurately summarize the content and be suitable for a knowledge base key. Consider the provided keyword for context.\nKeyword: " + keyword + "\nOriginal Content: " + originalContent + "\nAI Response: " + aiResponse + "\nHeading:";
        String model = this.defaultGeminiModel;
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider);
        if (apiKey == null) {
            this.getLogger().log(Level.WARNING, "No valid API key available for AI heading generation.");
            return "Generated Heading";
        }
        try {
            return (switch (apiKey.getType()) {
                case ApiKeyManager.ApiKey.Type.CLAUDE -> this.callClaudeApiForHeading(prompt, apiKey);
                case ApiKeyManager.ApiKey.Type.OPENAI -> this.callOpenAIApiForHeading(prompt, apiKey);
                default -> this.callGeminiApiForHeading(prompt, apiKey);
            }).trim();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error generating AI heading: " + e.getMessage(), e);
            return "Generated Heading";
        }
    }

    public String getCorrectedContent(String originalContent) {
        String prompt = "You are a grammar and spelling correction tool. Your task is to correct the following text. Do not add any new information, commentary, or change the meaning. Only output the corrected text.\n\nExample:\nOriginal Text: that punsihment are no griefing 7 dyas ban\nCorrected Text: The punishment for griefing is a 7-day ban.\n\nOriginal Text: " + originalContent + "\nCorrected Text:";
        String model = this.defaultGeminiModel;
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider);
        if (apiKey == null) {
            this.getLogger().log(Level.WARNING, "No valid API key available for content correction.");
            return originalContent;
        }
        try {
            return (switch (apiKey.getType()) {
                case ApiKeyManager.ApiKey.Type.CLAUDE -> this.callClaudeApiForCorrection(prompt, apiKey);
                case ApiKeyManager.ApiKey.Type.OPENAI -> this.callOpenAIApiForCorrection(prompt, apiKey);
                default -> this.callGeminiApiForCorrection(prompt, apiKey);
            }).trim();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error correcting content: " + e.getMessage(), e);
            return originalContent;
        }
    }

    private String callGeminiApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            if (!jsonResponse.has("candidates")) {
                this.getLogger().log(Level.SEVERE, "Gemini API error response: " + responseBody);
                throw new IOException("Gemini API returned an error: " + responseBody);
            }
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callClaudeApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.anthropic.com/v1/messages";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultClaudeModel);
        requestBody.addProperty("max_tokens", 1024);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callOpenAIApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.openai.com/v1/chat/completions";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultOpenAIModel);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
            return string;
        }
    }

    private String callGeminiApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            if (!jsonResponse.has("candidates")) {
                this.getLogger().log(Level.SEVERE, "Gemini API error response: " + responseBody);
                throw new IOException("Gemini API returned an error: " + responseBody);
            }
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callClaudeApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.anthropic.com/v1/messages";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultClaudeModel);
        requestBody.addProperty("max_tokens", 100);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callOpenAIApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.openai.com/v1/chat/completions";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultOpenAIModel);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
            return string;
        }
    }

    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    public PetManager getPetManager() {
        return this.petManager;
    }

    public ReservedNicknameManager getReservedNicknameManager() {
        return this.reservedNicknameManager;
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        this.petManager.loadPetsForPlayer(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.adminModePlayers.containsKey(player.getUniqueId())) {
            this.adminModePlayers.remove(player.getUniqueId());
            player.sendMessage(this.colorize("&aYour admin mode has been automatically disabled due to quitting the server."));
        }
        this.conversationManager.clearHistory(event.getPlayer().getUniqueId());
        this.playerApiKeyManager.clearApiKeys(player.getUniqueId());
        this.petManager.unloadPetsForPlayer(player);
        this.playerApiKeyManager.clearApiKeys(player.getUniqueId());
        this.chatLogger.recordPlayerQuit(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (event.isSneaking() && this.adminModePlayers.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            this.adminModePlayers.remove(player.getUniqueId());
            player.sendMessage(this.colorize("&aYour admin mode has been automatically disabled due to crouching."));
        }
    }

    public Plugin getPlugin() {
        return this;
    }

    public String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String refineResponse(String response, String userQuery) {
        if (userQuery.toLowerCase().contains("date") && response.matches(".*\\d{4}-\\d{2}-\\d{2}.*\\d{2}:\\d{2}:\\d{2}.*")) {
            try {
                Pattern pattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})");
                Matcher matcher = pattern.matcher(response);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error refining date from response: " + e.getMessage());
            }
        }
        return response;
    }

    public void addKnowledgeEntry(String keyword, String aiGeneratedHeading, String aiResponse) {
        String compositeKey = keyword.toLowerCase() + "/" + aiGeneratedHeading.toLowerCase();
        this.getLogger().info("Adding to knowledgeBase map: " + compositeKey);
        this.knowledgeManager.addKnowledge(compositeKey, aiResponse, false);
    }

    public String removeKnowledgeEntry(String key) {
        return this.knowledgeManager.removeKnowledge(key);
    }

    public Map<String, String> getKnowledgeBase() {
        return this.knowledgeManager.getAllKnowledge(true);
    }

    public String getAdminActivationCode() {
        return this.adminActivationCode;
    }

    public Map<UUID, Boolean> getAdminModePlayers() {
        return this.adminModePlayers;
    }

    public ChatLogger getChatLogger() {
        return this.chatLogger;
    }

    public String getGuiColorScheme() {
        return this.guiColorScheme;
    }

    public void setGuiColorScheme(String guiColorScheme) {
        this.guiColorScheme = guiColorScheme;
        this.featuresConfig.set("gui-color-scheme", (Object)guiColorScheme);
        this.saveFeaturesConfig();
    }

    public boolean isPetsEnabled() {
        return this.petsEnabled;
    }

    public void setPetsEnabled(boolean petsEnabled) {
        this.petsEnabled = petsEnabled;
        this.featuresConfig.set("global-toggles.pets", (Object)petsEnabled);
        this.saveFeaturesConfig();
    }

    public boolean isMemoryEnabled() {
        return this.memoryEnabled;
    }

    public void setMemoryEnabled(boolean memoryEnabled) {
        this.memoryEnabled = memoryEnabled;
        this.featuresConfig.set("global-toggles.memory", (Object)memoryEnabled);
        this.saveFeaturesConfig();
    }

    public boolean isChatsEnabled() {
        return this.chatsEnabled;
    }

    public void setChatsEnabled(boolean chatsEnabled) {
        this.chatsEnabled = chatsEnabled;
        this.featuresConfig.set("global-toggles.chats", (Object)chatsEnabled);
        this.saveFeaturesConfig();
    }

    public boolean isKnowledgeEnabled() {
        return this.knowledgeEnabled;
    }

    public void setKnowledgeEnabled(boolean knowledgeEnabled) {
        this.knowledgeEnabled = knowledgeEnabled;
        this.featuresConfig.set("global-toggles.knowledge", (Object)knowledgeEnabled);
        this.saveFeaturesConfig();
    }

    public String getAdminGuiColorScheme() {
        return this.adminGuiColorScheme;
    }

    public void setAdminGuiColorScheme(String adminGuiColorScheme) {
        this.adminGuiColorScheme = adminGuiColorScheme;
        this.featuresConfig.set("admin-gui-color-scheme", (Object)adminGuiColorScheme);
        this.saveFeaturesConfig();
    }

    public void saveFeaturesConfig() {
        try {
            this.featuresConfig.save(new File(this.getDataFolder(), "features.yml"));
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save features.yml", e);
        }
    }

    public boolean isAiEnabled(Player player) {
        return this.aiStatus.getOrDefault(player.getUniqueId(), true);
    }

    public void setAiEnabled(Player player, boolean enabled) {
        this.aiStatus.put(player.getUniqueId(), enabled);
    }

    public String getSecretKey() {
        return "a-very-secret-key-that-is-long-and-random";
    }

    public PlayerApiKeyManager getPlayerApiKeyManager() {
        return this.playerApiKeyManager;
    }

    public PrivacyManager getPrivacyManager() {
        return this.privacyManager;
    }

    public OverloadedKeyManager getOverloadedKeyManager() {
        return this.overloadedKeyManager;
    }

    public ApiKeyManager getApiKeyManager() {
        return this.apiKeyManager;
    }

    public String getPermissionDeniedMessage() {
        return this.permissionDeniedMessage;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public List<String> getApiKeys() {
        return this.apiKeys;
    }

    public String getAiNotConfiguredMessage() {
        return this.aiNotConfiguredMessage;
    }

    public String getDefaultApiProvider() {
        return this.defaultApiProvider;
    }

    public String getUserPrefix() {
        return this.userPrefix;
    }

    public String getUserChatColor() {
        return this.userChatColor;
    }

    public String getAdminAiPrefix() {
        return this.adminAiPrefix;
    }

    public String getAiPrefix() {
        return this.aiPrefix;
    }

    public String getAiChatColor() {
        return this.aiChatColor;
    }

    public String getSummary(List<ConversationManager.Message> history) throws IOException {
        if (history.isEmpty()) {
            return "";
        }
        StringBuilder conversationText = new StringBuilder();
        for (ConversationManager.Message msg : history) {
            conversationText.append(msg.getRole()).append(": ").append(msg.getContent()).append("\n");
        }
        String prompt = "You are a conversation summarizer. Your task is to create a concise summary of the following chat history. Capture the main points and key information, including both user and AI responses. Do not add any commentary. Output only the summary.\n\nConversation History:\n" + conversationText.toString() + "\nSummary:";
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey("gemini");
        if (apiKey == null && (apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider)) == null) {
            throw new IOException("No valid API key available for summarization.");
        }
        return this.callGeminiApiForSummary(prompt, apiKey);
    }

    private String callGeminiApiForSummary(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error during summarization: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            if (!jsonResponse.has("candidates")) {
                this.getLogger().log(Level.SEVERE, "Gemini API error response: " + responseBody);
                throw new IOException("Gemini API returned an error: " + responseBody);
            }
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    public Economy getEconomy() {
        return null;
    }

    public ConfirmationManager getConfirmationManager() {
        return this.confirmationManager;
    }

    public KnowledgeManager getKnowledgeManager() {
        return this.knowledgeManager;
    }

    public void saveLatestSummary(Player player, String summary, String commandType) {
        File summaryDir = new File(this.getDataFolder(), "summarychat/" + player.getName() + "-" + player.getUniqueId().toString());
        if (!summaryDir.exists()) {
            summaryDir.mkdirs();
        }
        File summaryFile = new File(summaryDir, "summary.txt");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(summaryFile, false));){
            writer.write("[Generated by: " + commandType + "]\n");
            writer.write("[Timestamp: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "]\n");
            writer.write(summary);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save latest summary for " + player.getName(), e);
        }
    }

    public void archiveOldSummary(Player player) {
        File summaryFile = new File(this.getDataFolder(), "summarychat/" + player.getName() + "-" + player.getUniqueId().toString() + "/summary.txt");
        if (!summaryFile.exists()) {
            return;
        }
        try {
            String oldSummary = new String(Files.readAllBytes(summaryFile.toPath()));
            if (!oldSummary.isEmpty()) {
                boolean isAdmin = this.getAdminModePlayers().getOrDefault(player.getUniqueId(), false);
                this.chatLogger.log(player, "\n--- Archived Summary ---\n" + oldSummary + "\n--- End of Summary ---", isAdmin, true);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not read old summary for archiving for " + player.getName(), e);
        }
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public void reloadPlayerSession(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            File playerDir = new File(this.chatLogger.getPlayerChatHistoryDir(), player.getName() + "-" + String.valueOf(player.getUniqueId()));
            if (!playerDir.exists() || !playerDir.isDirectory()) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "No chat history found to reload."));
                return;
            }
            File[] logFiles = playerDir.listFiles((dir, name) -> name.startsWith("chat-") && name.endsWith(".log"));
            if (logFiles == null || logFiles.length == 0) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "No chat history found to reload."));
                return;
            }
            File mostRecentLogFile = null;
            long latestTimestamp = 0L;
            int latestSuffix = -1;
            for (File file : logFiles) {
                String fileName = file.getName();
                Pattern pattern = Pattern.compile("chat-(\\d{2}-\\d{2}-\\d{4})(?:-(\\d+))?\\.log");
                Matcher matcher = pattern.matcher(fileName);
                if (!matcher.find()) continue;
                try {
                    int fileSuffix;
                    Date fileDate = new SimpleDateFormat("MM-dd-yyyy").parse(matcher.group(1));
                    int n = fileSuffix = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : 0;
                    if (fileDate.getTime() > latestTimestamp) {
                        latestTimestamp = fileDate.getTime();
                        latestSuffix = fileSuffix;
                        mostRecentLogFile = file;
                        continue;
                    }
                    if (fileDate.getTime() != latestTimestamp || fileSuffix <= latestSuffix) continue;
                    latestSuffix = fileSuffix;
                    mostRecentLogFile = file;
                }
                catch (ParseException e) {
                    this.getLogger().log(Level.WARNING, "Error parsing log file date: " + fileName, e);
                }
            }
            if (mostRecentLogFile == null) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "No readable chat history found to reload."));
                return;
            }
            try {
                List<String> lines = Files.readAllLines(mostRecentLogFile.toPath());
                int historyLength = this.featuresConfig.getInt("conversation-history-length", 10);
                int startIndex = Math.max(0, lines.size() - historyLength * 2);
                ArrayList<ConversationManager.Message> newHistory = new ArrayList<ConversationManager.Message>();
                for (int i = startIndex; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    Pattern messagePattern = Pattern.compile("^\\\\[\\\\d{4}-\\\\d{2}-\\\\d{2} \\\\d{2}:\\\\d{2}:\\\\d{2}\\\\] (.*)");
                    Matcher messageMatcher = messagePattern.matcher(line);
                    if (!messageMatcher.find()) continue;
                    String content = messageMatcher.group(1);
                    if (content.startsWith("[AI]")) {
                        newHistory.add(new ConversationManager.Message("assistant", content.substring(content.indexOf("[AI]") + 5)));
                        continue;
                    }
                    if (!content.startsWith("[" + player.getName() + "]")) continue;
                    newHistory.add(new ConversationManager.Message("user", content.substring(content.indexOf("]") + 2)));
                }
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    this.conversationManager.clearHistory(player.getUniqueId());
                    for (ConversationManager.Message msg : newHistory) {
                        this.conversationManager.addMessage(player.getUniqueId(), msg);
                    }
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your session has been reloaded from your chat history.");
                });
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error reloading session for " + player.getName(), e);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while reloading your session."));
            }
        });
    }

    public void summarizeAndClearSession(Player player) {
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        if (history.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is no conversation history to process.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Summarizing and clearing your session... This may take a moment.");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String summary = this.getSummary(history);
                this.archiveOldSummary(player);
                this.saveLatestSummary(player, summary, "clear");
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    this.conversationManager.clearHistory(player.getUniqueId());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your conversation has been summarized and a new session has started.");
                });
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error processing memory clear for " + player.getName(), e);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while processing your conversation memory."));
            }
        });
    }

    public void summarizeAndRefreshSession(Player player) {
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        if (history.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is no conversation history to process.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Summarizing and refreshing your session... This may take a moment.");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String summary = this.getSummary(history);
                this.archiveOldSummary(player);
                this.saveLatestSummary(player, summary, "refresh");
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    this.conversationManager.clearHistory(player.getUniqueId());
                    this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("system", "Previous conversation summary: " + summary));
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your conversation has been summarized. You can continue your chat.");
                });
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error processing memory refresh for " + player.getName(), e);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while processing your conversation memory."));
            }
        });
    }

    public String readSummaryFromFile(Player player) throws IOException {
        File summaryFile = new File(this.getDataFolder(), "summarychat/" + player.getName() + "-" + player.getUniqueId().toString() + "/summary.txt");
        if (!summaryFile.exists()) {
            return null;
        }
        List<String> lines = Files.readAllLines(summaryFile.toPath());
        StringBuilder summaryContent = new StringBuilder();
        boolean inSummary = false;
        for (String line : lines) {
            if (line.startsWith("[Generated by:") || line.startsWith("[Timestamp:")) continue;
            summaryContent.append(line).append("\n");
        }
        return summaryContent.toString().trim();
    }

    public void processMemoryCommand(Player player, String commandType) {
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        if (history.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is no conversation history to process.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Processing conversation memory... This may take a moment.");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String summary = this.getSummary(history);
                this.archiveOldSummary(player);
                this.saveLatestSummary(player, summary, commandType);
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    if (commandType.equals("clear")) {
                        this.conversationManager.clearHistory(player.getUniqueId());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your conversation has been summarized and a new session has started.");
                    } else if (commandType.equals("refresh")) {
                        try {
                            this.conversationManager.clearHistory(player.getUniqueId());
                            String previousSummary = this.readSummaryFromFile(player);
                            if (previousSummary != null && !previousSummary.isEmpty()) {
                                String summaryStatus = this.getSummaryStatus(player);
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Summary Status: " + summaryStatus);
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Type: cache/memory");
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Command: refresh");
                                this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("system", "Previous conversation summary: " + previousSummary));
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your conversation has been summarized. You can continue your chat.");
                            } else {
                                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "No previous summary found to refresh from. Starting a new session.");
                            }
                        }
                        catch (IOException e) {
                            this.getLogger().log(Level.SEVERE, "Error reading summary for refresh command for " + player.getName(), e);
                            player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while refreshing your session.");
                        }
                    }
                });
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error processing memory command for " + player.getName(), e);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while processing your conversation memory."));
            }
        });
    }

    public void processAndAddKnowledgeEntry(Player player, String keyword, String messageContent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String aiGeneratedHeading = this.generateAIHeading(messageContent, "", keyword);
            if (this.isSimpleKnowledgeYmlApprove()) {
                String code = this.getConfirmationManager().createConfirmation(player.getUniqueId(), "add", keyword + "/" + aiGeneratedHeading, messageContent);
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "--- Knowledge Entry Preview ---"));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "Heading: " + aiGeneratedHeading));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "Content: " + messageContent));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "-------------------------------"));
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please confirm adding this knowledge entry by typing: /ai confirm yes");
                });
            } else {
                String code = this.getConfirmationManager().createConfirmation(player.getUniqueId(), "add", keyword + "/" + aiGeneratedHeading, messageContent);
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "--- Knowledge Entry Preview ---"));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "Heading: " + aiGeneratedHeading));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "Content: " + messageContent));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "-------------------------------"));
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please confirm adding this knowledge entry by typing: /ai confirm " + code);
                });
            }
        });
    }

    public String getSummaryStatus(Player player) {
        long oneDayAgo;
        File summaryFile = new File(this.getDataFolder(), "summarychat/" + player.getName() + "-" + player.getUniqueId().toString() + "/summary.txt");
        if (!summaryFile.exists()) {
            return "No summary found.";
        }
        long lastModified = summaryFile.lastModified();
        if (lastModified > (oneDayAgo = System.currentTimeMillis() - 86400000L)) {
            return "active";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return "old (last updated: " + sdf.format(new Date(lastModified)) + ")";
    }

    public String getPetAIResponse(Pet pet, Player owner, Player interactingPlayer, String message) throws IOException {
        String petName = pet.getNickname() != null ? pet.getNickname() : pet.getPetName();
        String ownerName = owner.getName();
        String interactingPlayerName = interactingPlayer.getName();
        String prompt = "You are a " + pet.getPersonality() + " " + pet.getType().name().toLowerCase() + " named " + petName + ". Your owner is " + ownerName + ". Your current mood is " + String.valueOf((Object)pet.getMood()) + " and your bond level is " + pet.getBond() + " out of 100.";
        if (interactingPlayer.getUniqueId().equals(owner.getUniqueId())) {
            prompt = prompt + "\n\nRespond to the following message from your owner, " + ownerName + ", as if you are the pet. Keep your response short and in character. Do not include the pet sound in your response:";
            prompt = prompt + "\n\nOwner: " + message;
            prompt = prompt + "\n" + petName + ": ";
        } else if (pet.getPetFriends().containsKey(interactingPlayer.getUniqueId())) {
            String relationship = pet.getPetFriends().get(interactingPlayer.getUniqueId()).getRelationship();
            prompt = prompt + "\n\n" + interactingPlayerName + " is a " + relationship + " of your owner, " + ownerName + ". Respond to " + interactingPlayerName + "'s message as if you are the pet, acknowledging their relationship to your owner. Keep your response short and in character. Do not include the pet sound in your response:";
            prompt = prompt + "\n\n" + interactingPlayerName + ": " + message;
            prompt = prompt + "\n" + petName + ": ";
        } else {
            prompt = prompt + "\n\nRespond to the following message from " + interactingPlayerName + " as if you are the pet. Keep your response short and in character. Do not include the pet sound in your response:";
            prompt = prompt + "\n\n" + interactingPlayerName + ": " + message;
            prompt = prompt + "\n" + petName + ": ";
        }
        if (pet.getBond() > 75) {
            prompt = prompt + " You are very affectionate towards your owner and their friends.";
        } else if (pet.getBond() < 25) {
            prompt = prompt + " You are cold and distant towards your owner and others.";
        }
        switch (pet.getMood().name().toLowerCase()) {
            case "happy": {
                prompt = prompt + " You are happy, so your responses should be enthusiastic and friendly. Use happy emojis like \u2764\ufe0f and \ud83d\ude0a.";
                break;
            }
            case "sad": {
                prompt = prompt + " You are sad, so your responses should be short and withdrawn. Use sad emojis like \ud83d\ude14.";
                break;
            }
            case "angry": {
                prompt = prompt + " You are angry, so your responses should be short and grumpy. Use angry emojis like \ud83d\ude21.";
                break;
            }
            case "furious": {
                prompt = prompt + " You are furious! Your responses should be very short, sharp, and angry. Use angry emojis like \ud83d\ude21.";
                break;
            }
            case "playful": {
                prompt = prompt + " You are feeling playful, so your responses should be energetic and maybe a little mischievous. Use playful emojis like \ud83d\ude0f.";
                break;
            }
            case "scared": {
                prompt = prompt + " You are scared, so your responses should be timid and short. Use scared emojis like \ud83d\ude31.";
                break;
            }
            case "neutral": {
                prompt = prompt + " You are feeling neutral, so your responses should be calm and balanced.";
                break;
            }
            case "hungry": {
                prompt = prompt + " You are hungry, so your responses might hint at wanting food.";
            }
        }
        String response = null;
        boolean success = false;
        boolean playerHasKeys = this.playerApiKeyManager.hasApiKeys(interactingPlayer.getUniqueId());
        boolean fallbackEnabled = this.playerApiKeyManager.isFallbackEnabled(interactingPlayer.getUniqueId());
        if (playerHasKeys) {
            ArrayList<PlayerApiKeyManager.ApiKey> playerKeys = new ArrayList<PlayerApiKeyManager.ApiKey>(this.playerApiKeyManager.getAllKeys(interactingPlayer));
            PlayerApiKeyManager.ApiKey usingKey = playerKeys.stream().filter(k -> k.getStatus() == PlayerApiKeyManager.ApiKey.KeyStatus.USING).findFirst().orElse(null);
            if (usingKey != null) {
                try {
                    ApiKeyManager.ApiKey tempKey = new ApiKeyManager.ApiKey(usingKey.getApiKey());
                    tempKey.setType(ApiKeyManager.ApiKey.Type.fromString(usingKey.getProvider().name()));
                    tempKey.setModel(usingKey.getModel());
                    response = this.callAppropriateApi(interactingPlayer, prompt, tempKey);
                    usingKey.incrementUsageCount();
                    success = true;
                }
                catch (IOException e) {
                    usingKey.incrementFallbackCount();
                    this.handlePlayerApiError(interactingPlayer, usingKey, e);
                    success = false;
                }
            }
            if (!success) {
                for (PlayerApiKeyManager.ApiKey pKey : playerKeys) {
                    if (pKey.getStatus() != PlayerApiKeyManager.ApiKey.KeyStatus.ACTIVE) continue;
                    try {
                        pKey.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.USING);
                        ApiKeyManager.ApiKey tempKey = new ApiKeyManager.ApiKey(pKey.getApiKey());
                        tempKey.setType(ApiKeyManager.ApiKey.Type.fromString(pKey.getProvider().name()));
                        tempKey.setModel(pKey.getModel());
                        response = this.callAppropriateApi(interactingPlayer, prompt, tempKey);
                        pKey.incrementUsageCount();
                        success = true;
                        break;
                    }
                    catch (IOException e) {
                        pKey.incrementFallbackCount();
                        this.handlePlayerApiError(interactingPlayer, pKey, e);
                    }
                }
            }
        }
        if (!(success || playerHasKeys && !fallbackEnabled)) {
            ArrayList<ApiKeyManager.ApiKey> globalKeys = new ArrayList<ApiKeyManager.ApiKey>(this.apiKeyManager.getApiKeys());
            for (ApiKeyManager.ApiKey gKey : globalKeys) {
                if (gKey.getStatus() == ApiKeyManager.ApiKey.KeyStatus.INACTIVE || this.overloadedKeyManager.isOverloaded(gKey)) continue;
                try {
                    response = this.callAppropriateApi(interactingPlayer, prompt, gKey);
                    success = true;
                    break;
                }
                catch (IOException e) {
                    gKey.incrementFallbackCount();
                    this.logGlobalApiError(gKey, e);
                }
            }
        }
        if (success) {
            return response;
        }
        if (!playerHasKeys || fallbackEnabled) {
            return "(No API key available)";
        }
        return "(Personal API key failed)";
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public BugFixManager getBugFixManager() {
        return this.bugFixManager;
    }

    public void clearPlayerChat(Player player) {
        for (int i = 0; i < 100; ++i) {
            player.sendMessage("");
        }
    }

    public SecurityUtil getSecurityUtil() {
        return this.securityUtil;
    }

    public ApiKeyStorage getApiKeyStorage() {
        return this.apiKeyStorage;
    }

    public PlayerSecurityManager getPlayerSecurityManager() {
        return this.playerSecurityManager;
    }

    public ConfigEncryptor getConfigEncryptor() {
        return this.configEncryptor;
    }

    public void handleKnowledgeBasedConversation(Player player, String message) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String finalPrompt;
            boolean isAdmin;
            String coreQuestion = this.extractCoreQuestion(message);
            Map<String, String> knowledgeResults = this.knowledgeManager.searchKnowledge(coreQuestion, isAdmin = this.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue());
            if (knowledgeResults.isEmpty() || coreQuestion.equals(message)) {
                finalPrompt = message;
            } else {
                StringBuilder context = new StringBuilder();
                context.append("Based on the following information: \n");
                for (Map.Entry<String, String> entry : knowledgeResults.entrySet()) {
                    context.append("- ").append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
                context.append("\nAnswer the user's question naturally, incorporating the above information. The user's original message was: \n");
                context.append(message);
                finalPrompt = context.toString();
            }
            this.handleGlobalAIConversation(player, finalPrompt, isAdmin);
        });
    }

    private String extractCoreQuestion(String message) {
        String prompt = "From the following user message, what is the primary question that would require a database lookup? Respond with only the question itself. For example, if the message is 'hey ai how are you tell me who is the owner of the nsr-ai', you should respond with 'who is the owner of the nsr-ai'.\n\nMessage: '" + message + "'\n\nCore Question:";
        ApiKeyManager.ApiKey apiKey = null;
        for (ApiKeyManager.ApiKey key : this.apiKeyManager.getApiKeys()) {
            if (key.getStatus() != ApiKeyManager.ApiKey.KeyStatus.ACTIVE || this.overloadedKeyManager.isOverloaded(key)) continue;
            apiKey = key;
            break;
        }
        if (apiKey == null) {
            this.getLogger().warning("NSR-AI: No valid global API key available for knowledge base question extraction. Proceeding without context.");
            return message;
        }
        try {
            return this.callGeminiApiForExtraction(prompt, apiKey);
        }
        catch (IOException e) {
            this.getLogger().warning("NSR-AI: API error during knowledge base question extraction: " + e.getMessage());
            return message;
        }
    }

    private String callGeminiApiForExtraction(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error during question extraction: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            if (!jsonResponse.has("candidates")) {
                this.getLogger().log(Level.SEVERE, "Gemini API error response for extraction: " + responseBody);
                throw new IOException("Gemini API returned an error during extraction: " + responseBody);
            }
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString().trim();
            return string;
        }
    }
}

