/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.command;

import com.nsr.ai.api.AIAddon;
import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.managers.PlayerApiKeyManager;
import com.nsr.ai.plugin.pet.Pet;
import com.nsr.ai.plugin.pet.PetCommand;
import com.nsr.ai.plugin.pet.data.PetFriendData;
import com.nsr.ai.plugin.pet.data.SharedPetLink;
import com.nsr.ai.plugin.util.ConfirmationEntry;
import com.nsr.ai.plugin.util.MessageFormatter;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CommandManager
implements CommandExecutor,
TabCompleter,
Listener {
    private final NSRAIPlugin plugin;
    private final PetCommand petCommand;
    private final Map<UUID, KeyCreationRequest> apiKeyEntryMode = new HashMap<UUID, KeyCreationRequest>();

    public CommandManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.petCommand = new PetCommand(plugin, plugin.getPetManager());
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args2.length == 0) {
            this.handleHelpCommand(player);
            return true;
        }
        String subCommand = args2[0].toLowerCase();
        String fullMessage = String.join((CharSequence)" ", args2);
        if (this.plugin.getAddonManager() != null) {
            for (AIAddon addon : this.plugin.getAddonManager().getAddons()) {
                String result = addon.onCommand(player, args2);
                if (result == null) continue;
                player.sendMessage(result);
                return true;
            }
        }
        switch (subCommand) {
            case "admin": {
                this.handleAdminCommand(player, args2);
                break;
            }
            case "admincode": {
                this.handleAdminCodeCommand(player);
                break;
            }
            case "cache": {
                this.handleCacheCommand(player, args2);
                break;
            }
            case "memory": {
                this.handleMemoryCommand(player, args2);
                break;
            }
            case "version": 
            case "v": {
                this.handleVersionCommand(player, args2);
                break;
            }
            case "data": {
                if (args2.length > 1 && args2[1].equalsIgnoreCase("all")) {
                    this.handleDataAllCommand(player);
                    break;
                }
                this.handleDataCommand(player, args2);
                break;
            }
            case "add": {
                this.handleAddCommand(player, args2);
                break;
            }
            case "remove": {
                this.handleRemoveCommand(player, args2);
                break;
            }
            case "reload": {
                this.handleReloadCommand(player, args2);
                break;
            }
            case "confirm": {
                this.handleConfirmCommand(player, args2);
                break;
            }
            case "disable": {
                this.handleDisableCommand(player);
                break;
            }
            case "help": {
                this.handleHelpCommand(player);
                break;
            }
            case "pet": {
                this.handlePetCommand(player, command, label, args2);
                break;
            }
            case "apikey": {
                this.handleApiKeyCommand(player, args2);
                break;
            }
            default: {
                this.plugin.handleAIConversation(player, fullMessage, this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false), this.plugin.getDefaultApiProvider(), "AI_ONLY");
            }
        }
        return true;
    }

    private void handleApiKeyCommand(Player player, String[] args2) {
        String subCommand;
        if (args2.length == 1) {
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "--- API Key Management ---");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "To add a session-based key (temporary): Directly paste your API key in chat.");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "To store the session based key (permanent): Type /ai apikey store <projectId>.");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "To store a new API key from starting (permanent): Paste like this: store-<your_api_key> in chat.");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "--------------------------");
            this.apiKeyEntryMode.put(player.getUniqueId(), new KeyCreationRequest(StorageMode.SESSION, null));
            return;
        }
        switch (subCommand = args2[1].toLowerCase()) {
            case "store": {
                if (args2.length < 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai apikey store <projectId>");
                    return;
                }
                String projectId = args2[2];
                PlayerApiKeyManager.ApiKey sessionKey = this.plugin.getPlayerApiKeyManager().getMostRecentSessionKey(player.getUniqueId());
                if (sessionKey == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No active session key found to store. Please add a key first by typing /ai apikey and then pasting your key.");
                    return;
                }
                PlayerApiKeyManager.ApiKey storedKey = this.plugin.getPlayerApiKeyManager().convertSessionKeyToStored(player.getUniqueId(), sessionKey.getKeyId(), projectId);
                if (storedKey != null) {
                    player.sendMessage(String.valueOf(ChatColor.AQUA) + "Session key '" + sessionKey.getKeyId() + "' (" + sessionKey.getMaskedKey() + ") was successfully converted and stored with Project ID: " + String.valueOf(ChatColor.WHITE) + storedKey.getProjectId());
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to store the session key. It might not be a valid session key.");
                break;
            }
            case "fallback": {
                if (args2.length < 4 || !args2[2].equalsIgnoreCase("global")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai apikey fallback global <true|false>");
                    return;
                }
                boolean fallbackValue = Boolean.parseBoolean(args2[3]);
                this.plugin.getPlayerApiKeyManager().setFallbackEnabled(player.getUniqueId(), fallbackValue);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Global API key fallback has been set to: " + String.valueOf(ChatColor.YELLOW) + fallbackValue);
                break;
            }
            case "info": {
                if (args2.length < 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai apikey info [all|key-id]");
                    return;
                }
                if (args2[2].equalsIgnoreCase("all")) {
                    for (PlayerApiKeyManager.ApiKey key : this.plugin.getPlayerApiKeyManager().getAllKeys(player)) {
                        player.sendMessage(MessageFormatter.formatKeyInfo(key));
                    }
                    break;
                }
                PlayerApiKeyManager.ApiKey key = this.plugin.getPlayerApiKeyManager().getKey(player, args2[2]);
                if (key != null) {
                    player.sendMessage(MessageFormatter.formatKeyInfo(key));
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "API key with ID '" + args2[2] + "' not found.");
                break;
            }
            case "model": {
                if (args2.length < 4) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai apikey model <key-id> <new-model>");
                    return;
                }
                String oldModel = this.plugin.getPlayerApiKeyManager().getKey(player, args2[2]).getModel();
                PlayerApiKeyManager.ApiKey updatedKey = this.plugin.getPlayerApiKeyManager().updateModel(player, args2[2], args2[3]);
                if (updatedKey != null) {
                    player.sendMessage(MessageFormatter.formatModelUpdated(updatedKey, oldModel));
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "API key with ID '" + args2[2] + "' not found.");
                break;
            }
            case "list": {
                player.sendMessage(MessageFormatter.formatKeyList(this.plugin.getPlayerApiKeyManager().getAllKeys(player)));
                break;
            }
            case "clear": {
                if (args2.length < 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai apikey clear [all|key-id]");
                    return;
                }
                if (args2[2].equalsIgnoreCase("all")) {
                    int count = this.plugin.getPlayerApiKeyManager().deleteAllKeys(player);
                    player.sendMessage(MessageFormatter.formatKeysCleared(count, new ArrayList<PlayerApiKeyManager.ApiKey>()));
                    break;
                }
                PlayerApiKeyManager.ApiKey deletedKey = this.plugin.getPlayerApiKeyManager().deleteKey(player, args2[2]);
                if (deletedKey != null) {
                    player.sendMessage(MessageFormatter.formatKeysCleared(1, Arrays.asList(deletedKey)));
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "API key with ID '" + args2[2] + "' not found.");
                break;
            }
            case "timer": {
                this.handleApiKeyTimerCommand(player, args2);
                break;
            }
            case "msg": {
                this.handleApiKeyMsgCommand(player, args2);
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown apikey command. Usage: /ai apikey [store|info|model|list|clear|timer|msg]");
            }
        }
    }

    private void handleApiKeyMsgCommand(Player player, String[] args2) {
        String msgSubCommand;
        if (args2.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai apikey msg <save> <true|false>");
            return;
        }
        switch (msgSubCommand = args2[2].toLowerCase()) {
            case "save": {
                if (args2.length < 4) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai apikey msg save <true|false>");
                    return;
                }
                boolean saveChatHistory = Boolean.parseBoolean(args2[3]);
                PlayerApiKeyManager.ApiKey activeKey = this.plugin.getPlayerApiKeyManager().getActiveKey(player.getUniqueId());
                if (activeKey != null) {
                    this.plugin.getPlayerApiKeyManager().setSaveChatHistory(player.getUniqueId(), activeKey.getKeyId(), saveChatHistory);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chat history saving for your active API key has been set to: " + String.valueOf(ChatColor.YELLOW) + saveChatHistory);
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have an active API key. Please add one first.");
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown apikey msg command. Usage: /ai apikey msg <save>");
            }
        }
    }

    private void handleApiKeyTimerCommand(Player player, String[] args2) {
        if (args2.length < 4 || !args2[3].equalsIgnoreCase("remove")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai apikey timer <key-id> remove");
            return;
        }
        String keyId = args2[2];
        PlayerApiKeyManager.ApiKey apiKey = this.plugin.getPlayerApiKeyManager().getKey(player, keyId);
        if (apiKey != null) {
            if (apiKey.getStatus() != PlayerApiKeyManager.ApiKey.KeyStatus.INVALID) {
                apiKey.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.ACTIVE);
                this.plugin.getPlayerApiKeyManager().updateModel(player, keyId, apiKey.getModel());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "API key '" + keyId + "' has been activated.");
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot activate an invalid API key.");
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "API key with ID '" + keyId + "' not found.");
        }
    }

    @EventHandler
    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        KeyCreationRequest request = this.apiKeyEntryMode.get(player.getUniqueId());
        String message = event.getMessage();
        if (message.equalsIgnoreCase("cancel")) {
            if (request != null) {
                this.apiKeyEntryMode.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "API key entry cancelled.");
                event.setCancelled(true);
            }
            return;
        }
        if (request != null) {
            event.setCancelled(true);
            this.apiKeyEntryMode.remove(player.getUniqueId());
            if (request.mode == StorageMode.SESSION) {
                PlayerApiKeyManager.ApiKey key = this.plugin.getPlayerApiKeyManager().addSessionKey(player, message);
                if (key != null) {
                    player.sendMessage(MessageFormatter.formatKeyAdded(key));
                }
            } else if (request.mode == StorageMode.STORED) {
                PlayerApiKeyManager.ApiKey sessionKey = this.plugin.getPlayerApiKeyManager().getMostRecentSessionKey(player.getUniqueId());
                if (sessionKey == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You need to add a session-based API key first before storing it. Type /ai apikey and then paste your key.");
                    return;
                }
                PlayerApiKeyManager.ApiKey storedKey = this.plugin.getPlayerApiKeyManager().convertSessionKeyToStored(player.getUniqueId(), sessionKey.getKeyId(), request.projectId);
                if (storedKey != null) {
                    player.sendMessage(String.valueOf(ChatColor.AQUA) + "Session key '" + sessionKey.getKeyId() + "' converted and stored as '" + storedKey.getKeyId() + "' with Project ID: " + storedKey.getProjectId());
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to store the session key. It might no longer exist or is not a session key.");
                }
            }
        } else if (message.toLowerCase().startsWith("store-")) {
            event.setCancelled(true);
            String apiKey = message.substring("store-".length());
            String generatedProjectId = this.generateRandomAlphanumeric(6);
            PlayerApiKeyManager.ApiKey key = this.plugin.getPlayerApiKeyManager().addStoredKey(player, apiKey, generatedProjectId);
            player.sendMessage(MessageFormatter.formatKeyStored(key));
        }
    }

    private String generateRandomAlphanumeric(int length) {
        String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(CHARS.charAt(random.nextInt(CHARS.length())));
        }
        return sb.toString();
    }

    private void handlePetCommand(Player player, Command command, String label, String[] args2) {
        if (args2.length < 2) {
            this.petCommand.sendUsage(player);
            return;
        }
        String petSubCommand = args2[1].toLowerCase();
        String[] petArgs = Arrays.copyOfRange(args2, 1, args2.length);
        switch (petSubCommand) {
            case "share": {
                this.handlePetShareCommand(player, petArgs);
                break;
            }
            case "accept_request": {
                this.handleAcceptRequestCommand(player, petArgs);
                break;
            }
            case "deny_request": {
                this.handleDenyRequestCommand(player, petArgs);
                break;
            }
            case "removefriend": {
                this.handlePetRemoveFriendCommand(player, petArgs);
                break;
            }
            case "relation": {
                this.handlePetRelationCommand(player, petArgs);
                break;
            }
            case "link": {
                this.handlePetLinkListCommand(player, petArgs);
                break;
            }
            case "linked": {
                this.handlePetLinkedListCommand(player, petArgs);
                break;
            }
            case "unlink": {
                this.handlePetUnlinkCommand(player, petArgs);
                break;
            }
            case "inv": {
                if (args2.length > 2) {
                    if (args2[2].equalsIgnoreCase("allow")) {
                        this.handlePetInvAllowCommand(player, petArgs);
                        break;
                    }
                    if (args2[2].equalsIgnoreCase("disallow")) {
                        this.handlePetInvDisallowCommand(player, petArgs);
                        break;
                    }
                    this.petCommand.onCommand((CommandSender)player, command, label, args2);
                    break;
                }
                this.petCommand.onCommand((CommandSender)player, command, label, args2);
                break;
            }
            default: {
                if (petSubCommand.length() == 6) {
                    this.handlePetLinkUsageCommand(player, petSubCommand);
                    break;
                }
                if (args2.length > 1) {
                    String petName = args2[1];
                    Pet pet = this.plugin.getPetManager().findPetByName(petName);
                    if (pet != null && !this.plugin.getPetManager().canInteract(pet, player.getUniqueId())) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to interact with this pet.");
                        return;
                    }
                }
                this.petCommand.onCommand((CommandSender)player, command, label, args2);
            }
        }
    }

    private void handlePetLinkUsageCommand(Player player, String linkCode) {
        linkCode = linkCode.toLowerCase();
        SharedPetLink link = this.plugin.getPetManager().getActiveLinks().get(linkCode);
        if (link == null || link.isExpired()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid or expired pet share link.");
            return;
        }
        if (link.getOwnerUUID().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot use your own pet share link.");
            return;
        }
        Pet pet = this.plugin.getPetManager().getPet(Bukkit.getPlayer((UUID)link.getOwnerUUID()), link.getPetName());
        if (pet != null && pet.getPetFriends().containsKey(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are already a friend of this pet.");
            this.plugin.getPetManager().getActiveLinks().remove(linkCode);
            return;
        }
        link.setRequesterUUID(player.getUniqueId());
        if (link.isRequiresAcceptance()) {
            Player owner = Bukkit.getPlayer((UUID)link.getOwnerUUID());
            if (owner != null) {
                TextComponent message = new TextComponent(this.plugin.colorize("&aPlayer &f" + player.getName() + "&a wants to be &f" + link.getRequestedRelationship() + "&a with your pet &f" + link.getPetName() + "&a. "));
                TextComponent acceptButton = new TextComponent(this.plugin.colorize("&a[&2Accept&a]"));
                acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ai pet accept_request " + linkCode + " " + String.valueOf(player.getUniqueId())));
                TextComponent denyButton = new TextComponent(this.plugin.colorize(" &a[&cDeny&a]"));
                denyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ai pet deny_request " + linkCode + " " + String.valueOf(player.getUniqueId())));
                message.addExtra((BaseComponent)acceptButton);
                message.addExtra((BaseComponent)denyButton);
                owner.spigot().sendMessage((BaseComponent)message);
                player.sendMessage(this.plugin.colorize("&aRequest sent to &f" + owner.getName() + "&a for pet &f" + link.getPetName() + "&a."));
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The pet owner is offline. They need to be online to accept your request.");
                this.plugin.getPetManager().getActiveLinks().remove(linkCode);
            }
        } else {
            if (pet != null) {
                this.plugin.getPetManager().addPetFriend(pet, player.getUniqueId(), link.getRequestedRelationship());
                player.sendMessage(this.plugin.colorize("&aYou are now &f" + link.getRequestedRelationship() + "&a with pet &f" + pet.getPetName() + "&a!"));
                Player owner = Bukkit.getPlayer((UUID)link.getOwnerUUID());
                if (owner != null) {
                    owner.sendMessage(this.plugin.colorize("&f" + player.getName() + "&a is now &f" + link.getRequestedRelationship() + "&a with your pet &f" + pet.getPetName() + "&a (via direct link)."));
                }
            }
            this.plugin.getPetManager().getActiveLinks().remove(linkCode);
        }
    }

    private void handleAcceptRequestCommand(Player player, String[] args2) {
        if (args2.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: Invalid accept request command usage.");
            return;
        }
        String linkCode = args2[1].toLowerCase();
        UUID requesterUUID = UUID.fromString(args2[2]);
        SharedPetLink link = this.plugin.getPetManager().getActiveLinks().get(linkCode);
        if (link == null || link.isExpired() || !link.getOwnerUUID().equals(player.getUniqueId()) || !link.getRequesterUUID().equals(requesterUUID)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid or expired request.");
            return;
        }
        Pet pet = this.plugin.getPetManager().getPet(player, link.getPetName());
        if (pet == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: Pet not found.");
            this.plugin.getPetManager().getActiveLinks().remove(linkCode);
            return;
        }
        this.plugin.getPetManager().addPetFriend(pet, requesterUUID, link.getRequestedRelationship());
        player.sendMessage(this.plugin.colorize("&aYou accepted &f" + Bukkit.getOfflinePlayer((UUID)requesterUUID).getName() + "&a as &f" + link.getRequestedRelationship() + "&a for pet &f" + pet.getPetName() + "&a."));
        Player requester = Bukkit.getPlayer((UUID)requesterUUID);
        if (requester != null) {
            requester.sendMessage(this.plugin.colorize("&aYour request to be &f" + link.getRequestedRelationship() + "&a with pet &f" + pet.getPetName() + "&a was accepted by &f" + player.getName() + "&a!"));
        }
        this.plugin.getPetManager().getActiveLinks().remove(linkCode);
    }

    private void handleDenyRequestCommand(Player player, String[] args2) {
        if (args2.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: Invalid deny request command usage.");
            return;
        }
        String linkCode = args2[1].toLowerCase();
        UUID requesterUUID = UUID.fromString(args2[2]);
        SharedPetLink link = this.plugin.getPetManager().getActiveLinks().get(linkCode);
        if (link == null || link.isExpired() || !link.getOwnerUUID().equals(player.getUniqueId()) || !link.getRequesterUUID().equals(requesterUUID)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid or expired request.");
            return;
        }
        player.sendMessage(this.plugin.colorize("&cYou denied &f" + Bukkit.getOfflinePlayer((UUID)requesterUUID).getName() + "&c's request for pet &f" + link.getPetName() + "&c."));
        Player requester = Bukkit.getPlayer((UUID)requesterUUID);
        if (requester != null) {
            requester.sendMessage(this.plugin.colorize("&cYour request for pet &f" + link.getPetName() + "&c was denied by &f" + player.getName() + "&c."));
        }
        this.plugin.getPetManager().getActiveLinks().remove(linkCode);
    }

    private void handlePetRemoveFriendCommand(Player player, String[] args2) {
        if (args2.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet removefriend <player_name> <pet_name>");
            return;
        }
        String targetPlayerName = args2[1];
        String petName = args2[2];
        Pet pet = this.plugin.getPetManager().getPet(player, petName);
        if (pet == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Pet '" + petName + "' not found or you don't own it.");
            return;
        }
        UUID targetPlayerUUID = Bukkit.getOfflinePlayer((String)targetPlayerName).getUniqueId();
        if (!pet.getPetFriends().containsKey(targetPlayerUUID)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetPlayerName + "' is not a friend of pet '" + petName + "'.");
            return;
        }
        this.plugin.getPetManager().removePetFriend(pet, targetPlayerUUID);
        player.sendMessage(this.plugin.colorize("&aSuccessfully removed &f" + targetPlayerName + "&a from pet '&f" + petName + "&a's friends."));
        Player removedPlayer = Bukkit.getPlayer((UUID)targetPlayerUUID);
        if (removedPlayer != null) {
            removedPlayer.sendMessage(this.plugin.colorize("&cYou have been removed from pet '&f" + petName + "&c's friends by &f" + player.getName() + "&c."));
        }
    }

    private void handlePetRelationCommand(Player player, String[] args2) {
        if (args2.length < 4) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet relation <pet_name> <player_name> <new_relationship>");
            return;
        }
        String petName = args2[1];
        String targetPlayerName = args2[2];
        String newRelationship = args2[3];
        Pet pet = this.plugin.getPetManager().getPet(player, petName);
        if (pet == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Pet '" + petName + "' not found or you don't own it.");
            return;
        }
        UUID targetPlayerUUID = Bukkit.getOfflinePlayer((String)targetPlayerName).getUniqueId();
        PetFriendData friendData = pet.getPetFriends().get(targetPlayerUUID);
        if (friendData == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetPlayerName + "' is not a friend of pet '" + petName + "'.");
            return;
        }
        String oldRelationship = friendData.getRelationship();
        friendData.setRelationship(newRelationship);
        this.plugin.getPetManager().savePet(pet);
        player.sendMessage(this.plugin.colorize("&aRelationship for &f" + targetPlayerName + "&a with pet '&f" + petName + "&a' changed from &f" + oldRelationship + "&a to &f" + newRelationship + "&a."));
        Player targetPlayer = Bukkit.getPlayer((UUID)targetPlayerUUID);
        if (targetPlayer != null) {
            targetPlayer.sendMessage(this.plugin.colorize("&aYour relationship with pet '&f" + petName + "&a' has been changed to &f" + newRelationship + "&a by &f" + player.getName() + "&a."));
        }
    }

    private void handlePetLinkListCommand(Player player, String[] args2) {
        if (args2.length > 1 && !args2[1].equalsIgnoreCase("list")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet link list");
            return;
        }
        player.sendMessage(this.plugin.colorize("&a--- Your Pets Shared with Others ---"));
        boolean found = false;
        Map<String, Pet> ownedPets = this.plugin.getPetManager().getLoadedPets().get(player.getUniqueId());
        if (ownedPets != null) {
            for (Pet pet : ownedPets.values()) {
                if (pet.getPetFriends().isEmpty()) continue;
                player.sendMessage(this.plugin.colorize("&fPet: &b" + pet.getPetName()));
                for (PetFriendData friendData : pet.getPetFriends().values()) {
                    player.sendMessage(this.plugin.colorize("  &7- &f" + Bukkit.getOfflinePlayer((UUID)friendData.getFriendUUID()).getName() + " &7(&f" + friendData.getRelationship() + "&7)"));
                }
                found = true;
            }
        }
        if (!found) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "  No pets shared with others.");
        }
        player.sendMessage(this.plugin.colorize("&a----------------------------------"));
    }

    private void handlePetLinkedListCommand(Player player, String[] args2) {
        if (args2.length > 1 && !args2[1].equalsIgnoreCase("list")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet linked list");
            return;
        }
        player.sendMessage(this.plugin.colorize("&a--- Pets You Are Linked With ---"));
        boolean found = false;
        for (Map<String, Pet> ownerPetsMap : this.plugin.getPetManager().getLoadedPets().values()) {
            for (Pet pet : ownerPetsMap.values()) {
                if (!pet.getPetFriends().containsKey(player.getUniqueId())) continue;
                PetFriendData friendData = pet.getPetFriends().get(player.getUniqueId());
                player.sendMessage(this.plugin.colorize("&fPet: &b" + pet.getPetName() + " &7(Owner: &f" + pet.getOwnerName() + "&7, Relationship: &f" + friendData.getRelationship() + "&7)"));
                found = true;
            }
        }
        if (!found) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "  Not linked with any pets.");
        }
        player.sendMessage(this.plugin.colorize("&a--------------------------------"));
    }

    private void handlePetUnlinkCommand(Player player, String[] args2) {
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet unlink <pet_name>");
            return;
        }
        String petName = args2[1];
        Pet targetPet = this.plugin.getPetManager().findPetByFriendAndName(player.getUniqueId(), petName);
        Player owner = null;
        if (targetPet != null) {
            owner = Bukkit.getPlayer((UUID)targetPet.getOwnerUuid());
        }
        if (targetPet == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not linked with a pet named '" + petName + "'.");
            return;
        }
        this.plugin.getPetManager().removePetFriend(targetPet, player.getUniqueId());
        player.sendMessage(this.plugin.colorize("&aYou have successfully unlinked from pet '&f" + petName + "&a'."));
        if (owner != null) {
            owner.sendMessage(this.plugin.colorize("&f" + player.getName() + "&a has unlinked from your pet '&f" + petName + "&a'."));
        }
    }

    private void handlePetInvAllowCommand(Player player, String[] args2) {
        if (args2.length < 4) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet inv allow <pet_name> <player_name>");
            return;
        }
        String petName = args2[2];
        String targetPlayerName = args2[3];
        Pet pet = this.plugin.getPetManager().getPet(player, petName);
        if (pet == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Pet '" + petName + "' not found or you don't own it.");
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetPlayerName + "' not found or is offline.");
            return;
        }
        this.plugin.getPetManager().allowInventoryAccess(pet, targetPlayer.getUniqueId());
        player.sendMessage(this.plugin.colorize("&aSuccessfully allowed &f" + targetPlayerName + "&a to access &f" + petName + "&a's inventory."));
        targetPlayer.sendMessage(this.plugin.colorize("&aYou have been granted access to &f" + petName + "&a's inventory by &f" + player.getName() + "&a. Use /ai pet inv " + petName + " to open it."));
    }

    private void handlePetInvDisallowCommand(Player player, String[] args2) {
        if (args2.length < 4) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet inv disallow <pet_name> <player_name>");
            return;
        }
        String petName = args2[2];
        String targetPlayerName = args2[3];
        Pet pet = this.plugin.getPetManager().getPet(player, petName);
        if (pet == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Pet '" + petName + "' not found or you don't own it.");
            return;
        }
        if (!pet.getOwnerUuid().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the owner of this pet to change its permissions.");
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetPlayerName + "' not found or is offline.");
            return;
        }
        this.plugin.getPetManager().removeInventoryAccess(pet, targetPlayer.getUniqueId());
        player.sendMessage(this.plugin.colorize("&aSuccessfully revoked &f" + targetPlayerName + "&a's access to &f" + petName + "&a's inventory."));
        targetPlayer.sendMessage(this.plugin.colorize("&cYour access to &f" + petName + "&a's inventory has been revoked by &f" + player.getName() + "&c."));
    }

    private void handlePetShareCommand(Player player, String[] args2) {
        Pet pet;
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet share <pet_name> [allow] [relationship]");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "  [allow]: Use 'allow' if you want requests for this link to be instantly accepted without your approval.");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "  [relationship]: A custom string (e.g., 'friend', 'brother', 'ally'). Defaults to 'friend'.");
            return;
        }
        String petName = args2[1];
        boolean requiresAcceptance = true;
        String relationship = "friend";
        ArrayList<String> relationshipWords = new ArrayList<String>();
        if (args2.length > 2) {
            for (int i = 2; i < args2.length; ++i) {
                if (args2[i].equalsIgnoreCase("allow")) {
                    requiresAcceptance = false;
                    continue;
                }
                relationshipWords.add(args2[i]);
            }
        }
        if (!relationshipWords.isEmpty()) {
            relationship = String.join((CharSequence)" ", relationshipWords);
        }
        if ((pet = this.plugin.getPetManager().getPet(player, petName)) == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Pet '" + petName + "' not found or you don't own it.");
            return;
        }
        String linkCode = this.plugin.getPetManager().generateShareLink(pet, player.getUniqueId(), requiresAcceptance, relationship);
        player.sendMessage(this.plugin.colorize("&aPet share link generated for pet &f" + pet.getPetName() + "&a: &b" + linkCode));
        if (requiresAcceptance) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "This link requires your acceptance for the requester to be linked.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "This link will grant immediate access upon use.");
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Link expires in 10 minutes.");
    }

    private void handleVersionCommand(Player player, String[] args2) {
        if (!this.plugin.isVersionCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (args2.length > 1 && (args2[1].equalsIgnoreCase("security") || args2[1].equalsIgnoreCase("s"))) {
            String effectiveSecurityVersion = this.plugin.getSecurityManager().getSecurityVersion();
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "NSR-AI Security Version: " + String.valueOf(ChatColor.WHITE) + effectiveSecurityVersion);
            return;
        }
        if (args2.length > 1 && (args2[1].equalsIgnoreCase("bug") || args2[1].equalsIgnoreCase("b"))) {
            String internalBugFixVersion = this.plugin.getBugFixManager().getCurrentBugFixVersion();
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "NSR-AI Bug Fix Version: " + String.valueOf(ChatColor.WHITE) + internalBugFixVersion);
            return;
        }
        String currentVersion = this.plugin.getDescription().getVersion();
        String message = String.valueOf(ChatColor.AQUA) + "NSR-AI Plugin Version: " + String.valueOf(ChatColor.WHITE) + currentVersion;
        if (this.plugin.getUpdateChecker() != null) {
            boolean outdated = this.plugin.getUpdateChecker().isOutdated();
            if (outdated) {
                message = message + String.valueOf(ChatColor.RED) + " (Outdated)";
                player.sendMessage(message);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Latest version available: " + this.plugin.getUpdateChecker().getLatestVersion());
                if (this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Download from:");
                    player.sendMessage(String.valueOf(ChatColor.RED) + "  Modrinth: https://modrinth.com/plugin/nsr-ai");
                    player.sendMessage(String.valueOf(ChatColor.RED) + "  SpigotMC: https://www.spigotmc.org/resources/nsr-ai.127717/");
                    player.sendMessage(String.valueOf(ChatColor.RED) + "  Polymart: https://polymart.org/product/8380/nsr-ai");
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "--- Features of Latest Version (" + this.plugin.getUpdateChecker().getLatestVersion() + ") ---");
            } else {
                message = message + String.valueOf(ChatColor.GREEN) + " (Latest)";
                player.sendMessage(message);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "--- Current Version Features ---");
            }
            if (this.plugin.getUpdateChecker().getLatestFeatures() != null && !this.plugin.getUpdateChecker().getLatestFeatures().isEmpty()) {
                for (String feature : this.plugin.getUpdateChecker().getLatestFeatures()) {
                    player.sendMessage(String.valueOf(ChatColor.GRAY) + "- " + feature);
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "-----------------------");
            }
        } else {
            player.sendMessage(message + String.valueOf(ChatColor.YELLOW) + " (Update checker not initialized)");
        }
    }

    private void handleAdminCommand(Player player, String[] args2) {
        if (!this.plugin.isAdminDisableCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai admin <activation_code>");
            return;
        }
        String activationCode = args2[1];
        if (activationCode.equals(this.plugin.getAdminActivationCode())) {
            boolean isAdmin = this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false);
            if (isAdmin) {
                this.plugin.getAdminModePlayers().remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Admin mode disabled.");
            } else {
                this.plugin.getAdminModePlayers().put(player.getUniqueId(), true);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Admin mode enabled.");
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid activation code.");
        }
    }

    private void handleAdminCodeCommand(Player player) {
        if (!player.isOp()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "---------------------------------");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[WARNING] This is your private admin activation code.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DO NOT SHARE IT WITH ANYONE.");
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "Your Code: " + this.plugin.getAdminActivationCode());
        player.sendMessage(String.valueOf(ChatColor.RED) + "---------------------------------");
    }

    private void handleDataCommand(Player player, String[] args2) {
        if (!this.plugin.isDataCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai data <query>");
            return;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args2, 1, args2.length));
        String rawUserMessage = this.plugin.getUserPrefix().replace("%player_name%", "&e" + player.getName() + "&7") + this.plugin.getUserChatColor() + message;
        player.sendMessage(this.plugin.colorize(rawUserMessage));
        this.plugin.handleKnowledgeBasedConversation(player, message);
    }

    private void handleDataAllCommand(Player player) {
        if (!this.plugin.isDataCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (!this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage(this.plugin.getPermissionDeniedMessage());
            return;
        }
        Map<String, String> allKnowledge = this.plugin.getKnowledgeManager().getAllKnowledge(true);
        if (allKnowledge.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "The knowledge base is empty.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "--- All Knowledge Base Entries ---");
        for (Map.Entry<String, String> entry : allKnowledge.entrySet()) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Heading: " + String.valueOf(ChatColor.WHITE) + entry.getKey());
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Content: " + String.valueOf(ChatColor.WHITE) + entry.getValue());
            player.sendMessage("");
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "----------------------------------");
    }

    private void handleAddCommand(Player player, String[] args2) {
        if (!this.plugin.isAddConfirmCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (!this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage(this.plugin.getPermissionDeniedMessage());
            return;
        }
        String fullCommand = String.join((CharSequence)" ", args2);
        int firstCommaIndex = fullCommand.indexOf(44);
        if (firstCommaIndex == -1 || firstCommaIndex == fullCommand.length() - 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai add <keyword>, <message_content>");
            return;
        }
        String keyword = fullCommand.substring(fullCommand.indexOf("add ") + 4, firstCommaIndex).trim();
        String messageContent = fullCommand.substring(firstCommaIndex + 1).trim();
        if (keyword.isEmpty() || messageContent.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai add <keyword>, <message_content>");
            return;
        }
        if (this.plugin.isAddConfirmCommandEnabled()) {
            this.plugin.processAndAddKnowledgeEntry(player, keyword, messageContent);
        } else {
            String aiGeneratedHeading = this.plugin.generateAIHeading(messageContent, "", keyword);
            this.plugin.addKnowledgeEntry(keyword, aiGeneratedHeading, messageContent);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry added successfully!");
        }
    }

    private void handleRemoveCommand(Player player, String[] args2) {
        if (!this.plugin.isRemoveConfirmCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (!this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage(this.plugin.getPermissionDeniedMessage());
            return;
        }
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai remove <keyword>");
            return;
        }
        String key = args2[1];
        if (this.plugin.isRemoveConfirmCommandEnabled()) {
            String code = this.plugin.getConfirmationManager().createConfirmation(player.getUniqueId(), "remove", key, null);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please confirm removing this knowledge entry by typing: /ai confirm " + code);
        } else {
            String removedEntry = this.plugin.removeKnowledgeEntry(key);
            if (removedEntry != null) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry removed successfully!");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Removed content: " + removedEntry);
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Knowledge entry not found.");
            }
        }
    }

    private void handleConfirmCommand(Player player, String[] args2) {
        if (args2.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai confirm <code>");
            return;
        }
        String code = args2[1];
        ConfirmationEntry entry = null;
        String entryCode = null;
        if (this.plugin.isSimpleKnowledgeYmlApprove() && code.equalsIgnoreCase("yes")) {
            for (Map.Entry<String, ConfirmationEntry> mapEntry : this.plugin.getConfirmationManager().getPendingConfirmations().entrySet()) {
                if (!mapEntry.getValue().getPlayerId().equals(player.getUniqueId()) || !mapEntry.getValue().getActionType().equals("add")) continue;
                entry = mapEntry.getValue();
                entryCode = mapEntry.getKey();
                break;
            }
        } else {
            entry = this.plugin.getConfirmationManager().getConfirmation(code);
            entryCode = code;
        }
        if (entry == null || !entry.getPlayerId().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid or expired confirmation code.");
            return;
        }
        if (entry.getActionType().equals("add")) {
            String[] parts = entry.getOriginalContent().split("/", 2);
            this.plugin.addKnowledgeEntry(parts[0], parts[1], entry.getAiResponse());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry added successfully!");
        } else if (entry.getActionType().equals("remove")) {
            String removedEntry = this.plugin.removeKnowledgeEntry(entry.getOriginalContent());
            if (removedEntry != null) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry removed successfully!");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Removed content: " + removedEntry);
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Knowledge entry not found.");
            }
        }
        if (entryCode != null) {
            this.plugin.getConfirmationManager().removeConfirmation(entryCode);
        }
    }

    private void handleDisableCommand(Player player) {
        if (!this.plugin.isAdminDisableCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (this.plugin.getAdminModePlayers().containsKey(player.getUniqueId())) {
            this.plugin.getAdminModePlayers().remove(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Admin mode disabled.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Admin mode is not enabled.");
        }
    }

    private void handleReloadCommand(Player player, String[] args2) {
        if (!this.plugin.isReloadCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This command is currently disabled.");
            return;
        }
        if (args2.length == 1) {
            this.plugin.reloadConfig();
            this.plugin.loadConfig();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI main configuration reloaded.");
        } else if (args2.length == 2) {
            String subCommand = args2[1].toLowerCase();
            if (subCommand.equals("f") || subCommand.equals("features")) {
                this.plugin.reloadFeaturesConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI features configuration reloaded.");
            } else if (subCommand.equals("nsr-ai")) {
                this.plugin.reloadNSR_AIPlugin();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI plugin (configs and knowledge base) reloaded.");
            } else if (subCommand.equals("k") || subCommand.equals("knowledge")) {
                this.plugin.reloadKnowledgeBase();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI knowledge base reloaded.");
            } else if (subCommand.equals("c") || subCommand.equals("config")) {
                this.plugin.reloadConfig();
                this.plugin.loadConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI main configuration reloaded.");
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai reload [f|features|nsr-ai|k|knowledge|c|config]");
        }
    }

    private void handleCacheCommand(Player player, String[] args2) {
        if (args2.length < 2 || !args2[1].equalsIgnoreCase("clear") && !args2[1].equalsIgnoreCase("refresh")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai cache <clear|refresh>");
            return;
        }
        String action = args2[1].toLowerCase();
        if (action.equals("clear")) {
            if (!this.plugin.isCacheClearEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /ai cache clear command is currently disabled.");
                return;
            }
            this.plugin.getConversationManager().clearHistory(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your session has been cleared. A new session will begin with your next message.");
        } else if (action.equals("refresh")) {
            if (!this.plugin.isCacheRefreshEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /ai cache refresh command is currently disabled.");
                return;
            }
            this.plugin.reloadPlayerSession(player);
        }
    }

    private void handleMemoryCommand(Player player, String[] args2) {
        if (args2.length < 2 || !args2[1].equalsIgnoreCase("clear") && !args2[1].equalsIgnoreCase("refresh")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai memory <clear|refresh>");
            return;
        }
        String action = args2[1].toLowerCase();
        if (action.equals("clear")) {
            if (!this.plugin.isMemoryClearEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /ai memory clear command is currently disabled.");
                return;
            }
            this.plugin.summarizeAndClearSession(player);
        } else if (action.equals("refresh")) {
            if (!this.plugin.isMemoryRefreshEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /ai memory refresh command is currently disabled.");
                return;
            }
            this.plugin.summarizeAndRefreshSession(player);
        }
    }

    private void handleDefaultCommand(Player player, String[] args2) {
        this.handleHelpCommand(player);
    }

    private void handleHelpCommand(Player player) {
        boolean isAdmin = this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false);
        StringBuilder helpMessage = new StringBuilder();
        helpMessage.append(ChatColor.AQUA).append("--- NSR-AI Commands ---").append("\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai <message>").append(ChatColor.GRAY).append(" - Engage in a conversation with the AI. The AI will respond based on its knowledge and context.\n");
        if (this.plugin.isDataCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai data <query>").append(ChatColor.GRAY).append(" - Query the AI's knowledge base for information. Get instant answers on various topics.\n");
            if (isAdmin) {
                helpMessage.append(ChatColor.YELLOW).append("/ai data all").append(ChatColor.GRAY).append(" - View all entries currently stored in the AI's knowledge base. Requires admin mode.\n");
            }
        }
        if (isAdmin && this.plugin.isAdminDisableCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai admin <code>").append(ChatColor.GRAY).append(" - Toggle administrator mode for advanced plugin management. Requires a valid activation code.\n");
        }
        if (isAdmin && this.plugin.isAdminDisableCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai disable").append(ChatColor.GRAY).append(" - Disable your current admin mode session. Only available when admin mode is active.\n");
        }
        if (this.plugin.isVersionCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai version (or /ai v)").append(ChatColor.GRAY).append(" - Display the current plugin version and check for available updates.\n");
            helpMessage.append(ChatColor.YELLOW).append("/ai version security (or /ai v s)").append(ChatColor.GRAY).append(" - Show the version of the security library used by the plugin.\n");
            helpMessage.append(ChatColor.YELLOW).append("/ai version bug (or /ai v b)").append(ChatColor.GRAY).append(" - Display the current internal bug fix version of the plugin.\n");
        }
        if (isAdmin) {
            if (this.plugin.isAddConfirmCommandEnabled()) {
                helpMessage.append(ChatColor.YELLOW).append("/ai add <keyword>, <message_content>").append(ChatColor.GRAY).append(" - Add new knowledge entries to the AI's database. Requires confirmation.\n");
            } else {
                helpMessage.append(ChatColor.YELLOW).append("/ai add <keyword>, <message_content>").append(ChatColor.GRAY).append(" - Add new knowledge entries to the AI's database. No confirmation needed.\n");
            }
        }
        if (isAdmin) {
            if (this.plugin.isRemoveConfirmCommandEnabled()) {
                helpMessage.append(ChatColor.YELLOW).append("/ai remove <keyword>").append(ChatColor.GRAY).append(" - Remove existing knowledge entries from the AI's database. Requires confirmation.\n");
            } else {
                helpMessage.append(ChatColor.YELLOW).append("/ai remove <keyword>").append(ChatColor.GRAY).append(" - Remove existing knowledge entries from the AI's database. No confirmation needed.\n");
            }
        }
        helpMessage.append(ChatColor.YELLOW).append("/ai confirm <code>").append(ChatColor.GRAY).append(" - Confirm a pending action, such as adding or removing knowledge entries.\n");
        if (isAdmin && this.plugin.isReloadCommandEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai reload [f|features|nsr-ai|k|knowledge|c|config]").append(ChatColor.GRAY).append(" - Reload plugin configurations (main, features, knowledge base) without restarting the server.\n");
        }
        helpMessage.append(ChatColor.YELLOW).append("/ai shop <item_name>").append(ChatColor.GRAY).append(" - Search for prices of items in the server's economy shop.\n");
        if (isAdmin && this.plugin.isCacheClearEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai cache clear").append(ChatColor.GRAY).append(" - Clear your current AI conversation cache, starting a new session.\n");
        }
        if (isAdmin && this.plugin.isCacheRefreshEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai cache refresh").append(ChatColor.GRAY).append(" - Refresh your conversation cache from logs, restoring previous context.\n");
        }
        if (isAdmin && this.plugin.isMemoryClearEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai memory clear").append(ChatColor.GRAY).append(" - Summarize and clear your AI conversation memory, freeing up resources.\n");
        }
        if (isAdmin && this.plugin.isMemoryRefreshEnabled()) {
            helpMessage.append(ChatColor.YELLOW).append("/ai memory refresh").append(ChatColor.GRAY).append(" - Summarize and refresh your AI conversation memory from logs.\n");
        }
        helpMessage.append(ChatColor.AQUA).append("--- API Key Management ---").append("\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey").append(ChatColor.GRAY).append(" - Manage your personal API keys for AI services. Shows key management options.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey store <projectId>").append(ChatColor.GRAY).append(" - Convert your active session key into a permanent stored key with a project ID.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey fallback global <true|false>").append(ChatColor.GRAY).append(" - Enable or disable global API key fallback if your personal key fails.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey info [all|key-id]").append(ChatColor.GRAY).append(" - View detailed information and statistics for your API keys.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey model <key-id> <new-model>").append(ChatColor.GRAY).append(" - Change the AI model used by a specific API key.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey list").append(ChatColor.GRAY).append(" - List all your stored and session-based API keys.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey clear [all|key-id]").append(ChatColor.GRAY).append(" - Delete specific or all API keys from your account.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey timer <key-id> remove").append(ChatColor.GRAY).append(" - Manually clear the overloaded status of an API key.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai apikey msg save <true|false>").append(ChatColor.GRAY).append(" - Control whether your AI chat history is saved to plugin logs.\n");
        helpMessage.append(ChatColor.AQUA).append("--- Pet Commands ---").append("\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet").append(ChatColor.GRAY).append(" - View details about your active pet. If no pet is active, shows general pet commands.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet tame").append(ChatColor.GRAY).append(" - Tame a new pet. (Usage may vary based on pet type and configuration.)\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet inv").append(ChatColor.GRAY).append(" - Access your pet's inventory.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet info").append(ChatColor.GRAY).append(" - Display detailed information about your pet, including stats and mood.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet share <pet_name> [allow] [relationship]").append(ChatColor.GRAY).append(" - Generate a shareable link for your pet, allowing others to interact with it.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet removefriend <player_name> <pet_name>").append(ChatColor.GRAY).append(" - Remove a friend's access to your pet.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet relation <pet_name> <player_name> <new_relationship>").append(ChatColor.GRAY).append(" - Change a friend's relationship status with your pet.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet link list").append(ChatColor.GRAY).append(" - List your pets that are shared with other players.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet linked list").append(ChatColor.GRAY).append(" - List pets owned by other players that you are linked with.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet unlink <pet_name>").append(ChatColor.GRAY).append(" - Remove your link to another player's pet.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet nickname <new_nickname>").append(ChatColor.GRAY).append(" - Set a new nickname for your pet.\n");
        helpMessage.append(ChatColor.YELLOW).append("/ai pet inv allow <pet_name> <player_name>").append(ChatColor.GRAY).append(" - Grant another player access to your pet's inventory.\n");
        boolean isAdvancedPlayerStatsAddonLoaded = false;
        if (this.plugin.getAddonManager() != null) {
            for (AIAddon addon : this.plugin.getAddonManager().getAddons()) {
                if (!addon.getName().equals("NSR-AI-Advanced-Player-Stats")) continue;
                isAdvancedPlayerStatsAddonLoaded = true;
                break;
            }
        }
        if (isAdvancedPlayerStatsAddonLoaded) {
            helpMessage.append(ChatColor.AQUA).append("--- Privacy Commands ---").append("\n");
            if (isAdmin) {
                helpMessage.append(ChatColor.YELLOW).append("/ai privacy <player> <feature> [on|off]").append(ChatColor.GRAY).append(" - Manage privacy settings for a specific player and feature. Requires admin mode.\n");
            } else {
                helpMessage.append(ChatColor.YELLOW).append("/ai privacy <feature> [on|off]").append(ChatColor.GRAY).append(" - Manage your own privacy settings for a specific feature.\n");
            }
        }
        helpMessage.append(ChatColor.AQUA).append("-------------------------\n");
        helpMessage.append(ChatColor.GRAY).append("Note: Some commands may not be present, misconfigured, or have incorrect descriptions based on server settings.\n");
        player.sendMessage(helpMessage.toString());
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        if (args2.length == 1) {
            return Arrays.asList("admin", "admincode", "cache", "memory", "version", "data", "add", "remove", "reload", "confirm", "disable", "help", "pet", "apikey").stream().filter(s -> s.startsWith(args2[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args2.length >= 2 && args2[0].equalsIgnoreCase("pet")) {
            List<String> petSubCommands = Arrays.asList("tame", "inv", "info", "share", "removefriend", "relation", "link", "linked", "unlink", "nickname");
            if (args2.length == 2) {
                return petSubCommands.stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[1].equalsIgnoreCase("share")) {
                if (args2.length == 3) {
                    return this.getOwnedPetNames(player).stream().filter(s -> s.toLowerCase().startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
                if (args2.length == 4) {
                    ArrayList<String> suggestions = new ArrayList<String>();
                    suggestions.add("allow");
                    return suggestions.stream().filter(s -> s.toLowerCase().startsWith(args2[3].toLowerCase())).collect(Collectors.toList());
                }
            } else if (args2[1].equalsIgnoreCase("info")) {
                if (args2.length == 3) {
                    return this.getRelevantPetNames(player).stream().filter(s -> s.toLowerCase().startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
            } else if (args2[1].equalsIgnoreCase("removefriend")) {
                if (args2.length == 3) {
                    ArrayList<String> friendNames = new ArrayList<String>();
                    Map<String, Pet> ownedPets = this.plugin.getPetManager().getLoadedPets().get(player.getUniqueId());
                    if (ownedPets != null) {
                        for (Pet pet : ownedPets.values()) {
                            for (UUID friendUuid : pet.getPetFriends().keySet()) {
                                friendNames.add(Bukkit.getOfflinePlayer((UUID)friendUuid).getName());
                            }
                        }
                    }
                    return friendNames.stream().distinct().filter(name -> name != null && name.toLowerCase().startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
                if (args2.length == 4) {
                    return this.getOwnedPetNames(player).stream().filter(s -> s.toLowerCase().startsWith(args2[3].toLowerCase())).collect(Collectors.toList());
                }
            } else if (args2[1].equalsIgnoreCase("relation")) {
                if (args2.length == 3) {
                    return this.getOwnedPetNames(player).stream().filter(s -> s.toLowerCase().startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
                if (args2.length == 4) {
                    String petName = args2[2];
                    Pet pet = this.plugin.getPetManager().getPet(player, petName);
                    if (pet != null) {
                        return pet.getPetFriends().keySet().stream().map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid).getName()).filter(name -> name != null && name.toLowerCase().startsWith(args2[3].toLowerCase())).collect(Collectors.toList());
                    }
                }
            } else if (args2[1].equalsIgnoreCase("link") || args2[1].equalsIgnoreCase("linked")) {
                if (args2.length == 3) {
                    return Arrays.asList("list").stream().filter(s -> s.startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
            } else if (args2[1].equalsIgnoreCase("unlink")) {
                if (args2.length == 3) {
                    return this.getRelevantPetNames(player).stream().filter(s -> s.toLowerCase().startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
            } else if (args2[1].equalsIgnoreCase("inv")) {
                if (args2.length == 3) {
                    ArrayList<String> suggestions = new ArrayList<String>();
                    suggestions.add("allow");
                    suggestions.add("disallow");
                    suggestions.addAll(this.getRelevantPetNames(player));
                    return suggestions.stream().filter(s -> s.startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
                if (args2.length == 4 && (args2[2].equalsIgnoreCase("allow") || args2[2].equalsIgnoreCase("disallow"))) {
                    return ((Map)this.plugin.getPetManager().getLoadedPets().getOrDefault(player.getUniqueId(), new HashMap())).values().stream().map(Pet::getPetName).filter(s -> s.toLowerCase().startsWith(args2[3].toLowerCase())).collect(Collectors.toList());
                }
                if (args2.length == 5 && (args2[2].equalsIgnoreCase("allow") || args2[2].equalsIgnoreCase("disallow"))) {
                    return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).filter(s -> s.toLowerCase().startsWith(args2[4].toLowerCase())).collect(Collectors.toList());
                }
            }
            return new ArrayList<String>();
        }
        if (args2.length == 2 && !args2[0].equalsIgnoreCase("pet")) {
            if (args2[0].equalsIgnoreCase("apikey")) {
                ArrayList<String> subcommands = new ArrayList<String>(Arrays.asList("store", "info", "model", "list", "clear", "fallback", "timer", "msg"));
                return subcommands.stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[0].equalsIgnoreCase("cache")) {
                return Arrays.asList("clear", "refresh").stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[0].equalsIgnoreCase("memory")) {
                return Arrays.asList("clear", "refresh").stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[0].equalsIgnoreCase("reload")) {
                return Arrays.asList("f", "features", "nsr-ai", "k", "knowledge", "c", "config").stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[0].equalsIgnoreCase("version") || args2[0].equalsIgnoreCase("v")) {
                return Arrays.asList("security", "s", "bug", "b").stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
            }
        } else if (args2.length == 3) {
            if (args2[0].equalsIgnoreCase("apikey")) {
                if (args2[1].equalsIgnoreCase("store")) {
                    return this.plugin.getPlayerApiKeyManager().getAllKeys(player).stream().filter(key -> key.getStorageMode() == PlayerApiKeyManager.ApiKey.StorageMode.SESSION).map(PlayerApiKeyManager.ApiKey::getKeyId).filter(s -> s.toLowerCase().startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
                if (args2[1].equalsIgnoreCase("info") || args2[1].equalsIgnoreCase("clear") || args2[1].equalsIgnoreCase("timer")) {
                    List suggestions = this.plugin.getPlayerApiKeyManager().getAllKeys(player).stream().map(PlayerApiKeyManager.ApiKey::getKeyId).collect(Collectors.toList());
                    suggestions.add("all");
                    return suggestions.stream().filter(s -> s.toLowerCase().startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
                if (args2[1].equalsIgnoreCase("model")) {
                    return this.plugin.getPlayerApiKeyManager().getAllKeys(player).stream().map(PlayerApiKeyManager.ApiKey::getKeyId).filter(s -> s.toLowerCase().startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
                if (args2[1].equalsIgnoreCase("msg")) {
                    return Arrays.asList("save").stream().filter(s -> s.startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
                if (args2[1].equalsIgnoreCase("fallback")) {
                    return Arrays.asList("global").stream().filter(s -> s.startsWith(args2[2].toLowerCase())).collect(Collectors.toList());
                }
            }
        } else if (args2.length == 4 && args2[0].equalsIgnoreCase("apikey")) {
            if (args2[1].equalsIgnoreCase("fallback") && args2[2].equalsIgnoreCase("global")) {
                return Arrays.asList("true", "false").stream().filter(s -> s.startsWith(args2[3].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[1].equalsIgnoreCase("timer")) {
                return Arrays.asList("remove").stream().filter(s -> s.startsWith(args2[3].toLowerCase())).collect(Collectors.toList());
            }
            if (args2[1].equalsIgnoreCase("msg") && args2[2].equalsIgnoreCase("save")) {
                return Arrays.asList("true", "false").stream().filter(s -> s.startsWith(args2[3].toLowerCase())).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }

    private List<String> getOwnedPetNames(Player player) {
        return ((Map)this.plugin.getPetManager().getLoadedPets().getOrDefault(player.getUniqueId(), new HashMap())).values().stream().map(Pet::getPetName).collect(Collectors.toList());
    }

    private List<String> getLinkedPetNames(Player player) {
        ArrayList<String> petNames = new ArrayList<String>();
        for (Map<String, Pet> ownerPetsMap : this.plugin.getPetManager().getLoadedPets().values()) {
            for (Pet pet : ownerPetsMap.values()) {
                if (!pet.getPetFriends().containsKey(player.getUniqueId())) continue;
                petNames.add(pet.getPetName());
            }
        }
        return petNames;
    }

    private List<String> getRelevantPetNames(Player player) {
        ArrayList<String> petNames = new ArrayList<String>();
        petNames.addAll(this.getOwnedPetNames(player));
        petNames.addAll(this.getLinkedPetNames(player));
        return petNames.stream().distinct().collect(Collectors.toList());
    }

    private static class KeyCreationRequest {
        final StorageMode mode;
        final String projectId;
        final long timestamp;

        KeyCreationRequest(StorageMode mode, String projectId) {
            this.mode = mode;
            this.projectId = projectId;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private static enum StorageMode {
        SESSION,
        STORED;

    }
}

