/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.data.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class AdminRecipientDAO {
    private final NSRAIPlugin plugin;
    private final DatabaseManager dbManager;

    public AdminRecipientDAO(NSRAIPlugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
    }

    public void addRecipient(UUID uuid) {
        String sql = "INSERT OR IGNORE INTO admin_recipients(uuid) VALUES(?)";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error adding admin recipient: " + e.getMessage(), e);
        }
    }

    public void removeRecipient(UUID uuid) {
        String sql = "DELETE FROM admin_recipients WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error removing admin recipient: " + e.getMessage(), e);
        }
    }

    public List<UUID> getRecipients() {
        ArrayList<UUID> recipients = new ArrayList<UUID>();
        String sql = "SELECT uuid FROM admin_recipients";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                recipients.add(UUID.fromString(rs.getString("uuid")));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting admin recipients: " + e.getMessage(), e);
        }
        return recipients;
    }
}

