/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class DatabaseManager {
    private final NSRAIPlugin plugin;
    private final String databasePath;

    public DatabaseManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.databasePath = "jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + File.separator + "nsr_ai_stats.db";
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.databasePath);
    }

    public void initializeDatabase() {
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS players (uuid TEXT PRIMARY KEY,name TEXT NOT NULL,first_join INTEGER NOT NULL,last_seen INTEGER NOT NULL,sessions INTEGER DEFAULT 0,longest_session INTEGER DEFAULT 0,shortest_session INTEGER DEFAULT 0)");
            stmt.execute("CREATE TABLE IF NOT EXISTS stats (uuid TEXT NOT NULL,key TEXT NOT NULL,value BIGINT DEFAULT 0,PRIMARY KEY(uuid, key),FOREIGN KEY (uuid) REFERENCES players(uuid) ON DELETE CASCADE)");
            stmt.execute("CREATE TABLE IF NOT EXISTS locations (id INTEGER PRIMARY KEY AUTOINCREMENT,uuid TEXT NOT NULL,type TEXT NOT NULL,world TEXT NOT NULL,x INTEGER NOT NULL,y INTEGER NOT NULL,z INTEGER NOT NULL,ts INTEGER NOT NULL,extra TEXT,FOREIGN KEY (uuid) REFERENCES players(uuid) ON DELETE CASCADE)");
            stmt.execute("CREATE TABLE IF NOT EXISTS inventory_snapshots (uuid TEXT NOT NULL,id INTEGER NOT NULL,ts INTEGER NOT NULL,payload BLOB NOT NULL,PRIMARY KEY(uuid, id),FOREIGN KEY (uuid) REFERENCES players(uuid) ON DELETE CASCADE)");
            stmt.execute("CREATE TABLE IF NOT EXISTS admin_recipients (uuid TEXT PRIMARY KEY)");
            stmt.execute("CREATE TABLE IF NOT EXISTS player_notes (id INTEGER PRIMARY KEY AUTOINCREMENT,uuid TEXT NOT NULL,note TEXT NOT NULL,ts INTEGER NOT NULL,author_uuid TEXT NOT NULL,FOREIGN KEY (uuid) REFERENCES players(uuid) ON DELETE CASCADE)");
            stmt.execute("CREATE TABLE IF NOT EXISTS player_commands (id INTEGER PRIMARY KEY AUTOINCREMENT,uuid TEXT NOT NULL,command TEXT NOT NULL,timestamp INTEGER NOT NULL,FOREIGN KEY (uuid) REFERENCES players(uuid) ON DELETE CASCADE)");
            this.plugin.getLogger().info("Database initialized successfully.");
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database: " + e.getMessage(), e);
        }
    }
}

