/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.data.DatabaseManager;
import com.nsr.ai.plugin.data.LocationDAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Location;

public class LocationDAOImpl
implements LocationDAO {
    private final NSRAIPlugin plugin;
    private final DatabaseManager dbManager;

    public LocationDAOImpl(NSRAIPlugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
    }

    @Override
    public void addLocation(UUID uuid, String type, Location loc, String extra) {
        String sql = "INSERT INTO locations(uuid, type, world, x, y, z, ts, extra) VALUES(?,?,?,?,?,?,?,?)";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, type);
            pstmt.setString(3, loc.getWorld().getName());
            pstmt.setInt(4, loc.getBlockX());
            pstmt.setInt(5, loc.getBlockY());
            pstmt.setInt(6, loc.getBlockZ());
            pstmt.setLong(7, System.currentTimeMillis());
            pstmt.setString(8, extra);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error adding location for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Location getLastLocation(UUID uuid, String type) {
        String sql = "SELECT world, x, y, z FROM locations WHERE uuid = ? AND type = ? ORDER BY ts DESC LIMIT 1";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, type);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            String worldName = rs.getString("world");
            Location location = new Location(this.plugin.getServer().getWorld(worldName), (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z"));
            return location;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting last location for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return null;
    }

    public List<Location> getDeathHistory(UUID uuid, int limit) {
        ArrayList<Location> deathLocations = new ArrayList<Location>();
        String sql = "SELECT world, x, y, z FROM locations WHERE uuid = ? AND type = 'death_history' ORDER BY ts DESC LIMIT ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setInt(2, limit);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String worldName = rs.getString("world");
                deathLocations.add(new Location(this.plugin.getServer().getWorld(worldName), (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting death history for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return deathLocations;
    }

    @Override
    public void deleteOldestDeathHistory(UUID uuid, int keepCount) {
        String sql = "DELETE FROM locations WHERE id IN (SELECT id FROM locations WHERE uuid = ? AND type = 'death_history' ORDER BY ts ASC LIMIT (SELECT COUNT(*) FROM locations WHERE uuid = ? AND type = 'death_history') - ?)";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, uuid.toString());
            pstmt.setInt(3, keepCount);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error deleting oldest death history for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    @Override
    public List<Map.Entry<Location, String>> getDeathHistoryWithExtra(UUID uuid, int limit) {
        ArrayList<Map.Entry<Location, String>> deathHistory = new ArrayList<Map.Entry<Location, String>>();
        String sql = "SELECT world, x, y, z, extra FROM locations WHERE uuid = ? AND type = 'death_history' ORDER BY ts DESC LIMIT ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setInt(2, limit);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String worldName = rs.getString("world");
                Location loc = new Location(this.plugin.getServer().getWorld(worldName), (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z"));
                String extra = rs.getString("extra");
                deathHistory.add(new AbstractMap.SimpleEntry<Location, String>(loc, extra));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting death history with extra for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return deathHistory;
    }
}

