/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.data.DatabaseManager;
import com.nsr.ai.plugin.data.PlayerCommandDAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class PlayerCommandDAOImpl
implements PlayerCommandDAO {
    private final NSRAIPlugin plugin;
    private final DatabaseManager dbManager;

    public PlayerCommandDAOImpl(NSRAIPlugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
    }

    @Override
    public void addCommand(UUID uuid, String command) {
        String sql = "INSERT INTO player_commands(uuid, command, timestamp) VALUES(?,?,?)";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, command);
            pstmt.setLong(3, System.currentTimeMillis());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error adding command for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    @Override
    public List<String> getPlayerCommands(UUID uuid, int limit) {
        String sql = "SELECT command FROM player_commands WHERE uuid = ? ORDER BY timestamp DESC LIMIT ?";
        ArrayList<String> commands = new ArrayList<String>();
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setInt(2, limit);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                commands.add(rs.getString("command"));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting commands for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return commands;
    }
}

