/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.data.DatabaseManager;
import com.nsr.ai.plugin.data.PlayerDAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;

public class PlayerDAOImpl
implements PlayerDAO {
    private final NSRAIPlugin plugin;
    private final DatabaseManager dbManager;

    public PlayerDAOImpl(NSRAIPlugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
    }

    @Override
    public void createPlayer(UUID uuid, String name) {
        String sql = "INSERT OR IGNORE INTO players(uuid, name, first_join, last_seen, sessions, longest_session, shortest_session) VALUES(?,?,?,?,?,?,?)";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            long currentTime = System.currentTimeMillis();
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, name);
            pstmt.setLong(3, currentTime);
            pstmt.setLong(4, currentTime);
            pstmt.setInt(5, 1);
            pstmt.setLong(6, 0L);
            pstmt.setLong(7, 0L);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error creating player " + name + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void updatePlayerLastSeen(UUID uuid) {
        String sql = "UPDATE players SET last_seen = ? WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setLong(1, System.currentTimeMillis());
            pstmt.setString(2, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error updating player last seen for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void incrementPlayerSessions(UUID uuid) {
        String sql = "UPDATE players SET sessions = sessions + 1 WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error incrementing player sessions for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getPlayerFirstJoin(UUID uuid) {
        String sql = "SELECT first_join FROM players WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("first_join");
            return l;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting player first join for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getPlayerLastSeen(UUID uuid) {
        String sql = "SELECT last_seen FROM players WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("last_seen");
            return l;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting player last seen for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 0L;
    }

    @Override
    public void updatePlayerSessionStats(UUID uuid, long sessionDuration) {
        String sql = "UPDATE players SET longest_session = MAX(longest_session, ?), shortest_session = MIN(shortest_session, ?) WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setLong(1, sessionDuration);
            pstmt.setLong(2, sessionDuration);
            pstmt.setString(3, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error updating player session stats for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean playerExists(UUID uuid) {
        String sql = "SELECT uuid FROM players WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                try {
                    pstmt.setString(1, uuid.toString());
                    ResultSet rs = pstmt.executeQuery();
                    bl = rs.next();
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error checking if player exists for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getPlayerLongestSession(UUID uuid) {
        String sql = "SELECT longest_session FROM players WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("longest_session");
            return l;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting player longest session for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getPlayerShortestSession(UUID uuid) {
        String sql = "SELECT shortest_session FROM players WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("shortest_session");
            return l;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting player shortest session for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getPlayerSessionCount(UUID uuid) {
        String sql = "SELECT sessions FROM players WHERE uuid = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt("sessions");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting player session count for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getPlayerTotalPlaytime(UUID uuid) {
        String sql = "SELECT value FROM stats WHERE uuid = ? AND key = 'playtime.total'";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("value");
            return l;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting player total playtime for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 0L;
    }
}

