/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.managers.PlayerApiKeyManager;
import com.nsr.ai.plugin.managers.PlayerSecurityManager;
import com.nsr.ai.plugin.util.SecurityUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import org.bukkit.configuration.file.YamlConfiguration;

public class ApiKeyStorage {
    private final NSRAIPlugin plugin;
    private final File keysFolder;

    public ApiKeyStorage(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.keysFolder = new File(plugin.getDataFolder(), "player_keys");
        if (!this.keysFolder.exists()) {
            this.keysFolder.mkdirs();
        }
    }

    public void saveKey(PlayerApiKeyManager.ApiKey key) {
        File playerDir = new File(this.keysFolder, key.getPlayerUuid().toString());
        if (!playerDir.exists()) {
            playerDir.mkdirs();
        }
        File keyFile = new File(playerDir, key.getProjectId() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)keyFile);
        try {
            SecurityUtil securityUtil = this.plugin.getSecurityUtil();
            PlayerSecurityManager playerSecurityManager = this.plugin.getPlayerSecurityManager();
            SecretKey userKey = securityUtil.deriveUserKey(key.getPlayerUuid(), key.getProjectId());
            SecretKey playerMasterKey = playerSecurityManager.getPlayerMasterKey(key.getPlayerUuid());
            SecretKey serverMasterKey = securityUtil.getServerMasterKey();
            String cipher1 = securityUtil.encrypt(key.getApiKey(), userKey);
            String cipher2 = securityUtil.encrypt(cipher1, playerMasterKey);
            String finalCipher = securityUtil.encrypt(cipher2, serverMasterKey);
            String hash = securityUtil.hashSha256(finalCipher);
            config.set("key", (Object)finalCipher);
            config.set("hash", (Object)hash);
            config.set("model", (Object)key.getModel());
            config.set("save-chat-history", (Object)key.isSaveChatHistory());
            config.set("status", (Object)key.getStatus().name());
            config.set("projectId", (Object)key.getProjectId());
            config.set("uses", (Object)key.getUsageCount());
            config.set("fallback", (Object)key.getFallbackCount());
            config.set("error", (Object)key.getErrorCount());
            config.save(keyFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not securely save API key " + key.getProjectId() + " for player " + String.valueOf(key.getPlayerUuid()), e);
        }
    }

    public void loadKeysForPlayer(UUID playerUuid, Map<String, PlayerApiKeyManager.ApiKey> keyMap) {
        File[] keyFiles;
        File playerDir = new File(this.keysFolder, playerUuid.toString());
        if (!playerDir.exists() || !playerDir.isDirectory()) {
            this.migrateOldPlayerFile(playerUuid);
            if (!playerDir.exists() || !playerDir.isDirectory()) {
                return;
            }
        }
        if ((keyFiles = playerDir.listFiles((dir, name) -> name.endsWith(".yml"))) == null) {
            return;
        }
        for (File keyFile : keyFiles) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)keyFile);
            String projectId = keyFile.getName().replace(".yml", "");
            String encryptedApiKey = config.getString("key");
            String storedHash = config.getString("hash");
            if (encryptedApiKey == null || storedHash == null) {
                this.plugin.getLogger().warning("[NSR-AI Security] Incomplete key file for player " + String.valueOf(playerUuid) + " project " + projectId + ". Skipping.");
                continue;
            }
            String apiKeyStr = null;
            try {
                SecurityUtil securityUtil = this.plugin.getSecurityUtil();
                String calculatedHash = securityUtil.hashSha256(encryptedApiKey);
                if (!calculatedHash.equals(storedHash)) {
                    this.plugin.getLogger().warning("[NSR-AI Security] Hash mismatch for player " + String.valueOf(playerUuid) + " project " + projectId + ". Key may be tampered with. Skipping.");
                    continue;
                }
                PlayerSecurityManager playerSecurityManager = this.plugin.getPlayerSecurityManager();
                String cipher2 = securityUtil.decrypt(encryptedApiKey, securityUtil.getServerMasterKey());
                SecretKey playerMasterKey = playerSecurityManager.getPlayerMasterKey(playerUuid);
                String cipher1 = securityUtil.decrypt(cipher2, playerMasterKey);
                SecretKey userKey = securityUtil.deriveUserKey(playerUuid, projectId);
                apiKeyStr = securityUtil.decrypt(cipher1, userKey);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "[NSR-AI Security] Failed to decrypt API key for player " + String.valueOf(playerUuid) + " project " + projectId + ". Error: " + e.getMessage());
                continue;
            }
            if (apiKeyStr == null) {
                this.plugin.getLogger().warning("[NSR-AI Security] API key could not be loaded for player " + String.valueOf(playerUuid) + " project " + projectId + ". Skipping key.");
                continue;
            }
            PlayerApiKeyManager.ApiKey loadedKey = new PlayerApiKeyManager.ApiKey();
            loadedKey.setPlayerUuid(playerUuid);
            loadedKey.setApiKey(apiKeyStr);
            loadedKey.setProjectId(projectId);
            loadedKey.setKeyId(projectId);
            loadedKey.setStorageMode(PlayerApiKeyManager.ApiKey.StorageMode.STORED);
            loadedKey.setMaskedKey(this.plugin.getPlayerApiKeyManager().maskApiKey(apiKeyStr));
            loadedKey.setModel(config.getString("model"));
            loadedKey.setSaveChatHistory(config.getBoolean("save-chat-history", false));
            loadedKey.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.valueOf(config.getString("status", "ACTIVE")));
            loadedKey.setUsageCount(config.getInt("uses", 0));
            loadedKey.setFallbackCount(config.getInt("fallback", 0));
            loadedKey.setErrorCount(config.getInt("error", 0));
            loadedKey.setCreationDate(System.currentTimeMillis());
            this.plugin.getPlayerApiKeyManager().detectProviderAndModel(loadedKey);
            keyMap.put(loadedKey.getKeyId(), loadedKey);
        }
    }

    public void deleteKey(UUID playerUuid, String projectId) {
        File playerDir = new File(this.keysFolder, playerUuid.toString());
        File keyFile = new File(playerDir, projectId + ".yml");
        if (keyFile.exists() && !keyFile.delete()) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not delete API key file for player " + String.valueOf(playerUuid) + " and project " + projectId);
        }
    }

    public void savePlayerSettings(UUID playerUuid, boolean fallbackEnabled) {
        File playerDir = new File(this.keysFolder, playerUuid.toString());
        if (!playerDir.exists()) {
            playerDir.mkdirs();
        }
        File settingsFile = new File(playerDir, "settings.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)settingsFile);
        config.set("settings.fallback-to-global", (Object)fallbackEnabled);
        try {
            config.save(settingsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save player settings for " + String.valueOf(playerUuid), e);
        }
    }

    public boolean loadPlayerFallbackSetting(UUID playerUuid) {
        File playerDir = new File(this.keysFolder, playerUuid.toString());
        File settingsFile = new File(playerDir, "settings.yml");
        if (!settingsFile.exists()) {
            return false;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)settingsFile);
        return config.getBoolean("settings.fallback-to-global", false);
    }

    private void migrateOldPlayerFile(UUID playerUuid) {
        File migratedFile;
        File oldPlayerFile = new File(this.keysFolder, playerUuid.toString() + ".yml");
        if (!oldPlayerFile.exists()) {
            return;
        }
        this.plugin.getLogger().info("[NSR-AI Security] Found old key file for player " + String.valueOf(playerUuid) + ". Migrating to new format...");
        YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)oldPlayerFile);
        if (oldConfig.isConfigurationSection("keys")) {
            for (String projectId : oldConfig.getConfigurationSection("keys").getKeys(false)) {
                String encryptedApiKey = oldConfig.getString("keys." + projectId + ".key");
                String storedHash = oldConfig.getString("keys." + projectId + ".hash");
                String apiKeyStr = null;
                try {
                    String plainTextApiKey;
                    String calculatedHash;
                    SecurityUtil securityUtil = this.plugin.getSecurityUtil();
                    if (encryptedApiKey != null && storedHash != null && (calculatedHash = securityUtil.hashSha256(encryptedApiKey)).equals(storedHash)) {
                        String cipher1 = securityUtil.decrypt(encryptedApiKey, securityUtil.getServerMasterKey());
                        SecretKey userKey = securityUtil.deriveUserKey(playerUuid, projectId);
                        apiKeyStr = securityUtil.decrypt(cipher1, userKey);
                    }
                    if (apiKeyStr == null && (plainTextApiKey = oldConfig.getString("keys." + projectId + ".key")) != null && !plainTextApiKey.isEmpty() && !plainTextApiKey.equals(encryptedApiKey)) {
                        apiKeyStr = plainTextApiKey;
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("[NSR-AI Security] Could not decrypt old key for project " + projectId + ". Trying plain text. Error: " + e.getMessage());
                    apiKeyStr = oldConfig.getString("keys." + projectId + ".key");
                }
                if (apiKeyStr == null || apiKeyStr.isEmpty()) {
                    this.plugin.getLogger().warning("[NSR-AI Security] Could not load old key for project " + projectId + ". Skipping migration for this key.");
                    continue;
                }
                PlayerApiKeyManager.ApiKey keyToMigrate = new PlayerApiKeyManager.ApiKey();
                keyToMigrate.setPlayerUuid(playerUuid);
                keyToMigrate.setApiKey(apiKeyStr);
                keyToMigrate.setProjectId(projectId);
                keyToMigrate.setKeyId(projectId);
                keyToMigrate.setModel(oldConfig.getString("keys." + projectId + ".model"));
                keyToMigrate.setSaveChatHistory(oldConfig.getBoolean("keys." + projectId + ".save-chat-history", false));
                keyToMigrate.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.valueOf(oldConfig.getString("keys." + projectId + ".status", "ACTIVE")));
                keyToMigrate.setUsageCount(oldConfig.getInt("keys." + projectId + ".uses", 0));
                keyToMigrate.setFallbackCount(oldConfig.getInt("keys." + projectId + ".fallback", 0));
                keyToMigrate.setErrorCount(oldConfig.getInt("keys." + projectId + ".error", 0));
                this.saveKey(keyToMigrate);
                this.plugin.getLogger().info("[NSR-AI Security] Successfully migrated key for project: " + projectId);
            }
        }
        if (!oldPlayerFile.renameTo(migratedFile = new File(this.keysFolder, playerUuid.toString() + ".yml.migrated"))) {
            this.plugin.getLogger().severe("[NSR-AI Security] Could not rename migrated key file for player " + String.valueOf(playerUuid));
        } else {
            this.plugin.getLogger().info("[NSR-AI Security] Finished migrating old key file for player " + String.valueOf(playerUuid));
        }
    }
}

