/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.pet;

import org.bukkit.entity.EntityType;

public enum PetSpecies {
    WOLF("Woof \ud83d\udc15", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    CAT("Meow \ud83d\udc31", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    HORSE("Neigh \ud83d\udc34", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    PARROT("Squawk \ud83e\udd9c", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    PIG("Oink \ud83d\udc37", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    PANDA("Munch \ud83d\udc3c", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    FOX("Yip \ud83e\udd8a", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    RABBIT("Squeak \ud83d\udc07", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    TURTLE("Splash \ud83d\udc22", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d"),
    AXOLOTL("Blub \ud83d\udc20", "\u2764\ufe0f", "\ud83d\ude21", "\ud83d\ude14", "\ud83d\ude31", "\ud83d\ude0d");

    private final String sound;
    private final String happyEmoji;
    private final String angryEmoji;
    private final String sadEmoji;
    private final String scaredEmoji;
    private final String bondingEmoji;

    private PetSpecies(String sound, String happyEmoji, String angryEmoji, String sadEmoji, String scaredEmoji, String bondingEmoji) {
        this.sound = sound;
        this.happyEmoji = happyEmoji;
        this.angryEmoji = angryEmoji;
        this.sadEmoji = sadEmoji;
        this.scaredEmoji = scaredEmoji;
        this.bondingEmoji = bondingEmoji;
    }

    public String getSound() {
        return this.sound;
    }

    public String getEmoji(String mood) {
        switch (mood.toLowerCase()) {
            case "happy": {
                return this.happyEmoji;
            }
            case "angry": {
                return this.angryEmoji;
            }
            case "sad": {
                return this.sadEmoji;
            }
            case "scared": {
                return this.scaredEmoji;
            }
            case "bonding": {
                return this.bondingEmoji;
            }
        }
        return "";
    }

    public static PetSpecies fromEntityType(EntityType entityType) {
        try {
            return PetSpecies.valueOf(entityType.name());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

