/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.pet.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.pet.Pet;
import com.nsr.ai.plugin.pet.data.PetFriendData;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class PetDataStorage {
    private final NSRAIPlugin plugin;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public PetDataStorage(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    public void savePet(Pet pet) {
        File petFile = this.getPetDataFile(pet.getOwnerName(), pet.getPetName());
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)petFile);
        config.set("pet-name", (Object)pet.getPetName());
        config.set("nickname", (Object)pet.getNickname());
        config.set("type", (Object)pet.getType().name());
        config.set("owner", (Object)pet.getOwnerName());
        config.set("owner-uuid", (Object)pet.getOwnerUuid().toString());
        config.set("personality", (Object)pet.getPersonality());
        config.set("bond", (Object)pet.getBond());
        config.set("hunger", (Object)pet.getHunger());
        config.set("mood", (Object)pet.getMood().name());
        if (pet.getTamedDate() != null) {
            config.set("tamed-date", (Object)this.dateFormat.format(pet.getTamedDate()));
        }
        if (pet.getLinkedDate() != null) {
            config.set("linked-date", (Object)this.dateFormat.format(pet.getLinkedDate()));
        }
        config.set("last-message", (Object)pet.getLastMessage());
        config.set("status", (Object)pet.getStatus());
        config.set("recent-hits", (Object)pet.getRecentHits());
        config.set("last-hit-timestamp", (Object)pet.getLastHitTimestamp());
        config.set("level", (Object)pet.getLevel());
        config.set("xp", (Object)pet.getXp());
        config.set("health", (Object)pet.getHealth());
        if (pet.getInventory() != null) {
            config.set("inventory", (Object)pet.getInventory().getContents());
        }
        config.set("death-message-sent", (Object)pet.hasDeathMessageBeenSent());
        config.set("death-reason", (Object)pet.getDeathReason());
        config.set("location.world", (Object)pet.getWorld());
        config.set("location.x", (Object)pet.getX());
        config.set("location.y", (Object)pet.getY());
        config.set("location.z", (Object)pet.getZ());
        if (pet.getPetFriends() != null && !pet.getPetFriends().isEmpty()) {
            int i = 0;
            for (Map.Entry<UUID, PetFriendData> entry : pet.getPetFriends().entrySet()) {
                config.set("friends." + i + ".uuid", (Object)entry.getKey().toString());
                config.set("friends." + i + ".relationship", (Object)entry.getValue().getRelationship());
                config.set("friends." + i + ".acceptedTimestamp", (Object)entry.getValue().getAcceptedTimestamp());
                ++i;
            }
        } else {
            config.set("friends", null);
        }
        if (pet.getAllowedInventoryAccess() != null && !pet.getAllowedInventoryAccess().isEmpty()) {
            config.set("allowed-inventory-access", (Object)pet.getAllowedInventoryAccess().stream().map(UUID::toString).collect(ArrayList::new, ArrayList::add, ArrayList::addAll));
        } else {
            config.set("allowed-inventory-access", null);
        }
        try {
            config.save(petFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save pet data for " + pet.getPetName());
            e.printStackTrace();
        }
    }

    public Pet loadPet(String ownerName, String petName) {
        File petFile = this.getPetDataFile(ownerName, petName);
        if (!petFile.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)petFile);
        try {
            UUID ownerUuid;
            String name = config.getString("pet-name");
            EntityType type = EntityType.valueOf((String)config.getString("type"));
            UUID uUID = ownerUuid = config.getString("owner-uuid") != null ? UUID.fromString(config.getString("owner-uuid")) : null;
            if (ownerUuid == null) {
                this.plugin.getLogger().warning("Pet " + petName + " for owner " + ownerName + " has no owner-uuid saved. Skipping load.");
                return null;
            }
            Pet pet = new Pet(name, type, ownerName, ownerUuid);
            pet.setNickname(config.getString("nickname"));
            pet.setPersonality(config.getString("personality"));
            pet.setBond(config.getInt("bond"));
            pet.setHunger(config.getInt("hunger"));
            pet.setMood(Pet.Mood.valueOf(config.getString("mood", "NEUTRAL")));
            pet.setLastMessage(config.getString("last-message"));
            if (config.getString("tamed-date") != null) {
                pet.setTamedDate(this.dateFormat.parse(config.getString("tamed-date")));
            }
            if (config.getString("linked-date") != null) {
                pet.setLinkedDate(this.dateFormat.parse(config.getString("linked-date")));
            }
            pet.setStatus(config.getString("status", "alive"));
            pet.setRecentHits(config.getInt("recent-hits", 0));
            pet.setLastHitTimestamp(config.getLong("last-hit-timestamp", 0L));
            pet.setLevel(config.getInt("level", 1));
            pet.setXp(config.getInt("xp", 0));
            pet.setHealth(config.getDouble("health", 20.0));
            if (pet.getInventory() == null) {
                pet.setInventory(Bukkit.createInventory(null, (int)9, (String)(pet.getPetName() + "'s Inventory")));
            }
            if (config.isSet("inventory")) {
                List rawItems = config.getList("inventory");
                if (rawItems != null && !rawItems.isEmpty() && rawItems.get(0) instanceof ItemStack) {
                    ItemStack[] items = rawItems.toArray(new ItemStack[0]);
                    pet.getInventory().setContents(items);
                } else if (rawItems != null && !rawItems.isEmpty()) {
                    this.plugin.getLogger().warning("Inventory for pet " + petName + " contains non-ItemStack objects. Skipping inventory load.");
                }
            }
            pet.setDeathMessageSent(config.getBoolean("death-message-sent", false));
            pet.setDeathReason(config.getString("death-reason"));
            pet.setWorld(config.getString("location.world"));
            pet.setX(config.getDouble("location.x"));
            pet.setY(config.getDouble("location.y"));
            pet.setZ(config.getDouble("location.z"));
            if (config.isConfigurationSection("friends")) {
                for (String key : config.getConfigurationSection("friends").getKeys(false)) {
                    UUID friendUUID = UUID.fromString(config.getString("friends." + key + ".uuid"));
                    String relationship = config.getString("friends." + key + ".relationship", "friend");
                    long acceptedTimestamp = config.getLong("friends." + key + ".acceptedTimestamp", 0L);
                    pet.getPetFriends().put(friendUUID, new PetFriendData(friendUUID, relationship, acceptedTimestamp));
                }
            }
            if (config.isSet("allowed-inventory-access")) {
                List allowedUUIDStrings = config.getStringList("allowed-inventory-access");
                for (String uuidString : allowedUUIDStrings) {
                    pet.getAllowedInventoryAccess().add(UUID.fromString(uuidString));
                }
            }
            return pet;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Could not load pet data for " + petName);
            e.printStackTrace();
            return null;
        }
    }

    public File getPetDataFile(String ownerName, String petName) {
        File playerPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName);
        if (!playerPetFolder.exists()) {
            playerPetFolder.mkdirs();
        }
        return new File(playerPetFolder, petName + File.separator + "data.yml");
    }

    public File getChatsFile(String ownerName, String petName) {
        File petFolder;
        File playerPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName);
        if (!playerPetFolder.exists()) {
            playerPetFolder.mkdirs();
        }
        if (!(petFolder = new File(playerPetFolder, petName)).exists()) {
            petFolder.mkdirs();
        }
        return new File(petFolder, "chats.yml");
    }

    public void logChatMessage(String ownerName, String petName, String sender, String message) {
        File chatsFile = this.getChatsFile(ownerName, petName);
        try {
            YamlConfiguration chats = YamlConfiguration.loadConfiguration((File)chatsFile);
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            chats.set(timestamp, (Object)(sender + ": " + message));
            chats.save(chatsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not log chat message for pet " + petName);
            e.printStackTrace();
        }
    }

    public void logPetDeath(String petName, String ownerName, String reason, String location) {
        File petsFolder = new File(this.plugin.getDataFolder(), "pets");
        if (!petsFolder.exists()) {
            petsFolder.mkdirs();
        }
        File deathLogFile = new File(petsFolder, "death_log.yml");
        YamlConfiguration deathLogConfig = YamlConfiguration.loadConfiguration((File)deathLogFile);
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String logEntry = String.format("[%s] Pet: %s, Owner: %s, Reason: %s, Location: %s", timestamp, petName, ownerName, reason, location);
        List logs = deathLogConfig.getStringList("deaths");
        logs.add(logEntry);
        deathLogConfig.set("deaths", (Object)logs);
        try {
            deathLogConfig.save(deathLogFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save pet death log: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void renamePetDataFolder(String ownerName, String petName) {
        File newPetFolder;
        File petFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName + File.separator + petName);
        if (!petFolder.exists()) {
            return;
        }
        Object newPetFolderName = petName;
        int counter = 0;
        do {
            newPetFolderName = petName + "_dead";
            if (counter > 0) {
                newPetFolderName = (String)newPetFolderName + "_" + counter;
            }
            newPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName + File.separator + (String)newPetFolderName);
            ++counter;
        } while (newPetFolder.exists());
        if (petFolder.renameTo(newPetFolder)) {
            this.plugin.getLogger().info("Renamed dead pet folder from " + petFolder.getName() + " to " + newPetFolder.getName());
        } else {
            this.plugin.getLogger().warning("Failed to rename dead pet folder: " + petFolder.getName());
        }
    }

    public String getUniqueDeadPetFolderName(String ownerName, String petName) {
        File newPetFolder;
        String baseName = petName + "_dead";
        int counter = 0;
        String uniqueName = baseName;
        do {
            if (counter > 0) {
                uniqueName = baseName + "_" + counter;
            }
            newPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName + File.separator + uniqueName);
            ++counter;
        } while (newPetFolder.exists());
        return uniqueName;
    }

    public void deletePetDataFolder(String ownerName, String petName) {
        File petFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName + File.separator + petName);
        if (petFolder.exists()) {
            try {
                this.deleteDirectory(petFolder);
                this.plugin.getLogger().info("Deleted old pet folder: " + petFolder.getName());
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to delete old pet folder: " + petFolder.getName() + " - " + e.getMessage());
            }
        }
    }

    private void deleteDirectory(File directory) throws IOException {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                this.deleteDirectory(file);
            }
        }
        if (!directory.delete()) {
            throw new IOException("Failed to delete file or directory: " + directory.getAbsolutePath());
        }
    }
}

