/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class AdminRecipientManager {
    private final NSRAIPlugin plugin;
    private final File adminRecipientsFile;
    private final FileConfiguration adminRecipientsConfig;
    private final List<UUID> adminRecipients;

    public AdminRecipientManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.adminRecipientsFile = new File(plugin.getDataFolder(), "admin_recipients.yml");
        if (!this.adminRecipientsFile.exists()) {
            try {
                this.adminRecipientsFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create admin_recipients.yml file!");
            }
        }
        this.adminRecipientsConfig = YamlConfiguration.loadConfiguration((File)this.adminRecipientsFile);
        this.adminRecipients = this.loadRecipients();
    }

    private List<UUID> loadRecipients() {
        List recipientStrings = this.adminRecipientsConfig.getStringList("recipients");
        return recipientStrings.stream().map(UUID::fromString).collect(Collectors.toList());
    }

    private void saveRecipients() {
        List recipientStrings = this.adminRecipients.stream().map(UUID::toString).collect(Collectors.toList());
        this.adminRecipientsConfig.set("recipients", recipientStrings);
        try {
            this.adminRecipientsConfig.save(this.adminRecipientsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save admin_recipients.yml file!");
        }
    }

    public void addRecipient(UUID uuid) {
        if (!this.adminRecipients.contains(uuid)) {
            this.adminRecipients.add(uuid);
            this.saveRecipients();
        }
    }

    public void removeRecipient(UUID uuid) {
        this.adminRecipients.remove(uuid);
        this.saveRecipients();
    }

    public void notifyAdmins(String message) {
        for (UUID uuid : this.adminRecipients) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            player.sendMessage(message);
        }
    }
}

