/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.nsr.ai.plugin.ApiKeyManager;
import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.managers.PlayerApiKeyManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatLogger {
    private final NSRAIPlugin plugin;
    private final ConcurrentLinkedQueue<LogEntry> logQueue = new ConcurrentLinkedQueue();
    private final File playerChatHistoryDir;
    private final File adminChatHistoryDir;
    private final Map<UUID, Long> lastActivityTime = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Integer> currentLogSuffix = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, String> currentLogDate = new ConcurrentHashMap<UUID, String>();
    private final long SESSION_TIMEOUT_MILLIS = 300000L;

    public ChatLogger(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.playerChatHistoryDir = new File(plugin.getDataFolder(), "playerchathistory");
        this.adminChatHistoryDir = new File(plugin.getDataFolder(), "adminchathistory");
        if (!this.playerChatHistoryDir.exists()) {
            this.playerChatHistoryDir.mkdirs();
        }
        if (!this.adminChatHistoryDir.exists()) {
            this.adminChatHistoryDir.mkdirs();
        }
        this.startWriterTask();
    }

    public void log(Player player, String message, boolean isAdmin, boolean isAI) {
        for (ApiKeyManager.ApiKey globalKey : this.plugin.getApiKeyManager().getApiKeys()) {
            if (!message.contains(globalKey.getKey())) continue;
            return;
        }
        for (UUID playerUUID : this.plugin.getPlayerApiKeyManager().getAllPlayerUUIDs()) {
            Collection<PlayerApiKeyManager.ApiKey> playerKeys = this.plugin.getPlayerApiKeyManager().getAllKeys(playerUUID);
            for (PlayerApiKeyManager.ApiKey pKey : playerKeys) {
                if (!message.contains(pKey.getApiKey())) continue;
                return;
            }
        }
        if (message.toLowerCase().startsWith("store-")) {
            return;
        }
        PlayerApiKeyManager.ApiKey activeKey = this.plugin.getPlayerApiKeyManager().getActiveKey(player.getUniqueId());
        if (activeKey != null && !activeKey.isSaveChatHistory()) {
            return;
        }
        String prefix = isAI ? this.plugin.getAiPrefix() + this.plugin.getAiChatColor() : this.plugin.getUserPrefix().replace("%player_name%", "&e" + player.getName() + "&7") + this.plugin.getUserChatColor();
        String maskedMessage = this.maskApiKeys(message);
        this.logQueue.offer(new LogEntry(player.getUniqueId(), player.getName(), this.plugin.colorize(prefix + maskedMessage), isAdmin, System.currentTimeMillis()));
        this.lastActivityTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private void startWriterTask() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            while (!this.logQueue.isEmpty()) {
                LogEntry entry = this.logQueue.poll();
                if (entry == null) continue;
                this.writeToFile(entry);
            }
        }, 100L, 100L);
    }

    private void writeToFile(LogEntry entry) {
        File logFile = this.getLogFile(entry.playerUUID, entry.playerName, entry.isAdmin, entry.timestamp);
        File parentDir = logFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));){
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(entry.timestamp));
            writer.write("[" + timestamp + "] " + entry.message);
            writer.newLine();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not write to chat log for " + entry.playerName, e);
        }
    }

    private File getLogFile(UUID playerUUID, String playerName, boolean isAdmin, long messageTimestamp) {
        boolean sessionTimedOut;
        File baseDir = isAdmin ? new File(this.adminChatHistoryDir, playerName + "-" + String.valueOf(playerUUID)) : new File(this.playerChatHistoryDir, playerName + "-" + String.valueOf(playerUUID));
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
        String dateString = dateFormat.format(new Date(messageTimestamp));
        long lastActivity = this.lastActivityTime.getOrDefault(playerUUID, 0L);
        String lastLogDate = this.currentLogDate.getOrDefault(playerUUID, "");
        int suffix = this.currentLogSuffix.getOrDefault(playerUUID, 0);
        boolean newDay = !dateString.equals(lastLogDate);
        boolean bl = sessionTimedOut = messageTimestamp - lastActivity > 300000L;
        if (newDay) {
            suffix = 1;
            this.currentLogDate.put(playerUUID, dateString);
        } else if (sessionTimedOut) {
            ++suffix;
        }
        this.currentLogSuffix.put(playerUUID, suffix);
        String fileName = "chat-" + dateString;
        if (suffix > 0) {
            fileName = fileName + "-" + suffix;
        }
        fileName = fileName + ".log";
        return new File(baseDir, fileName);
    }

    public void recordPlayerQuit(UUID playerUUID) {
        this.lastActivityTime.put(playerUUID, System.currentTimeMillis());
    }

    public File getPlayerChatHistoryDir() {
        return this.playerChatHistoryDir;
    }

    public File getAdminChatHistoryDir() {
        return this.adminChatHistoryDir;
    }

    private String maskApiKeys(String message) {
        String maskedMessage = message;
        for (ApiKeyManager.ApiKey key : this.plugin.getApiKeyManager().getApiKeys()) {
            if (key == null || key.getKey() == null) continue;
            maskedMessage = maskedMessage.replace(key.getKey(), "[GLOBAL_API_KEY_MASKED]");
        }
        for (UUID playerUUID : this.plugin.getPlayerApiKeyManager().getAllPlayerUUIDs()) {
            Collection<PlayerApiKeyManager.ApiKey> playerKeys = this.plugin.getPlayerApiKeyManager().getAllKeys(playerUUID);
            for (PlayerApiKeyManager.ApiKey pKey : playerKeys) {
                if (pKey == null || pKey.getApiKey() == null) continue;
                maskedMessage = maskedMessage.replace(pKey.getApiKey(), "[PLAYER_API_KEY_MASKED]");
            }
        }
        return maskedMessage;
    }

    private static class LogEntry {
        final UUID playerUUID;
        final String playerName;
        final String message;
        final boolean isAdmin;
        final long timestamp;

        LogEntry(UUID playerUUID, String playerName, String message, boolean isAdmin, long timestamp) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
            this.message = message;
            this.isAdmin = isAdmin;
            this.timestamp = timestamp;
        }
    }
}

