/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigEncryptor {
    private static final String ENCRYPTION_PREFIX = "enc@";
    private final NSRAIPlugin plugin;

    public ConfigEncryptor(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    private String encrypt(String plainText) throws Exception {
        if (this.plugin.getSecurityUtil() == null) {
            throw new IllegalStateException("SecurityUtil is not initialized.");
        }
        return this.plugin.getSecurityUtil().encrypt(plainText, this.plugin.getSecurityUtil().getServerMasterKey());
    }

    private String decrypt(String encryptedText) throws Exception {
        if (this.plugin.getSecurityUtil() == null) {
            throw new IllegalStateException("SecurityUtil is not initialized.");
        }
        return this.plugin.getSecurityUtil().decrypt(encryptedText, this.plugin.getSecurityUtil().getServerMasterKey());
    }

    public String getDecryptedString(FileConfiguration config, String path) {
        String value = config.getString(path);
        if (value != null && value.startsWith(ENCRYPTION_PREFIX)) {
            try {
                return this.decrypt(value.substring(ENCRYPTION_PREFIX.length()));
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to decrypt config value at path: " + path + ". Please check your config or master key.", e);
                return null;
            }
        }
        return value;
    }

    public boolean encryptIfNecessary(FileConfiguration config, String path) {
        String currentValue = config.getString(path);
        if (currentValue == null || currentValue.isEmpty() || currentValue.startsWith(ENCRYPTION_PREFIX)) {
            return false;
        }
        try {
            String encryptedValue = ENCRYPTION_PREFIX + this.encrypt(currentValue);
            config.set(path, (Object)encryptedValue);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to encrypt config value at path: " + path, e);
            return false;
        }
    }

    public boolean encryptStringListIfNecessary(FileConfiguration config, String path) {
        List currentList = config.getStringList(path);
        if (currentList == null || currentList.isEmpty()) {
            return false;
        }
        boolean changesMade = false;
        ArrayList<Object> newList = new ArrayList<Object>();
        for (String value : currentList) {
            if (value != null && !value.isEmpty() && !value.startsWith(ENCRYPTION_PREFIX)) {
                try {
                    String encryptedValue = ENCRYPTION_PREFIX + this.encrypt(value);
                    newList.add(encryptedValue);
                    changesMade = true;
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to encrypt value in list at path: " + path, e);
                    newList.add(value);
                }
                continue;
            }
            newList.add(value);
        }
        if (changesMade) {
            config.set(path, newList);
        }
        return changesMade;
    }

    public List<String> getDecryptedStringList(FileConfiguration config, String path) {
        List encryptedList = config.getStringList(path);
        if (encryptedList == null || encryptedList.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> decryptedList = new ArrayList<String>();
        for (String value : encryptedList) {
            if (value != null && value.startsWith(ENCRYPTION_PREFIX)) {
                try {
                    decryptedList.add(this.decrypt(value.substring(ENCRYPTION_PREFIX.length())));
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to decrypt value in list at path: " + path, e);
                    decryptedList.add(value);
                }
                continue;
            }
            decryptedList.add(value);
        }
        return decryptedList;
    }
}

