/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.nsr.ai.plugin.managers.PlayerApiKeyManager;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.bukkit.ChatColor;

public class MessageFormatter {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    private static String border() {
        return String.valueOf(ChatColor.DARK_GRAY) + "---------------------------------------";
    }

    private static String title() {
        return ChatColor.GOLD.toString() + String.valueOf(ChatColor.BOLD) + "----------- NSR-AI -----------";
    }

    public static String formatKeyAdded(PlayerApiKeyManager.ApiKey key) {
        return MessageFormatter.border() + "\n" + MessageFormatter.title() + "\n" + String.valueOf(ChatColor.WHITE) + "\ud83d\udd11 " + String.valueOf(ChatColor.YELLOW) + "API Key Added Successfully!\n" + String.valueOf(ChatColor.GRAY) + "\ud83d\udce6 Mode: " + String.valueOf(ChatColor.AQUA) + "Session-Based \u26a1\n" + String.valueOf(ChatColor.GRAY) + "\u2699\ufe0f Provider: " + String.valueOf(ChatColor.WHITE) + String.valueOf((Object)key.getProvider()) + "\n" + String.valueOf(ChatColor.GRAY) + "\ud83e\udde9 Model: " + String.valueOf(ChatColor.WHITE) + key.getModel() + "\n" + String.valueOf(ChatColor.GRAY) + "\ud83e\udde0 Key ID: " + String.valueOf(ChatColor.GREEN) + key.getKeyId() + "\n" + String.valueOf(ChatColor.GRAY) + "\ud83d\udcc5 Created: " + String.valueOf(ChatColor.WHITE) + DATE_FORMAT.format(new Date(key.getCreationDate())) + "\n" + String.valueOf(ChatColor.GRAY) + "\ud83d\udce1 Status: " + String.valueOf(ChatColor.GREEN) + "\ud83d\udfe2 Active\n" + MessageFormatter.border();
    }

    public static String formatKeyStored(PlayerApiKeyManager.ApiKey key) {
        return MessageFormatter.border() + "\n" + MessageFormatter.title() + "\n" + String.valueOf(ChatColor.WHITE) + "\ud83d\udd11 " + String.valueOf(ChatColor.GREEN) + "API Key Stored Securely!\n" + String.valueOf(ChatColor.GRAY) + "\ud83d\udce6 Mode: " + String.valueOf(ChatColor.AQUA) + "Stored-Based \ud83e\uddf1\n" + String.valueOf(ChatColor.GRAY) + "\ud83e\udde0 Project: " + String.valueOf(ChatColor.WHITE) + (key.getProjectId() != null && !key.getProjectId().isEmpty() ? key.getProjectId() : "N/A") + "\n" + String.valueOf(ChatColor.GRAY) + "\u2699\ufe0f Provider: " + String.valueOf(ChatColor.WHITE) + String.valueOf((Object)key.getProvider()) + "\n" + String.valueOf(ChatColor.GRAY) + "\ud83e\udde9 Model: " + String.valueOf(ChatColor.WHITE) + key.getModel() + "\n" + String.valueOf(ChatColor.GRAY) + "\ud83d\udd12 Encryption: " + String.valueOf(ChatColor.WHITE) + "AES-256-GCM\n" + String.valueOf(ChatColor.GRAY) + "\ud83d\udce1 Status: " + String.valueOf(ChatColor.GREEN) + "\ud83d\udfe2 Active\n" + MessageFormatter.border();
    }

    public static String formatKeyInfo(PlayerApiKeyManager.ApiKey key) {
        String statusColor;
        String statusText = switch (key.getStatus()) {
            case PlayerApiKeyManager.ApiKey.KeyStatus.ACTIVE -> {
                statusColor = ChatColor.GREEN.toString();
                yield "\ud83d\udfe2 Active";
            }
            case PlayerApiKeyManager.ApiKey.KeyStatus.INACTIVE -> {
                statusColor = ChatColor.RED.toString();
                yield "\ud83d\udd34 Inactive";
            }
            case PlayerApiKeyManager.ApiKey.KeyStatus.USING -> {
                statusColor = ChatColor.GOLD.toString();
                yield "\ud83d\udfe0 Using";
            }
            case PlayerApiKeyManager.ApiKey.KeyStatus.OVERLOADED -> {
                statusColor = ChatColor.YELLOW.toString();
                yield "\ud83d\udfe1 Overloaded";
            }
            case PlayerApiKeyManager.ApiKey.KeyStatus.LIMIT_REACHED -> {
                statusColor = ChatColor.DARK_RED.toString();
                yield "\ud83d\udeab Limit Reached";
            }
            default -> {
                statusColor = ChatColor.GRAY.toString();
                yield "\u26aa Unknown";
            }
        };
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormatter.border()).append("\n");
        sb.append(MessageFormatter.title()).append("\n");
        sb.append(ChatColor.WHITE).append("\ud83d\udd11 ").append(ChatColor.YELLOW).append("Key ID: ").append(ChatColor.GREEN).append(key.getKeyId()).append("\n");
        sb.append(ChatColor.GRAY).append("\ud83d\udd12 Key: ").append(ChatColor.WHITE).append(key.getMaskedKey()).append("\n");
        sb.append(ChatColor.GRAY).append("\u2699\ufe0f Provider: ").append(ChatColor.WHITE).append((Object)key.getProvider()).append("\n");
        sb.append(ChatColor.GRAY).append("\ud83e\udde9 Model: ").append(ChatColor.WHITE).append(key.getModel()).append("\n");
        sb.append(ChatColor.GRAY).append("\ud83d\udcc5 Created: ").append(ChatColor.WHITE).append(DATE_FORMAT.format(new Date(key.getCreationDate()))).append("\n");
        sb.append(ChatColor.GRAY).append("\ud83d\udcca Uses: ").append(ChatColor.WHITE).append(key.getUsageCount()).append(ChatColor.GRAY).append(" | Errors: ").append(ChatColor.WHITE).append(key.getErrorCount()).append(ChatColor.GRAY).append(" | Fallbacks: ").append(ChatColor.WHITE).append(key.getFallbackCount()).append("\n");
        sb.append(ChatColor.GRAY).append("\ud83d\udce1 Status: ").append(statusColor).append(statusText).append("\n");
        sb.append(ChatColor.GRAY).append("\ud83d\udce6 Mode: ").append(ChatColor.AQUA).append(key.getStorageMode() == PlayerApiKeyManager.ApiKey.StorageMode.SESSION ? "Session-Based \u26a1" : "Stored-Based \ud83e\uddf1").append("\n");
        if (key.getStorageMode() == PlayerApiKeyManager.ApiKey.StorageMode.STORED) {
            String projectId = key.getProjectId();
            sb.append(ChatColor.GRAY).append("\ud83e\udde0 Project: ").append(ChatColor.WHITE).append(projectId != null && !projectId.isEmpty() ? projectId : "N/A").append("\n");
        }
        sb.append(MessageFormatter.border());
        return sb.toString();
    }

    public static String formatModelUpdated(PlayerApiKeyManager.ApiKey key, String oldModel) {
        return MessageFormatter.border() + "\n" + MessageFormatter.title() + "\n" + String.valueOf(ChatColor.WHITE) + "\ud83d\udd11 " + String.valueOf(ChatColor.YELLOW) + "Key ID: " + String.valueOf(ChatColor.GREEN) + key.getKeyId() + "\n" + String.valueOf(ChatColor.WHITE) + "\ud83d\udd04 " + String.valueOf(ChatColor.WHITE) + "Model Updated\n" + String.valueOf(ChatColor.RED) + "\u274c Old: " + oldModel + "\n" + String.valueOf(ChatColor.GREEN) + "\u2705 New: " + key.getModel() + "\n" + String.valueOf(ChatColor.GRAY) + "\ud83d\udce6 Mode: " + String.valueOf(ChatColor.AQUA) + (key.getStorageMode() == PlayerApiKeyManager.ApiKey.StorageMode.SESSION ? "Session-Based \u26a1" : "Stored-Based \ud83e\uddf1") + "\n" + MessageFormatter.border();
    }

    public static String formatKeyList(Collection<PlayerApiKeyManager.ApiKey> keys2) {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormatter.border()).append("\n");
        sb.append(MessageFormatter.title()).append("\n");
        sb.append(ChatColor.WHITE).append("\ud83d\udd11 ").append(ChatColor.YELLOW).append("Key List\n");
        sb.append(MessageFormatter.border()).append("\n");
        if (keys2.isEmpty()) {
            sb.append(ChatColor.GRAY).append("No API keys found.\n");
        } else {
            for (PlayerApiKeyManager.ApiKey key : keys2) {
                String statusColor = switch (key.getStatus()) {
                    case PlayerApiKeyManager.ApiKey.KeyStatus.ACTIVE -> "\u00a7a\ud83d\udfe2";
                    case PlayerApiKeyManager.ApiKey.KeyStatus.INACTIVE -> "\u00a7c\ud83d\udd34";
                    case PlayerApiKeyManager.ApiKey.KeyStatus.USING -> "\u00a76\ud83d\udfe0";
                    case PlayerApiKeyManager.ApiKey.KeyStatus.OVERLOADED -> "\u00a7e\ud83d\udfe1";
                    case PlayerApiKeyManager.ApiKey.KeyStatus.LIMIT_REACHED -> "\u00a74\ud83d\udeab";
                    default -> "\u00a77";
                };
                String mode = key.getStorageMode() == PlayerApiKeyManager.ApiKey.StorageMode.SESSION ? "\u26a1 Session" : "\ud83e\uddf1 Stored";
                sb.append(ChatColor.GRAY).append(key.getMaskedKey()).append(" | ").append(ChatColor.GREEN).append(key.getKeyId()).append(" | ").append(ChatColor.WHITE).append((Object)key.getProvider()).append(" | ").append(statusColor).append(" | ").append(mode).append("\n");
            }
        }
        sb.append(MessageFormatter.border());
        return sb.toString();
    }

    public static String formatKeysCleared(int count, Collection<PlayerApiKeyManager.ApiKey> deletedKeys) {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormatter.border()).append("\n");
        sb.append(MessageFormatter.title()).append("\n");
        sb.append(ChatColor.WHITE).append("\ud83d\uddd1\ufe0f ").append(ChatColor.YELLOW).append(count).append(" API Keys Deleted Successfully!\n");
        sb.append(ChatColor.GRAY).append("\ud83d\udce6 Total Deleted: ").append(ChatColor.GREEN).append(count).append("\n");
        sb.append(MessageFormatter.border()).append("\n");
        for (PlayerApiKeyManager.ApiKey key : deletedKeys) {
            String mode = key.getStorageMode() == PlayerApiKeyManager.ApiKey.StorageMode.SESSION ? "\u26a1 Session" : "\ud83e\uddf1 Stored";
            sb.append(ChatColor.GRAY).append("\ud83d\udd39 ").append(ChatColor.WHITE).append("Key ID: ").append(key.getKeyId()).append(" | ").append("Provider: ").append((Object)key.getProvider()).append(" | ").append(key.getMaskedKey()).append(" | ").append(mode).append("\n");
        }
        sb.append(MessageFormatter.border());
        return sb.toString();
    }
}

