/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nsr.ai.plugin.ApiKeyManager;
import com.nsr.ai.plugin.ConversationManager;
import com.nsr.ai.plugin.PlayerListener;
import com.nsr.ai.plugin.addons.AddonManager;
import com.nsr.ai.plugin.api.NSRaiAPI;
import com.nsr.ai.plugin.command.CommandManager;
import com.nsr.ai.plugin.config.ConfigUpdater;
import com.nsr.ai.plugin.managers.BugFixManager;
import com.nsr.ai.plugin.managers.KnowledgeManager;
import com.nsr.ai.plugin.managers.PlayerApiKeyManager;
import com.nsr.ai.plugin.managers.PrivacyManager;
import com.nsr.ai.plugin.pet.Pet;
import com.nsr.ai.plugin.pet.PetListener;
import com.nsr.ai.plugin.pet.PetManager;
import com.nsr.ai.plugin.pet.ReservedNicknameManager;
import com.nsr.ai.plugin.util.ChatHistoryManager;
import com.nsr.ai.plugin.util.ChatLogger;
import com.nsr.ai.plugin.util.ConfirmationManager;
import com.nsr.ai.plugin.util.UpdateChecker;
import com.nsr.ai.security.SecurityManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NSRAIPlugin
extends JavaPlugin
implements Listener,
NSRaiAPI {
    private FileConfiguration featuresConfig;
    private SecurityManager securityManager;
    private ConfirmationManager confirmationManager;
    private String adminActivationCode;
    private String defaultGeminiModel;
    private String defaultClaudeModel;
    private String defaultOpenAIModel;
    private String defaultApiProvider;
    private List<String> apiKeys;
    private ApiKeyManager apiKeyManager;
    private PlayerApiKeyManager playerApiKeyManager;
    private PrivacyManager privacyManager;
    private String aiChatColor;
    private String userChatColor;
    private String aiPrefix;
    private String userPrefix;
    private String adminAiPrefix;
    private String aiNotConfiguredMessage;
    private String apiErrorMessage;
    private String permissionDeniedMessage;
    private String noValidKeysMessage;
    private String allKeysRateLimitedMessage;
    private String systemPrompt;
    private boolean codeBlockerEnabled;
    private String codeBlockerMessage;
    private String knowledgeBaseColor;
    private boolean simpleKnowledgeYmlApprove;
    private boolean dataCommandEnabled;
    private boolean adminDisableCommandEnabled;
    private boolean versionCommandEnabled;
    private boolean addConfirmCommandEnabled;
    private boolean removeConfirmCommandEnabled;
    private boolean reloadCommandEnabled;
    private boolean memoryClearEnabled;
    private boolean memoryRefreshEnabled;
    private boolean cacheClearEnabled;
    private boolean cacheRefreshEnabled;
    private ConversationManager conversationManager;
    private AddonManager addonManager;
    private BugFixManager bugFixManager;
    private ChatHistoryManager chatHistoryManager;
    private ChatLogger chatLogger;
    private UpdateChecker updateChecker;
    private KnowledgeManager knowledgeManager;
    private PetManager petManager;
    private ReservedNicknameManager reservedNicknameManager;
    private final Map<UUID, Boolean> adminModePlayers = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> aiChatCooldown = new HashMap<UUID, Long>();
    private long aiChatCooldownDuration;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).build();
    private final Gson gson = new Gson();
    private boolean hasCriticalError = false;
    private String guiColorScheme;
    private String adminGuiColorScheme;
    private boolean petsEnabled;
    private boolean memoryEnabled;
    private boolean chatsEnabled;
    private boolean knowledgeEnabled;
    public final Map<UUID, Boolean> aiStatus = new HashMap<UUID, Boolean>();

    public String getKnowledgeBaseColor() {
        return this.knowledgeBaseColor;
    }

    public boolean isSimpleKnowledgeYmlApprove() {
        return this.simpleKnowledgeYmlApprove;
    }

    public boolean isDataCommandEnabled() {
        return this.dataCommandEnabled;
    }

    public boolean isAdminDisableCommandEnabled() {
        return this.adminDisableCommandEnabled;
    }

    public boolean isVersionCommandEnabled() {
        return this.versionCommandEnabled;
    }

    public boolean isAddConfirmCommandEnabled() {
        return this.addConfirmCommandEnabled;
    }

    public boolean isRemoveConfirmCommandEnabled() {
        return this.removeConfirmCommandEnabled;
    }

    public boolean isReloadCommandEnabled() {
        return this.reloadCommandEnabled;
    }

    public void reloadFeaturesConfig() {
        File featuresFile = new File(this.getDataFolder(), "features.yml");
        if (!featuresFile.exists()) {
            this.saveResource("features.yml", false);
        }
        this.featuresConfig = YamlConfiguration.loadConfiguration((File)featuresFile);
        this.loadConfig();
        this.getLogger().info("features.yml reloaded.");
    }

    public void reloadNSR_AIPlugin() {
        this.getLogger().info("Attempting to reload NSR-AI plugin...");
        this.reloadConfig();
        this.knowledgeManager.loadKnowledgeBase();
        this.getLogger().info("NSR-AI plugin (configs and knowledge base) reloaded.");
    }

    public void reloadKnowledgeBase() {
        this.knowledgeManager.loadKnowledgeBase();
        this.getLogger().info("Knowledge base reloaded.");
    }

    public boolean isMemoryClearEnabled() {
        return this.memoryClearEnabled;
    }

    public boolean isMemoryRefreshEnabled() {
        return this.memoryRefreshEnabled;
    }

    public boolean isCacheClearEnabled() {
        return this.cacheClearEnabled;
    }

    public boolean isCacheRefreshEnabled() {
        return this.cacheRefreshEnabled;
    }

    public void setCriticalError(boolean status) {
        this.hasCriticalError = status;
    }

    public void onEnable() {
        ConfigUpdater configUpdater = new ConfigUpdater(this);
        configUpdater.updateConfigs();
        File featuresFile = new File(this.getDataFolder(), "features.yml");
        if (!featuresFile.exists()) {
            this.saveResource("features.yml", false);
        }
        this.featuresConfig = YamlConfiguration.loadConfiguration((File)featuresFile);
        this.loadConfig();
        this.updateChecker = new UpdateChecker(this, "https://nsr-ai-version.1987sakshamsingh.workers.dev/");
        this.chatHistoryManager = new ChatHistoryManager(this);
        this.confirmationManager = new ConfirmationManager(this);
        this.chatLogger = new ChatLogger(this);
        this.knowledgeManager = new KnowledgeManager(this);
        this.petManager = new PetManager(this);
        this.reservedNicknameManager = new ReservedNicknameManager(this);
        this.playerApiKeyManager = new PlayerApiKeyManager(this);
        this.privacyManager = new PrivacyManager(this);
        this.addonManager = new AddonManager(this);
        this.apiKeyManager = new ApiKeyManager(this, this.apiKeys);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> this.apiKeyManager.validateKeys(this.defaultGeminiModel, this.defaultClaudeModel, this.defaultOpenAIModel));
        this.conversationManager = new ConversationManager(this.featuresConfig.getInt("conversation-history-length", 10));
        this.securityManager = new SecurityManager(this, this.addonManager);
        if (!this.securityManager.initialize()) {
            this.getLogger().severe("[NSR-AI] Security system failed to initialize. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.addonManager.loadAddons();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.securityManager.checkAndPerformUpdate(), 1200L, 1200L);
        this.bugFixManager = new BugFixManager(this);
        this.bugFixManager.initialize();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PetListener(this, this.petManager), (Plugin)this);
        CommandManager commandManager = new CommandManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)commandManager, (Plugin)this);
        this.getCommand("ai").setExecutor((CommandExecutor)commandManager);
        this.getCommand("ai").setTabCompleter((TabCompleter)commandManager);
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||====================================================||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||                                                    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||   _   _   _____    _____                 _____    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  | \\ | | / ____|  |  __ \\      /\\      |_   _|   ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  |  \\| | | (___   | |__) |    /  \\        | |     ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  | . ` |  \\___ \\  |  _  /    / /\\ \\       | |      ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  | |\\  |  ____) | | | \\ \\   / ____ \\     _| |_     ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||  |_| \\_| |_____/  |_|  \\_\\ /_/    \\_\\   |_____|    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||                                                    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||                    Version: " + String.valueOf(ChatColor.WHITE) + this.getDescription().getVersion() + "                     " + String.valueOf(ChatColor.AQUA) + "||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||               " + String.valueOf(ChatColor.GREEN) + "Thanks for downloading!" + String.valueOf(ChatColor.AQUA) + "              ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||               " + String.valueOf(ChatColor.AQUA) + "Developed by: " + String.valueOf(ChatColor.GOLD) + "BlackForge" + String.valueOf(ChatColor.AQUA) + "             ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||                                                    ||");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "||====================================================||");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            this.updateChecker.checkForUpdates();
            if (this.updateChecker.isOutdated()) {
                this.getLogger().info(String.valueOf(ChatColor.RED) + "-----------------------------------------------------------------");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| Your NSR-AI plugin is outdated!                              ||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| Latest version: " + String.valueOf(ChatColor.YELLOW) + this.updateChecker.getLatestVersion() + String.valueOf(ChatColor.RED) + " (You are using: " + String.valueOf(ChatColor.GRAY) + this.updateChecker.getCurrentVersion() + String.valueOf(ChatColor.RED) + ")                    ||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| Please download the latest version from:                     ||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| " + String.valueOf(ChatColor.GREEN) + "Modrinth: " + String.valueOf(ChatColor.BLUE) + "https://modrinth.com/plugin/nsr-ai                " + String.valueOf(ChatColor.RED) + "||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| " + String.valueOf(ChatColor.GOLD) + "SpigotMC: " + String.valueOf(ChatColor.BLUE) + "https://www.spigotmc.org/resources/nsr-ai.127717/ " + String.valueOf(ChatColor.RED) + "||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "|| " + String.valueOf(ChatColor.AQUA) + "Polymart: " + String.valueOf(ChatColor.BLUE) + "https://polymart.org/product/8380/nsr-ai          " + String.valueOf(ChatColor.RED) + "||");
                this.getLogger().info(String.valueOf(ChatColor.RED) + "-----------------------------------------------------------------");
            } else {
                this.getLogger().info(String.valueOf(ChatColor.GREEN) + "NSR-AI plugin is up to date!");
            }
        });
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.petManager.loadPetsForPlayer(player);
        }
        this.petManager.loadAllPets();
    }

    public void onDisable() {
        if (this.addonManager != null) {
            this.addonManager.unloadAddons();
        }
        if (this.hasCriticalError) {
            String statusMessage = String.valueOf(ChatColor.AQUA) + "\"NSR-AI\" has been " + String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED (Errors Found)!";
            this.getLogger().warning(String.valueOf(ChatColor.RED) + " _   _  _____ _____               _____  ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "| \\ | |/ ____|  __ \\        /\\   |_   _| ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "|  \\| | (___ | |__) |_____ /  \\    | |   ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "| . ` |\\___ \\|  _  /______/ /\\ \\   | |   ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "| |\\  |____) | | \\ \\     / ____ \\ _| |_  ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "|_| \\_|_____/|_|  \\_\\   /_/    \\_\\_____| ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "                                         ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "                                         ");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||====================================================||");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||                                                    ||");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||   " + statusMessage + String.valueOf(ChatColor.RED) + "                        ||");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||                                                    ||");
            this.getLogger().warning(String.valueOf(ChatColor.RED) + "||====================================================||");
        } else {
            String statusMessage = String.valueOf(ChatColor.AQUA) + "\"NSR-AI\" has been " + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "DISABLED.";
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + " _   _  _____ _____               _____  ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "| \\ | |/ ____|  __ \\        /\\   |_   _| ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "|  \\| | (___ | |__) |_____ /  \\    | |   ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "| . ` |\\___ \\|  _  /______/ /\\ \\   | |   ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "| |\\  |____) | | \\ \\     / ____ \\ _| |_  ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "|_| \\_|_____/|_|  \\_\\   /_/    \\_\\_____| ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "                                         ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "                                         ");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||====================================================||");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||                                                    ||");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||   " + statusMessage + String.valueOf(ChatColor.GREEN) + "                      ||");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||                                                    ||");
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "||====================================================||");
        }
    }

    public void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.adminActivationCode = config.getString("admin-activation-code", "3637");
        this.defaultGeminiModel = config.getString("default-gemini-model", "gemini-2.0-flash");
        this.defaultClaudeModel = config.getString("default-claude-model", "claude-3-opus-20240229");
        this.defaultOpenAIModel = config.getString("default-openai-model", "gpt-4");
        this.defaultApiProvider = config.getString("default-api-provider", "all");
        this.apiKeys = config.getStringList("api-keys");
        this.aiChatColor = "&b";
        this.userChatColor = "&7";
        this.aiPrefix = this.colorize("&b[AI]");
        this.userPrefix = this.colorize("&7[You]");
        this.adminAiPrefix = this.colorize("&c[AI]");
        this.aiNotConfiguredMessage = this.colorize("&cThe AI chat is not configured correctly. Please contact the server owner.");
        this.apiErrorMessage = this.colorize("&cAPI Error: Could not get a response from the AI. Please try again later.");
        this.permissionDeniedMessage = this.colorize("&cI don't have permission to fulfill that request for you.");
        this.noValidKeysMessage = this.colorize("&cThere are no valid API keys available. Please contact the server owner.");
        this.allKeysRateLimitedMessage = this.colorize("&cAll API keys are currently rate-limited. Please try again later.");
        this.systemPrompt = "You are a helpful AI.";
        this.codeBlockerEnabled = true;
        this.codeBlockerMessage = this.colorize("&cThis is a game built for fun and answering, not for coding.");
        this.knowledgeBaseColor = "&a";
        this.simpleKnowledgeYmlApprove = false;
        this.dataCommandEnabled = true;
        this.adminDisableCommandEnabled = true;
        this.versionCommandEnabled = true;
        this.addConfirmCommandEnabled = true;
        this.removeConfirmCommandEnabled = true;
        this.reloadCommandEnabled = true;
        this.memoryClearEnabled = true;
        this.memoryRefreshEnabled = true;
        this.cacheClearEnabled = true;
        this.cacheRefreshEnabled = true;
        this.aiChatCooldownDuration = 5000L;
        if (this.featuresConfig != null) {
            this.aiChatColor = this.featuresConfig.getString("chat-colors.ai", this.aiChatColor);
            this.userChatColor = this.featuresConfig.getString("chat-colors.user", this.userChatColor);
            this.aiPrefix = this.colorize(this.featuresConfig.getString("chat-prefixes.ai", this.aiPrefix));
            this.userPrefix = this.colorize(this.featuresConfig.getString("chat-prefixes.user", this.userPrefix));
            this.adminAiPrefix = this.colorize(this.featuresConfig.getString("chat-prefixes.admin-ai", this.adminAiPrefix));
            this.aiNotConfiguredMessage = this.colorize(this.featuresConfig.getString("messages.ai-not-configured", this.aiNotConfiguredMessage));
            this.apiErrorMessage = this.colorize(this.featuresConfig.getString("messages.api-error", this.apiErrorMessage));
            this.permissionDeniedMessage = this.colorize(this.featuresConfig.getString("messages.permission-denied", this.permissionDeniedMessage));
            this.noValidKeysMessage = this.colorize(this.featuresConfig.getString("messages.no-valid-keys", this.noValidKeysMessage));
            this.allKeysRateLimitedMessage = this.colorize(this.featuresConfig.getString("messages.all-keys-rate-limited", this.allKeysRateLimitedMessage));
            this.systemPrompt = this.featuresConfig.getString("system-prompt", this.systemPrompt);
            this.codeBlockerEnabled = this.featuresConfig.getBoolean("code-blocker.enabled", this.codeBlockerEnabled);
            this.codeBlockerMessage = this.colorize(this.featuresConfig.getString("code-blocker.message", this.codeBlockerMessage));
            this.knowledgeBaseColor = this.featuresConfig.getString("chat-colors.knowledge-base", this.knowledgeBaseColor);
            this.simpleKnowledgeYmlApprove = this.featuresConfig.getBoolean("simple-knowledge-yml-approve", this.simpleKnowledgeYmlApprove);
            this.dataCommandEnabled = this.featuresConfig.getBoolean("command-toggles.data", this.dataCommandEnabled);
            this.adminDisableCommandEnabled = this.featuresConfig.getBoolean("command-toggles.admin-disable", this.adminDisableCommandEnabled);
            this.versionCommandEnabled = this.featuresConfig.getBoolean("command-toggles.version", this.versionCommandEnabled);
            this.addConfirmCommandEnabled = this.featuresConfig.getBoolean("command-toggles.add-confirm", this.addConfirmCommandEnabled);
            this.removeConfirmCommandEnabled = this.featuresConfig.getBoolean("command-toggles.remove-confirm", this.removeConfirmCommandEnabled);
            this.reloadCommandEnabled = this.featuresConfig.getBoolean("command-toggles.reload", this.reloadCommandEnabled);
            this.memoryClearEnabled = this.featuresConfig.getBoolean("command-toggles.memory-clear", this.memoryClearEnabled);
            this.memoryRefreshEnabled = this.featuresConfig.getBoolean("command-toggles.memory-refresh", this.memoryRefreshEnabled);
            this.cacheClearEnabled = this.featuresConfig.getBoolean("command-toggles.cache-clear", this.cacheClearEnabled);
            this.guiColorScheme = this.featuresConfig.getString("gui-color-scheme", "&1");
            this.petsEnabled = this.featuresConfig.getBoolean("global-toggles.pets", true);
            this.memoryEnabled = this.featuresConfig.getBoolean("global-toggles.memory", true);
            this.chatsEnabled = this.featuresConfig.getBoolean("global-toggles.chats", true);
            this.knowledgeEnabled = this.featuresConfig.getBoolean("global-toggles.knowledge", true);
            this.adminGuiColorScheme = this.featuresConfig.getString("admin-gui-color-scheme", "&c");
            this.cacheRefreshEnabled = this.featuresConfig.getBoolean("command-toggles.cache-refresh", this.cacheRefreshEnabled);
        }
    }

    public void handleAIConversation(Player player, String message, boolean isAdmin, String provider, String mode) {
        long timeLeft;
        if (this.aiChatCooldown.containsKey(player.getUniqueId()) && (timeLeft = this.aiChatCooldown.get(player.getUniqueId()) + this.aiChatCooldownDuration - System.currentTimeMillis()) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + String.format("%.1f", (double)timeLeft / 1000.0) + " seconds before using the AI chat again.");
            return;
        }
        this.chatLogger.log(player, message, isAdmin, false);
        String finalMessage = message;
        String lowerCaseMessage = finalMessage.toLowerCase();
        if (lowerCaseMessage.equals("hi") || lowerCaseMessage.equals("hey")) {
            player.sendMessage(this.colorize(this.aiPrefix + this.aiChatColor + "hey " + player.getName() + " how are you do you have question or anything else"));
            return;
        }
        if (this.codeBlockerEnabled && (lowerCaseMessage.contains("code") || lowerCaseMessage.contains("script") || lowerCaseMessage.contains("program"))) {
            player.sendMessage(this.codeBlockerMessage);
            return;
        }
        if (mode.equals("KNOWLEDGE_SEARCH")) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                Map<String, String> searchResults = this.knowledgeManager.searchKnowledge(finalMessage, isAdmin);
                if (!searchResults.isEmpty()) {
                    String context = searchResults.entrySet().stream().map(entry -> "Heading: " + (String)entry.getKey() + "\nContent: " + (String)entry.getValue()).collect(Collectors.joining("\n\n"));
                    String prompt = "Based on the following knowledge base entries, answer the user's query. If you find a direct answer, provide it. If the query is ambiguous, ask for clarification.\n\nKnowledge Base Entries:\n" + context + "\n\nUser Query: " + finalMessage + "\n\nAnswer:";
                    try {
                        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(provider, player);
                        if (apiKey == null) {
                            player.sendMessage(this.noValidKeysMessage);
                            this.getLogger().warning("No valid API key found for player " + player.getName());
                            return;
                        }
                        String keyType = this.getPlayerApiKeyManager().hasApiKeys(player.getUniqueId()) ? "own" : "global";
                        this.getLogger().info("Using " + keyType + " API key of type: " + String.valueOf((Object)apiKey.getType()) + " for player " + player.getName());
                        String response = this.callAppropriateApi(player, prompt, apiKey);
                        String finalResponse = this.filterCodeSnippets(response, isAdmin);
                        Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.colorize(this.aiPrefix + this.knowledgeBaseColor + finalResponse)));
                        this.aiChatCooldown.put(player.getUniqueId(), System.currentTimeMillis());
                    }
                    catch (IOException e) {
                        this.getLogger().log(Level.SEVERE, "Error calling AI API for knowledge search", e);
                        player.sendMessage(this.apiErrorMessage);
                    }
                } else {
                    player.sendMessage(this.colorize(this.aiPrefix + this.knowledgeBaseColor + "I could not find any information in the knowledge base matching your query."));
                }
            });
            return;
        }
        if (mode.equals("AI_ONLY")) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(provider, player);
                if (apiKey == null) {
                    if (this.apiKeyManager.getApiKeys().stream().allMatch(k -> k.getStatus() == ApiKeyManager.ApiKey.Status.RATE_LIMITED)) {
                        player.sendMessage(this.allKeysRateLimitedMessage);
                    } else {
                        player.sendMessage(this.noValidKeysMessage);
                        this.getLogger().warning("No valid API key found for player " + player.getName());
                    }
                    return;
                }
                String keyOrigin = this.apiKeyManager.getApiKeys().contains(apiKey) ? "default" : "player's own";
                this.getLogger().info("Using " + keyOrigin + " API key of type: " + String.valueOf((Object)apiKey.getType()) + " for player " + player.getName());
                try {
                    String response = this.callAppropriateApi(player, finalMessage, apiKey);
                    this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("user", finalMessage));
                    String finalResponse = this.filterCodeSnippets(response, isAdmin);
                    this.chatLogger.log(player, finalResponse, isAdmin, true);
                    Bukkit.getScheduler().runTask((Plugin)this, () -> {
                        String[] lines = finalResponse.split("\n");
                        for (int i = 0; i < lines.length; ++i) {
                            String line = lines[i];
                            if (isAdmin) {
                                player.sendMessage(this.colorize((i == 0 ? this.adminAiPrefix : "") + this.aiChatColor + line));
                                continue;
                            }
                            player.sendMessage(this.colorize((i == 0 ? this.aiPrefix : "") + this.aiChatColor + line));
                        }
                    });
                    this.aiChatCooldown.put(player.getUniqueId(), System.currentTimeMillis());
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "Error calling AI API", e);
                    player.sendMessage(this.apiErrorMessage + " Details: " + e.getMessage());
                }
            });
        }
    }

    private String callAppropriateApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        switch (apiKey.getType()) {
            case CLAUDE: {
                return this.callClaudeApi(player, prompt, apiKey);
            }
            case OPENAI: {
                return this.callOpenAIApi(player, prompt, apiKey);
            }
        }
        return this.callGeminiApi(player, prompt, apiKey);
    }

    private String filterCodeSnippets(String response, boolean isAdmin) {
        if (isAdmin) {
            return response;
        }
        if (response == null) {
            return "";
        }
        if (response.matches(".*```[\\w\\W]*?```.*")) {
            return this.codeBlockerMessage;
        }
        return response;
    }

    private String callGeminiApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonArray contents = new JsonArray();
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        StringBuilder systemInstructions = new StringBuilder();
        ArrayList<ConversationManager.Message> filteredHistory = new ArrayList<ConversationManager.Message>();
        for (ConversationManager.Message message : history) {
            if (message.getRole().equals("system")) {
                systemInstructions.append(message.getContent()).append("\n");
                continue;
            }
            filteredHistory.add(message);
        }
        Object finalPrompt = prompt;
        if (systemInstructions.length() > 0) {
            finalPrompt = systemInstructions.toString().trim() + "\n" + (String)prompt;
        }
        for (ConversationManager.Message message : filteredHistory) {
            JsonObject message2 = new JsonObject();
            message2.addProperty("role", message.getRole().equals("assistant") ? "model" : message.getRole());
            JsonObject part = new JsonObject();
            part.addProperty("text", message.getContent());
            message2.add("parts", this.gson.toJsonTree(new JsonObject[]{part}));
            contents.add(message2);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("role", "user");
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.addProperty("text", (String)finalPrompt);
        jsonObject.add("parts", this.gson.toJsonTree(new JsonObject[]{jsonObject2}));
        contents.add(jsonObject);
        JsonObject requestBody = new JsonObject();
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        int retries = 0;
        while (retries < 3) {
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    this.getLogger().log(Level.WARNING, "Gemini API Error (Attempt " + (retries + 1) + "): " + response.code() + " - " + response.message() + " Body: " + errorBody);
                    if (response.code() == 429 || response.code() >= 500) {
                        ++retries;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new IOException("API call interrupted during retry.", ie);
                        }
                    }
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
                return string;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        throw new IOException("Gemini API call failed after 3 retries.");
    }

    private String callClaudeApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://api.anthropic.com/v1/messages";
        JsonArray messages = new JsonArray();
        if (this.systemPrompt != null && !this.systemPrompt.isEmpty()) {
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("role", "system");
            systemMessage.addProperty("content", this.systemPrompt);
            messages.add(systemMessage);
        }
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        for (ConversationManager.Message msg : history) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            message.addProperty("content", msg.getContent());
            messages.add(message);
        }
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", (String)prompt);
        messages.add(userMessage);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("model", this.defaultClaudeModel);
        requestBody.addProperty("max_tokens", 1024);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        int retries = 0;
        while (retries < 3) {
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    this.getLogger().log(Level.WARNING, "Claude API Error (Attempt " + (retries + 1) + "): " + response.code() + " - " + response.message() + " Body: " + errorBody);
                    if (response.code() == 429 || response.code() >= 500) {
                        ++retries;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new IOException("API call interrupted during retry.", ie);
                        }
                    }
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
                return string;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        throw new IOException("Claude API call failed after 3 retries.");
    }

    private String callOpenAIApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://api.openai.com/v1/chat/completions";
        JsonArray messages = new JsonArray();
        if (this.systemPrompt != null && !this.systemPrompt.isEmpty()) {
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("role", "system");
            systemMessage.addProperty("content", this.systemPrompt);
            messages.add(systemMessage);
        }
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        for (ConversationManager.Message msg : history) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            message.addProperty("content", msg.getContent());
            messages.add(message);
        }
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", (String)prompt);
        messages.add(userMessage);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("model", this.defaultOpenAIModel);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        int retries = 0;
        while (retries < 3) {
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    this.getLogger().log(Level.WARNING, "OpenAI API Error (Attempt " + (retries + 1) + "): " + response.code() + " - " + response.message() + " Body: " + errorBody);
                    if (response.code() == 429 || response.code() >= 500) {
                        ++retries;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new IOException("API call interrupted during retry.", ie);
                        }
                    }
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
                return string;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        throw new IOException("OpenAI API call failed after 3 retries.");
    }

    public String generateAIHeading(String originalContent, String aiResponse, String keyword) {
        String prompt = "Generate a descriptive and concise heading (single phrase or short sentence) for the following knowledge base entry. The heading should accurately summarize the content and be suitable for a knowledge base key. Consider the provided keyword for context.\nKeyword: " + keyword + "\nOriginal Content: " + originalContent + "\nAI Response: " + aiResponse + "\nHeading:";
        String model = this.defaultGeminiModel;
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider);
        if (apiKey == null) {
            this.getLogger().log(Level.WARNING, "No valid API key available for AI heading generation.");
            return "Generated Heading";
        }
        try {
            return (switch (apiKey.getType()) {
                case ApiKeyManager.ApiKey.Type.CLAUDE -> this.callClaudeApiForHeading(prompt, apiKey);
                case ApiKeyManager.ApiKey.Type.OPENAI -> this.callOpenAIApiForHeading(prompt, apiKey);
                default -> this.callGeminiApiForHeading(prompt, apiKey);
            }).trim();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error generating AI heading: " + e.getMessage(), e);
            return "Generated Heading";
        }
    }

    public String getCorrectedContent(String originalContent) {
        String prompt = "You are a grammar and spelling correction tool. Your task is to correct the following text. Do not add any new information, commentary, or change the meaning. Only output the corrected text.\n\nExample:\nOriginal Text: that punsihment are no griefing 7 dyas ban\nCorrected Text: The punishment for griefing is a 7-day ban.\n\nOriginal Text: " + originalContent + "\nCorrected Text:";
        String model = this.defaultGeminiModel;
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider);
        if (apiKey == null) {
            this.getLogger().log(Level.WARNING, "No valid API key available for content correction.");
            return originalContent;
        }
        try {
            return (switch (apiKey.getType()) {
                case ApiKeyManager.ApiKey.Type.CLAUDE -> this.callClaudeApiForCorrection(prompt, apiKey);
                case ApiKeyManager.ApiKey.Type.OPENAI -> this.callOpenAIApiForCorrection(prompt, apiKey);
                default -> this.callGeminiApiForCorrection(prompt, apiKey);
            }).trim();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error correcting content: " + e.getMessage(), e);
            return originalContent;
        }
    }

    private String callGeminiApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            if (!jsonResponse.has("candidates")) {
                this.getLogger().log(Level.SEVERE, "Gemini API error response: " + responseBody);
                throw new IOException("Gemini API returned an error: " + responseBody);
            }
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callClaudeApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.anthropic.com/v1/messages";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultClaudeModel);
        requestBody.addProperty("max_tokens", 1024);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callOpenAIApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.openai.com/v1/chat/completions";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultOpenAIModel);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
            return string;
        }
    }

    private String callGeminiApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            if (!jsonResponse.has("candidates")) {
                this.getLogger().log(Level.SEVERE, "Gemini API error response: " + responseBody);
                throw new IOException("Gemini API returned an error: " + responseBody);
            }
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callClaudeApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.anthropic.com/v1/messages";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultClaudeModel);
        requestBody.addProperty("max_tokens", 100);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callOpenAIApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.openai.com/v1/chat/completions";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultOpenAIModel);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
            return string;
        }
    }

    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    public PetManager getPetManager() {
        return this.petManager;
    }

    public ReservedNicknameManager getReservedNicknameManager() {
        return this.reservedNicknameManager;
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        this.petManager.loadPetsForPlayer(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.adminModePlayers.containsKey(player.getUniqueId())) {
            this.adminModePlayers.remove(player.getUniqueId());
            player.sendMessage(this.colorize("&aYour admin mode has been automatically disabled due to quitting the server."));
        }
        this.conversationManager.clearHistory(event.getPlayer().getUniqueId());
        this.playerApiKeyManager.clearApiKeys(player.getUniqueId());
        this.petManager.unloadPetsForPlayer(player);
        this.playerApiKeyManager.clearApiKeys(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (event.isSneaking() && this.adminModePlayers.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            this.adminModePlayers.remove(player.getUniqueId());
            player.sendMessage(this.colorize("&aYour admin mode has been automatically disabled due to crouching."));
        }
    }

    @Override
    public Plugin getPlugin() {
        return this;
    }

    public ChatHistoryManager getChatHistoryManager() {
        return this.chatHistoryManager;
    }

    @Override
    public String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String refineResponse(String response, String userQuery) {
        if (userQuery.toLowerCase().contains("date") && response.matches(".*\\d{4}-\\d{2}-\\d{2}.*\\d{2}:\\d{2}:\\d{2}.*")) {
            try {
                Pattern pattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})");
                Matcher matcher = pattern.matcher(response);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error refining date from response: " + e.getMessage());
            }
        }
        return response;
    }

    public void addKnowledgeEntry(String keyword, String aiGeneratedHeading, String aiResponse) {
        String compositeKey = keyword.toLowerCase() + "/" + aiGeneratedHeading.toLowerCase();
        this.getLogger().info("Adding to knowledgeBase map: " + compositeKey);
        this.knowledgeManager.addKnowledge(compositeKey, aiResponse, false);
    }

    public String removeKnowledgeEntry(String key) {
        return this.knowledgeManager.removeKnowledge(key);
    }

    public Map<String, String> getKnowledgeBase() {
        return this.knowledgeManager.getAllKnowledge(true);
    }

    public String getAdminActivationCode() {
        return this.adminActivationCode;
    }

    public Map<UUID, Boolean> getAdminModePlayers() {
        return this.adminModePlayers;
    }

    public ChatLogger getChatLogger() {
        return this.chatLogger;
    }

    public String getGuiColorScheme() {
        return this.guiColorScheme;
    }

    public void setGuiColorScheme(String guiColorScheme) {
        this.guiColorScheme = guiColorScheme;
        this.featuresConfig.set("gui-color-scheme", (Object)guiColorScheme);
        this.saveFeaturesConfig();
    }

    public boolean isPetsEnabled() {
        return this.petsEnabled;
    }

    public void setPetsEnabled(boolean petsEnabled) {
        this.petsEnabled = petsEnabled;
        this.featuresConfig.set("global-toggles.pets", (Object)petsEnabled);
        this.saveFeaturesConfig();
    }

    public boolean isMemoryEnabled() {
        return this.memoryEnabled;
    }

    public void setMemoryEnabled(boolean memoryEnabled) {
        this.memoryEnabled = memoryEnabled;
        this.featuresConfig.set("global-toggles.memory", (Object)memoryEnabled);
        this.saveFeaturesConfig();
    }

    public boolean isChatsEnabled() {
        return this.chatsEnabled;
    }

    public void setChatsEnabled(boolean chatsEnabled) {
        this.chatsEnabled = chatsEnabled;
        this.featuresConfig.set("global-toggles.chats", (Object)chatsEnabled);
        this.saveFeaturesConfig();
    }

    public boolean isKnowledgeEnabled() {
        return this.knowledgeEnabled;
    }

    public void setKnowledgeEnabled(boolean knowledgeEnabled) {
        this.knowledgeEnabled = knowledgeEnabled;
        this.featuresConfig.set("global-toggles.knowledge", (Object)knowledgeEnabled);
        this.saveFeaturesConfig();
    }

    public String getAdminGuiColorScheme() {
        return this.adminGuiColorScheme;
    }

    public void setAdminGuiColorScheme(String adminGuiColorScheme) {
        this.adminGuiColorScheme = adminGuiColorScheme;
        this.featuresConfig.set("admin-gui-color-scheme", (Object)adminGuiColorScheme);
        this.saveFeaturesConfig();
    }

    public void saveFeaturesConfig() {
        try {
            this.featuresConfig.save(new File(this.getDataFolder(), "features.yml"));
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save features.yml", e);
        }
    }

    public boolean isAiEnabled(Player player) {
        return this.aiStatus.getOrDefault(player.getUniqueId(), true);
    }

    public void setAiEnabled(Player player, boolean enabled) {
        this.aiStatus.put(player.getUniqueId(), enabled);
    }

    public PlayerApiKeyManager getPlayerApiKeyManager() {
        return this.playerApiKeyManager;
    }

    public PrivacyManager getPrivacyManager() {
        return this.privacyManager;
    }

    public ApiKeyManager getApiKeyManager() {
        return this.apiKeyManager;
    }

    @Override
    public String getPermissionDeniedMessage() {
        return this.permissionDeniedMessage;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public List<String> getApiKeys() {
        return this.apiKeys;
    }

    public String getAiNotConfiguredMessage() {
        return this.aiNotConfiguredMessage;
    }

    public String getDefaultApiProvider() {
        return this.defaultApiProvider;
    }

    public String getUserPrefix() {
        return this.userPrefix;
    }

    public String getUserChatColor() {
        return this.userChatColor;
    }

    public String getAdminAiPrefix() {
        return this.adminAiPrefix;
    }

    public String getAiPrefix() {
        return this.aiPrefix;
    }

    public String getAiChatColor() {
        return this.aiChatColor;
    }

    public String getSummary(List<ConversationManager.Message> history) throws IOException {
        if (history.isEmpty()) {
            return "";
        }
        StringBuilder conversationText = new StringBuilder();
        for (ConversationManager.Message msg : history) {
            conversationText.append(msg.getRole()).append(": ").append(msg.getContent()).append("\n");
        }
        String prompt = "You are a conversation summarizer. Your task is to create a concise summary of the following chat history. Capture the main points and key information, including both user and AI responses. Do not add any commentary. Output only the summary.\n\nConversation History:\n" + conversationText.toString() + "\nSummary:";
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey("gemini");
        if (apiKey == null && (apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider)) == null) {
            throw new IOException("No valid API key available for summarization.");
        }
        return this.callGeminiApiForSummary(prompt, apiKey);
    }

    private String callGeminiApiForSummary(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error during summarization: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            if (!jsonResponse.has("candidates")) {
                this.getLogger().log(Level.SEVERE, "Gemini API error response: " + responseBody);
                throw new IOException("Gemini API returned an error: " + responseBody);
            }
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    @Override
    public Economy getEconomy() {
        return null;
    }

    public ConfirmationManager getConfirmationManager() {
        return this.confirmationManager;
    }

    public KnowledgeManager getKnowledgeManager() {
        return this.knowledgeManager;
    }

    public void saveLatestSummary(Player player, String summary, String commandType) {
        File summaryDir = new File(this.getDataFolder(), "summarychat/" + player.getName() + "-" + player.getUniqueId().toString());
        if (!summaryDir.exists()) {
            summaryDir.mkdirs();
        }
        File summaryFile = new File(summaryDir, "summary.txt");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(summaryFile, false));){
            writer.write("[Generated by: " + commandType + "]\n");
            writer.write("[Timestamp: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "]\n");
            writer.write(summary);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save latest summary for " + player.getName(), e);
        }
    }

    public void archiveOldSummary(Player player) {
        File summaryFile = new File(this.getDataFolder(), "summarychat/" + player.getName() + "-" + player.getUniqueId().toString() + "/summary.txt");
        if (!summaryFile.exists()) {
            return;
        }
        try {
            String oldSummary = new String(Files.readAllBytes(summaryFile.toPath()));
            if (!oldSummary.isEmpty()) {
                boolean isAdmin = this.getAdminModePlayers().getOrDefault(player.getUniqueId(), false);
                this.chatLogger.log(player, "\n--- Archived Summary ---\n" + oldSummary + "\n--- End of Summary ---", isAdmin, true);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not read old summary for archiving for " + player.getName(), e);
        }
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public void reloadPlayerSession(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            boolean isAdmin = this.getAdminModePlayers().getOrDefault(player.getUniqueId(), false);
            File logFile = this.chatLogger.getLogFile(player, isAdmin);
            if (!logFile.exists()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No chat history found to reload.");
                return;
            }
            try {
                List<String> lines = Files.readAllLines(logFile.toPath());
                int historyLength = this.featuresConfig.getInt("conversation-history-length", 10);
                int startIndex = Math.max(0, lines.size() - historyLength * 2);
                ArrayList<ConversationManager.Message> newHistory = new ArrayList<ConversationManager.Message>();
                for (int i = startIndex; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    if (line.contains("[AI]")) {
                        newHistory.add(new ConversationManager.Message("assistant", line.substring(line.indexOf("[AI]") + 5)));
                        continue;
                    }
                    if (!line.contains("[" + player.getName() + "]")) continue;
                    newHistory.add(new ConversationManager.Message("user", line.substring(line.indexOf("]") + 2)));
                }
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    this.conversationManager.clearHistory(player.getUniqueId());
                    for (ConversationManager.Message msg : newHistory) {
                        this.conversationManager.addMessage(player.getUniqueId(), msg);
                    }
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your session has been reloaded from your chat history.");
                });
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error reloading session for " + player.getName(), e);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while reloading your session."));
            }
        });
    }

    public void summarizeAndClearSession(Player player) {
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        if (history.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is no conversation history to process.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Summarizing and clearing your session... This may take a moment.");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String summary = this.getSummary(history);
                this.archiveOldSummary(player);
                this.saveLatestSummary(player, summary, "clear");
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    this.conversationManager.clearHistory(player.getUniqueId());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your conversation has been summarized and a new session has started.");
                });
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error processing memory clear for " + player.getName(), e);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while processing your conversation memory."));
            }
        });
    }

    public void summarizeAndRefreshSession(Player player) {
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        if (history.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is no conversation history to process.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Summarizing and refreshing your session... This may take a moment.");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String summary = this.getSummary(history);
                this.archiveOldSummary(player);
                this.saveLatestSummary(player, summary, "refresh");
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    this.conversationManager.clearHistory(player.getUniqueId());
                    this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("system", "Previous conversation summary: " + summary));
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your conversation has been summarized. You can continue your chat.");
                });
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error processing memory refresh for " + player.getName(), e);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while processing your conversation memory."));
            }
        });
    }

    public String readSummaryFromFile(Player player) throws IOException {
        File summaryFile = new File(this.getDataFolder(), "summarychat/" + player.getName() + "-" + player.getUniqueId().toString() + "/summary.txt");
        if (!summaryFile.exists()) {
            return null;
        }
        List<String> lines = Files.readAllLines(summaryFile.toPath());
        StringBuilder summaryContent = new StringBuilder();
        boolean inSummary = false;
        for (String line : lines) {
            if (line.startsWith("[Generated by:") || line.startsWith("[Timestamp:")) continue;
            summaryContent.append(line).append("\n");
        }
        return summaryContent.toString().trim();
    }

    public void processMemoryCommand(Player player, String commandType) {
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        if (history.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is no conversation history to process.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Processing conversation memory... This may take a moment.");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String summary = this.getSummary(history);
                this.archiveOldSummary(player);
                this.saveLatestSummary(player, summary, commandType);
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    if (commandType.equals("clear")) {
                        this.conversationManager.clearHistory(player.getUniqueId());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your conversation has been summarized and a new session has started.");
                    } else if (commandType.equals("refresh")) {
                        try {
                            this.conversationManager.clearHistory(player.getUniqueId());
                            String previousSummary = this.readSummaryFromFile(player);
                            if (previousSummary != null && !previousSummary.isEmpty()) {
                                String summaryStatus = this.getSummaryStatus(player);
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Summary Status: " + summaryStatus);
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Type: cache/memory");
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Command: refresh");
                                this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("system", "Previous conversation summary: " + previousSummary));
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your conversation has been summarized. You can continue your chat.");
                            } else {
                                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "No previous summary found to refresh from. Starting a new session.");
                            }
                        }
                        catch (IOException e) {
                            this.getLogger().log(Level.SEVERE, "Error reading summary for refresh command for " + player.getName(), e);
                            player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while refreshing your session.");
                        }
                    }
                });
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error processing memory command for " + player.getName(), e);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while processing your conversation memory."));
            }
        });
    }

    public void processAndAddKnowledgeEntry(Player player, String keyword, String messageContent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String aiGeneratedHeading = this.generateAIHeading(messageContent, "", keyword);
            if (this.isSimpleKnowledgeYmlApprove()) {
                String code = this.getConfirmationManager().createConfirmation(player.getUniqueId(), "add", keyword + "/" + aiGeneratedHeading, messageContent);
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "--- Knowledge Entry Preview ---"));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "Heading: " + aiGeneratedHeading));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "Content: " + messageContent));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "-------------------------------"));
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please confirm adding this knowledge entry by typing: /ai confirm yes");
                });
            } else {
                String code = this.getConfirmationManager().createConfirmation(player.getUniqueId(), "add", keyword + "/" + aiGeneratedHeading, messageContent);
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "--- Knowledge Entry Preview ---"));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "Heading: " + aiGeneratedHeading));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "Content: " + messageContent));
                    player.sendMessage(this.colorize(this.knowledgeBaseColor + "-------------------------------"));
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please confirm adding this knowledge entry by typing: /ai confirm " + code);
                });
            }
        });
    }

    public String getSummaryStatus(Player player) {
        long oneDayAgo;
        File summaryFile = new File(this.getDataFolder(), "summarychat/" + player.getName() + "-" + player.getUniqueId().toString() + "/summary.txt");
        if (!summaryFile.exists()) {
            return "No summary found.";
        }
        long lastModified = summaryFile.lastModified();
        if (lastModified > (oneDayAgo = System.currentTimeMillis() - 86400000L)) {
            return "active";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return "old (last updated: " + sdf.format(new Date(lastModified)) + ")";
    }

    public String getPetAIResponse(Pet pet, Player player, String message) throws IOException {
        String petName = pet.getNickname() != null ? pet.getNickname() : pet.getPetName();
        String prompt = "You are a " + pet.getPersonality() + " " + pet.getType().name().toLowerCase() + " named " + petName + ". Your owner is " + player.getName() + ". Your current mood is " + pet.getMood() + " and your bond level is " + pet.getBond() + " out of 100.";
        if (pet.getBond() > 75) {
            prompt = prompt + " You are very affectionate towards your owner.";
        } else if (pet.getBond() < 25) {
            prompt = prompt + " You are cold and distant towards your owner.";
        }
        switch (pet.getMood().toLowerCase()) {
            case "happy": {
                prompt = prompt + " You are happy, so your responses should be enthusiastic and friendly. Use happy emojis like \u2764\ufe0f and \ud83d\ude0a.";
                break;
            }
            case "sad": {
                prompt = prompt + " You are sad, so your responses should be short and withdrawn. Use sad emojis like \ud83d\ude14.";
                break;
            }
            case "angry": {
                prompt = prompt + " You are angry, so your responses should be short and grumpy. Use angry emojis like \ud83d\ude21.";
                break;
            }
            case "furious": {
                prompt = prompt + " You are furious! Your responses should be very short, sharp, and angry. Use angry emojis like \ud83d\ude21.";
                break;
            }
            case "playful": {
                prompt = prompt + " You are feeling playful, so your responses should be energetic and maybe a little mischievous. Use playful emojis like \ud83d\ude0f.";
                break;
            }
            case "scared": {
                prompt = prompt + " You are scared, so your responses should be timid and short. Use scared emojis like \ud83d\ude31.";
            }
        }
        prompt = prompt + "\n\nRespond to the following message from your owner as if you are the pet. Keep your response short and in character. Do not include the pet sound in your response:";
        prompt = prompt + "\n\nOwner: " + message;
        prompt = prompt + "\n" + petName + ": ";
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider, player);
        if (apiKey == null) {
            this.getLogger().warning("No valid API key found for pet of player " + player.getName());
            return "(No API key available)";
        }
        String keyOrigin = this.getPlayerApiKeyManager().hasApiKeys(player.getUniqueId()) ? "player's own" : "default";
        this.getLogger().info("Using " + keyOrigin + " API key of type: " + String.valueOf((Object)apiKey.getType()) + " for pet of player " + player.getName());
        return this.callAppropriateApi(player, prompt, apiKey);
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public BugFixManager getBugFixManager() {
        return this.bugFixManager;
    }

    public void clearPlayerChat(Player player) {
        for (int i = 0; i < 100; ++i) {
            player.sendMessage("");
        }
    }
}

